/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.test.common.cases;

import java.util.Iterator;
import org.eclipse.emf.emfstore.client.ESServer;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.client.ESWorkspaceProvider;
import org.eclipse.emf.emfstore.client.exceptions.ESServerNotFoundException;
import org.eclipse.emf.emfstore.client.test.common.cases.ESTestWithServer;
import org.eclipse.emf.emfstore.client.test.common.dsl.Delete;
import org.eclipse.emf.emfstore.client.test.common.util.ServerUtil;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.Workspace;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESServerImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESUsersessionImpl;
import org.eclipse.emf.emfstore.internal.client.model.util.EMFStoreCommandWithException;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class ESTestWithLoggedInUser
extends ESTestWithServer {
    private ESServer server;
    private ESUsersession usersession;
    private ESUsersession superSession;
    private ACOrgUnitId userId;

    public ESServer getServer() {
        return this.server;
    }

    public ServerInfo getServerInfo() {
        ESServerImpl serverImpl = (ESServerImpl)ESServerImpl.class.cast(this.server);
        return (ServerInfo)serverImpl.toInternalAPI();
    }

    public ESUsersession getUsersession() {
        return this.usersession;
    }

    public ESUsersession getSuperUsersession() {
        return this.superSession;
    }

    public String getUser() {
        return ServerUtil.superUser();
    }

    public String getPassword() {
        return ServerUtil.superUserPassword();
    }

    @Before
    public void before() {
        super.before();
        this.server = ESServer.FACTORY.createServer(ServerUtil.localhost(), ServerUtil.defaultPort(), "emfstore test certificate (do not use in production!)");
        try {
            this.superSession = this.server.login(ServerUtil.superUser(), ServerUtil.superUserPassword());
            Delete.allRemoteProjects(this.server, this.superSession);
            if (this.isSuperUser()) {
                this.usersession = this.superSession;
                return;
            }
            if (!this.userExists(this.getServerInfo(), this.superSession, this.getUser())) {
                this.userId = ServerUtil.createUser(this.superSession, this.getUser());
                ServerUtil.changeUser(this.superSession, this.userId, this.getUser(), this.getPassword());
            }
            this.usersession = this.server.login(this.getUser(), this.getPassword());
        }
        catch (ESException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((Object)this.usersession, (Object)this.server.getLastUsersession());
    }

    private boolean isSuperUser() {
        return this.getUser().equals(ServerUtil.superUser());
    }

    public boolean userExists(ServerInfo serverInfo, ESUsersession session, String name) throws ESException {
        ACUser user = ServerUtil.getUser(session, name);
        return user != null;
    }

    @After
    public void after() {
        super.after();
        if (!this.isSuperUser()) {
            try {
                ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager().deleteUser(((Usersession)((ESUsersessionImpl)this.getSuperUsersession()).toInternalAPI()).getSessionId(), this.userId);
            }
            catch (ESException ex) {
                Assert.fail((String)ex.getMessage());
            }
        }
        EMFStoreCommandWithException<ESException> cmd = new EMFStoreCommandWithException<ESException>(){

            protected void doRun() {
                ((ServerInfo)((ESServerImpl)ESTestWithLoggedInUser.this.server).toInternalAPI()).setLastUsersession(null);
                ((ESUsersessionImpl)ESTestWithLoggedInUser.this.usersession).setServer(null);
                ((ESUsersessionImpl)ESTestWithLoggedInUser.this.superSession).setServer(null);
                if (ESTestWithLoggedInUser.this.usersession != null && ESTestWithLoggedInUser.this.usersession.isLoggedIn()) {
                    try {
                        ESTestWithLoggedInUser.this.logoutSessions();
                        Iterator iter = ((Workspace)ESWorkspaceProviderImpl.getInstance().getWorkspace().toInternalAPI()).getUsersessions().iterator();
                        while (iter.hasNext()) {
                            if (((Usersession)iter.next()).getServerInfo() != ((ESServerImpl)ESTestWithLoggedInUser.this.server).toInternalAPI()) continue;
                            iter.remove();
                        }
                        ESWorkspaceProvider.INSTANCE.getWorkspace().removeServer(ESTestWithLoggedInUser.this.server);
                    }
                    catch (ESException e) {
                        this.setException((Object)e);
                    }
                    catch (ESServerNotFoundException e) {
                        Assert.fail((String)e.getMessage());
                    }
                }
            }
        };
        cmd.run();
        if (cmd.hasException()) {
            Assert.fail((String)((ESException)((Object)cmd.getException())).getMessage());
        }
        super.after();
    }

    private void logoutSessions() throws ESException {
        this.superSession.logout();
        if (!this.isSuperUser()) {
            this.usersession.logout();
        }
    }
}

