/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.edit.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gmf.gmfgraph.GMFGraphPackage;
import org.eclipse.gmf.gmfgraph.Layout;
import org.eclipse.gmf.gmfgraph.RoundedRectangle;
import org.eclipse.gmf.graphdef.editor.edit.parts.AbstractFigureEditPart;
import org.eclipse.gmf.graphdef.editor.edit.policies.BorderLayoutEditPolicy;
import org.eclipse.gmf.graphdef.editor.edit.policies.ChildFigureSelectionEditPolicy;
import org.eclipse.gmf.graphdef.editor.edit.policies.FigureContainerXYLayoutEditPolicy;
import org.eclipse.gmf.graphdef.editor.edit.policies.GridLayoutEditPolicy;
import org.eclipse.gmf.graphdef.editor.edit.policies.RoundedRectangle3CanonicalEditPolicy;
import org.eclipse.gmf.graphdef.editor.edit.policies.RoundedRectangle3ItemSemanticEditPolicy;
import org.eclipse.gmf.graphdef.editor.providers.GMFGraphElementTypes;
import org.eclipse.gmf.graphdef.editor.sheet.AttachAdapter;
import org.eclipse.gmf.graphdef.editor.sheet.ChangeTracker;
import org.eclipse.gmf.graphdef.editor.sheet.FeatureTracker;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

public class RoundedRectangle3EditPart
extends AbstractFigureEditPart {
    public static final int VISUAL_ID = 3020;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    private Collection<Adapter> myDomainElementAdapters = new ArrayList<Adapter>();

    public RoundedRectangle3EditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        this.installEditPolicy("CreationPolicy", (EditPolicy)new CreationEditPolicy());
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new RoundedRectangle3ItemSemanticEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new DragDropEditPolicy());
        this.installEditPolicy("Canonical", (EditPolicy)new RoundedRectangle3CanonicalEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.installEditPolicy("KeyHandlerEditPolicy", new ChildFigureSelectionEditPolicy());
        this.removeEditPolicy("ConnectionHandlesPolicy");
    }

    @Override
    protected LayoutEditPolicy createLayoutEditPolicy() {
        Layout layout = this.getGmfgraphElement().getLayout();
        if (layout != null) {
            switch (layout.eClass().getClassifierID()) {
                case 67: {
                    return new BorderLayoutEditPolicy();
                }
                case 66: {
                    return new GridLayoutEditPolicy();
                }
            }
        }
        return new FigureContainerXYLayoutEditPolicy(this.getMapMode());
    }

    protected IFigure createNodeShape() {
        RoundedRectangleFigure figure = new RoundedRectangleFigure();
        figure.setUseLocalCoordinates(true);
        this.primaryShape = figure;
        return this.primaryShape;
    }

    public RoundedRectangleFigure getPrimaryShape() {
        return (RoundedRectangleFigure)this.primaryShape;
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(0, 0);
        result.setMinimumSize(new Dimension(0, 0));
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            nodeShape.setLayoutManager((LayoutManager)new FreeformLayout(){

                public Object getConstraint(IFigure figure) {
                    Object result = this.constraints.get(figure);
                    if (result == null) {
                        result = new Rectangle(0, 0, -1, -1);
                    }
                    return result;
                }
            });
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setBackgroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setBackgroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineWidth(width);
        }
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineStyle(style);
        }
    }

    public List getMARelTypesOnTarget() {
        ArrayList<IElementType> types = new ArrayList<IElementType>();
        types.add(GMFGraphElementTypes.ChildAccess_4002);
        return types;
    }

    public List getMATypesForSource(IElementType relationshipType) {
        ArrayList<IElementType> types = new ArrayList<IElementType>();
        if (relationshipType == GMFGraphElementTypes.ChildAccess_4002) {
            types.add(GMFGraphElementTypes.FigureDescriptor_3009);
        }
        return types;
    }

    private RoundedRectangle getGmfgraphElement() {
        View view = this.getNotationView();
        if (view == null) {
            return null;
        }
        EObject element = view.getElement();
        if (element instanceof RoundedRectangle) {
            RoundedRectangle modelFigureElement = (RoundedRectangle)element;
            return modelFigureElement;
        }
        return null;
    }

    protected void removeSemanticListeners() {
        RoundedRectangle modelElement = this.getGmfgraphElement();
        if (modelElement != null) {
            modelElement.eAdapters().removeAll(this.myDomainElementAdapters);
            this.myDomainElementAdapters.clear();
        }
        super.removeSemanticListeners();
    }

    protected void setFigure(IFigure figure) {
        super.setFigure(figure);
        RoundedRectangle modelElement = this.getGmfgraphElement();
        if (modelElement != null) {
            this.getPrimaryShape().setOutline(modelElement.isOutline());
            this.getPrimaryShape().setFill(modelElement.isFill());
            this.getPrimaryShape().setLineWidth(modelElement.getLineWidth());
            this.getPrimaryShape().setLineStyle(RoundedRectangle3EditPart.getLineStyle(modelElement.getLineKind()));
            this.getPrimaryShape().setFillXOR(modelElement.isXorFill());
            this.getPrimaryShape().setOutlineXOR(modelElement.isXorOutline());
            this.getPrimaryShape().setCornerDimensions(this.getCornerDimensions(modelElement.getCornerWidth(), modelElement.getCornerHeight()));
            this.getPrimaryShape().setLayoutManager(this.getLayoutManager(modelElement.getLayout()));
            this.refreshLayoutManager();
            this.getPrimaryShape().setBackgroundColor(RoundedRectangle3EditPart.getColor(modelElement.getBackgroundColor()));
            this.getPrimaryShape().setForegroundColor(RoundedRectangle3EditPart.getColor(modelElement.getForegroundColor()));
            this.refreshFont();
        }
    }

    public void activate() {
        if (this.isActive()) {
            return;
        }
        final RoundedRectangle modelElement = this.getGmfgraphElement();
        if (modelElement == null) {
            super.activate();
            return;
        }
        ChangeTracker outlineTracker = new ChangeTracker(){

            @Override
            public void modelChanged(Notification msg) {
                RoundedRectangle3EditPart.this.getPrimaryShape().setOutline(modelElement.isOutline());
            }
        };
        this.myDomainElementAdapters.add((Adapter)new FeatureTracker(outlineTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getShape_Outline()}));
        ChangeTracker fillTracker = new ChangeTracker(){

            @Override
            public void modelChanged(Notification msg) {
                RoundedRectangle3EditPart.this.getPrimaryShape().setFill(modelElement.isFill());
            }
        };
        this.myDomainElementAdapters.add((Adapter)new FeatureTracker(fillTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getShape_Fill()}));
        ChangeTracker lineWidthTracker = new ChangeTracker(){

            @Override
            public void modelChanged(Notification msg) {
                RoundedRectangle3EditPart.this.getPrimaryShape().setLineWidth(modelElement.getLineWidth());
            }
        };
        this.myDomainElementAdapters.add((Adapter)new FeatureTracker(lineWidthTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getShape_LineWidth()}));
        ChangeTracker lineStyleTracker = new ChangeTracker(){

            @Override
            public void modelChanged(Notification msg) {
                RoundedRectangle3EditPart.this.getPrimaryShape().setLineStyle(RoundedRectangle3EditPart.getLineStyle(modelElement.getLineKind()));
            }
        };
        this.myDomainElementAdapters.add((Adapter)new FeatureTracker(lineStyleTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getShape_LineKind()}));
        ChangeTracker fillXORTracker = new ChangeTracker(){

            @Override
            public void modelChanged(Notification msg) {
                RoundedRectangle3EditPart.this.getPrimaryShape().setFillXOR(modelElement.isXorFill());
            }
        };
        this.myDomainElementAdapters.add((Adapter)new FeatureTracker(fillXORTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getShape_XorFill()}));
        ChangeTracker outlineXORTracker = new ChangeTracker(){

            @Override
            public void modelChanged(Notification msg) {
                RoundedRectangle3EditPart.this.getPrimaryShape().setOutlineXOR(modelElement.isXorOutline());
            }
        };
        this.myDomainElementAdapters.add((Adapter)new FeatureTracker(outlineXORTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getShape_XorOutline()}));
        ChangeTracker cornerDimensionsTracker = new ChangeTracker(){

            @Override
            public void modelChanged(Notification msg) {
                RoundedRectangle3EditPart.this.getPrimaryShape().setCornerDimensions(RoundedRectangle3EditPart.this.getCornerDimensions(modelElement.getCornerWidth(), modelElement.getCornerHeight()));
            }
        };
        this.myDomainElementAdapters.add((Adapter)new FeatureTracker(cornerDimensionsTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getRoundedRectangle_CornerWidth()}));
        this.myDomainElementAdapters.add((Adapter)new FeatureTracker(cornerDimensionsTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getRoundedRectangle_CornerHeight()}));
        ChangeTracker layoutManagerTracker = new ChangeTracker(){

            @Override
            public void modelChanged(Notification msg) {
                RoundedRectangle3EditPart.this.getPrimaryShape().setLayoutManager(RoundedRectangle3EditPart.this.getLayoutManager(modelElement.getLayout()));
                RoundedRectangle3EditPart.this.refreshLayoutManager();
            }
        };
        this.myDomainElementAdapters.add((Adapter)new AttachAdapter(GMFGraphPackage.eINSTANCE.getLayoutable_Layout(), layoutManagerTracker, new Adapter[]{new AttachAdapter(GMFGraphPackage.eINSTANCE.getBorderLayout_Spacing(), layoutManagerTracker, new Adapter[]{new FeatureTracker(layoutManagerTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getDimension_Dx()}), new FeatureTracker(layoutManagerTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getDimension_Dy()})}), new FeatureTracker(layoutManagerTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getFlowLayout_Vertical()}), new FeatureTracker(layoutManagerTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getFlowLayout_MatchMinorSize()}), new FeatureTracker(layoutManagerTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getFlowLayout_ForceSingleLine()}), new FeatureTracker(layoutManagerTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getFlowLayout_MajorAlignment()}), new FeatureTracker(layoutManagerTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getFlowLayout_MinorAlignment()}), new FeatureTracker(layoutManagerTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getFlowLayout_MajorSpacing()}), new FeatureTracker(layoutManagerTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getFlowLayout_MinorSpacing()}), new FeatureTracker(layoutManagerTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getGridLayout_NumColumns()}), new FeatureTracker(layoutManagerTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getGridLayout_EqualWidth()}), new AttachAdapter(GMFGraphPackage.eINSTANCE.getGridLayout_Margins(), layoutManagerTracker, new Adapter[]{new FeatureTracker(layoutManagerTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getDimension_Dx()}), new FeatureTracker(layoutManagerTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getDimension_Dy()})}), new AttachAdapter(GMFGraphPackage.eINSTANCE.getGridLayout_Spacing(), layoutManagerTracker, new Adapter[]{new FeatureTracker(layoutManagerTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getDimension_Dx()}), new FeatureTracker(layoutManagerTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getDimension_Dy()})})}));
        ChangeTracker backgroundColorTracker = new ChangeTracker(){

            @Override
            public void modelChanged(Notification msg) {
                RoundedRectangle3EditPart.this.getPrimaryShape().setBackgroundColor(RoundedRectangle3EditPart.getColor(modelElement.getBackgroundColor()));
            }
        };
        this.myDomainElementAdapters.add((Adapter)new AttachAdapter(GMFGraphPackage.eINSTANCE.getFigure_BackgroundColor(), backgroundColorTracker, new Adapter[]{new FeatureTracker(backgroundColorTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getConstantColor_Value()}), new FeatureTracker(backgroundColorTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getRGBColor_Red()}), new FeatureTracker(backgroundColorTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getRGBColor_Green()}), new FeatureTracker(backgroundColorTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getRGBColor_Blue()})}));
        ChangeTracker foregroundColorTracker = new ChangeTracker(){

            @Override
            public void modelChanged(Notification msg) {
                RoundedRectangle3EditPart.this.getPrimaryShape().setForegroundColor(RoundedRectangle3EditPart.getColor(modelElement.getForegroundColor()));
            }
        };
        this.myDomainElementAdapters.add((Adapter)new AttachAdapter(GMFGraphPackage.eINSTANCE.getFigure_ForegroundColor(), foregroundColorTracker, new Adapter[]{new FeatureTracker(foregroundColorTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getConstantColor_Value()}), new FeatureTracker(foregroundColorTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getRGBColor_Red()}), new FeatureTracker(foregroundColorTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getRGBColor_Green()}), new FeatureTracker(foregroundColorTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getRGBColor_Blue()})}));
        ChangeTracker refreshFontTracker = new ChangeTracker(){

            @Override
            public void modelChanged(Notification msg) {
                RoundedRectangle3EditPart.this.refreshFont();
            }
        };
        this.myDomainElementAdapters.add((Adapter)new AttachAdapter(GMFGraphPackage.eINSTANCE.getFigure_Font(), refreshFontTracker, new Adapter[]{new FeatureTracker(refreshFontTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getBasicFont_FaceName()}), new FeatureTracker(refreshFontTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getBasicFont_Height()}), new FeatureTracker(refreshFontTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getBasicFont_Style()})}));
        modelElement.eAdapters().addAll(this.myDomainElementAdapters);
        super.activate();
    }

    public class RoundedRectangleFigure
    extends org.eclipse.draw2d.RoundedRectangle {
        private boolean myUseLocalCoordinates = false;

        public RoundedRectangleFigure() {
            this.setLayoutManager((LayoutManager)new XYLayout());
            this.setCornerDimensions(new Dimension(RoundedRectangle3EditPart.this.getMapMode().DPtoLP(8), RoundedRectangle3EditPart.this.getMapMode().DPtoLP(8)));
            this.setLineWidth(1);
        }

        protected boolean useLocalCoordinates() {
            return this.myUseLocalCoordinates;
        }

        protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
            this.myUseLocalCoordinates = useLocalCoordinates;
        }
    }
}

