/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.DistType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.common.box.CodeBox;

public class SamplerCodeGenerator {
    private SamplerCodeGenerator() {
    }

    public static void gencodeSampler(CifCompilerContext ctxt) {
        if (!ctxt.needSampler) {
            return;
        }
        JavaCodeFile file = ctxt.addCodeFile("Sampler");
        CodeBox h = file.header;
        h.add("/** Sampler for sampling stochastic distributions. */");
        h.add("public final class Sampler {");
        CodeBox c = file.body;
        Field bfield1 = CifConstructors.newField();
        Field bfield2 = CifConstructors.newField();
        DistType bdtype = CifConstructors.newDistType();
        bdtype.setSampleType((CifType)CifConstructors.newBoolType());
        bfield1.setType((CifType)CifConstructors.newBoolType());
        bfield2.setType((CifType)bdtype);
        TupleType bttype = CifConstructors.newTupleType();
        bttype.getFields().add((Object)bfield1);
        bttype.getFields().add((Object)bfield2);
        Field ifield1 = CifConstructors.newField();
        Field ifield2 = CifConstructors.newField();
        DistType idtype = CifConstructors.newDistType();
        idtype.setSampleType((CifType)CifConstructors.newIntType());
        ifield1.setType((CifType)CifConstructors.newIntType());
        ifield2.setType((CifType)idtype);
        TupleType ittype = CifConstructors.newTupleType();
        ittype.getFields().add((Object)ifield1);
        ittype.getFields().add((Object)ifield2);
        Field rfield1 = CifConstructors.newField();
        Field rfield2 = CifConstructors.newField();
        DistType rdtype = CifConstructors.newDistType();
        rdtype.setSampleType((CifType)CifConstructors.newRealType());
        rfield1.setType((CifType)CifConstructors.newRealType());
        rfield2.setType((CifType)rdtype);
        TupleType rttype = CifConstructors.newTupleType();
        rttype.getFields().add((Object)rfield1);
        rttype.getFields().add((Object)rfield2);
        String brclass = ctxt.getTupleTypeClassName(bttype);
        String irclass = ctxt.getTupleTypeClassName(ittype);
        String rrclass = ctxt.getTupleTypeClassName(rttype);
        c.add("public static %s sample(BooleanDistribution d) {", new Object[]{brclass});
        c.indent();
        c.add("d = d.copy();");
        c.add("boolean value = d.sample();");
        c.add("return new %s(value, d);", new Object[]{brclass});
        c.dedent();
        c.add("}");
        c.add();
        c.add("public static %s sample(IntegerDistribution d) {", new Object[]{irclass});
        c.indent();
        c.add("d = d.copy();");
        c.add("int value = d.sample();");
        c.add("return new %s(value, d);", new Object[]{irclass});
        c.dedent();
        c.add("}");
        c.add();
        c.add("public static %s sample(RealDistribution d) {", new Object[]{rrclass});
        c.indent();
        c.add("d = d.copy();");
        c.add("double value = d.sample();");
        c.add("if (Double.isNaN(value)) {");
        c.indent();
        c.add("String msg = fmt(\"Invalid operation: sample %s: result is NaN.\", d);");
        c.add("throw new CifSimulatorException(msg);");
        c.dedent();
        c.add("}");
        c.add("if (Double.isInfinite(value)) {");
        c.indent();
        c.add("String valueTxt;");
        c.add("if (value == Double.POSITIVE_INFINITY) {");
        c.indent();
        c.add("valueTxt = \"+inf\";");
        c.dedent();
        c.add("} else {");
        c.indent();
        c.add("Assert.check(value == Double.NEGATIVE_INFINITY);");
        c.add("valueTxt = \"-inf\";");
        c.dedent();
        c.add("}");
        c.add("String msg = fmt(\"Invalid operation: sample %s: result is %s.\", d, valueTxt);");
        c.add("throw new CifSimulatorException(msg);");
        c.dedent();
        c.add("}");
        c.add("return new %s(value, d);", new Object[]{rrclass});
        c.dedent();
        c.add("}");
    }
}

