/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.bundle.acceleo.gmf.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gendoc.documents.FileRunnable;
import org.eclipse.gendoc.documents.IImageManipulationService;
import org.eclipse.gendoc.documents.IImageManipulationServiceFactory;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.IGendocDiagnostician;
import org.eclipse.gendoc.services.ILogger;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramGenerator;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.DiagramUIRenderPlugin;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToImageUtil;
import org.eclipse.gmf.runtime.diagram.ui.util.DiagramEditorUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class GMFDiagramRunnable
implements FileRunnable {
    private Diagram diagram;
    private FileFormat extension;
    private final List<EObject> visibleElements;

    public GMFDiagramRunnable(Diagram diagram, String extension) {
        this(diagram, extension, null);
    }

    public GMFDiagramRunnable(Diagram diagram, String extension, List<EObject> visibleElements) {
        this.diagram = diagram;
        this.extension = GMFDiagramRunnable.transformToFormat(extension);
        this.visibleElements = visibleElements != null ? visibleElements : Collections.emptyList();
    }

    private static FileFormat transformToFormat(String ext) {
        try {
            FileFormat format = FileFormat.valueOf(ext.toUpperCase());
            return format;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IGendocDiagnostician diagnostician = (IGendocDiagnostician)GendocServices.getDefault().getService(IGendocDiagnostician.class);
            String message = "The format " + ext + " is not supported";
            diagnostician.addDiagnostic((Diagnostic)new BasicDiagnostic(4, "org.eclipse.gendoc.tags.handlers", 0, message, null));
            return FileFormat.valueOf(ext);
        }
    }

    public void run(final String resourceId, final String outputResourceFolder) {
        if (Realm.getDefault() == null) {
            Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)Display.getDefault()), (Runnable)new Runnable(){

                @Override
                public void run() {
                    GMFDiagramRunnable.this.doRun(resourceId, outputResourceFolder);
                }
            });
        } else {
            this.doRun(resourceId, outputResourceFolder);
        }
    }

    protected void doRun(String resourceId, String outputResourceFolder) {
        if (this.extension != null) {
            MultiElementsCopytoImageUtils c = new MultiElementsCopytoImageUtils();
            new File(outputResourceFolder).mkdirs();
            Path path = new Path(String.valueOf(outputResourceFolder) + "/" + resourceId + this.extension.getFullExtension());
            try {
                ResourceSet resourceSet;
                Resource eResource = this.diagram.eResource();
                if (eResource != null && TransactionUtil.getEditingDomain((ResourceSet)(resourceSet = eResource.getResourceSet())) == null) {
                    TransactionalEditingDomain.Factory factory = TransactionalEditingDomain.Factory.INSTANCE;
                    factory.createEditingDomain(resourceSet);
                }
                if (this.visibleElements == null || this.visibleElements.isEmpty()) {
                    c.copyToImage(this.diagram, (IPath)path, this.getImageFileFormat(this.extension.getExtension()), new NullProgressMonitor(), PreferencesHint.USE_DEFAULTS);
                } else {
                    c.copyToImage(this.diagram, (IPath)path, this.visibleElements, this.getImageFileFormat(this.extension.getExtension()), new NullProgressMonitor(), PreferencesHint.USE_DEFAULTS);
                }
                IImageManipulationServiceFactory imageManipulationServiceFactory = (IImageManipulationServiceFactory)GendocServices.getDefault().getService(IImageManipulationServiceFactory.class);
                IImageManipulationService imageManipulationService = imageManipulationServiceFactory.getService(this.extension.name().toLowerCase());
                imageManipulationService.transform((IPath)path);
            }
            catch (CoreException e) {
                IGendocDiagnostician diag = (IGendocDiagnostician)GendocServices.getDefault().getService(IGendocDiagnostician.class);
                if (diag != null) {
                    diag.addDiagnostic(2, "no image can be generated for Diagram : " + this.diagram.toString(), (Object)new Object[]{this.diagram});
                }
                e.printStackTrace();
            }
            catch (Exception ex) {
                IGendocDiagnostician diag = (IGendocDiagnostician)GendocServices.getDefault().getService(IGendocDiagnostician.class);
                if (diag != null) {
                    diag.addDiagnostic(2, "no image can be generated for Diagram : " + this.diagram.toString(), (Object)new Object[]{this.diagram});
                }
                ex.printStackTrace();
            }
        }
    }

    private ImageFileFormat getImageFileFormat(FileFormat format) {
        return ImageFileFormat.resolveImageFormat((String)format.name());
    }

    public String getFileExtension() {
        return this.extension.toString().toLowerCase();
    }

    public List<?> getEditParts(List<EObject> visibleElements, DiagramEditPart diagramEditPart) {
        return this.getEditParts(visibleElements, diagramEditPart, true);
    }

    public List<?> getEditParts(List<EObject> visibleElements, DiagramEditPart diagramEditPart, boolean includeConnections) {
        LinkedList<GraphicalEditPart> result = new LinkedList<GraphicalEditPart>();
        for (EObject e : visibleElements) {
            Object model = diagramEditPart.getModel();
            if (!(model instanceof Diagram)) continue;
            Diagram diagram = (Diagram)model;
            TreeIterator i = EcoreUtil.getAllProperContents((EObject)diagram, (boolean)true);
            while (i.hasNext()) {
                Object part;
                View view;
                EObject current = (EObject)i.next();
                if (!(current instanceof View) || !this.equals(e, (view = (View)current).getElement()) || !((part = diagramEditPart.getViewer().getEditPartRegistry().get(view)) instanceof GraphicalEditPart)) continue;
                result.add((GraphicalEditPart)part);
            }
        }
        if (includeConnections) {
            ArrayList tmp = new ArrayList(result);
            for (GraphicalEditPart g : tmp) {
                result.addAll(this.findConnectionsToPaint(g, result));
            }
        }
        return result;
    }

    protected boolean equals(EObject e, EObject fromView) {
        boolean result = false;
        if (fromView == e) {
            result = true;
        } else if (e.eResource() != null && fromView.eResource() != null) {
            Resource eResource = e.eResource();
            Resource viewResoure = fromView.eResource();
            if (eResource.getURI() != null && eResource.getURI().equals(viewResoure.getURI())) {
                result = eResource.getURIFragment(e) != null && eResource.getURIFragment(e).equals(viewResoure.getURIFragment(fromView));
            }
        }
        return result;
    }

    protected Collection<ConnectionEditPart> findConnectionsToPaint(GraphicalEditPart editPart, List<GraphicalEditPart> relatedEditParts) {
        HashSet<GraphicalEditPart> editParts = new HashSet<GraphicalEditPart>();
        HashSet<ConnectionEditPart> connectionEPs = new HashSet<ConnectionEditPart>();
        HashSet<ConnectionEditPart> connectionsToPaint = new HashSet<ConnectionEditPart>();
        this.getNestedEditParts(editPart, editParts);
        for (GraphicalEditPart gep : editParts) {
            connectionEPs.addAll(this.getAllConnectionsFrom(gep));
        }
        connectionEPs.addAll(this.getAllConnectionsFrom(editPart));
        while (!connectionEPs.isEmpty()) {
            Stack<ConnectionEditPart> connectionsPath = new Stack<ConnectionEditPart>();
            ConnectionEditPart conn = (ConnectionEditPart)connectionEPs.iterator().next();
            connectionEPs.remove(conn);
            connectionsPath.add(conn);
            EditPart target = conn.getTarget();
            while (connectionEPs.contains(target)) {
                ConnectionEditPart targetConn = (ConnectionEditPart)target;
                connectionEPs.remove(targetConn);
                connectionsPath.add(targetConn);
                target = targetConn.getTarget();
            }
            if (!editParts.contains(target) && !connectionsToPaint.contains(target) && !relatedEditParts.contains(target)) continue;
            connectionsToPaint.addAll(connectionsPath);
        }
        return connectionsToPaint;
    }

    protected void getNestedEditParts(GraphicalEditPart baseEditPart, Collection<GraphicalEditPart> editParts) {
        for (Object child : baseEditPart.getChildren()) {
            if (!(child instanceof GraphicalEditPart)) continue;
            GraphicalEditPart childEP = (GraphicalEditPart)child;
            editParts.add(childEP);
            this.getNestedEditParts(childEP, editParts);
        }
    }

    protected List<ConnectionEditPart> getAllConnectionsFrom(GraphicalEditPart ep) {
        LinkedList<ConnectionEditPart> connections = new LinkedList<ConnectionEditPart>();
        for (Object sourceConnObj : ep.getSourceConnections()) {
            if (!(sourceConnObj instanceof ConnectionEditPart)) continue;
            ConnectionEditPart sourceConn = (ConnectionEditPart)sourceConnObj;
            connections.add(sourceConn);
            connections.addAll(this.getAllConnectionsFrom((GraphicalEditPart)sourceConn));
        }
        return connections;
    }

    private static enum FileFormat {
        PNG,
        JPEG,
        GIF,
        BMP,
        JPG,
        SVG,
        EMF;


        public FileFormat getExtension() {
            IImageManipulationServiceFactory imageManipulationServiceFactory = (IImageManipulationServiceFactory)GendocServices.getDefault().getService(IImageManipulationServiceFactory.class);
            IImageManipulationService imageManipulationService = imageManipulationServiceFactory.getService(this.name().toLowerCase());
            return GMFDiagramRunnable.transformToFormat(imageManipulationService.renameExtension(this.name()));
        }

        public String getFullExtension() {
            return "." + this.getExtension().name().toLowerCase();
        }
    }

    public class MultiElementsCopytoImageUtils
    extends CopyToImageUtil {
        public List copyToImage(Diagram diagram, IPath destination, ImageFileFormat format, NullProgressMonitor monitor, PreferencesHint preferencesHint) throws CoreException {
            Trace.trace((Plugin)DiagramUIRenderPlugin.getInstance(), (String)("Copy diagram to Image " + destination + " as " + format));
            List partInfo = Collections.EMPTY_LIST;
            DiagramEditor openedDiagramEditor = this.findOpenedDiagramEditor(diagram);
            if (openedDiagramEditor != null) {
                DiagramGenerator generator = this.copyToImage(openedDiagramEditor.getDiagramEditPart(), destination, format, (IProgressMonitor)monitor);
                partInfo = generator.getDiagramPartInfo(openedDiagramEditor.getDiagramEditPart());
            } else {
                Shell shell = new Shell();
                try {
                    DiagramEditPart diagramEditPart = this.createDiagramEditPart(diagram, shell, preferencesHint);
                    Assert.isNotNull((Object)diagramEditPart);
                    DiagramGenerator generator = this.copyToImage(diagramEditPart, destination, format, (IProgressMonitor)monitor);
                    partInfo = generator.getDiagramPartInfo(diagramEditPart);
                }
                finally {
                    shell.dispose();
                }
            }
            return partInfo;
        }

        private DiagramEditor findOpenedDiagramEditor(Diagram diagram) {
            DiagramEditor result = DiagramEditorUtil.findOpenedDiagramEditorForID((String)ViewUtil.getIdStr((View)diagram));
            if (result != null) {
                IPath iPathDiagEditor = this.getIPath(result.getDiagram());
                IPath iPathDiag = this.getIPath(diagram);
                if (iPathDiagEditor == null || iPathDiag == null || !iPathDiag.equals((Object)iPathDiagEditor)) {
                    ((ILogger)GendocServices.getDefault().getService(ILogger.class)).log("Two diagrams in separate files " + iPathDiagEditor + " and " + iPathDiag + " have the same identifier", 2);
                    return null;
                }
            }
            return result;
        }

        private IPath getIPath(Diagram diagram) {
            IFile file;
            Resource resource;
            if (diagram != null && (resource = diagram.eResource()) != null && (file = WorkspaceSynchronizer.getUnderlyingFile((Resource)resource)) != null) {
                return file.getFullPath();
            }
            return null;
        }

        public List copyToImage(Diagram diagram, IPath destination, List<EObject> visibleElements, ImageFileFormat format, NullProgressMonitor monitor, PreferencesHint preferencesHint) throws CoreException {
            Shell shell = null;
            try {
                Trace.trace((Plugin)DiagramUIRenderPlugin.getInstance(), (String)("Copy diagram to Image " + destination + " as " + format));
                List partInfo = Collections.EMPTY_LIST;
                DiagramEditor openedDiagramEditor = this.findOpenedDiagramEditor(diagram);
                DiagramEditPart diagramEditPart = null;
                if (openedDiagramEditor != null) {
                    diagramEditPart = openedDiagramEditor.getDiagramEditPart();
                } else {
                    shell = new Shell();
                    diagramEditPart = this.createDiagramEditPart(diagram, shell, preferencesHint);
                }
                Assert.isNotNull((Object)diagramEditPart);
                this.copyToImage(diagramEditPart, GMFDiagramRunnable.this.getEditParts(visibleElements, diagramEditPart), destination, format, (IProgressMonitor)monitor);
                List list = partInfo;
                return list;
            }
            finally {
                if (shell != null && !shell.isDisposed()) {
                    shell.dispose();
                }
            }
        }
    }
}

