/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.handly.buffer.Buffer;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.impl.DefaultWorkingCopyCallback;
import org.eclipse.handly.model.impl.IWorkingCopyCallback;
import org.eclipse.handly.model.impl.support.ElementManager;
import org.eclipse.handly.model.impl.support.IElementImplSupport;
import org.eclipse.handly.model.impl.support.ISourceFileImplSupport;
import org.eclipse.handly.model.impl.support.SimpleModelManager;
import org.eclipse.handly.model.impl.support.SimpleSourceConstruct;
import org.eclipse.handly.model.impl.support.SimpleSourceFile;
import org.eclipse.handly.model.impl.support.SourceElementBody;
import org.eclipse.handly.model.impl.support.WorkingCopyInfo;

public class ElementManagerTest
extends TestCase {
    private ElementManager manager;
    private SimpleSourceFile a;
    private SimpleSourceConstruct b;

    protected void setUp() throws Exception {
        super.setUp();
        SimpleModelManager modelManager = new SimpleModelManager();
        this.manager = modelManager.elementManager;
        this.a = new SimpleSourceFile(null, "a.foo", null, modelManager);
        this.b = this.a.getChild("B");
    }

    public void test1() {
        ElementManagerTest.assertNull((Object)this.manager.get((IElementImplSupport)this.a));
        ElementManagerTest.assertNull((Object)this.manager.peek((IElementImplSupport)this.a));
        ElementManagerTest.assertNull((Object)this.manager.get((IElementImplSupport)this.b));
        ElementManagerTest.assertNull((Object)this.manager.peek((IElementImplSupport)this.b));
        SourceElementBody aBody = new SourceElementBody();
        SourceElementBody bBody = new SourceElementBody();
        HashMap<Object, SourceElementBody> newElements = new HashMap<Object, SourceElementBody>();
        newElements.put((Object)this.a, aBody);
        newElements.put((Object)this.b, bBody);
        aBody.addChild((IElement)this.b);
        this.manager.put((IElementImplSupport)this.a, newElements);
        ElementManagerTest.assertSame((Object)aBody, (Object)this.manager.get((IElementImplSupport)this.a));
        ElementManagerTest.assertSame((Object)aBody, (Object)this.manager.peek((IElementImplSupport)this.a));
        ElementManagerTest.assertSame((Object)bBody, (Object)this.manager.get((IElementImplSupport)this.b));
        ElementManagerTest.assertSame((Object)bBody, (Object)this.manager.peek((IElementImplSupport)this.b));
        SourceElementBody aBody2 = new SourceElementBody();
        this.manager.pushTemporaryCache(Collections.singletonMap(this.a, aBody2));
        ElementManagerTest.assertSame((Object)aBody2, (Object)this.manager.get((IElementImplSupport)this.a));
        ElementManagerTest.assertSame((Object)aBody2, (Object)this.manager.peek((IElementImplSupport)this.a));
        ElementManagerTest.assertSame((Object)bBody, (Object)this.manager.get((IElementImplSupport)this.b));
        ElementManagerTest.assertSame((Object)bBody, (Object)this.manager.peek((IElementImplSupport)this.b));
        SourceElementBody bBody2 = new SourceElementBody();
        this.manager.pushTemporaryCache(Collections.singletonMap(this.b, bBody2));
        ElementManagerTest.assertSame((Object)aBody2, (Object)this.manager.get((IElementImplSupport)this.a));
        ElementManagerTest.assertSame((Object)aBody2, (Object)this.manager.peek((IElementImplSupport)this.a));
        ElementManagerTest.assertSame((Object)bBody2, (Object)this.manager.get((IElementImplSupport)this.b));
        ElementManagerTest.assertSame((Object)bBody2, (Object)this.manager.peek((IElementImplSupport)this.b));
        this.manager.popTemporaryCache();
        ElementManagerTest.assertSame((Object)aBody2, (Object)this.manager.get((IElementImplSupport)this.a));
        ElementManagerTest.assertSame((Object)aBody2, (Object)this.manager.peek((IElementImplSupport)this.a));
        ElementManagerTest.assertSame((Object)bBody, (Object)this.manager.get((IElementImplSupport)this.b));
        ElementManagerTest.assertSame((Object)bBody, (Object)this.manager.peek((IElementImplSupport)this.b));
        this.manager.popTemporaryCache();
        ElementManagerTest.assertSame((Object)aBody, (Object)this.manager.get((IElementImplSupport)this.a));
        ElementManagerTest.assertSame((Object)aBody, (Object)this.manager.peek((IElementImplSupport)this.a));
        ElementManagerTest.assertSame((Object)bBody, (Object)this.manager.get((IElementImplSupport)this.b));
        ElementManagerTest.assertSame((Object)bBody, (Object)this.manager.peek((IElementImplSupport)this.b));
        try {
            this.manager.popTemporaryCache();
            ElementManagerTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        ElementManagerTest.assertSame((Object)aBody, (Object)this.manager.putIfAbsent((IElementImplSupport)this.a, Collections.singletonMap(this.a, aBody2)));
        ElementManagerTest.assertSame((Object)aBody, (Object)this.manager.get((IElementImplSupport)this.a));
        ElementManagerTest.assertSame((Object)aBody, (Object)this.manager.peek((IElementImplSupport)this.a));
        ElementManagerTest.assertSame((Object)bBody, (Object)this.manager.get((IElementImplSupport)this.b));
        ElementManagerTest.assertSame((Object)bBody, (Object)this.manager.peek((IElementImplSupport)this.b));
        this.manager.remove((IElementImplSupport)this.a);
        ElementManagerTest.assertNull((Object)this.manager.get((IElementImplSupport)this.a));
        ElementManagerTest.assertNull((Object)this.manager.peek((IElementImplSupport)this.a));
        ElementManagerTest.assertNull((Object)this.manager.get((IElementImplSupport)this.b));
        ElementManagerTest.assertNull((Object)this.manager.peek((IElementImplSupport)this.b));
        this.manager.remove((IElementImplSupport)this.a);
        ElementManagerTest.assertNull((Object)this.manager.putIfAbsent((IElementImplSupport)this.a, newElements));
        ElementManagerTest.assertSame((Object)aBody, (Object)this.manager.get((IElementImplSupport)this.a));
        ElementManagerTest.assertSame((Object)aBody, (Object)this.manager.peek((IElementImplSupport)this.a));
        ElementManagerTest.assertSame((Object)bBody, (Object)this.manager.get((IElementImplSupport)this.b));
        ElementManagerTest.assertSame((Object)bBody, (Object)this.manager.peek((IElementImplSupport)this.b));
        this.manager.put((IElementImplSupport)this.a, Collections.singletonMap(this.a, aBody2));
        ElementManagerTest.assertSame((Object)aBody2, (Object)this.manager.get((IElementImplSupport)this.a));
        ElementManagerTest.assertSame((Object)aBody2, (Object)this.manager.peek((IElementImplSupport)this.a));
        ElementManagerTest.assertNull((Object)this.manager.get((IElementImplSupport)this.b));
        ElementManagerTest.assertNull((Object)this.manager.peek((IElementImplSupport)this.b));
    }

    public void test2() {
        TestBuffer buffer = new TestBuffer();
        WorkingCopyInfo info = new WorkingCopyInfo((IBuffer)buffer, Contexts.EMPTY_CONTEXT, (context, monitor) -> {}, (IWorkingCopyCallback)new DefaultWorkingCopyCallback());
        ElementManagerTest.assertEquals((int)0, (int)buffer.refCount);
        ElementManagerTest.assertNull((Object)this.manager.putWorkingCopyInfoIfAbsent((ISourceFileImplSupport)this.a, info));
        ElementManagerTest.assertEquals((int)1, (int)info.refCount);
        ElementManagerTest.assertEquals((int)1, (int)buffer.refCount);
        ElementManagerTest.assertEquals(Collections.singletonList(this.a), Arrays.asList(this.manager.getWorkingCopies()));
        ElementManagerTest.assertFalse((boolean)info.created);
        SourceElementBody body = new SourceElementBody();
        this.manager.put((IElementImplSupport)this.a, Collections.singletonMap(this.a, body));
        ElementManagerTest.assertTrue((boolean)info.created);
        ElementManagerTest.assertSame((Object)info, (Object)this.manager.peekAtWorkingCopyInfo((ISourceFileImplSupport)this.a));
        ElementManagerTest.assertEquals((int)1, (int)info.refCount);
        ElementManagerTest.assertEquals((int)1, (int)buffer.refCount);
        ElementManagerTest.assertSame((Object)info, (Object)this.manager.getWorkingCopyInfo((ISourceFileImplSupport)this.a));
        ElementManagerTest.assertEquals((int)2, (int)info.refCount);
        ElementManagerTest.assertEquals((int)1, (int)buffer.refCount);
        WorkingCopyInfo info2 = new WorkingCopyInfo((IBuffer)buffer, Contexts.EMPTY_CONTEXT, (context, monitor) -> {}, (IWorkingCopyCallback)new DefaultWorkingCopyCallback());
        ElementManagerTest.assertEquals((int)1, (int)buffer.refCount);
        ElementManagerTest.assertSame((Object)info, (Object)this.manager.putWorkingCopyInfoIfAbsent((ISourceFileImplSupport)this.a, info2));
        ElementManagerTest.assertEquals((int)3, (int)info.refCount);
        ElementManagerTest.assertEquals((int)0, (int)info2.refCount);
        ElementManagerTest.assertEquals((int)1, (int)buffer.refCount);
        ElementManagerTest.assertSame((Object)info, (Object)this.manager.releaseWorkingCopyInfo((ISourceFileImplSupport)this.a));
        ElementManagerTest.assertEquals((int)2, (int)info.refCount);
        ElementManagerTest.assertEquals((int)1, (int)buffer.refCount);
        ElementManagerTest.assertSame((Object)info, (Object)this.manager.releaseWorkingCopyInfo((ISourceFileImplSupport)this.a));
        ElementManagerTest.assertEquals((int)1, (int)info.refCount);
        ElementManagerTest.assertEquals((int)1, (int)buffer.refCount);
        ElementManagerTest.assertSame((Object)body, (Object)this.manager.peek((IElementImplSupport)this.a));
        ElementManagerTest.assertSame((Object)info, (Object)this.manager.releaseWorkingCopyInfo((ISourceFileImplSupport)this.a));
        ElementManagerTest.assertTrue((boolean)info.isDisposed());
        ElementManagerTest.assertEquals((int)0, (int)buffer.refCount);
        ElementManagerTest.assertEquals((int)0, (int)this.manager.getWorkingCopies().length);
        ElementManagerTest.assertNull((Object)this.manager.getWorkingCopyInfo((ISourceFileImplSupport)this.a));
        ElementManagerTest.assertNull((Object)this.manager.get((IElementImplSupport)this.a));
        ElementManagerTest.assertNull((Object)this.manager.releaseWorkingCopyInfo((ISourceFileImplSupport)this.a));
    }

    private static class TestBuffer
    extends Buffer {
        int refCount;

        private TestBuffer() {
        }

        public void addRef() {
            super.addRef();
            ++this.refCount;
        }

        public void release() {
            --this.refCount;
            super.release();
        }
    }
}

