/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.form;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclipse.january.form.AbstractEntry;
import org.eclipse.january.form.Component;
import org.eclipse.january.form.DataComponent;
import org.eclipse.january.form.IComponentVisitor;
import org.eclipse.january.form.IEntry;
import org.eclipse.january.form.IUpdateableListener;
import org.eclipse.january.form.TreeComposite;

@XmlRootElement(name="AdaptiveTreeComposite")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AdaptiveTreeComposite
extends TreeComposite {
    @XmlAttribute
    private String type = null;
    @XmlElementWrapper(name="TypesMap")
    private HashMap<String, TreeComposite> typesMap;

    public AdaptiveTreeComposite() {
        this(null);
    }

    public AdaptiveTreeComposite(ArrayList<TreeComposite> types) {
        this.setName("Adaptive Tree Composite 1");
        this.setDescription("A TreeComposite object that can toggle its type");
        this.setId(1);
        if (types != null && !types.isEmpty()) {
            this.typesMap = new HashMap();
            for (TreeComposite tree : types) {
                this.typesMap.put(tree.getName(), tree);
            }
        }
    }

    public String getType() {
        return this.type;
    }

    public boolean setType(String type) {
        TreeComposite typeTree;
        boolean wasSuccess = false;
        TreeComposite child = null;
        if (type != null && !type.isEmpty() && !type.equals(this.type) && (typeTree = this.typesMap.get(type)) != null) {
            ArrayList listenersCopy = new ArrayList(this.listeners);
            for (IUpdateableListener listener : listenersCopy) {
                this.unregister(listener);
            }
            String oldTreeName = this.getName();
            boolean isActive = this.isActive();
            String oldType = this.getType();
            ArrayList<TreeComposite> childExemplars = this.getChildExemplars();
            ArrayList<TreeComposite> children = new ArrayList<TreeComposite>();
            this.resetChildIterator();
            while ((child = this.getNextChild()) != null) {
                children.add(child);
            }
            ArrayList<Component> oldDataNodes = this.getDataNodes();
            if (oldDataNodes != null && !oldDataNodes.isEmpty()) {
                DataComponent oldParamData = (DataComponent)oldDataNodes.get(0);
                this.type = type;
                this.copy(typeTree);
                ArrayList<Component> newDataNodes = this.getDataNodes();
                DataComponent newParamData = (DataComponent)newDataNodes.get(0);
                HashMap<String, IEntry> newParamMap = new HashMap<String, IEntry>();
                for (IEntry currEntry : newParamData.retrieveAllEntries()) {
                    newParamMap.put(currEntry.getName(), currEntry);
                }
                TreeComposite oldTypeTree = this.typesMap.get(oldType);
                HashMap<String, IEntry> oldTypeParamMap = null;
                if (oldTypeTree != null) {
                    DataComponent oldTypeParameters = (DataComponent)oldTypeTree.getDataNodes().get(0);
                    oldTypeParamMap = new HashMap<String, IEntry>();
                    for (IEntry currEntry : oldTypeParameters.retrieveAllEntries()) {
                        oldTypeParamMap.put(currEntry.getName(), currEntry);
                    }
                }
                for (IEntry currEntry : oldParamData.retrieveAllEntries()) {
                    if (newParamMap.containsKey(currEntry.getName())) {
                        IEntry newEntry = (IEntry)newParamMap.get(currEntry.getName());
                        boolean req = currEntry.isRequired();
                        ((AbstractEntry)newEntry).copy((AbstractEntry)currEntry);
                        newEntry.setRequired(req);
                    } else if (oldType == null || !oldTypeParamMap.containsKey(currEntry.getName())) {
                        newParamData.addEntry(currEntry);
                    }
                    if (!"type".equals(currEntry.getName())) continue;
                    ((IEntry)newParamMap.get(currEntry.getName())).setValue(type);
                }
            } else {
                this.type = type;
                this.copy(typeTree);
            }
            this.setName(oldTreeName);
            this.setActive(isActive);
            if (this.getDataNodes() != null && !this.getDataNodes().isEmpty()) {
                this.setActiveDataNode(this.getDataNodes().get(0));
            }
            for (TreeComposite tree : children) {
                this.setNextChild(tree);
            }
            this.setChildExemplars(childExemplars);
            wasSuccess = true;
            for (IUpdateableListener listener : listenersCopy) {
                this.register(listener);
            }
            this.notifyListeners();
        }
        return wasSuccess;
    }

    public ArrayList<String> getTypes() {
        return this.typesMap != null ? new ArrayList<String>(this.typesMap.keySet()) : null;
    }

    public void copy(AdaptiveTreeComposite otherObject) {
        if (otherObject == null || otherObject == this) {
            return;
        }
        this.typesMap = otherObject.typesMap;
        this.type = otherObject.type;
        super.copy(otherObject);
    }

    @Override
    public AdaptiveTreeComposite clone() {
        AdaptiveTreeComposite clonedTree = new AdaptiveTreeComposite(null);
        clonedTree.copy(this);
        return clonedTree;
    }

    @Override
    public boolean equals(Object otherObject) {
        boolean isEqual = false;
        if (this == otherObject) {
            isEqual = true;
        } else if (otherObject != null && otherObject instanceof AdaptiveTreeComposite) {
            AdaptiveTreeComposite otherTree = (AdaptiveTreeComposite)otherObject;
            isEqual = super.equals(otherTree) && (this.type == null ? otherTree.type == null : this.type.equals(otherTree.type)) && this.typesMap.equals(otherTree.typesMap);
        }
        return isEqual;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = this.type == null ? hash : 31 * hash + this.type.hashCode();
        hash = 31 * hash + this.typesMap.hashCode();
        return hash;
    }

    @Override
    public void accept(IComponentVisitor visitor) {
        if (visitor != null) {
            visitor.visit(this);
        }
    }
}

