/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import org.eclipse.january.dataset.IDynamicDataset;
import org.eclipse.january.dataset.ILazyDataset;
import org.eclipse.january.dataset.Slice;

public class SliceND {
    private int[] lstart;
    private int[] lstop;
    private int[] lstep;
    private transient int[] lshape;
    private int[] oshape;
    private int[] mshape;
    private boolean expanded;

    public SliceND(int[] shape) {
        int rank = shape.length;
        this.lstart = new int[rank];
        this.lstop = (int[])shape.clone();
        this.lstep = new int[rank];
        Arrays.fill(this.lstep, 1);
        this.lshape = (int[])shape.clone();
        this.oshape = (int[])shape.clone();
        this.mshape = this.oshape;
        this.expanded = false;
    }

    public SliceND(int[] shape, Slice ... slice) {
        this(shape, (int[])null, slice);
    }

    public SliceND(int[] shape, int[] maxShape, Slice ... slice) {
        this(shape);
        if (maxShape != null) {
            this.initMaxShape(maxShape);
        }
        if (slice != null) {
            int length = slice.length;
            int rank = shape.length;
            if (length > rank) {
                throw new IllegalArgumentException("More slices have been specified than rank of shape");
            }
            int i = 0;
            while (i < length) {
                Slice s = slice[i];
                if (s != null) {
                    this.setSlice(i, s);
                }
                ++i;
            }
        }
    }

    private void initMaxShape(int[] maxShape) {
        int rank = this.oshape.length;
        if (maxShape.length != rank) {
            throw new IllegalArgumentException("Maximum shape must have same rank as shape");
        }
        this.mshape = (int[])maxShape.clone();
        int i = 0;
        while (i < rank) {
            int m = this.mshape[i];
            if (m != -1 && m < this.oshape[i]) {
                throw new IllegalArgumentException("Maximum shape must be greater than or equal to shape");
            }
            ++i;
        }
    }

    public SliceND(int[] shape, int[] start, int[] stop, int[] step) {
        this(shape, null, start, stop, step);
    }

    public SliceND(int[] shape, int[] maxShape, int[] start, int[] stop, int[] step) {
        int rank = shape.length;
        this.lstart = start == null ? new int[rank] : (int[])start.clone();
        this.lstop = stop == null ? new int[rank] : (int[])stop.clone();
        if (step == null) {
            this.lstep = new int[rank];
            Arrays.fill(this.lstep, 1);
        } else {
            this.lstep = (int[])step.clone();
        }
        if (this.lstart.length != rank || this.lstop.length != rank || this.lstep.length != rank) {
            throw new IllegalArgumentException("No of indexes does not match data dimensions: you passed it start=" + this.lstart.length + ", stop=" + this.lstop.length + ", step=" + this.lstep.length + ", and it needs " + rank);
        }
        this.lshape = new int[rank];
        this.oshape = (int[])shape.clone();
        if (maxShape == null) {
            this.mshape = this.oshape;
        } else {
            this.initMaxShape(maxShape);
        }
        int i = 0;
        while (i < rank) {
            this.internalSetSlice(i, start == null ? null : Integer.valueOf(this.lstart[i]), stop == null ? null : Integer.valueOf(this.lstop[i]), this.lstep[i]);
            ++i;
        }
    }

    public void setSlice(int i, Integer start, Integer stop, int step) {
        this.internalSetSlice(i, start, stop, step);
    }

    public void setSlice(int i, int start, int stop, int step) {
        this.internalSetSlice(i, start, stop, step);
    }

    public void setSlice(int i, Slice slice) {
        this.internalSetSlice(i, slice.getStart(), slice.getStop(), slice.getStep());
    }

    private void internalSetSlice(int i, Integer start, Integer stop, int step) {
        if (step == 0) {
            throw new IllegalArgumentException("Step size must not be zero");
        }
        int s = this.oshape[i];
        int m = this.mshape[i];
        if (start == null) {
            start = step > 0 ? 0 : s - 1;
        } else if (start < 0) {
            start = start + s;
        }
        if (step > 0) {
            if (start < 0) {
                start = 0;
            } else if (start > s) {
                if (m == s) {
                    start = s;
                } else if (m != -1 && start > m) {
                    start = m;
                }
            }
            if (stop == null) {
                if (start >= s && m == -1) {
                    throw new IllegalArgumentException("To extend past current dimension in unlimited case, a stop value must be specified");
                }
                stop = s;
            } else if (stop < 0) {
                stop = stop + s;
            }
            if (stop < 0) {
                stop = 0;
            } else if (stop > s) {
                if (m == s) {
                    stop = s;
                } else if (m != -1 && stop > m) {
                    stop = m;
                }
            }
            if (start >= stop) {
                if (start < s || m == s) {
                    this.lstop[i] = start;
                } else {
                    stop = start + step;
                    if (m != -1 && stop > m) {
                        stop = m;
                    }
                    this.lstop[i] = stop;
                }
            } else {
                this.lstop[i] = stop;
            }
            if (this.lstop[i] > s) {
                this.oshape[i] = this.lstop[i];
                this.expanded = true;
            }
        } else {
            if (start < 0) {
                start = -1;
            } else if (start >= s) {
                start = s - 1;
            }
            if (stop == null) {
                stop = -1;
            } else if (stop < 0) {
                stop = stop + s;
            }
            if (stop < -1) {
                stop = -1;
            } else if (stop >= s) {
                stop = s - 1;
            }
            this.lstop[i] = stop >= start ? start.intValue() : stop.intValue();
        }
        this.lshape[i] = start == (stop = Integer.valueOf(this.lstop[i])) ? 0 : (step > 0 ? Math.max(0, (stop - start - 1) / step + 1) : Math.max(0, (stop - start + 1) / step + 1));
        this.lstart[i] = start;
        this.lstep[i] = step;
    }

    public int[] getSourceShape() {
        return this.oshape;
    }

    public int[] getMaxShape() {
        return this.mshape;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public int[] getShape() {
        return this.lshape;
    }

    public int[] getStart() {
        return this.lstart;
    }

    public int[] getStop() {
        return this.lstop;
    }

    public int[] getStep() {
        return this.lstep;
    }

    public boolean isAll() {
        if (this.expanded) {
            return false;
        }
        boolean allData = Arrays.equals(this.oshape, this.getShape());
        if (allData) {
            int i = 0;
            while (i < this.lshape.length) {
                if (this.lstep[i] < 0) {
                    allData = false;
                    break;
                }
                ++i;
            }
        }
        return allData;
    }

    public SliceND flip(int i) {
        if (i < 0 || i >= this.lshape.length) {
            throw new IllegalArgumentException("Given dimension is less than zero or greater than last dimension");
        }
        int beg = this.lstart[i];
        int end = this.lstop[i];
        int step = this.lstep[i];
        int del = this.lstep[i] > 0 ? 1 : -1;
        int num = (end - beg - del) / step + 1;
        this.lstart[i] = beg + (num - 1) * step;
        this.lstop[i] = Math.max(beg - step, -1);
        this.lstep[i] = -step;
        return this;
    }

    public SliceND flip() {
        int orank = this.lshape.length;
        int i = 0;
        while (i < orank) {
            this.flip(i);
            ++i;
        }
        return this;
    }

    public Slice[] convertToSlice() {
        int orank = this.lshape.length;
        Slice[] slice = new Slice[orank];
        int j = 0;
        while (j < orank) {
            slice[j] = new Slice(this.lstart[j], this.lstop[j], this.lstep[j]);
            ++j;
        }
        return slice;
    }

    public SliceND clone() {
        SliceND c = new SliceND(this.oshape);
        int i = 0;
        while (i < this.lshape.length) {
            c.lstart[i] = this.lstart[i];
            c.lstop[i] = this.lstop[i];
            c.lstep[i] = this.lstep[i];
            c.lshape[i] = this.lshape[i];
            ++i;
        }
        c.expanded = this.expanded;
        return c;
    }

    public String toString() {
        int rank = this.lshape.length;
        if (rank == 0) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < rank) {
            Slice.appendSliceToString(s, this.oshape[i], this.lstart[i], this.lstop[i], this.lstep[i]);
            s.append(',');
            ++i;
        }
        return s.substring(0, s.length() - 1);
    }

    public static SliceND createSlice(ILazyDataset data, int[] start, int[] stop) {
        return SliceND.createSlice(data, start, stop, null);
    }

    public static SliceND createSlice(ILazyDataset data, int[] start, int[] stop, int[] step) {
        if (data instanceof IDynamicDataset) {
            return new SliceND(data.getShape(), ((IDynamicDataset)data).getMaxShape(), start, stop, step);
        }
        return new SliceND(data.getShape(), start, stop, step);
    }
}

