/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ie extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "arabic";
        final String metaValue_ja = "japanesi";
        final String metaValue_ko = "korean";
        final Object[][] data = new Object[][] {
            { "001", "munde" },
            { "002", "Africa" },
            { "005", "Sud-America" },
            { "009", "Oceania" },
            { "013", "central America" },
            { "019", "Americas" },
            { "021", "Nord-America" },
            { "142", "Asia" },
            { "150", "Europa" },
            { "419", "latin America" },
            { "AL", "Albania" },
            { "AQ", "Antarctica" },
            { "AT", "Austria" },
            { "BA", "Bosnia e Herzegovina" },
            { "BE", "Belgia" },
            { "BG", "Bulgaria" },
            { "CH", "Svissia" },
            { "CZ", "Tchekia" },
            { "DE", "Germania" },
            { "DK", "Dania" },
            { "EE", "Estonia" },
            { "ER", "Eritrea" },
            { "ES", "Hispania" },
            { "ET", "Etiopia" },
            { "EU", "Union Europan" },
            { "EZ", "Zone de euro" },
            { "FI", "Finland" },
            { "FJ", "Fidji" },
            { "FR", "Francia" },
            { "GB", "Unit Reyia" },
            { "GR", "Grecia" },
            { "GY", "Guyana" },
            { "HR", "Croatia" },
            { "HU", "Hungaria" },
            { "ID", "Indonesia" },
            { "IE", "Irland" },
            { "IN", "India" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italia" },
            { "KH", "Cambodja" },
            { "LK", "Sri-Lanka" },
            { "LU", "Luxemburg" },
            { "MC", "M\u00f3naco" },
            { "ME", "Montenegro" },
            { "MK", "Nord-Macedonia" },
            { "MQ", "Martinica" },
            { "MT", "Malta" },
            { "MU", "Mauricio" },
            { "MV", "Maldivas" },
            { "NF", "Insul Norfolk" },
            { "NR", "Nauru" },
            { "NZ", "Nov-Zeland" },
            { "PE", "Per\u00fa" },
            { "PH", "Filipines" },
            { "PK", "Pakistan" },
            { "PL", "Polonia" },
            { "PR", "Porto-Rico" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "RO", "Rumania" },
            { "RS", "Serbia" },
            { "RU", "Russia" },
            { "SE", "Svedia" },
            { "SI", "Slovenia" },
            { "SK", "Slovakia" },
            { "SM", "San-Marino" },
            { "SX", "Sint-Maarten" },
            { "TC", "Turks e Caicos" },
            { "TD", "Tchad" },
            { "TK", "Tokelau" },
            { "TL", "Ost-Timor" },
            { "TT", "Trinidad e Tobago" },
            { "TV", "Tuvalu" },
            { "UA", "Ukraina" },
            { "UN", "Unit Nationes" },
            { "VU", "Vanuatu" },
            { "WS", "Samoa" },
            { "XK", "Kosovo" },
            { "ZZ", "\u00ednconosset region" },
            { "ar", metaValue_ar },
            { "cs", "tchec" },
            { "da", "danesi" },
            { "de", "german" },
            { "el", "grec" },
            { "en", "anglesi" },
            { "es", "hispan" },
            { "et", "estonian" },
            { "fa", "persian" },
            { "fr", "francesi" },
            { "hu", "hungarian" },
            { "id", "indonesian" },
            { "ie", "Interlingue" },
            { "it", "italian" },
            { "ja", metaValue_ja },
            { "ko", metaValue_ko },
            { "lv", "lettonian" },
            { "mt", "maltesi" },
            { "nl", "hollandesi" },
            { "pl", "polonesi" },
            { "pt", "portugalesi" },
            { "ru", "russ" },
            { "sk", "slovac" },
            { "sl", "slovenian" },
            { "sv", "sved" },
            { "sw", "swahili" },
            { "tr", "turc" },
            { "zh", "chinesi" },
            { "lij", "ligurian" },
            { "prg", "prussian" },
            { "und", "\u00ednconosset lingue" },
            { "Arab", metaValue_ar },
            { "Cyrl", "cirillic" },
            { "Hans", "simplificat" },
            { "Hant", "traditional" },
            { "Jpan", metaValue_ja },
            { "Kore", metaValue_ko },
            { "Latn", "latin" },
            { "Zxxx", "\u00ednscrit" },
            { "Zzzz", "\u00ednconosset scritura" },
            { "de_AT", "austrian german" },
            { "de_CH", "sviss alt-german" },
            { "es_ES", "europan hispan" },
            { "es_MX", "mexican hispan" },
            { "fr_CH", "sviss francesi" },
            { "nl_BE", "flandrian" },
            { "pt_BR", "brasilian portugalesi" },
            { "pt_PT", "europan portugalesi" },
            { "es_419", "hispan del latin America" },
            { "type.nu.latn", "occidental ciffres" },
            { "type.co.standard", "standard \u00f3rdine" },
            { "type.ca.gregorian", "gregorian calendare" },
        };
        return data;
    }
}
