/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_yo extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwich Mean Time",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Apia",
               "",
               "\u00c0k\u00f3k\u00f2 Oj\u00fam\u1ecdm\u1ecd Apia",
               "",
               "\u00c0k\u00f3k\u00f2 Apia",
               "",
            };
        final String[] Cook = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 \u00c0w\u1ecdn Erekusu Kuuku",
               "",
               "\u00c0k\u00f3k\u00f2 Ilaji S\u1ecdma \u00c0w\u1ecdn Erekusu Kuuku",
               "",
               "\u00c0k\u00f3k\u00f2 \u00c0w\u1ecdn Erekusu Kuuku",
               "",
            };
        final String[] Cuba = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 K\u00fab\u00e0",
               "CST",
               "\u00c0k\u00f3k\u00f2 Oj\u00fam\u1ecdm\u1ecd K\u00fab\u00e0",
               "CDT",
               "\u00c0k\u00f3k\u00f2 K\u00fab\u00e0",
               "CT",
            };
        final String[] Fiji = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Fiji",
               "",
               "\u00c0k\u00f3k\u00f2 S\u1ecdma Fiji",
               "",
               "\u00c0k\u00f3k\u00f2 Fiji",
               "",
            };
        final String[] Gulf = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Gulf",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00ccf\u1eb9nuk\u00f2s\u00ed Hofidi",
               "",
               "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 Hofidi",
               "",
               "\u00c0k\u00f3k\u00f2 Hofidi",
               "",
            };
        final String[] Iran = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Irani",
               "",
               "\u00c0k\u00f3k\u00f2 Oj\u00fam\u1ecdm\u1ecd Irani",
               "",
               "\u00c0k\u00f3k\u00f2 Irani",
               "",
            };
        final String[] Niue = new String[] {
               "\u00c0k\u00f3k\u00f2 Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Omisiki",
               "",
               "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 Omisiki",
               "",
               "\u00c0k\u00f3k\u00f2 Omisiki",
               "",
            };
        final String[] Peru = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 P\u00e9r\u00f9",
               "",
               "\u00c0k\u00f3k\u00f2 Ooru P\u00e9r\u00f9",
               "",
               "\u00c0k\u00f3k\u00f2 P\u00e9r\u00f9",
               "",
            };
        final String[] Truk = new String[] {
               "\u00c0k\u00f3k\u00f2 Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "\u00c0k\u00f3k\u00f2 Er\u00e9k\u00f9s\u00f9 Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 \u1e62\u00edl\u00e8",
               "",
               "\u00c0k\u00f3k\u00f2 Oru \u1e62\u00edl\u00e8",
               "",
               "\u00c0k\u00f3k\u00f2 \u1e62\u00edl\u00e8",
               "",
            };
        final String[] China = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00ccf\u1eb9nuk\u00f2s\u00ed \u1e62\u00e1\u00edn\u00e0",
               "CST",
               "\u00c0k\u00f3k\u00f2 Oj\u00fam\u1ecdm\u1ecd \u1e62\u00e1\u00edn\u00e0",
               "CDT",
               "\u00c0k\u00f3k\u00f2 \u1e62\u00e1\u00edn\u00e0",
               "CT",
            };
        final String[] Cocos = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0w\u1ecdn Er\u00e9k\u00f9s\u00f9 Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "\u00c0k\u00f3k\u00f2 Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 India",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00ccf\u1eb9nuk\u00f2s\u00ed Japan",
               "JST",
               "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 Japan",
               "JDT",
               "\u00c0k\u00f3k\u00f2 Japan",
               "JT",
            };
        final String[] Korea = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00ccf\u1eb9nuk\u00f2s\u00ed Koria",
               "KST",
               "\u00c0k\u00f3k\u00f2 Oj\u00fam\u1ecdm\u1ecd Koria",
               "KST",
               "\u00c0k\u00f3k\u00f2 Koria",
               "KST",
            };
        final String[] Nauru = new String[] {
               "\u00c0k\u00f3k\u00f2 Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "\u00c0k\u00f3k\u00f2 Nepali",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "\u00c0k\u00f3k\u00f2 Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Samoa",
               "SST",
               "\u00c0k\u00f3k\u00f2 Oj\u00fam\u1ecdm\u1ecd Samoa",
               "SST",
               "\u00c0k\u00f3k\u00f2 Samoa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "\u00c0k\u00f3k\u00f2 Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Tonga",
               "",
               "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 Tonga",
               "",
               "\u00c0k\u00f3k\u00f2 Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "\u00c0k\u00f3k\u00f2 Y\u00fak\u1ecd\u0301n\u00ec",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Al\u00e1s\u00edk\u00e0",
               "AKST",
               "\u00c0k\u00f3k\u00f2 Oj\u00fam\u1ecd\u0301 Al\u00e1s\u00edk\u00e0",
               "AKDT",
               "\u00c0k\u00f3k\u00f2 Al\u00e1s\u00edk\u00e0",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "\u00c0k\u00f3k\u00f2 Af\u1eb9nuk\u00f2 Am\u00e1s\u1ecd\u0301n\u00ec",
               "",
               "\u00c0k\u00f3k\u00f2 Oru Am\u00e1s\u1ecd\u0301n\u00ec",
               "",
               "\u00c0k\u00f3k\u00f2 Am\u00e1s\u1ecd\u0301n\u00ec",
               "",
            };
        final String[] Azores = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 \u00c1s\u1ecd\u0301s\u00ec",
               "",
               "\u00c0k\u00f3k\u00f2 Ooru \u00c1s\u1ecd\u0301s\u00ec",
               "",
               "\u00c0k\u00f3k\u00f2 \u00c1s\u1ecd\u0301s\u00ec",
               "",
            };
        final String[] Bhutan = new String[] {
               "\u00c0k\u00f3k\u00f2 Bhutan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunei Darussalam Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Aago \u00e0s\u00eck\u00f2 Easter Island",
               "",
               "Aago Soma Easter Island",
               "",
               "Aago Ajnde Ib\u00f9gb\u00e9 Omi",
               "",
            };
        final String[] Guyana = new String[] {
               "\u00c0k\u00f3k\u00f2 G\u00fay\u00e0n\u00e0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Israel",
               "IST",
               "\u00c0k\u00f3k\u00f2 Oj\u00fam\u1ecdm\u1ecd Israel",
               "IDT",
               "\u00c0k\u00f3k\u00f2 Israel",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "\u00c0k\u00f3k\u00f2 Kosirai",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "\u00c0k\u00f3k\u00f2 Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Mosiko",
               "MSK",
               "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 Mosiko",
               "MSK",
               "\u00c0k\u00f3k\u00f2 Mosiko",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "\u00c0k\u00f3k\u00f2 Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "\u00c0k\u00f3k\u00f2 Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00ccf\u1eb9nuk\u00f2s\u00ed Taipei",
               "CST",
               "\u00c0k\u00f3k\u00f2 Oj\u00fam\u1ecdm\u1ecd Taipei",
               "CDT",
               "\u00c0k\u00f3k\u00f2 Taipei",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "\u00c0k\u00f3k\u00f2 Tufalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "\u00c0k\u00f3k\u00f2 Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "\u00c0k\u00f3k\u00f2 Wallis & Futuina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Arabia",
               "",
               "\u00c0k\u00f3k\u00f2 Oj\u00fam\u1ecdm\u1ecd Arabia",
               "",
               "\u00c0k\u00f3k\u00f2 Arabia",
               "",
            };
        final String[] Armenia = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Armenia",
               "",
               "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 Arabia",
               "",
               "\u00c0k\u00f3k\u00f2 Armenia",
               "",
            };
        final String[] Bolivia = new String[] {
               "Aago Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Chatam",
               "",
               "\u00c0k\u00f3k\u00f2 Oj\u00fam\u1ecdm\u1ecd Chatam",
               "",
               "\u00c0k\u00f3k\u00f2 Chatam",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "\u00c0pap\u1ecd\u0300 \u00c0k\u00f3k\u00f2 \u00c0gb\u00e1y\u00e9",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Aago Ecuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "\u00c0k\u00f3k\u00f2 Gambia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Georgia",
               "",
               "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 Georgia",
               "",
               "\u00c0k\u00f3k\u00f2 Georgia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 \u00cdk\u00f3s\u00edk\u00ec",
               "",
               "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 \u00cdk\u00fas\u00edk\u00ec",
               "",
               "\u00c0k\u00f3k\u00f2 \u00cdk\u00f3s\u00edk\u00ec",
               "",
            };
        final String[] Magadan = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Magadani",
               "",
               "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 Magadani",
               "",
               "\u00c0k\u00f3k\u00f2 Magadani",
               "",
            };
        final String[] Myanmar = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00ccl\u00e0 Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Er\u00e9k\u00f9s\u00f9 Norfolk",
               "",
               "\u00c0k\u00f3k\u00f2 Oj\u00fam\u1ecdm\u1ecd Er\u00e9k\u00f9s\u00f9 Norfolk",
               "",
               "\u00c0k\u00f3k\u00f2 Er\u00e9k\u00f9s\u00f9 Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "Aago \u00e0s\u00eck\u00f2 Fenando de Norona",
               "",
               "Aago Soma Fernando de Noronha",
               "",
               "Aago Fenando de Norona",
               "",
            };
        final String[] Reunion = new String[] {
               "\u00c0k\u00f3k\u00f2 R\u1eb9\u0301y\u00fan\u00ed\u1ecd\u0301n\u00ec",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "\u00c0k\u00f3k\u00f2 Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0w\u1ecdn Erekusu Solomon",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "\u00c0k\u00f3k\u00f2 Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 \u00dar\u00fag\u00faw\u00e8",
               "",
               "Aago Soma Uruguay",
               "",
               "Aago Uruguay",
               "",
            };
        final String[] Vanuatu = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Fanuatu",
               "",
               "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 Fanuatu",
               "",
               "\u00c0k\u00f3k\u00f2 Fanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Yatutsk",
               "",
               "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 Yatutsk",
               "",
               "\u00c0k\u00f3k\u00f2 Yatutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00e0sik\u00f2 \u00c0t\u00ecl\u00e1\u0144t\u00ed\u00eck\u00ec",
               "AST",
               "\u00c0k\u00f3k\u00f2 \u00ccy\u00e1l\u1eb9ta \u00c0t\u00ecl\u00e1\u0144t\u00ed\u00eck\u00ec",
               "AST",
               "\u00c0k\u00f3k\u00f2 \u00c0t\u00ecl\u00e1\u0144t\u00ed\u00eck\u00ec",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Aago \u00e0s\u00eck\u00f2 B\u00f9r\u00e0s\u00edl\u00ed\u00e0",
               "",
               "Aago Soma Brasilia",
               "",
               "Aago B\u00f9r\u00e0s\u00edl\u00ed\u00e0",
               "",
            };
        final String[] Chamorro = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Aago \u00e0s\u00eck\u00f2 Kolombia",
               "",
               "Aago Soma Colombia",
               "",
               "Aago Kolombia",
               "",
            };
        final String[] Falkland = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Et\u00edkun F\u00f3k\u00edl\u00e1nd\u00ec",
               "",
               "\u00c0k\u00f3k\u00f2 Ooru Et\u00edkun F\u00f3k\u00edl\u00e1nd\u00ec",
               "",
               "\u00c0k\u00f3k\u00f2 F\u00f3k\u00edl\u00e1nd\u00ec",
               "",
            };
        final String[] Malaysia = new String[] {
               "\u00c0k\u00f3k\u00f2 Malaysia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "\u00c0k\u00f3k\u00f2 Maldives",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00ccf\u1eb9nuk\u00f2s\u00ed Ulaanbaatar",
               "",
               "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 Ulaanbaatar",
               "",
               "\u00c0k\u00f3k\u00f2 Ulaanbaatar",
               "",
            };
        final String[] Pakistan = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Pakistani",
               "PKT",
               "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 Pakistani",
               "PKST",
               "\u00c0k\u00f3k\u00f2 Pakistani",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 P\u00e1r\u00e1g\u00faw\u00e8",
               "",
               "\u00c0k\u00f3k\u00f2 Ooru P\u00e1r\u00e1g\u00faw\u00e8",
               "",
               "\u00c0k\u00f3k\u00f2 P\u00e1r\u00e1g\u00faw\u00e8",
               "",
            };
        final String[] Pitcairn = new String[] {
               "\u00c0k\u00f3k\u00f2 Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Sakhalin",
               "",
               "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 Sakhalin",
               "",
               "\u00c0k\u00f3k\u00f2 Sakhalin",
               "",
            };
        final String[] Suriname = new String[] {
               "\u00c0k\u00f3k\u00f2 S\u00far\u00edn\u00e1m\u00f9",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Aago \u00e0s\u00eck\u00f2 Argentina",
               "",
               "Aago Soma Argentina",
               "",
               "Aago Aj\u1eb9nt\u00ecn\u00e0",
               "",
            };
        final String[] Christmas = new String[] {
               "\u00c0k\u00f3k\u00f2 Er\u00e9k\u00f9s\u00f9 Christmas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Aago Galapago",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00ccf\u1eb9nuk\u00f2s\u00ed Hong Kong",
               "HKT",
               "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 Hong Kong",
               "HKST",
               "\u00c0k\u00f3k\u00f2 Hong Kong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "\u00c0k\u00f3k\u00f2 Indochina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "\u00c0k\u00f3k\u00f2 Kirigisitaani",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Lord Howe",
               "",
               "\u00c0k\u00f3k\u00f2 Oj\u00fam\u1ecdm\u1ecd Lord Howe",
               "",
               "\u00c0k\u00f3k\u00f2 Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "\u00c0k\u00f3k\u00f2 Makuesasi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 M\u00e1r\u00ed\u1e63\u00fa\u1e63\u00ec",
               "",
               "\u00c0k\u00f3k\u00f2 Ooru M\u00e1r\u00ed\u1e63\u00fa\u1e63\u00ec",
               "",
               "\u00c0k\u00f3k\u00f2 M\u00e1r\u00ed\u1e63\u00fa\u1e63\u00ec",
               "",
            };
        final String[] Singapore = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Singapore",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Aago Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Foligogiradi",
               "MSK",
               "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 Foligogiradi",
               "MSK",
               "\u00c0k\u00f3k\u00f2 Foligogiradi",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Azerbaijan",
               "",
               "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 Azerbaijan",
               "",
               "\u00c0k\u00f3k\u00f2 Azerbaijan",
               "",
            };
        final String[] Bangladesh = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Bangladesh",
               "",
               "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 Bangladesh",
               "",
               "\u00c0k\u00f3k\u00f2 Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 K\u00e9p\u00fa F\u00e1\u00e0d\u00ec",
               "",
               "\u00c0k\u00f3k\u00f2 \u1eb8\u0300r\u00fan K\u00e9p\u00fa F\u00e1\u00e0d\u00ec",
               "",
               "\u00c0k\u00f3k\u00f2 K\u00e9p\u00fa F\u00e1\u00e0d\u00ec",
               "",
            };
        final String[] East_Timor = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00ccl\u00e0 oor\u00f9n Timor",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Aago Kasasit\u00e1\u00e0n\u00ec",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "\u00c0k\u00f3k\u00f2 S\u00e8\u1e63\u1eb9\u0301\u1eb9\u0300l\u00ec",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "\u00c0k\u00f3k\u00f2 Tajikisitaani",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Usibekistani",
               "",
               "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 Usibekistani",
               "",
               "\u00c0k\u00f3k\u00f2 Usibekistani",
               "",
            };
        final String[] Afghanistan = new String[] {
               "\u00c0k\u00f3k\u00f2 Afghanistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Krasinoyasiki",
               "",
               "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 Krasinoyasiki",
               "",
               "\u00c0k\u00f3k\u00f2 Krasinoyasiki",
               "",
            };
        final String[] New_Zealand = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 New zealand",
               "NZST",
               "\u00c0k\u00f3k\u00f2 Oj\u00fam\u1ecdm\u1ecd New Zealand",
               "NZDT",
               "\u00c0k\u00f3k\u00f2 New Zealand",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Nofosibiriki",
               "",
               "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 Noforibisiki",
               "",
               "\u00c0k\u00f3k\u00f2 Nofosibiriski",
               "",
            };
        final String[] Philippines = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Filipininni",
               "PST",
               "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 Filipininni",
               "PDT",
               "\u00c0k\u00f3k\u00f2 Filipininni",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Filadifositoki",
               "",
               "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 Filadifositoki",
               "",
               "\u00c0k\u00f3k\u00f2 Filadifositoki",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "\u00c0k\u00f3k\u00f2 Et\u00edkun \u00cdnd\u00ed\u00e0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0w\u1ecdn Erekusu Laini",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Newfoundland",
               "NST",
               "\u00c0k\u00f3k\u00f2 Oj\u00fam\u1ecdm\u1ecd Newfoundland",
               "NDT",
               "\u00c0k\u00f3k\u00f2 Newfoundland",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Turkimenistani",
               "",
               "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 Turkmenistani",
               "",
               "\u00c0k\u00f3k\u00f2 Turkimenistani",
               "",
            };
        final String[] French_Guiana = new String[] {
               "\u00c0k\u00f3k\u00f2 G\u00fay\u00e1n\u00e0 F\u00e1r\u00e1ns\u00e8",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Kalidonia Tuntun",
               "",
               "\u00c0k\u00f3k\u00f2 S\u1ecdma Kalidonia Tuntun",
               "",
               "\u00c0k\u00f3k\u00f2 Kalidonia Tuntun",
               "",
            };
        final String[] South_Georgia = new String[] {
               "\u00c0k\u00f3k\u00f2 G\u00fas\u00f9 J\u1ecd\u0301j\u00ed\u00e0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Yekaterinburg",
               "",
               "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 Yekaterinburg",
               "",
               "\u00c0k\u00f3k\u00f2 Yekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0\u00e1r\u00edn Af\u00edrik\u00e0",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00ccl\u00e0-O\u00f2r\u00f9n Af\u00edrik\u00e0",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00ccw\u1ecd\u0300-O\u00f2r\u00f9n \u00c0f\u1eb9nuk\u00f2 Af\u00edrik\u00e0",
               "WAT",
               "\u00c0k\u00f3k\u00f2 \u00ccw\u1ecd\u0300-O\u00f2r\u00f9n Ooru Af\u00edrik\u00e0",
               "WAT",
               "\u00c0k\u00f3k\u00f2 \u00ccw\u1ecd\u0300-O\u00f2r\u00f9n Af\u00edrik\u00e0",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "\u00c0k\u00f3k\u00f2 Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0\u00e1rin \u00e0sik\u00f2 Europe",
               "CET",
               "\u00c0k\u00f3k\u00f2 \u00c0\u00e1rin S\u1ecdm\u00e0 Europe",
               "CEST",
               "\u00c0k\u00f3k\u00f2 \u00c0\u00e1rin Europe",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00e0sik\u00f2 \u00cch\u00e0 \u00ccl\u00e0 O\u00f2r\u00f9n Europe",
               "EET",
               "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 \u00ccha \u00ccl\u00e0 O\u00f2r\u00f9n Europe",
               "EEST",
               "\u00c0k\u00f3k\u00f2 \u00cch\u00e0 \u00ccl\u00e0 O\u00f2r\u00f9n Europe",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00e0sik\u00f2 \u00ccw\u1ecd O\u00f2r\u00f9n Europe",
               "WET",
               "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 \u00cch\u00e0 \u00ccw\u1ecd O\u00f2r\u00f9n Europe",
               "WEST",
               "\u00c0k\u00f3k\u00f2 \u00ccw\u1ecd O\u00f2r\u00f9n Europe",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 P\u00e1s\u00edf\u00ed\u00eck\u00ec M\u1eb9\u0301s\u00edk\u00f2",
               "MST",
               "\u00c0k\u00f3k\u00f2 Oj\u00fam\u1ecdm\u1ecd P\u00e1s\u00edf\u00ed\u00eck\u00ec M\u1eb9\u0301s\u00edk\u00f2",
               "MDT",
               "\u00c0k\u00f3k\u00f2 P\u00e1s\u00edf\u00ed\u00eck\u00ec M\u1eb9\u0301\u1e63\u00edk\u00f2",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "South Africa Standard Time",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "\u00e0k\u00f3k\u00f2 asiko \u00e0\u00e1r\u00edn gb\u00f9ngb\u00f9n",
               "CST",
               "Ak\u00f3k\u00f2 \u00e0\u00e1r\u00edn gb\u00f9ngb\u00f9n oj\u00fam\u1ecdm\u1ecd",
               "CDT",
               "\u00e0k\u00f3k\u00f2 \u00e0\u00e1r\u00edn gb\u00f9ngb\u00f9n",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Ak\u00f3k\u00f2 \u00c0sik\u00f2 \u00ccha \u00ccla O\u00f2r\u00f9n",
               "EST",
               "\u00c0k\u00f3k\u00f2 oj\u00fam\u1ecdm\u1ecd \u00cch\u00e0 \u00ccl\u00e0 O\u00f2run",
               "EST",
               "\u00c0k\u00f3k\u00f2 \u00ech\u00e0 \u00ecl\u00e0 o\u00f2r\u00f9n",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00e0sik\u00f2 P\u00e0s\u00edf\u00ed\u00eck\u00ec",
               "PST",
               "\u00c0k\u00f3k\u00f2 \u00ccy\u00e1l\u1eb9ta P\u00e0s\u00edf\u00ed\u00eck\u00ec",
               "PDT",
               "\u00c0k\u00f3k\u00f2 P\u00e0s\u00edf\u00ed\u00eck\u00ec",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "\u00c0k\u00f3k\u00f2 G\u00fas\u00f9 F\u00e1rans\u00e9 \u00e0ti \u00c0nt\u00e1t\u00ed\u00eck\u00ec",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0w\u1ecdn Erekusu Gilibati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Hawaii-Aleutian",
               "HST",
               "\u00c0k\u00f3k\u00f2 Oj\u00fam\u1ecdm\u1ecd Hawaii-Aleutian",
               "HST",
               "\u00c0k\u00f3k\u00f2 Hawaii-Aleutian",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0w\u1ecdn Er\u00e9k\u00f9s\u00f9 Phoenix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Pierre & Miquelon",
               "",
               "\u00c0k\u00f3k\u00f2 Oj\u00fam\u1ecdm\u1ecd Pierre & Miquelon",
               "",
               "\u00c0k\u00f3k\u00f2 Pierre & Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "\u00c0k\u00f3k\u00f2 asiko \u00f2k\u00e8",
               "MST",
               "\u00c0k\u00f3k\u00f2 oj\u00fam\u1ecdm\u1ecd Ori-\u00f2k\u00e8",
               "MST",
               "\u00c0k\u00f3k\u00f2 \u00f2k\u00e8",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0w\u1ecdn Erekusu Masaali",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "\u00c0k\u00f3k\u00f2 Papua New Guinea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 \u00c0\u00e0rin G\u00f9ng\u00f9n Australia",
               "ACST",
               "\u00c0k\u00f3k\u00f2 Oj\u00fam\u1ecdm\u1ecd \u00c0\u00e0rin G\u00f9ng\u00f9n Australia",
               "ACDT",
               "\u00c0k\u00f3k\u00f2 \u00c0\u00e0rin G\u00f9ng\u00f9n Australia",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 \u00ccl\u00e0-O\u00f2r\u00f9n Australia",
               "AEST",
               "\u00c0k\u00f3k\u00f2 Oj\u00fam\u1ecdm\u1ecd \u00ccl\u00e0-O\u00f2r\u00f9n Australia",
               "AEDT",
               "\u00c0k\u00f3k\u00f2 \u00ccl\u00e0-O\u00f2r\u00f9n Australia",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 \u00ccw\u1ecd\u0300-O\u00f2r\u00f9n Australia",
               "AWST",
               "\u00c0k\u00f3k\u00f2 Oj\u00fam\u1ecdm\u1ecd \u00ccw\u1ecd\u0300-O\u00f2r\u00f9n Australia",
               "AWDT",
               "\u00c0k\u00f3k\u00f2 \u00ccw\u1ecd\u0300-O\u00f2r\u00f9n Australia",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0\u00e0rin Gb\u00f9ngb\u00f9n Indonesia",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00ccl\u00e0 oor\u00f9n Indonesia",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00ccw\u1ecd\u0300 oor\u00f9n Indonesia",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 \u00c0\u00e0rin G\u00f9ng\u00f9n \u00ccw\u1ecd\u0300-O\u00f2r\u00f9n Australia",
               "",
               "\u00c0k\u00f3k\u00f2 Oj\u00fam\u1ecdm\u1ecd \u00c0\u00e0rin G\u00f9ng\u00f9n \u00ccw\u1ecd\u0300-O\u00f2r\u00f9n Australia",
               "",
               "\u00c0k\u00f3k\u00f2 \u00c0\u00e0rin G\u00f9ng\u00f9n \u00ccw\u1ecd\u0300-O\u00f2r\u00f9n Australia",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 G\u1eb9\u1eb9si",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "\u00c0pap\u1ecd\u0300 \u00c0k\u00f3k\u00f2 \u00c0gb\u00e1y\u00e9",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Airiisi",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "\u00c0pap\u1ecd\u0300 \u00c0k\u00f3k\u00f2 \u00c0gb\u00e1y\u00e9",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "\u00c0pap\u1ecd\u0300 \u00c0k\u00f3k\u00f2 \u00c0gb\u00e1y\u00e9",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 G\u1eb9\u1eb9si",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "\u00c0pap\u1ecd\u0300 \u00c0k\u00f3k\u00f2 \u00c0gb\u00e1y\u00e9",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "\u00c0pap\u1ecd\u0300 \u00c0k\u00f3k\u00f2 \u00c0gb\u00e1y\u00e9",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "\u00c0pap\u1ecd\u0300 \u00c0k\u00f3k\u00f2 \u00c0gb\u00e1y\u00e9",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "\u00c0k\u00f3k\u00f2 \u00c0f\u1eb9nuk\u00f2 Airiisi",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 G\u1eb9\u1eb9si",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 G\u1eb9\u1eb9si",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 G\u1eb9\u1eb9si",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 G\u1eb9\u1eb9si",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "\u00c0k\u00f3k\u00f2 S\u1ecdm\u00e0 G\u1eb9\u1eb9si",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Saigon", "Ilu Ho Chi Minh" },
            { "timezone.excity.Etc/Unknown", "\u00ccl\u00fa \u00c0\u00ecm\u1ecd\u0300" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.America/Adak", "\u00ecl\u00fa Ad\u00e1k\u00ec" },
            { "timezone.excity.America/Nome", "\u00ecl\u00fa Nomi" },
            { "timezone.excity.America/Aruba", "\u00ecl\u00fa Ar\u00fab\u00e1" },
            { "timezone.excity.America/Boise", "\u00ecl\u00fa B\u1ecd\u0301is\u00e8" },
            { "timezone.excity.America/Sitka", "\u00ecl\u00fa Sika" },
            { "timezone.excity.America/Thule", "\u00ecl\u00fa Tul\u00e8" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.America/Belize", "\u00ecl\u00fa B\u1eb9\u0300l\u00ed\u00ecs\u00ec" },
            { "timezone.excity.America/Cancun", "\u00ecl\u00fa Kancun" },
            { "timezone.excity.America/Cayman", "il\u00fa Kayman" },
            { "timezone.excity.America/Dawson", "\u00ecl\u00fa Dawson" },
            { "timezone.excity.America/Denver", "\u00ecl\u00fa Denver" },
            { "timezone.excity.America/Havana", "\u00ecl\u00fa Havana" },
            { "timezone.excity.America/Inuvik", "\u00ecl\u00fa Inuvik" },
            { "timezone.excity.America/Juneau", "\u00ecl\u00fa Junu" },
            { "timezone.excity.America/Merida", "\u00ecl\u00fa Merida" },
            { "timezone.excity.America/Nassau", "\u00ecl\u00fa Nasa\u00f2" },
            { "timezone.excity.America/Panama", "\u00ecl\u00fa Panama" },
            { "timezone.excity.America/Regina", "\u00ecl\u00fa Regina" },
            { "timezone.excity.America/Antigua", "\u00ecl\u00fa Ant\u00edg\u00f9\u00e0" },
            { "timezone.excity.America/Chicago", "\u00ecl\u00fa Chicago" },
            { "timezone.excity.America/Creston", "\u00ecl\u00fa K\u00edr\u1eb9st\u1ecd\u0301\u1ecd\u0300n\u00f9" },
            { "timezone.excity.America/Curacao", "\u00ecl\u00fa Kura\u1e63ao" },
            { "timezone.excity.America/Detroit", "\u00ecl\u00fa Detroit" },
            { "timezone.excity.America/Godthab", "\u00ecl\u00fa Nuuk" },
            { "timezone.excity.America/Grenada", "\u00ecl\u00fa Grenada" },
            { "timezone.excity.America/Halifax", "\u00ecl\u00fa Halif\u00e1s\u00ec" },
            { "timezone.excity.America/Iqaluit", "\u00ecl\u00fa Iqaluit" },
            { "timezone.excity.America/Jamaica", "\u00ecl\u00fa Jamaik\u00e0" },
            { "timezone.excity.America/Managua", "\u00ecl\u00fa Managua" },
            { "timezone.excity.America/Marigot", "\u00ecl\u00fa Marig\u1ecd\u0301\u1ecd\u0300t\u00ec" },
            { "timezone.excity.America/Moncton", "\u00ecl\u00fa Montoni" },
            { "timezone.excity.America/Ojinaga", "\u00ecl\u00fa Ojinaga" },
            { "timezone.excity.America/Phoenix", "\u00ecl\u00fa F\u00edn\u00eds\u00ec" },
            { "timezone.excity.America/Tijuana", "\u00ecl\u00fa T\u00edj\u00faana" },
            { "timezone.excity.America/Toronto", "\u00ecl\u00fa Toronto" },
            { "timezone.excity.America/Tortola", "\u00ecl\u00fa Totola" },
            { "timezone.excity.America/Yakutat", "\u00ecl\u00fa Yakuta" },
            { "timezone.excity.America/Anguilla", "\u00ecl\u00fa Ang\u00fa\u00edl\u00e0" },
            { "timezone.excity.America/Barbados", "\u00ecl\u00fa B\u00e1b\u00e1d\u1ecd\u0301\u1ecd\u0300s\u00ec" },
            { "timezone.excity.America/Dominica", "\u00ecl\u00fa Dominika" },
            { "timezone.excity.America/Edmonton", "\u00ecl\u00fa Edmonton" },
            { "timezone.excity.America/Mazatlan", "\u00ecl\u00fa Masatiani" },
            { "timezone.excity.America/Miquelon", "\u00ecl\u00fa Mikul\u1ecd\u0301n\u00ec" },
            { "timezone.excity.America/New_York", "\u00ecl\u00fa New York" },
            { "timezone.excity.America/Resolute", "\u00ecl\u00fa Resol\u00fat\u00ec" },
            { "timezone.excity.America/St_Johns", "\u00ecl\u00fa St J\u1ecd\u0301\u1ecd\u0300n\u00f9" },
            { "timezone.excity.America/St_Kitts", "\u00ecl\u00fa St kitis\u00ec" },
            { "timezone.excity.America/St_Lucia", "\u00ecl\u00fa St Lusia" },
            { "timezone.excity.America/Winnipeg", "\u00ecl\u00fa Winipeg\u00ec" },
            { "timezone.excity.Atlantic/Bermuda", "\u00ecl\u00fa B\u1eb9\u0300m\u00fad\u00e0" },
            { "timezone.excity.America/Anchorage", "\u00ecl\u00fa Ank\u1ecd\u0301r\u00e9\u00e8j\u00ec" },
            { "timezone.excity.America/Chihuahua", "\u00ecl\u00fa \u1e62ihuahua" },
            { "timezone.excity.America/Glace_Bay", "\u00ecl\u00fa omi Glace" },
            { "timezone.excity.America/Goose_Bay", "\u00ecl\u00fa omi Goos\u00f9" },
            { "timezone.excity.America/Guatemala", "\u00ecl\u00fa Guatemala" },
            { "timezone.excity.America/Matamoros", "\u00ecl\u00fa Matamoros\u00ec" },
            { "timezone.excity.America/Menominee", "\u00ecl\u00fa Menomin\u00ec" },
            { "timezone.excity.America/Monterrey", "\u00ecl\u00fa Monteri" },
            { "timezone.excity.America/St_Thomas", "\u00ecl\u00fa St T\u1ecd\u0301m\u00e0s\u00ec" },
            { "timezone.excity.America/Vancouver", "\u00ecl\u00fa Vankuva" },
            { "timezone.excity.America/Costa_Rica", "\u00ecl\u00fa Kosta R\u00edk\u00e0" },
            { "timezone.excity.America/Grand_Turk", "\u00ecl\u00fa Grand Turk" },
            { "timezone.excity.America/Guadeloupe", "\u00ecl\u00fa Guadeloupe" },
            { "timezone.excity.America/Hermosillo", "\u00ecl\u00fa Hermosilo" },
            { "timezone.excity.America/Kralendijk", "\u00ecl\u00fa K\u00edral\u1eb9\u0301nd\u00e1ik\u00ec" },
            { "timezone.excity.America/Louisville", "\u00ecl\u00fa L\u00fa\u00edf\u00ed\u00ecl\u00ec" },
            { "timezone.excity.America/Martinique", "\u00ecl\u00fa M\u00e1t\u00edn\u00edk\u00ec" },
            { "timezone.excity.America/Metlakatla", "\u00ecl\u00fa Metilakatila" },
            { "timezone.excity.America/Montserrat", "\u00ecl\u00fa Monserat\u00ec" },
            { "timezone.excity.America/St_Vincent", "\u00ecl\u00fa Finsent\u00ec" },
            { "timezone.excity.America/Whitehorse", "\u00ecl\u00fa Whitehos\u00ec" },
            { "timezone.excity.America/El_Salvador", "\u00ecl\u00fa El Savador" },
            { "timezone.excity.America/Fort_Nelson", "\u00ecl\u00fa Fort Nelson" },
            { "timezone.excity.America/Los_Angeles", "\u00ecl\u00fa Los Angeles" },
            { "timezone.excity.America/Mexico_City", "\u00ecl\u00fa M\u1eb9\u0301s\u00edk\u00f2" },
            { "timezone.excity.America/Puerto_Rico", "\u00ecl\u00fa Puerto Riko" },
            { "timezone.excity.America/Tegucigalpa", "\u00ecl\u00fa Tegusigap\u00e0" },
            { "timezone.excity.America/Blanc-Sablon", "\u00ecl\u00fa Blank Sabul\u1ecd\u0301\u1ecd\u0300n\u00ec" },
            { "timezone.excity.America/Danmarkshavn", "\u00ecl\u00fa Banmarkshan" },
            { "timezone.excity.America/Dawson_Creek", "\u00ecl\u00fa Dawson Creek" },
            { "timezone.excity.America/Indiana/Knox", "\u00ecl\u00fa n\u1ecd\u0301s\u00ec" },
            { "timezone.excity.America/Indianapolis", "\u00ecl\u00fa Indianapolis" },
            { "timezone.excity.America/Rankin_Inlet", "\u00ecl\u00fa Rankin Inlet" },
            { "timezone.excity.America/Scoresbysund", "\u00ecl\u00fa Itokotomiti" },
            { "timezone.excity.America/Cambridge_Bay", "\u00ecl\u00fa \u00f2kun kamb\u00edr\u00ed\u00ecj\u00ec" },
            { "timezone.excity.America/Coral_Harbour", "\u00ecl\u00fa \u00e0tik\u1ecdk\u00e0n" },
            { "timezone.excity.America/Indiana/Vevay", "\u00ecl\u00fa Vevay" },
            { "timezone.excity.America/Lower_Princes", "\u00ecl\u00fa Lower Prince\u2019s Quarter" },
            { "timezone.excity.America/Port_of_Spain", "\u00ecl\u00fa et\u00ed omi S\u00edp\u00e9\u00e8n\u00ec" },
            { "timezone.excity.America/Santo_Domingo", "\u00ecl\u00fa Santo Domigo" },
            { "timezone.excity.America/St_Barthelemy", "\u00ecl\u00fa Batilem\u00ec" },
            { "timezone.excity.America/Swift_Current", "\u00ecl\u00fa S\u00faf\u00edt\u00f9 K\u1ecd\u0300rent\u00ec" },
            { "timezone.excity.America/Bahia_Banderas", "\u00ecl\u00fa B\u00e1h\u00ec B\u00e1nd\u1eb9\u0301r\u00e1s\u00ec" },
            { "timezone.excity.America/Port-au-Prince", "\u00ecl\u00fa Port-au-Prince" },
            { "timezone.excity.America/Indiana/Marengo", "\u00ecl\u00fa Mar\u1eb9\u0301ngo" },
            { "timezone.excity.America/Indiana/Winamac", "\u00ecl\u00fa Winamak n\u00ed Indiana" },
            { "timezone.excity.America/Indiana/Tell_City", "\u00ecl\u00fa Tell City" },
            { "timezone.excity.America/Indiana/Vincennes", "\u00ecl\u00fa Vincennes n\u00ed Indiana" },
            { "timezone.excity.America/Indiana/Petersburg", "\u00ecl\u00fa Petersburg" },
            { "timezone.excity.America/Kentucky/Monticello", "\u00ecl\u00fa Montis\u1eb9\u0301l\u00f2" },
            { "timezone.excity.America/North_Dakota/Beulah", "\u00ecl\u00fa Beul\u00e0 n\u00ed North Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "\u00ecl\u00fa Senta North Dakota" },
            { "timezone.excity.America/North_Dakota/New_Salem", "\u00ecl\u00fa New Salem ni North Dakota" },
        };
        return data;
    }
}
