package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link TaskStatus}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTaskStatus.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableTaskStatus implements TaskStatus {
  private final Date timestamp;
  private final String state;
  private final String message;
  private final @Nullable String err;
  private final @Nullable ContainerStatus containerStatus;

  private ImmutableTaskStatus(
      Date timestamp,
      String state,
      String message,
      @Nullable String err,
      @Nullable ContainerStatus containerStatus) {
    this.timestamp = timestamp;
    this.state = state;
    this.message = message;
    this.err = err;
    this.containerStatus = containerStatus;
  }

  /**
   * @return The value of the {@code timestamp} attribute
   */
  @JsonProperty("Timestamp")
  @Override
  public Date timestamp() {
    return timestamp;
  }

  /**
   * @return The value of the {@code state} attribute
   */
  @JsonProperty("State")
  @Override
  public String state() {
    return state;
  }

  /**
   * @return The value of the {@code message} attribute
   */
  @JsonProperty("Message")
  @Override
  public String message() {
    return message;
  }

  /**
   * @return The value of the {@code err} attribute
   */
  @JsonProperty("Err")
  @Override
  public @Nullable String err() {
    return err;
  }

  /**
   * @return The value of the {@code containerStatus} attribute
   */
  @JsonProperty("ContainerStatus")
  @Override
  public @Nullable ContainerStatus containerStatus() {
    return containerStatus;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TaskStatus#timestamp() timestamp} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for timestamp
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTaskStatus withTimestamp(Date value) {
    if (this.timestamp == value) return this;
    Date newValue = Objects.requireNonNull(value, "timestamp");
    return new ImmutableTaskStatus(newValue, this.state, this.message, this.err, this.containerStatus);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TaskStatus#state() state} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for state
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTaskStatus withState(String value) {
    String newValue = Objects.requireNonNull(value, "state");
    if (this.state.equals(newValue)) return this;
    return new ImmutableTaskStatus(this.timestamp, newValue, this.message, this.err, this.containerStatus);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TaskStatus#message() message} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for message
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTaskStatus withMessage(String value) {
    String newValue = Objects.requireNonNull(value, "message");
    if (this.message.equals(newValue)) return this;
    return new ImmutableTaskStatus(this.timestamp, this.state, newValue, this.err, this.containerStatus);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TaskStatus#err() err} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for err (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTaskStatus withErr(@Nullable String value) {
    if (Objects.equals(this.err, value)) return this;
    return new ImmutableTaskStatus(this.timestamp, this.state, this.message, value, this.containerStatus);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TaskStatus#containerStatus() containerStatus} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for containerStatus (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTaskStatus withContainerStatus(@Nullable ContainerStatus value) {
    if (this.containerStatus == value) return this;
    return new ImmutableTaskStatus(this.timestamp, this.state, this.message, this.err, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTaskStatus} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTaskStatus
        && equalTo(0, (ImmutableTaskStatus) another);
  }

  private boolean equalTo(int synthetic, ImmutableTaskStatus another) {
    return timestamp.equals(another.timestamp)
        && state.equals(another.state)
        && message.equals(another.message)
        && Objects.equals(err, another.err)
        && Objects.equals(containerStatus, another.containerStatus);
  }

  /**
   * Computes a hash code from attributes: {@code timestamp}, {@code state}, {@code message}, {@code err}, {@code containerStatus}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + timestamp.hashCode();
    h += (h << 5) + state.hashCode();
    h += (h << 5) + message.hashCode();
    h += (h << 5) + Objects.hashCode(err);
    h += (h << 5) + Objects.hashCode(containerStatus);
    return h;
  }

  /**
   * Prints the immutable value {@code TaskStatus} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TaskStatus{"
        + "timestamp=" + timestamp
        + ", state=" + state
        + ", message=" + message
        + ", err=" + err
        + ", containerStatus=" + containerStatus
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link TaskStatus} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TaskStatus instance
   */
  public static ImmutableTaskStatus copyOf(TaskStatus instance) {
    if (instance instanceof ImmutableTaskStatus) {
      return (ImmutableTaskStatus) instance;
    }
    return ImmutableTaskStatus.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTaskStatus ImmutableTaskStatus}.
   * <pre>
   * ImmutableTaskStatus.builder()
   *    .timestamp(Date) // required {@link TaskStatus#timestamp() timestamp}
   *    .state(String) // required {@link TaskStatus#state() state}
   *    .message(String) // required {@link TaskStatus#message() message}
   *    .err(String | null) // nullable {@link TaskStatus#err() err}
   *    .containerStatus(org.mandas.docker.client.messages.swarm.ContainerStatus | null) // nullable {@link TaskStatus#containerStatus() containerStatus}
   *    .build();
   * </pre>
   * @return A new ImmutableTaskStatus builder
   */
  public static ImmutableTaskStatus.Builder builder() {
    return new ImmutableTaskStatus.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTaskStatus ImmutableTaskStatus}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder {
    private static final long INIT_BIT_TIMESTAMP = 0x1L;
    private static final long INIT_BIT_STATE = 0x2L;
    private static final long INIT_BIT_MESSAGE = 0x4L;
    private long initBits = 0x7L;

    private Date timestamp;
    private String state;
    private String message;
    private String err;
    private ContainerStatus containerStatus;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TaskStatus} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TaskStatus instance) {
      Objects.requireNonNull(instance, "instance");
      this.timestamp(instance.timestamp());
      this.state(instance.state());
      this.message(instance.message());
      @Nullable String errValue = instance.err();
      if (errValue != null) {
        err(errValue);
      }
      @Nullable ContainerStatus containerStatusValue = instance.containerStatus();
      if (containerStatusValue != null) {
        containerStatus(containerStatusValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link TaskStatus#timestamp() timestamp} attribute.
     * @param timestamp The value for timestamp 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Timestamp")
    public final Builder timestamp(Date timestamp) {
      this.timestamp = Objects.requireNonNull(timestamp, "timestamp");
      initBits &= ~INIT_BIT_TIMESTAMP;
      return this;
    }

    /**
     * Initializes the value for the {@link TaskStatus#state() state} attribute.
     * @param state The value for state 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("State")
    public final Builder state(String state) {
      this.state = Objects.requireNonNull(state, "state");
      initBits &= ~INIT_BIT_STATE;
      return this;
    }

    /**
     * Initializes the value for the {@link TaskStatus#message() message} attribute.
     * @param message The value for message 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Message")
    public final Builder message(String message) {
      this.message = Objects.requireNonNull(message, "message");
      initBits &= ~INIT_BIT_MESSAGE;
      return this;
    }

    /**
     * Initializes the value for the {@link TaskStatus#err() err} attribute.
     * @param err The value for err (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Err")
    public final Builder err(@Nullable String err) {
      this.err = err;
      return this;
    }

    /**
     * Initializes the value for the {@link TaskStatus#containerStatus() containerStatus} attribute.
     * @param containerStatus The value for containerStatus (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ContainerStatus")
    public final Builder containerStatus(@Nullable ContainerStatus containerStatus) {
      this.containerStatus = containerStatus;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTaskStatus ImmutableTaskStatus}.
     * @return An immutable instance of TaskStatus
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTaskStatus build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTaskStatus(timestamp, state, message, err, containerStatus);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TIMESTAMP) != 0) attributes.add("timestamp");
      if ((initBits & INIT_BIT_STATE) != 0) attributes.add("state");
      if ((initBits & INIT_BIT_MESSAGE) != 0) attributes.add("message");
      return "Cannot build TaskStatus, some of required attributes are not set " + attributes;
    }
  }
}
