/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.irix;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.iri.Violation;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIProvider;
import org.apache.jena.irix.IRIx;
import org.apache.jena.irix.SetupJenaIRI;

public class IRIProviderJenaIRI
implements IRIProvider {
    private static final IRIFactory iriFactoryInst = SetupJenaIRI.setupCheckerIRIFactory();
    private static boolean STRICT_HTTP = true;
    private static boolean STRICT_URN = true;
    private static boolean STRICT_FILE = true;
    private static final boolean showExceptions = true;
    private static final boolean includeWarnings = false;
    private static String UUID_REGEXP = "^(?:urn:uuid|uuid):[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$";
    private static Pattern UUID_PATTERN = Pattern.compile(UUID_REGEXP, 2);

    private static IRIxJena newIRIxJena(IRI iri2) {
        String iriStr2 = iri2.toString();
        return IRIProviderJenaIRI.newIRIxJena(iri2, iriStr2);
    }

    private static IRIxJena newIRIxJena(IRI iri2, String iriStr2) {
        IRIProviderJenaIRI.exceptions(iri2, iriStr2);
        return new IRIxJena(iriStr2, iri2);
    }

    @Override
    public IRIx create(String iriStr) throws IRIException {
        IRI iriObj = IRIProviderJenaIRI.iriFactory().create(iriStr);
        return IRIProviderJenaIRI.newIRIxJena(iriObj, iriStr);
    }

    @Override
    public void check(String iriStr) throws IRIException {
        IRI iri = IRIProviderJenaIRI.iriFactory().create(iriStr);
        IRIProviderJenaIRI.exceptions(iri, iriStr);
    }

    @Override
    public void strictMode(String scheme, boolean runStrict) {
        switch (scheme) {
            case "urn": {
                STRICT_URN = runStrict;
                break;
            }
            case "file": {
                STRICT_FILE = runStrict;
                break;
            }
            case "http": {
                STRICT_HTTP = runStrict;
            }
        }
    }

    @Override
    public boolean isStrictMode(String scheme) {
        switch (scheme) {
            case "urn": {
                return STRICT_URN;
            }
            case "file": {
                return STRICT_FILE;
            }
            case "http": {
                return STRICT_HTTP;
            }
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static IRIFactory iriFactory() {
        return iriFactoryInst;
    }

    private static IRI exceptions(IRI iri, String iriStr) {
        if (iriStr == null) {
            iriStr = iri.toString();
        }
        if (STRICT_FILE && IRIProviderJenaIRI.isFILE(iri) && iriStr.startsWith("file://") && !iriStr.startsWith("file:///")) {
            throw new IRIException("file: URLs should start file:///: <" + iriStr + ">");
        }
        if (IRIProviderJenaIRI.isUUID(iri, iriStr)) {
            IRIProviderJenaIRI.checkUUID(iri, iriStr);
        }
        if (!iri.hasViolation(false)) {
            return iri;
        }
        Iterator vIter = iri.violations(false);
        block5: while (vIter.hasNext()) {
            Violation v = (Violation)vIter.next();
            int code = v.getViolationCode();
            switch (code) {
                case 58: {
                    if (!IRIProviderJenaIRI.isHTTP(iri) || STRICT_HTTP || v.getComponent() != 6) break;
                    continue block5;
                }
                case 61: {
                    if ((!IRIProviderJenaIRI.isURN(iri) || STRICT_URN) && !IRIProviderJenaIRI.isFILE(iri)) break;
                    continue block5;
                }
                case 57: {
                    if (!IRIProviderJenaIRI.isFILE(iri)) break;
                    continue block5;
                }
            }
            String msg = v.getShortMessage();
            throw new IRIException(msg);
        }
        return iri;
    }

    private static boolean isHTTP(IRI iri) {
        return "http".equalsIgnoreCase(iri.getScheme()) || "https".equalsIgnoreCase(iri.getScheme());
    }

    private static boolean isURN(IRI iri) {
        return "urn".equalsIgnoreCase(iri.getScheme());
    }

    private static boolean isFILE(IRI iri) {
        return "file".equalsIgnoreCase(iri.getScheme());
    }

    private static boolean isUUID(IRI iri, String iriStr) {
        return iriStr.regionMatches(true, 0, "urn:uuid:", 0, "urn:uuid:".length()) || iriStr.regionMatches(true, 0, "uuid:", 0, "uuid:".length());
    }

    private static void checkUUID(IRI iriObj, String original) {
        if (iriObj.hasViolation(true)) {
            return;
        }
        if (iriObj.getRawFragment() != null) {
            throw new IRIException("Fragment used with UUID");
        }
        if (iriObj.getRawQuery() != null) {
            throw new IRIException("Query used with UUID");
        }
        boolean matches = UUID_PATTERN.matcher(original).matches();
        if (!matches) {
            throw new IRIException("Not a valid UUID string: " + original);
        }
    }

    public static class IRIxJena
    extends IRIx {
        private final IRI jenaIRI;
        private static int relFlags = 29;

        private IRIxJena(String iriStr, IRI iri) {
            super(iri.toString());
            this.jenaIRI = iri;
        }

        @Override
        public boolean isAbsolute() {
            return this.jenaIRI.isAbsolute();
        }

        @Override
        public boolean isRelative() {
            return this.jenaIRI.isRelative();
        }

        @Override
        public boolean isReference() {
            if (this.jenaIRI.isRootless()) {
                return true;
            }
            return this.jenaIRI.getScheme() != null;
        }

        @Override
        public boolean hasScheme(String scheme) {
            if (this.jenaIRI.getScheme() == null) {
                return false;
            }
            return this.jenaIRI.getScheme().startsWith(scheme);
        }

        @Override
        public IRIx resolve(String other) {
            IRI iri2 = this.jenaIRI.resolve(other);
            return IRIProviderJenaIRI.newIRIxJena(iri2);
        }

        @Override
        public IRIx resolve(IRIx other) {
            IRIxJena iriOther = (IRIxJena)other;
            IRI iri2 = this.jenaIRI.resolve(iriOther.jenaIRI);
            return IRIProviderJenaIRI.newIRIxJena(iri2);
        }

        @Override
        public IRIx normalize() {
            IRI irin = this.jenaIRI.normalize(false);
            return new IRIxJena(irin.toString(), irin);
        }

        @Override
        public IRIx relativize(IRIx other) {
            if (this.jenaIRI.getRawQuery() != null) {
                return null;
            }
            IRIxJena iriOther = (IRIxJena)other;
            IRI iri2 = this.jenaIRI.relativize(iriOther.jenaIRI, relFlags);
            if (iri2.equals(iriOther.jenaIRI)) {
                return null;
            }
            return IRIProviderJenaIRI.newIRIxJena(iri2);
        }

        public IRI getImpl() {
            return this.jenaIRI;
        }

        @Override
        public boolean hasViolations() {
            return this.jenaIRI.hasViolation(false);
        }

        @Override
        public void handleViolations(BiConsumer<Boolean, String> handler) {
            this.jenaIRI.violations(false).forEachRemaining(v -> handler.accept(v.isError(), v.getShortMessage()));
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.jenaIRI);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IRIxJena other = (IRIxJena)obj;
            return Objects.equals(this.jenaIRI, other.jenaIRI);
        }
    }
}

