/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.store;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.NullIterator;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.tdb.lib.TupleLib;
import org.apache.jena.tdb.store.NodeId;
import org.apache.jena.tdb.store.TableBase;
import org.apache.jena.tdb.store.nodetable.NodeTable;
import org.apache.jena.tdb.store.tupletable.TupleIndex;
import org.apache.jena.tdb.sys.DatasetControl;

public class QuadTable
extends TableBase {
    public QuadTable(TupleIndex[] indexes, NodeTable nodeTable, DatasetControl policy) {
        super(4, indexes, nodeTable, policy);
    }

    public boolean add(Quad quad) {
        return this.add(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    public boolean add(Node gn, Triple triple) {
        return this.add(gn, triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public boolean add(Node g, Node s, Node p, Node o) {
        return this.table.addRow(g, s, p, o);
    }

    public boolean delete(Quad quad) {
        return this.delete(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    public boolean delete(Node gn, Triple triple) {
        return this.delete(gn, triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public boolean delete(Node g, Node s, Node p, Node o) {
        return this.table.deleteRow(g, s, p, o);
    }

    public Iterator<Quad> find(Node g, Node s, Node p, Node o) {
        Iterator<Tuple<NodeId>> iter = this.table.findAsNodeIds(g, s, p, o);
        if (iter == null) {
            return new NullIterator();
        }
        Iterator<Quad> iter2 = TupleLib.convertToQuads(this.table.getNodeTable(), iter);
        return iter2;
    }

    public void clearQuads() {
        this.table.clear();
    }
}

