/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.ocl;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.gmf.internal.xpand.ocl.EmbeddedOCLAnalyzer;
import org.eclipse.ocl.cst.CollectionTypeCS;
import org.eclipse.ocl.cst.PathNameCS;
import org.eclipse.ocl.cst.PrimitiveTypeCS;
import org.eclipse.ocl.cst.TypeCS;

public class TypeHelper {
    private final TypeCS typeCS;

    public TypeHelper(TypeCS typeCS) {
        this.typeCS = typeCS;
    }

    public EClassifier getTypeForName(ExecutionContext ctx) {
        return new EmbeddedOCLAnalyzer(ctx.getOCLEnvironment()).typeForName(this.typeCS);
    }

    public String getName() {
        if (this.typeCS instanceof PrimitiveTypeCS) {
            return ((PrimitiveTypeCS)this.typeCS).getValue();
        }
        if (this.typeCS instanceof PathNameCS) {
            return TypeHelper.toString((PathNameCS)this.typeCS);
        }
        if (this.typeCS instanceof CollectionTypeCS) {
            CollectionTypeCS collTypeCS = (CollectionTypeCS)this.typeCS;
            return String.valueOf(collTypeCS.getCollectionTypeIdentifier().getName()) + '[' + new TypeHelper(collTypeCS.getTypeCS()).getName() + ']';
        }
        return this.typeCS.toString();
    }

    public static String toString(PathNameCS pathName) {
        StringBuilder sb = new StringBuilder();
        for (String s : pathName.getSequenceOfNames()) {
            if (sb.length() > 0) {
                sb.append("::");
            }
            sb.append(s);
        }
        return sb.toString();
    }
}

