/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.preferences;

import java.util.ArrayList;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class ComboFieldEditor
extends FieldEditor {
    protected boolean separateLine = false;
    protected boolean readOnly = false;
    protected int indent = 0;
    protected int width = 0;
    protected Combo combo = null;
    public static final int STRING_TYPE = 0;
    public static final int INT_TYPE = 1;
    public static final int INT_TYPE_INDEXED = 2;
    protected int type;
    protected ArrayList indexToValue = new ArrayList();
    public boolean autoStorage = true;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.common.ui.preferences.ComboFieldEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ComboFieldEditor(String name, String labelText, Composite parent) {
        this(name, labelText, parent, 0, false, 0, 0, false);
    }

    public ComboFieldEditor(String name, String labelText, Composite parent, int aType, boolean aSeparateLine, int anIndent, int aWidth, boolean aReadOnly) {
        this.separateLine = aSeparateLine;
        this.indent = anIndent;
        this.width = aWidth;
        this.readOnly = aReadOnly;
        this.type = aType;
        this.init(name, labelText);
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        GridData labelGridData = new GridData();
        this.getLabelControl(parent).setLayoutData((Object)labelGridData);
        labelGridData.horizontalIndent = this.indent;
        this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = this.separateLine ? numColumns : numColumns - 1;
        if (this.width == 0) {
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
        } else {
            gd.widthHint = this.width;
        }
        if (this.separateLine) {
            gd.horizontalIndent = this.indent;
        }
        int flags = 12292;
        if (this.readOnly) {
            flags |= 8;
        }
        this.combo = new Combo(parent, flags);
        this.combo.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (!this.autoStorage) {
            return;
        }
        if (this.combo != null) {
            if (this.type == 0) {
                this.combo.setText(this.getPreferenceStore().getString(this.getPreferenceName()));
            } else if (this.type == 1) {
                this.combo.select(this.getPreferenceStore().getInt(this.getPreferenceName()));
            } else if (this.type == 2) {
                int storeValue = this.getPreferenceStore().getInt(this.getPreferenceName());
                int index = this.indexToValue.indexOf(new Integer(storeValue));
                this.combo.select(index);
            }
        }
    }

    protected void doLoadDefault() {
        if (!this.autoStorage) {
            return;
        }
        if (this.combo != null) {
            if (this.type == 0) {
                this.combo.setText(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
            } else if (this.type == 1) {
                this.combo.select(this.getPreferenceStore().getDefaultInt(this.getPreferenceName()));
            } else if (this.type == 2) {
                int storeValue = this.getPreferenceStore().getDefaultInt(this.getPreferenceName());
                int index = this.indexToValue.indexOf(new Integer(storeValue));
                this.combo.select(index);
            }
        }
    }

    protected void doStore() {
        if (!this.autoStorage) {
            return;
        }
        if (this.type == 0) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), this.combo.getText());
        } else if (this.type == 1) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), this.combo.getSelectionIndex());
        } else if (this.type == 2) {
            Integer storeValue = (Integer)this.indexToValue.get(this.combo.getSelectionIndex());
            this.getPreferenceStore().setValue(this.getPreferenceName(), storeValue.intValue());
        }
    }

    public String getStringValue() {
        return this.combo.getText();
    }

    public int getNumberOfControls() {
        return 2;
    }

    public Combo getComboControl() {
        return this.combo;
    }

    public boolean existsInCombo(String value) {
        int i = 0;
        while (i < this.combo.getItemCount()) {
            if (this.combo.getItem(i).compareToIgnoreCase(value) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setAutoStorage(boolean anAutoStorage) {
        this.autoStorage = anAutoStorage;
    }

    public void addIndexedItemToCombo(String stringValue, int storeValue) {
        if (!$assertionsDisabled && this.type != 2) {
            throw new AssertionError((Object)"type is not equal to INT_TYPE_INDEXED");
        }
        this.combo.add(stringValue);
        this.indexToValue.add(new Integer(storeValue));
    }
}

