/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.expression.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.EvaluationException;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.internal.xpand.expression.ast.FeatureCall;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.gmf.internal.xpand.xtend.ast.Extension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationCall
extends FeatureCall {
    private Expression[] params;

    public OperationCall(int start, int end, int line, Identifier name, Expression target, Expression[] params) {
        super(start, end, line, name, target);
        this.params = params;
    }

    public Expression[] getParams() {
        return this.params;
    }

    @Override
    public Object evaluateInternal(ExecutionContext ctx) {
        Object[] params = new Object[this.getParams().length];
        EClassifier[] paramTypes = new EClassifier[params.length];
        int i = 0;
        while (i < this.getParams().length) {
            params[i] = this.getParams()[i].evaluate(ctx);
            paramTypes[i] = BuiltinMetaModel.getType(params[i]);
            ++i;
        }
        Object targetObj = null;
        if (this.getTarget() == null) {
            Extension f = ctx.getExtension(this.getName().getValue(), paramTypes);
            if (f != null) {
                return f.evaluate(params, ctx);
            }
            Variable var = ctx.getVariable("this");
            if (var == null) {
                throw new EvaluationException("Couldn't find extension '" + this.getName().getValue() + this.getParamTypes(params, ctx) + "'!", (SyntaxElement)this);
            }
            targetObj = var.getValue();
        } else {
            targetObj = this.getTarget().evaluate(ctx);
        }
        BuiltinMetaModel.Operation op = BuiltinMetaModel.executableOperation(this.getName().getValue(), params, targetObj);
        if (op != null) {
            return op.evaluate();
        }
        EClassifier[] ps = new EClassifier[paramTypes.length + 1];
        ps[0] = BuiltinMetaModel.getType(targetObj);
        System.arraycopy(paramTypes, 0, ps, 1, paramTypes.length);
        Extension f = ctx.getExtension(this.getName().getValue(), ps);
        if (f != null) {
            Object[] paramsAll = new Object[params.length + 1];
            paramsAll[0] = targetObj;
            System.arraycopy(params, 0, paramsAll, 1, params.length);
            return f.evaluate(paramsAll, ctx);
        }
        if (targetObj instanceof Collection) {
            ArrayList<Object> result = new ArrayList<Object>();
            Collection col = (Collection)targetObj;
            for (Object element : col) {
                op = BuiltinMetaModel.executableOperation(this.getName().getValue(), params, element);
                if (op != null) {
                    Object r = op.evaluate();
                    if (r instanceof Collection) {
                        result.addAll((Collection)r);
                        continue;
                    }
                    result.add(r);
                    continue;
                }
                ps = new EClassifier[paramTypes.length + 1];
                ps[0] = BuiltinMetaModel.getType(element);
                System.arraycopy(paramTypes, 0, ps, 1, paramTypes.length);
                f = ctx.getExtension(this.getName().getValue(), ps);
                if (f != null) {
                    Object[] paramsAll = new Object[params.length + 1];
                    paramsAll[0] = element;
                    System.arraycopy(params, 0, paramsAll, 1, params.length);
                    Object r = f.evaluate(paramsAll, ctx);
                    if (r instanceof Collection) {
                        result.addAll((Collection)r);
                        continue;
                    }
                    result.add(r);
                    continue;
                }
                throw new EvaluationException("Couldn't find operation '" + this.getName().getValue() + this.getParamTypes(params, ctx) + "' for " + BuiltinMetaModel.getType(targetObj).getName() + "!", (SyntaxElement)this);
            }
            return result;
        }
        if (targetObj != null && f == null && op == null) {
            throw new EvaluationException("Couldn't find operation '" + this.getName().getValue() + this.getParamTypes(params, ctx) + "' for " + BuiltinMetaModel.getType(targetObj).getName() + ".", (SyntaxElement)this);
        }
        return null;
    }

    @Override
    public EClassifier analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        EClassifier[] paramTypes = new EClassifier[this.getParams().length];
        int i = 0;
        while (i < this.getParams().length) {
            paramTypes[i] = this.getParams()[i].analyze(ctx, issues);
            if (paramTypes[i] == null) {
                return null;
            }
            ++i;
        }
        EClassifier targetType = null;
        if (this.getTarget() == null) {
            Extension f = null;
            try {
                f = ctx.getExtension(this.getName().getValue(), paramTypes);
            }
            catch (Exception e) {
                issues.add(new AnalysationIssue(AnalysationIssue.Type.INTERNAL_ERROR, "Error parsing extensions : " + e.getMessage(), this));
            }
            if (f != null) {
                return f.getReturnType(paramTypes, ctx, issues);
            }
            Variable var = ctx.getVariable("this");
            if (var != null) {
                targetType = (EClassifier)var.getValue();
            } else {
                issues.add(new AnalysationIssue(AnalysationIssue.Type.FEATURE_NOT_FOUND, "Couldn't find extensions : " + this.toString(), this));
            }
        } else {
            targetType = this.getTarget().analyze(ctx, issues);
        }
        if (targetType == null) {
            return null;
        }
        EOperation op = BuiltinMetaModel.findOperation(targetType, this.getName().getValue(), paramTypes);
        if (op != null) {
            return op.getEType() == null ? BuiltinMetaModel.VOID : BuiltinMetaModel.getTypedElementType((ETypedElement)op);
        }
        int issueSize = issues.size();
        EClassifier rt = this.getExtensionsReturnType(ctx, issues, paramTypes, targetType);
        if (rt != null) {
            return rt;
        }
        if (issueSize < issues.size()) {
            return null;
        }
        String additionalMsg = "";
        if (BuiltinMetaModel.isParameterizedType(targetType)) {
            EClassifier innerType = BuiltinMetaModel.getInnerType(targetType);
            op = BuiltinMetaModel.findOperation(innerType, this.getName().getValue(), paramTypes);
            if (op != null) {
                Object object = rt = op.getEType() == null ? BuiltinMetaModel.VOID : op.getEType();
                if (BuiltinMetaModel.isParameterizedType(rt)) {
                    rt = BuiltinMetaModel.getInnerType(rt);
                }
                return BuiltinMetaModel.getListType(rt);
            }
            rt = this.getExtensionsReturnType(ctx, issues, paramTypes, innerType);
            if (rt != null) {
                return BuiltinMetaModel.getListType(rt);
            }
            additionalMsg = " or type '" + innerType + "'";
        }
        issues.add(new AnalysationIssue(AnalysationIssue.Type.FEATURE_NOT_FOUND, "Couldn't find operation '" + this.getName().getValue() + this.getParamsString(paramTypes) + "' for type '" + targetType.getName() + "'" + additionalMsg, this));
        return null;
    }

    private EClassifier getExtensionsReturnType(ExecutionContext ctx, Set<AnalysationIssue> issues, EClassifier[] paramEClassifiers, EClassifier targetEClassifier) {
        EClassifier[] pts = new EClassifier[paramEClassifiers.length + 1];
        pts[0] = targetEClassifier;
        System.arraycopy(paramEClassifiers, 0, pts, 1, paramEClassifiers.length);
        Extension f = null;
        try {
            f = ctx.getExtension(this.getName().getValue(), pts);
        }
        catch (Exception e) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.INTERNAL_ERROR, "Error parsing extensions : " + e.getMessage(), this));
        }
        if (f != null) {
            HashSet<AnalysationIssue> temp = new HashSet<AnalysationIssue>();
            EClassifier rt = f.getReturnType(pts, ctx, temp);
            if (rt == null) {
                issues.add(new AnalysationIssue(AnalysationIssue.Type.INTERNAL_ERROR, "couldn't resolve return type for extension " + f + "! Errors : " + ((Object)temp).toString(), this));
            }
            return rt;
        }
        if (this.getTarget() == null) {
            try {
                f = ctx.getExtension(this.getName().getValue(), paramEClassifiers);
            }
            catch (Exception e) {
                issues.add(new AnalysationIssue(AnalysationIssue.Type.INTERNAL_ERROR, "Error parsing extensions : " + e.getMessage(), this));
            }
            if (f != null) {
                HashSet<AnalysationIssue> temp = new HashSet<AnalysationIssue>();
                EClassifier rt = f.getReturnType(pts, ctx, temp);
                if (rt == null) {
                    issues.add(new AnalysationIssue(AnalysationIssue.Type.INTERNAL_ERROR, "couldn't resolve return type for extension " + f + "! Errors : " + ((Object)temp).toString(), this));
                }
                return rt;
            }
        }
        return null;
    }

    private String getParamTypes(Object[] params2, ExecutionContext ctx) {
        StringBuffer buff = new StringBuffer("(");
        int i = 0;
        while (i < params2.length) {
            EClassifier type = BuiltinMetaModel.getType(params2[i]);
            buff.append(type.getName());
            if (i + 1 < params2.length) {
                buff.append(",");
            }
            ++i;
        }
        return buff.append(")").toString();
    }

    private String getParamsString(EClassifier[] paramTypes) {
        StringBuffer buff = new StringBuffer("(");
        int i = 0;
        while (i < paramTypes.length) {
            EClassifier type = paramTypes[i];
            buff.append(type.getName());
            if (i + 1 < paramTypes.length) {
                buff.append(",");
            }
            ++i;
        }
        return buff.append(")").toString();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getTarget() != null ? String.valueOf(this.getTarget().toString()) + "." : "") + this.getName() + this.getParamsExpressionString(this.getParams());
    }

    private String getParamsExpressionString(Expression[] params2) {
        StringBuffer buff = new StringBuffer("(");
        int i = 0;
        while (i < params2.length) {
            buff.append(params2[i]);
            if (i + 1 < params2.length) {
                buff.append(",");
            }
            ++i;
        }
        return buff.append(")").toString();
    }
}

