/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoConfiguration;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoDocumentProvider;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoOutlinePage;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoPairMatcher;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoSourceContent;
import org.eclipse.acceleo.internal.ide.ui.editors.template.ColorManager;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoEditor
extends TextEditor
implements IResourceChangeListener {
    public static final String ACCELEO_EDITOR_ID = "org.eclipse.acceleo.ide.ui.editors.template.AcceleoEditor";
    private static final String MATCHING_BRACKETS = "matchingBrackets";
    private static final String MATCHING_BRACKETS_COLOR = "matchingBracketsColor";
    private AcceleoSourceContent content = new AcceleoSourceContent();
    private ColorManager colorManager = new ColorManager();
    private AcceleoOutlinePage contentOutlinePage;
    private ISelectionChangedListener selectionChangedListener;
    private AcceleoPairMatcher blockMatcher = new AcceleoPairMatcher();
    private ProjectionSupport projectionSupport;
    private ProjectionAnnotationModel annotationModel;
    private EObject updatingOutline;

    public AcceleoSourceContent getContent() {
        return this.content;
    }

    public ColorManager getColorManager() {
        return this.colorManager;
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        this.setSourceViewerConfiguration(this.createSourceViewerConfiguration());
        this.setDocumentProvider(this.createDocumentProvider());
        super.doSetInput(input);
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider != null) {
            IFile file = this.getFile();
            IDocument document = provider.getDocument((Object)this.getEditorInput());
            this.initializeContent(document, file);
        }
    }

    private void initializeContent(IDocument document, IFile file) {
        if (document != null && file != null) {
            try {
                if (file.getProject().hasNature("org.eclipse.acceleo.ide.ui.acceleoNature")) {
                    this.content.init(new StringBuffer(document.get()), file);
                    this.content.createCST();
                } else {
                    MessageDialog.openError((Shell)this.getSite().getShell(), (String)AcceleoUIMessages.getString("AcceleoEditor.MissingNatureTitle"), (String)AcceleoUIMessages.getString("AcceleoEditor.MissingNatureDescription"));
                    this.content.init(new StringBuffer(document.get()), file);
                    this.content.createCST();
                }
            }
            catch (CoreException e) {
                AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
            }
        }
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.acceleo.ide.ui.editors.template.editor"});
    }

    protected SourceViewerConfiguration createSourceViewerConfiguration() {
        return new AcceleoConfiguration(this, this.getPreferenceStore());
    }

    protected IDocumentProvider createDocumentProvider() {
        return new AcceleoDocumentProvider(this);
    }

    public void dispose() {
        super.dispose();
        this.colorManager.dispose();
        this.getContentOutlinePage().removeSelectionChangedListener(this.selectionChangedListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        if (this.blockMatcher != null) {
            this.blockMatcher.dispose();
            this.blockMatcher = null;
        }
    }

    public Object getAdapter(Class type) {
        if (type.equals(IContentOutlinePage.class)) {
            return this.getContentOutlinePage();
        }
        return super.getAdapter(type);
    }

    protected AcceleoOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            this.contentOutlinePage = this.createContentOutlinePage();
            this.selectionChangedListener = this.createSelectionChangeListener();
            this.contentOutlinePage.addSelectionChangedListener(this.selectionChangedListener);
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
        return this.contentOutlinePage;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor() != this && event.getType() == 1 && this.deltaMembers(event.getDelta()).contains(this.getFile())) {
            try {
                this.init(this.getEditorSite(), this.getEditorInput());
            }
            catch (PartInitException e) {
                AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
            }
        }
    }

    private List<IFile> deltaMembers(IResourceDelta delta) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        IResource resource = delta.getResource();
        if (resource instanceof IFile && delta.getKind() == 4) {
            files.add((IFile)resource);
        }
        IResourceDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            files.addAll(this.deltaMembers(children[i]));
            ++i;
        }
        return files;
    }

    protected AcceleoOutlinePage createContentOutlinePage() {
        return new AcceleoOutlinePage(this);
    }

    protected ISelectionChangedListener createSelectionChangeListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AcceleoEditor.this.selectionChangedDetected(event);
            }
        };
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setCharacterPairMatcher((ICharacterPairMatcher)this.blockMatcher);
        support.setMatchingCharacterPainterPreferenceKeys(MATCHING_BRACKETS, MATCHING_BRACKETS_COLOR);
        IPreferenceStore pref = AcceleoUIActivator.getDefault().getPreferenceStore();
        IPreferenceStore[] stores = new IPreferenceStore[]{this.getPreferenceStore(), pref};
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(stores));
        support.install(this.getPreferenceStore());
        super.configureSourceViewerDecorationSupport(support);
    }

    protected void selectionChangedDetected(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
        if (selectedElement == this.updatingOutline) {
            this.updatingOutline = null;
        } else if (selectedElement instanceof CSTNode) {
            int b = ((CSTNode)selectedElement).getStartPosition();
            int e = ((CSTNode)selectedElement).getEndPosition();
            if (b > -1 && e > -1) {
                this.selectRange(b, e);
            }
        }
    }

    public void updateSelection(int posBegin, int posEnd) {
        CSTNode object;
        AcceleoSourceContent source;
        int e = posEnd < posBegin ? posBegin : posEnd;
        if (this.getContentOutlinePage() != null && posBegin > -1 && e > -1 && (source = this.getContent()) != null && (object = source.getCSTNode(posBegin, e)) != null) {
            this.updatingOutline = object;
            this.getContentOutlinePage().setSelection((ISelection)new StructuredSelection((Object)object));
        }
    }

    protected void selectRange(int begin, int end) {
        if (begin > -1 && end >= begin) {
            ISourceViewer viewer = this.getSourceViewer();
            StyledText widget = viewer.getTextWidget();
            widget.setRedraw(false);
            this.setHighlightRange(begin, end - begin, true);
            this.selectAndReveal(begin, end - begin);
            widget.setRedraw(true);
        }
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
    }

    public void doSaveAs() {
        super.doSaveAs();
    }

    public IFile getFile() {
        return (IFile)this.getEditorInput().getAdapter(IFile.class);
    }

    public void updateFoldingStructure(Map<Annotation, Position> addedAnnotations, List<Annotation> deletedAnnotations, Map<Annotation, Position> modifiedAnnotations) {
        Annotation[] deleted = new Annotation[deletedAnnotations.size() + modifiedAnnotations.size()];
        int i = 0;
        while (i < deletedAnnotations.size()) {
            deleted[i] = deletedAnnotations.get(i);
            ++i;
        }
        Iterator<Annotation> modifiedIterator = modifiedAnnotations.keySet().iterator();
        int i2 = deletedAnnotations.size();
        while (i2 < deleted.length) {
            deleted[i2] = modifiedIterator.next();
            ++i2;
        }
        addedAnnotations.putAll(modifiedAnnotations);
        if (this.annotationModel != null) {
            this.annotationModel.modifyAnnotations(deleted, addedAnnotations, null);
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.install();
        viewer.doOperation(19);
        this.annotationModel = viewer.getProjectionAnnotationModel();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }
}

