/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoSourceContent;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.AbstractRefactoringWithVariableContextAction;
import org.eclipse.acceleo.parser.cst.Block;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.acceleo.parser.cst.ForBlock;
import org.eclipse.acceleo.parser.cst.IfBlock;
import org.eclipse.acceleo.parser.cst.ModelExpression;
import org.eclipse.acceleo.parser.cst.Module;
import org.eclipse.acceleo.parser.cst.TemplateExpression;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateForIfAction
extends AbstractRefactoringWithVariableContextAction {
    public static final String ACTION_ID = "org.eclipse.acceleo.ide.ui.editors.template.actions.refactor.createForIf";
    public static final String COMMAND_ID = "org.eclipse.acceleo.ide.ui.createForIf";

    @Override
    protected int modify(IDocument document, AcceleoSourceContent content, int offset, int length) throws BadLocationException {
        int b = offset;
        int e = offset + length;
        try {
            int outputIndex = b;
            String text = document.get(offset, length);
            CSTNode currentNode = content.getCSTNode(b, e);
            boolean singleLine = !text.contains("\n");
            StringBuilder newBuffer = new StringBuilder();
            List<String> parts = this.getParts(text);
            String indentIf = singleLine ? "" : (parts.size() > 1 ? "\t\t" : "\t");
            StringBuilder prefix = new StringBuilder();
            if (parts.size() > 1) {
                prefix.append("\t[for (");
                prefix.append(this.computeForExpression(content, text, currentNode));
                outputIndex = b + prefix.length();
                prefix.append(")");
                prefix.append("]");
                if (!singleLine) {
                    prefix.append("\n");
                }
            }
            prefix.append(indentIf);
            String ifCondition = parts.size() > 0 ? this.computeIfExpression(content, parts.get(0)) : "";
            prefix.append("[if (");
            prefix.append(ifCondition);
            outputIndex = b + prefix.length();
            prefix.append(")]");
            if (!singleLine) {
                prefix.append("\n");
            }
            newBuffer.append((CharSequence)prefix);
            if (parts.size() > 0) {
                int i = 0;
                while (i < parts.size()) {
                    String part = parts.get(i);
                    if (i > 0) {
                        StringBuilder elseIfPrefix = new StringBuilder();
                        elseIfPrefix.append(indentIf);
                        elseIfPrefix.append("[elseif (");
                        elseIfPrefix.append(this.computeIfExpression(content, part));
                        elseIfPrefix.append(")]");
                        if (!singleLine) {
                            elseIfPrefix.append("\n");
                        }
                        newBuffer.append((CharSequence)elseIfPrefix);
                    }
                    newBuffer.append(part);
                    ++i;
                }
            }
            StringBuilder suffix = new StringBuilder();
            if (!singleLine) {
                suffix.append("\n");
            }
            suffix.append(indentIf);
            suffix.append("[/if]");
            if (!singleLine) {
                suffix.append("\n");
            }
            if (parts.size() > 1) {
                suffix.append("\t[/for]");
                if (!singleLine) {
                    suffix.append("\n");
                }
            }
            newBuffer.append((CharSequence)suffix);
            document.replace(b, e - b, newBuffer.toString());
            return outputIndex;
        }
        catch (BadLocationException badLocationException) {
            return offset;
        }
    }

    private List<String> getParts(String text) {
        ArrayList<String> result = new ArrayList<String>();
        if (text.trim().length() == 0) {
            return result;
        }
        StringBuilder current = new StringBuilder();
        boolean emptyLine = true;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            current.append(c);
            if (c == '\n') {
                if (emptyLine) {
                    if (current.toString().trim().length() > 0) {
                        result.add(current.toString());
                        current = new StringBuilder();
                    }
                } else {
                    emptyLine = true;
                }
            } else if (!Character.isWhitespace(c)) {
                emptyLine = false;
            }
            ++i;
        }
        if (current.toString().trim().length() > 0) {
            result.add(current.toString());
        }
        return result;
    }

    private String computeIfExpression(AcceleoSourceContent content, String text) {
        StringBuilder result = new StringBuilder();
        String ifCondition = this.findBestAvailableExpression(content, text, true, false);
        if (ifCondition != null && ifCondition.length() > 0) {
            result.append(ifCondition);
        } else {
            result.append("oclIsKindOf()");
        }
        return result.toString();
    }

    private String computeForExpression(AcceleoSourceContent content, String text, CSTNode currentNode) {
        StringBuilder result = new StringBuilder();
        String forCondition = this.findBestAvailableExpression(content, text, false, true);
        if (forCondition != null && forCondition.length() > 0) {
            result.append(forCondition);
        } else if (currentNode == null) {
            result.append("e : E | eAllContents()");
        } else {
            EReference eRef = null;
            String currentType = this.getCurrentVariableTypeName(currentNode, "");
            Iterator<EClassifier> eTypes = content.getTypes().iterator();
            block0: while (eRef == null && eTypes.hasNext()) {
                EClassifier eType = eTypes.next();
                if (!(eType instanceof EClass) || ((EClass)eType).getName() == null || !((EClass)eType).getName().equals(currentType)) continue;
                for (EReference eReference : ((EClass)eType).getEAllReferences()) {
                    if (!eReference.isContainment() || eReference.isDerived()) continue;
                    eRef = eReference;
                    continue block0;
                }
            }
            if (eRef != null && eRef.getName() != null && eRef.getEType() != null && eRef.getEType().getName() != null) {
                if (eRef.getEType().getName().length() > 0) {
                    result.append(Character.toLowerCase(eRef.getEType().getName().charAt(0)));
                }
                result.append(" : ");
                result.append(eRef.getEType().getName());
                result.append(" | ");
                result.append(eRef.getName());
            } else {
                result.append("e : E | eAllContents()");
            }
        }
        return result.toString();
    }

    private String findBestAvailableExpression(AcceleoSourceContent content, String body, boolean includeIf, boolean includeFor) {
        Module eRoot = content.getCST();
        if (eRoot == null) {
            return "";
        }
        int maxScore = -1;
        String maxScoreExpression = "";
        List<String> words = this.getOrderedWords(body);
        TreeIterator eAllContents = eRoot.eAllContents();
        while (eAllContents.hasNext()) {
            ForBlock forBlock;
            int score;
            int score2;
            IfBlock ifBlock;
            ModelExpression modelExpression;
            EObject eObject = (EObject)eAllContents.next();
            if (includeIf && eObject instanceof IfBlock && (modelExpression = (ifBlock = (IfBlock)eObject).getIfExpr()) != null && modelExpression.getBody() != null && (score2 = this.computeScore((Block)ifBlock, content, words)) >= maxScore) {
                maxScore = score2;
                maxScoreExpression = modelExpression.getBody();
            }
            if (!includeFor || !(eObject instanceof ForBlock) || (score = this.computeScore((Block)(forBlock = (ForBlock)eObject), content, words)) < maxScore || forBlock.getIterSet() == null || forBlock.getIterSet().getBody() == null) continue;
            String iterSet = forBlock.getIterSet().getBody();
            maxScore = score;
            maxScoreExpression = forBlock.getLoopVariable() != null ? String.valueOf(forBlock.getLoopVariable().getName()) + " : " + forBlock.getLoopVariable().getType() + " | " + iterSet : iterSet;
        }
        if (maxScoreExpression != null) {
            if ((maxScoreExpression = maxScoreExpression.trim()).startsWith("(")) {
                maxScoreExpression = maxScoreExpression.substring(1).trim();
            }
            if (maxScoreExpression.endsWith(")")) {
                maxScoreExpression = maxScoreExpression.substring(0, maxScoreExpression.length() - 1).trim();
            }
        }
        return maxScoreExpression;
    }

    private int computeScore(Block block, AcceleoSourceContent content, List<String> words) {
        int e;
        int b;
        if (block.getBody().size() > 0) {
            b = ((TemplateExpression)block.getBody().get(0)).getStartPosition();
            e = ((TemplateExpression)block.getBody().get(block.getBody().size() - 1)).getEndPosition();
        } else {
            b = 0;
            e = 0;
        }
        String thenText = content.getText().substring(b, e);
        ArrayList<String> refCopy = new ArrayList<String>(words);
        int score = 0;
        for (String token : this.getOrderedWords(thenText)) {
            if (!refCopy.contains(token)) continue;
            refCopy.remove(token);
            score += token.length();
        }
        return score;
    }

    private List<String> getOrderedWords(String text) {
        ArrayList<String> words = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                if (Character.isUpperCase(c) && current.length() > 0) {
                    words.add(current.toString().toLowerCase());
                    current = new StringBuilder();
                }
                current.append(c);
            } else if (current.length() > 0) {
                words.add(current.toString().toLowerCase());
                current = new StringBuilder();
            }
            ++i;
        }
        if (current.length() > 0) {
            words.add(current.toString().toLowerCase());
        }
        return words;
    }
}

