/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename;

import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameModuleRefactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AcceleoRenameModuleInputWizardPage
extends UserInputWizardPage {
    private Text fNameField;

    public AcceleoRenameModuleInputWizardPage(String name) {
        super(name);
    }

    public void createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        Label label = new Label(result, 0);
        label.setText(AcceleoUIMessages.getString("AcceleoEditorRenameModuleRefactoring.NewName"));
        this.fNameField = this.createNameField(result);
        AcceleoRenameModuleRefactoring refactoring = this.getRenameModuleRefactoring();
        this.fNameField.setText(refactoring.getModule().getName());
        this.fNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AcceleoRenameModuleInputWizardPage.this.handleInputChanged();
            }
        });
        this.fNameField.setFocus();
        this.fNameField.selectAll();
        this.handleInputChanged();
    }

    private Text createNameField(Composite result) {
        Text field = new Text(result, 18436);
        field.setLayoutData((Object)new GridData(768));
        return field;
    }

    private AcceleoRenameModuleRefactoring getRenameModuleRefactoring() {
        return (AcceleoRenameModuleRefactoring)this.getRefactoring();
    }

    private void handleInputChanged() {
        RefactoringStatus status = new RefactoringStatus();
        AcceleoRenameModuleRefactoring refactoring = this.getRenameModuleRefactoring();
        status.merge(refactoring.setNewModuleName(this.fNameField.getText()));
        this.setPageComplete(!status.hasError());
        int severity = status.getSeverity();
        String message = status.getMessageMatchingSeverity(severity);
        if (severity >= 1) {
            this.setMessage(message, severity);
        } else {
            this.setMessage("", 0);
        }
    }
}

