/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.editor.configuration.delegates.xml;

import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jet.internal.editor.Activator;
import org.eclipse.jet.internal.editor.JETTextEditor;
import org.eclipse.jet.internal.editor.configuration.delegates.IJETDefaultTextColorerDelegate;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public class XMLContentPartitionConfigurationDelegate
implements IJETDefaultTextColorerDelegate {
    public static final String XML_COMMENT = "__xml_comment";
    public static final String XML_TAG = "__xml_tag";
    private XMLTagScanner tagScanner;
    private XMLScanner scanner;
    private XMLScanner commentScanner;
    private IColorManager colorManager;

    public XMLContentPartitionConfigurationDelegate(JETTextEditor editor) {
        this.colorManager = editor.getTokenStyleManager();
    }

    public String getName() {
        return "XML Text Content Colorer";
    }

    public Image getImage() {
        return Activator.getDefault().getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    }

    public IPredicateRule[] getPartitioningRules() {
        Token xmlComment = new Token((Object)XML_COMMENT);
        Token tag = new Token((Object)XML_TAG);
        IPredicateRule[] rules = new IPredicateRule[]{new MultiLineRule("<!--", "-->", (IToken)xmlComment), new TagRule((IToken)tag)};
        return rules;
    }

    public ITokenScanner getTokenScanner(String contentType) {
        if ("__dftl_partition_content_type".equals(contentType)) {
            return this.getXMLScanner();
        }
        if (XML_TAG.equals(contentType)) {
            return this.getXMLTagScanner();
        }
        if (XML_COMMENT.equals(contentType)) {
            return this.getCommentScanner();
        }
        return this.getXMLScanner();
    }

    protected XMLScanner getCommentScanner() {
        if (this.commentScanner == null) {
            this.commentScanner = new XMLScanner(this.colorManager);
            this.commentScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IXMLColorConstants.XML_COMMENT))));
        }
        return this.commentScanner;
    }

    protected XMLScanner getXMLScanner() {
        if (this.scanner == null) {
            this.scanner = new XMLScanner(this.colorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IXMLColorConstants.DEFAULT))));
        }
        return this.scanner;
    }

    protected XMLTagScanner getXMLTagScanner() {
        if (this.tagScanner == null) {
            this.tagScanner = new XMLTagScanner(this.colorManager);
            this.tagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IXMLColorConstants.TAG))));
        }
        return this.tagScanner;
    }

    public static interface IXMLColorConstants {
        public static final RGB XML_COMMENT = new RGB(128, 0, 0);
        public static final RGB PROC_INSTR = new RGB(128, 128, 128);
        public static final RGB STRING = new RGB(0, 128, 0);
        public static final RGB DEFAULT = new RGB(0, 0, 0);
        public static final RGB TAG = new RGB(0, 0, 128);
    }

    public class TagRule
    extends MultiLineRule {
        protected boolean sequenceDetected(ICharacterScanner scanner, char[] sequence, boolean eofAllowed) {
            int c = scanner.read();
            if (sequence[0] == '<') {
                if (c == 63) {
                    scanner.unread();
                    return false;
                }
                if (c == 33) {
                    scanner.unread();
                    return false;
                }
            } else if (sequence[0] == '>') {
                scanner.unread();
            }
            return super.sequenceDetected(scanner, sequence, eofAllowed);
        }

        public TagRule(IToken token) {
            super("<", ">", token);
        }
    }

    public class XMLScanner
    extends RuleBasedScanner {
        public XMLScanner(IColorManager manager) {
            Token procInstr = new Token((Object)new TextAttribute(manager.getColor(IXMLColorConstants.PROC_INSTR)));
            IRule[] rules = new IRule[]{new SingleLineRule("<?", "?>", (IToken)procInstr), new WhitespaceRule((IWhitespaceDetector)new XMLWhitespaceDetector())};
            this.setRules(rules);
        }
    }

    public class XMLTagScanner
    extends RuleBasedScanner {
        public XMLTagScanner(IColorManager manager) {
            Token string = new Token((Object)new TextAttribute(manager.getColor(IXMLColorConstants.STRING)));
            IRule[] rules = new IRule[]{new SingleLineRule("\"", "\"", (IToken)string, '\\'), new SingleLineRule("'", "'", (IToken)string, '\\'), new WhitespaceRule((IWhitespaceDetector)new XMLWhitespaceDetector())};
            this.setRules(rules);
        }
    }

    public class XMLWhitespaceDetector
    implements IWhitespaceDetector {
        public boolean isWhitespace(char c) {
            return c == ' ' || c == '\t' || c == '\n' || c == '\r';
        }
    }
}

