/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.format;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.taglib.AbstractFunctionTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.osgi.util.NLS;

public class IndentTag
extends AbstractFunctionTag {
    private static final String TEXT_ATTR = "text";
    private static final String DEPTH_ATTR = "depth";
    private static final String NL_REGEX = "([\\n][\\r]?|[\\r][\\n]?)";
    private static final Pattern NL_PATTERN = Pattern.compile("([\\n][\\r]?|[\\r][\\n]?)", 8);
    private static final String NL = System.getProperty("line.separator");

    public String doFunction(TagInfo td, JET2Context context, String bodyContent) throws JET2TagException {
        String indentText = this.getAttribute(TEXT_ATTR);
        String depthValue = this.getAttribute(DEPTH_ATTR);
        try {
            int depth = depthValue == null ? 1 : Integer.decode(depthValue);
            return IndentTag.indent(bodyContent, indentText, depth);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JET2TagException(NLS.bind((String)JET2Messages.IndentTag_AttributeValueMustBeInteger, (Object)DEPTH_ATTR, (Object)depthValue));
        }
    }

    public static String indent(String content, String indent, int depth) {
        String line;
        String totalIndent = IndentTag.computeTotalIndent(indent, depth);
        if (totalIndent.length() == 0) {
            return content;
        }
        boolean indentIsWhitespace = totalIndent.matches("\\s*");
        Matcher matcher = NL_PATTERN.matcher(content);
        StringBuffer result = new StringBuffer(content.length() * 2);
        int lineStart = 0;
        while (matcher.find(lineStart)) {
            line = content.substring(lineStart, matcher.start());
            if (line.length() > 0 || !indentIsWhitespace) {
                result.append(totalIndent);
            }
            result.append(line);
            result.append(NL);
            lineStart = matcher.end();
            lineStart = matcher.end();
        }
        if (lineStart < content.length()) {
            line = content.substring(lineStart);
            result.append(totalIndent).append(line).append(NL);
        }
        return result.toString();
    }

    private static String computeTotalIndent(String indent, int depth) {
        StringBuffer buffer = new StringBuffer(depth * indent.length());
        if (indent != null) {
            int i = 0;
            while (i < depth) {
                buffer.append(indent);
                ++i;
            }
        }
        return buffer.toString();
    }
}

