/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.xpath;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jet.internal.xpath.functions.BooleanFunction;
import org.eclipse.jet.internal.xpath.functions.NumberFunction;
import org.eclipse.jet.internal.xpath.functions.StringFunction;
import org.eclipse.jet.xpath.NodeSet;

public final class XPathUtil {
    private XPathUtil() {
    }

    public static String xpathString(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return StringFunction.evaluate(object);
    }

    public static boolean xpathBoolean(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return BooleanFunction.evaluate(object);
    }

    public static double xpathNumber(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return NumberFunction.evaluate(object);
    }

    public static NodeSet asNodeSet(Object[] objectArray) {
        return new NodeSetAdapter(objectArray);
    }

    public static NodeSet asNodeSet(Collection collection) {
        return new NodeSetAdapter(collection);
    }

    protected static class NodeSetAdapter
    implements NodeSet {
        private final Collection collection;

        public NodeSetAdapter(Object[] objectArray) {
            this(Arrays.asList(objectArray));
        }

        public NodeSetAdapter(Collection collection) {
            this.collection = collection;
        }

        public boolean add(Object o) {
            return this.collection.add(o);
        }

        public boolean addAll(Collection c) {
            return this.collection.addAll(c);
        }

        public void clear() {
            this.collection.clear();
        }

        public boolean contains(Object o) {
            return this.collection.contains(o);
        }

        public boolean containsAll(Collection c) {
            return this.collection.containsAll(c);
        }

        public boolean isEmpty() {
            return this.collection.isEmpty();
        }

        public Iterator iterator() {
            return this.collection.iterator();
        }

        public boolean remove(Object o) {
            return this.collection.remove(o);
        }

        public boolean removeAll(Collection c) {
            return this.collection.removeAll(c);
        }

        public boolean retainAll(Collection c) {
            return this.collection.retainAll(c);
        }

        public int size() {
            return this.collection.size();
        }

        public Object[] toArray() {
            return this.collection.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.collection.toArray(a);
        }
    }
}

