/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.ConnectorKind;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.internal.operations.ConnectableElementOperations;
import org.eclipse.uml2.uml.internal.operations.RedefinableElementOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorOperations
extends RedefinableElementOperations {
    protected ConnectorOperations() {
    }

    public static boolean validateTypes(Connector connector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Association connectorType = connector.getType();
        if (connectorType != null) {
            Iterator ends = connector.getEnds().iterator();
            Iterator memberEnds = connectorType.getMemberEnds().iterator();
            while (ends.hasNext() && memberEnds.hasNext()) {
                ConnectableElement role = ((ConnectorEnd)ends.next()).getRole();
                Type type = role == null ? null : role.getType();
                Type memberEndType = ((Property)memberEnds.next()).getType();
                if (!(type == null ? memberEndType != null : !type.conformsTo(memberEndType))) continue;
                result = false;
                break;
            }
            if (ends.hasNext() || memberEnds.hasNext()) {
                result = false;
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 113, UMLPlugin.INSTANCE.getString("_UI_Connector_Types_diagnostic", ConnectorOperations.getMessageSubstitutions(context, (Object)connector)), new Object[]{connector}));
        }
        return result;
    }

    public static boolean validateCompatible(Connector connector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateRoles(Connector connector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        for (ConnectorEnd end : connector.getEnds()) {
            ConnectableElement role = end.getRole();
            Element owner = null;
            if (role instanceof Port) {
                Property partWithPort = end.getPartWithPort();
                owner = partWithPort == null ? role.getOwner() : partWithPort.getOwner();
            } else {
                Element element = owner = role == null ? null : role.getOwner();
            }
            if (connector.getOwner() == owner) continue;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 115, UMLPlugin.INSTANCE.getString("_UI_Connector_Roles_diagnostic", ConnectorOperations.getMessageSubstitutions(context, (Object)connector)), new Object[]{connector}));
            }
            return false;
        }
        return true;
    }

    public static boolean validateBetweenInterfacesPorts(Connector connector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EList<ConnectorEnd> ends = connector.getEnds();
        if (connector.getKind() == ConnectorKind.DELEGATION_LITERAL && ends.size() == 2) {
            ConnectableElement role1 = ((ConnectorEnd)ends.get(0)).getRole();
            EList<Interface> required1 = ConnectableElementOperations.getRequiredInterfaces(role1);
            EList<Interface> provided1 = ConnectableElementOperations.getProvidedInterfaces(role1);
            ConnectableElement role2 = ((ConnectorEnd)ends.get(1)).getRole();
            EList<Interface> required2 = ConnectableElementOperations.getRequiredInterfaces(role2);
            EList<Interface> provided2 = ConnectableElementOperations.getProvidedInterfaces(role2);
            if (ConnectorOperations.intersect(provided2, required1) || ConnectorOperations.intersect(provided1, required2)) {
                if (diagnostics != null) {
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 116, UMLPlugin.INSTANCE.getString("_UI_Connector_BetweenInterfacesPorts_diagnostic", ConnectorOperations.getMessageSubstitutions(context, (Object)connector)), new Object[]{connector}));
                }
                return false;
            }
        }
        return true;
    }

    public static boolean validateBetweenInterfacePortImplements(Connector connector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EList<ConnectorEnd> ends = connector.getEnds();
        if (connector.getKind() == ConnectorKind.DELEGATION_LITERAL && ends.size() == 2) {
            Type toType;
            ConnectorEnd end1 = (ConnectorEnd)ends.get(0);
            ConnectableElement role1 = end1.getRole();
            ConnectorEnd end2 = (ConnectorEnd)ends.get(1);
            ConnectableElement role2 = end2.getRole();
            EList<Interface> provided1 = ConnectableElementOperations.getProvidedInterfaces(role1);
            if (!provided1.isEmpty() && !(role2 instanceof Port) && role2 instanceof Property && (toType = ((Property)role2).getType()) instanceof BehavioredClassifier && !((BehavioredClassifier)toType).getAllImplementedInterfaces().containsAll(provided1)) {
                if (diagnostics != null) {
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 117, UMLPlugin.INSTANCE.getString("_UI_Connector_BetweenInterfacePortImplements_diagnostic", ConnectorOperations.getMessageSubstitutions(context, (Object)connector)), new Object[]{connector}));
                }
                return false;
            }
        }
        return true;
    }

    public static boolean validateBetweenInterfacePortSignature(Connector connector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        EList<ConnectorEnd> ends = connector.getEnds();
        if (connector.getKind() == ConnectorKind.DELEGATION_LITERAL && ends.size() == 2) {
            ConnectableElement role1 = ((ConnectorEnd)ends.get(0)).getRole();
            EList<Interface> required1 = ConnectableElementOperations.getRequiredInterfaces(role1);
            EList<Interface> provided1 = ConnectableElementOperations.getProvidedInterfaces(role1);
            ConnectableElement role2 = ((ConnectorEnd)ends.get(1)).getRole();
            EList<Interface> required2 = ConnectableElementOperations.getRequiredInterfaces(role2);
            EList<Interface> provided2 = ConnectableElementOperations.getProvidedInterfaces(role2);
            if (!provided1.isEmpty() && !provided2.isEmpty()) {
                boolean bl = result = result && ConnectorOperations.intersect(provided1, provided2);
            }
            if (!required1.isEmpty() && !required2.isEmpty()) {
                boolean bl = result = result && ConnectorOperations.intersect(required1, required2);
            }
            if (!result && diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 118, UMLPlugin.INSTANCE.getString("_UI_Connector_BetweenInterfacePortSignature_diagnostic", ConnectorOperations.getMessageSubstitutions(context, (Object)connector)), new Object[]{connector}));
            }
        }
        return result;
    }

    public static boolean validateUnionSignatureCompatible(Connector connector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateAssemblyConnector(Connector connector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EList<ConnectorEnd> ends = connector.getEnds();
        if (connector.getKind() == ConnectorKind.ASSEMBLY_LITERAL && ends.size() == 2) {
            ConnectableElement role1 = ((ConnectorEnd)ends.get(0)).getRole();
            EList<Interface> required1 = ConnectableElementOperations.getRequiredInterfaces(role1);
            EList<Interface> provided1 = ConnectableElementOperations.getProvidedInterfaces(role1);
            ConnectableElement role2 = ((ConnectorEnd)ends.get(1)).getRole();
            EList<Interface> required2 = ConnectableElementOperations.getRequiredInterfaces(role2);
            EList<Interface> provided2 = ConnectableElementOperations.getProvidedInterfaces(role2);
            if (!ConnectorOperations.intersect(provided1, required2) && !ConnectorOperations.intersect(provided2, required1)) {
                if (diagnostics != null) {
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 120, UMLPlugin.INSTANCE.getString("_UI_Connector_AssemblyConnector_diagnostic", ConnectorOperations.getMessageSubstitutions(context, (Object)connector)), new Object[]{connector}));
                }
                return false;
            }
        }
        return true;
    }
}

