/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.rdf.reasoner.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.eodm.rdf.rdfbase.RDFGraph;
import org.eclipse.eodm.rdf.rdfbase.RDFProperty;
import org.eclipse.eodm.rdf.rdfbase.RDFSResource;
import org.eclipse.eodm.rdf.rdfs.RDFSClass;
import org.eclipse.eodm.rdf.reasoner.RDFSReasoner;
import org.eclipse.eodm.rdf.reasoner.RDFSReasonerException;
import org.eclipse.eodm.util.Triple;

public class RDFSReasonerImpl
implements RDFSReasoner {
    protected long lastTag = 1000000L;
    protected static Map DATATYPE_HIER = RDFSReasonerImpl.buildDataHierarchy();
    private RDFGraph gModel = null;
    private static String RDF_TYPE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
    private static String RDFS_CLASS = "http://www.w3.org/2000/01/rdf-schema#Class";
    private static String RDF_PROPERTY = "http://www.w3.org/1999/02/22-rdf-syntax-ns#Property";
    protected AccessInfoMap accessMap = new AccessInfoMap();
    protected List classes = new ArrayList();
    protected List properties = new ArrayList();

    public void initialize(RDFGraph graph) throws RDFSReasonerException {
        try {
            this.navigateModel(graph);
        }
        catch (Exception exception) {}
        this.gModel = graph;
        Report report = new Report();
        report.errorMsg.isEmpty();
        report.warningMsg.isEmpty();
    }

    public void initializeWithoutValidation(RDFGraph model) {
        try {
            this.navigateModel(model);
        }
        catch (Exception exception) {}
    }

    public List getDescendantClasses(RDFSClass c) {
        ArrayList<RDFSClass> result = new ArrayList<RDFSClass>();
        if (c != null) {
            long tag = this.applyAccessTag();
            ArrayList<RDFSClass> queue = new ArrayList<RDFSClass>();
            queue.add(c);
            while (!queue.isEmpty()) {
                RDFSClass node = (RDFSClass)queue.remove(0);
                AccessInfo info = this.accessMap.getAccessInfo(node);
                if (info.visitTag == tag) continue;
                info.visitTag = tag;
                result.add(node);
                queue.addAll((Collection<RDFSClass>)node.getSubClass());
            }
        }
        return result;
    }

    public List getAncestorClasses(RDFSClass c) {
        ArrayList<RDFSClass> result = new ArrayList<RDFSClass>();
        if (c != null) {
            long tag = this.applyAccessTag();
            ArrayList<RDFSClass> queue = new ArrayList<RDFSClass>();
            queue.add(c);
            while (!queue.isEmpty()) {
                RDFSClass node = (RDFSClass)queue.remove(0);
                AccessInfo info = this.accessMap.getAccessInfo(node);
                if (info.visitTag == tag) continue;
                info.visitTag = tag;
                result.add(node);
                queue.addAll((Collection<RDFSClass>)node.getRDFSsubClassOf());
            }
        }
        return result;
    }

    public List getDescendantProperties(RDFProperty property) {
        long tag = this.applyAccessTag();
        ArrayList<RDFProperty> result = new ArrayList<RDFProperty>();
        if (property != null) {
            ArrayList<RDFProperty> queue = new ArrayList<RDFProperty>();
            queue.add(property);
            while (!queue.isEmpty()) {
                RDFProperty node = (RDFProperty)queue.remove(0);
                AccessInfo info = this.accessMap.getAccessInfo(node);
                if (info.visitTag == tag) continue;
                info.visitTag = tag;
                result.add(node);
                queue.addAll((Collection<RDFProperty>)node.getSubProperty());
            }
        }
        return result;
    }

    public List getAncestorProperties(RDFProperty property) {
        ArrayList<RDFProperty> result = new ArrayList<RDFProperty>();
        if (property != null) {
            ArrayList<RDFProperty> queue = new ArrayList<RDFProperty>();
            queue.add(property);
            long tag = this.applyAccessTag();
            while (!queue.isEmpty()) {
                RDFProperty node = (RDFProperty)queue.remove(0);
                AccessInfo info = this.accessMap.getAccessInfo(node);
                if (info.visitTag == tag) continue;
                info.visitTag = tag;
                result.add(node);
                queue.addAll((Collection<RDFProperty>)node.getRDFSsubPropertyOf());
            }
        }
        return result;
    }

    public boolean isDescendantClassOf(RDFSClass c1, RDFSClass c2) {
        if (c1 != null && c2 != null) {
            ArrayList<RDFSClass> queue = new ArrayList<RDFSClass>();
            queue.add(c2);
            long tag = this.applyAccessTag();
            while (!queue.isEmpty()) {
                RDFSClass node = (RDFSClass)queue.remove(0);
                if (node == c1) {
                    return true;
                }
                AccessInfo info = this.accessMap.getAccessInfo(node);
                if (info.visitTag == tag) continue;
                info.visitTag = tag;
                queue.addAll((Collection<RDFSClass>)node.getSubClass());
            }
        }
        return false;
    }

    public boolean isAncestorClassOf(RDFSClass c1, RDFSClass c2) {
        return !this.isDescendantClassOf(c2, c1);
    }

    public boolean isDescendantPropertyOf(RDFProperty p1, RDFProperty p2) {
        if (p1 != null && p2 != null) {
            ArrayList<RDFProperty> queue = new ArrayList<RDFProperty>();
            queue.add(p2);
            long tag = this.applyAccessTag();
            while (!queue.isEmpty()) {
                RDFProperty node = (RDFProperty)queue.remove(0);
                if (node == p1) {
                    return true;
                }
                AccessInfo info = this.accessMap.getAccessInfo(node);
                if (info.visitTag == tag) continue;
                info.visitTag = tag;
                queue.addAll((Collection<RDFProperty>)node.getSubProperty());
            }
        }
        return false;
    }

    public boolean isAncestorPropertyOf(RDFProperty p1, RDFProperty p2) {
        return !this.isDescendantPropertyOf(p2, p1);
    }

    private void navigateModel(RDFGraph graph) throws Exception {
        this.classes = graph.getTypeResources(RDFS_CLASS);
        this.properties = graph.getTypeResources(RDF_PROPERTY);
        Iterator it = graph.exportTriples().iterator();
        while (it.hasNext()) {
            Triple t = (Triple)it.next();
            String predicate = t.getPredicate();
            if (predicate.equals(RDF_TYPE)) {
                RDFSResource subj;
                RDFSResource type = graph.getRDFSResource(t.getObjectURI());
                if (type == null || (subj = graph.getRDFSResource(t.getSubjectURI())) == null) continue;
                this.accessMap.getAccessInfo((Object)type).cache.add(subj);
                continue;
            }
            RDFSResource p = graph.getRDFSResource(predicate);
            if (p == null) continue;
            this.accessMap.getAccessInfo((Object)p).cache.add(t);
        }
    }

    public void validateOntology(RDFGraph model) {
        try {
            this.navigateModel(model);
        }
        catch (Exception exception) {}
    }

    protected long applyAccessTag() {
        return this.lastTag++;
    }

    protected boolean isDatatypeSubClassOf(String type1, String type2) {
        String key1 = (String)DATATYPE_HIER.get(type1);
        String key2 = (String)DATATYPE_HIER.get(type2);
        return key1.startsWith(key2);
    }

    protected static Map buildDataHierarchy() {
        HashMap<String, String> datatypeHier = new HashMap<String, String>();
        datatypeHier.put("string", "a");
        datatypeHier.put("normalizedString", "aa");
        datatypeHier.put("token", "aaa");
        datatypeHier.put("language", "aaaa");
        datatypeHier.put("Name", "aaab");
        datatypeHier.put("NMTOKEN", "aaac");
        datatypeHier.put("NCName", "aaaba");
        datatypeHier.put("NMTOKENS", "aaaca");
        datatypeHier.put("ID", "aaabaa");
        datatypeHier.put("IDREF", "aaabab");
        datatypeHier.put("ENTITY", "aaabac");
        datatypeHier.put("IDREFS", "aaababa");
        datatypeHier.put("ENTITIES", "aaabaca");
        datatypeHier.put("boolean", "b");
        datatypeHier.put("base64Binary", "c");
        datatypeHier.put("hexBinary", "d");
        datatypeHier.put("float", "e");
        datatypeHier.put("decimal", "f");
        datatypeHier.put("integer", "fa");
        datatypeHier.put("nonPositiveInteger", "faa");
        datatypeHier.put("long", "fab");
        datatypeHier.put("nonNegativeInteger", "fac");
        datatypeHier.put("negativeInteger", "faaa");
        datatypeHier.put("int", "faba");
        datatypeHier.put("unsignedLong", "faca");
        datatypeHier.put("positiveInteger", "facb");
        datatypeHier.put("short", "fabaa");
        datatypeHier.put("unsignedInt", "facaa");
        datatypeHier.put("byte", "fabaaa");
        datatypeHier.put("unsignedShort", "facaaa");
        datatypeHier.put("unsignedByte", "facaaaa");
        datatypeHier.put("double", "g");
        datatypeHier.put("anyURI", "h");
        datatypeHier.put("QName", "i");
        datatypeHier.put("NOTATION", "j");
        datatypeHier.put("duration", "k");
        datatypeHier.put("dateTime", "l");
        datatypeHier.put("time", "m");
        datatypeHier.put("date", "n");
        datatypeHier.put("gYearMonth", "o");
        datatypeHier.put("gYear", "p");
        datatypeHier.put("gMonthDay", "q");
        datatypeHier.put("gDay", "r");
        datatypeHier.put("gMonth", "s");
        return datatypeHier;
    }

    public List getInstances(RDFSClass c) {
        ArrayList<RDFSResource> result = new ArrayList<RDFSResource>();
        long tag = this.applyAccessTag();
        List children = this.getDescendantClasses(c);
        long domainRelatedTag = this.applyAccessTag();
        Iterator it = children.iterator();
        while (it.hasNext()) {
            RDFSClass subClass = (RDFSClass)it.next();
            Iterator itInst = this.accessMap.getAccessInfo((Object)subClass).cache.iterator();
            while (itInst.hasNext()) {
                RDFSResource instance = (RDFSResource)itInst.next();
                AccessInfo info = this.accessMap.getAccessInfo(instance);
                if (info.visitTag == tag) continue;
                info.visitTag = tag;
                result.add(instance);
            }
            Iterator itP = subClass.getPropertyForDomain().iterator();
            while (itP.hasNext()) {
                RDFProperty property = (RDFProperty)itP.next();
                Iterator itSubP = this.getDescendantPropertiesByTag(property, domainRelatedTag).iterator();
                while (itSubP.hasNext()) {
                    RDFProperty subProperty = (RDFProperty)itSubP.next();
                    Iterator itS = this.accessMap.getAccessInfo((Object)subProperty).cache.iterator();
                    while (itS.hasNext()) {
                        Triple t = (Triple)itS.next();
                        RDFSResource instance = this.gModel.getRDFSResource(t.getSubjectURI());
                        AccessInfo info = this.accessMap.getAccessInfo(instance);
                        if (info.visitTag == tag) continue;
                        info.visitTag = tag;
                        result.add(instance);
                    }
                }
            }
        }
        long rangeRelatedTag = this.applyAccessTag();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            RDFSClass subClass = (RDFSClass)i.next();
            Iterator itP = subClass.getPropertyForRange().iterator();
            while (itP.hasNext()) {
                RDFProperty property = (RDFProperty)itP.next();
                Iterator itSubP = this.getDescendantPropertiesByTag(property, rangeRelatedTag).iterator();
                while (itSubP.hasNext()) {
                    RDFProperty subProperty = (RDFProperty)itSubP.next();
                    Iterator itS = this.accessMap.getAccessInfo((Object)subProperty).cache.iterator();
                    while (itS.hasNext()) {
                        Triple t = (Triple)itS.next();
                        RDFSResource instance = this.gModel.getRDFSResource(t.getObjectURI());
                        AccessInfo info = this.accessMap.getAccessInfo(instance);
                        if (info.visitTag == tag) continue;
                        info.visitTag = tag;
                        result.add(instance);
                    }
                }
            }
        }
        return result;
    }

    public List getTriples(RDFProperty property) {
        ArrayList<Triple> result = new ArrayList<Triple>();
        Iterator it = this.getDescendantProperties(property).iterator();
        while (it.hasNext()) {
            RDFProperty p = (RDFProperty)it.next();
            Iterator iter = this.accessMap.getAccessInfo((Object)p).cache.iterator();
            while (iter.hasNext()) {
                Triple s = (Triple)iter.next();
                Triple t = new Triple();
                t.setObjectLiteral(s.getObjectLiteral());
                t.setObjectNodeID(s.getObjectNodeID());
                t.setObjectURI(s.getObjectURI());
                t.setPredicate(property.getURI());
                t.setSubjectURI(s.getSubjectURI());
                t.setSubjectNodeID(s.getSubjectNodeID());
                result.add(t);
            }
        }
        return result;
    }

    protected List getDescendantPropertiesByTag(RDFProperty property, long tag) {
        ArrayList<RDFProperty> result = new ArrayList<RDFProperty>();
        if (property != null) {
            ArrayList<RDFProperty> queue = new ArrayList<RDFProperty>();
            queue.add(property);
            while (!queue.isEmpty()) {
                RDFProperty node = (RDFProperty)queue.remove(0);
                AccessInfo info = this.accessMap.getAccessInfo(node);
                if (info.visitTag == tag) continue;
                info.visitTag = tag;
                result.add(node);
                queue.addAll((Collection<RDFProperty>)node.getSubProperty());
            }
        }
        return result;
    }

    public boolean isValid(RDFGraph graph) {
        return false;
    }

    class AccessInfo {
        long visitTag = 0L;
        HashSet cache = new HashSet();

        AccessInfo() {
        }
    }

    class AccessInfoMap {
        private Map map = new HashMap();

        AccessInfoMap() {
        }

        public AccessInfo getAccessInfo(Object key) {
            AccessInfo info = (AccessInfo)this.map.get(key);
            if (info == null) {
                info = new AccessInfo();
                this.map.put(key, info);
            }
            return info;
        }

        public long getAccessTag(Object key) {
            return this.getAccessInfo((Object)key).visitTag;
        }

        public void setAccessTag(Object key, long tag) {
            this.getAccessInfo((Object)key).visitTag = tag;
        }
    }

    protected class Report {
        public ArrayList errorMsg = new ArrayList();
        public ArrayList warningMsg = new ArrayList();

        protected Report() {
        }
    }
}

