/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.rdf.resource;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLHandler;
import org.eclipse.eodm.rdf.rdfweb.Document;
import org.eclipse.eodm.rdf.resource.RDFXMLResource;
import org.eclipse.eodm.rdf.resource.RDFXMLSaver;
import org.eclipse.eodm.rdf.resource.parser.exception.ParserException;
import org.eclipse.eodm.rdf.resource.parser.impl.RDFXMLLoader;

public class RDFXMLResourceImpl
extends ResourceImpl
implements RDFXMLResource {
    protected String defaultEncoding = null;

    public RDFXMLResourceImpl(URI uri) {
        super(uri);
    }

    protected String getEncodingOption(Map options) {
        if (options == null) {
            return null;
        }
        Object enc = options.get("ENCODING");
        if (enc != null && enc instanceof String) {
            return (String)enc;
        }
        return null;
    }

    protected byte[] readGuessBuffer(InputStream is) throws IOException {
        int bytesRead;
        int BUFFER_SIZE = 200;
        if (is.available() == 0) {
            return new byte[0];
        }
        byte[] buffer = new byte[BUFFER_SIZE];
        is.mark(BUFFER_SIZE);
        int totalBytesRead = bytesRead = is.read(buffer, 0, BUFFER_SIZE);
        while (bytesRead != -1 && totalBytesRead < BUFFER_SIZE) {
            bytesRead = is.read(buffer, totalBytesRead, BUFFER_SIZE - totalBytesRead);
            if (bytesRead == -1) continue;
            totalBytesRead += bytesRead;
        }
        if (totalBytesRead < BUFFER_SIZE) {
            byte[] smallerBuffer = new byte[totalBytesRead];
            System.arraycopy(buffer, 0, smallerBuffer, 0, totalBytesRead);
            smallerBuffer = buffer;
        }
        is.reset();
        return buffer;
    }

    protected String guessEncoding(InputStream is) throws IOException {
        if (!is.markSupported()) {
            return null;
        }
        return XMLHandler.getXMLEncoding((byte[])this.readGuessBuffer(is));
    }

    protected void doLoad(InputStream inputStream, Map options) throws IOException {
        String enc = this.getEncodingOption(options);
        if (enc == null) {
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            enc = this.guessEncoding(inputStream);
        }
        this.defaultEncoding = enc;
        RDFXMLLoader.setDefaultBaseURI(this.getURI().toString());
        try {
            Document document = null;
            document = enc != null ? RDFXMLLoader.loadFromStream(inputStream, enc) : RDFXMLLoader.loadFromStream(inputStream);
            if (document != null) {
                this.getContents().add((Object)document);
            }
        }
        catch (ParserException pe) {
            IOException ioEx = new IOException("Exception in loading from RDF/XML stream");
            ioEx.initCause(pe);
            throw ioEx;
        }
    }

    protected void doSave(OutputStream outputStream, Map options) throws IOException {
        String enc = this.getEncodingOption(options);
        if (enc == null) {
            enc = this.defaultEncoding;
        }
        Document document = null;
        Iterator iterator = this.getContents().iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!(obj instanceof Document)) continue;
            document = (Document)obj;
            break;
        }
        if (document != null) {
            if (enc != null) {
                RDFXMLSaver.saveToStream(document, outputStream, enc);
            } else {
                RDFXMLSaver.saveToStream(document, outputStream);
            }
        }
    }
}

