/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: DisjunctionLink.java,v 1.2 2007/03/18 09:06:59 lzhang Exp $
 */

package org.eclipse.eodm.owl.reasoner.structural;

public class DisjunctionLink extends NodeLink {
    public DisjunctionLink(TBox graph) {
        super(graph);
    }

    public DisjunctionLink(TBox graph, CTNode source,
            CTNode target, int targetID) {
        super(graph, source, target);
        setTargetID(targetID);
    }

    public void setSource(CTNode source) {
        if (this.source != source) {
            if (this.source != null) {
                this.source.disjunctionLinks.remove(this);
            }
            this.source = source;
            if (source != null) {
                source.disjunctionLinks.add(this);
            }
        }
    }

    public void setTarget(CTNode target) {
        this.target = target;
    }

    public int getTargetID() {
        return targetID;
    }

    public void setTargetID(int targetID) {
        this.targetID = targetID;
    }

    int targetID;

}
