/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: StatementHandler.java,v 1.2 2007/03/18 08:39:03 lzhang Exp $
 */

package org.eclipse.eodm.rdf.resource.parser;

import org.eclipse.eodm.rdf.resource.parser.element.RDFResourceElement;
import org.eclipse.eodm.rdf.resource.parser.element.RDFValue;
import org.eclipse.eodm.rdf.resource.parser.element.URIReference;

/**
 * The statement handler.
 */
public interface StatementHandler {

    /**
     * Export RDF triple
     * 
     * @param subject
     *            the subject of the triple
     * @param predicate
     *            the property of the triple
     * @param object
     *            the object of the triple
     */
    void exportStatement(RDFResourceElement subject, URIReference predicate,
            RDFValue object);

    /**
     * Export the reification.
     * 
     * @param reifyNode
     *            the reification node
     * @param subject
     *            the subject of the statement
     * @param predicate
     *            the predicate of the statement
     * @param object
     *            the object of the statement
     */

    void exportReification(RDFResourceElement reifyNode,
            RDFResourceElement subject, URIReference predicate, RDFValue object);

    /**
     * Separate the output of statement and reification.
     * 
     * @param exportSeparate
     *            If true, the reification node will not bt exported in
     *            exportStatement(...) method
     */
    void setSeparateExport(boolean exportSeparate);

    /**
     * Whether the reification is exported separately.
     * 
     * @return true if the reification is exported separately
     */
    boolean isSeparateExport();
}