/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.internal.draw2d.handles;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.uml2.diagram.common.internal.draw2d.handles.U2THandleKit;

public class U2TMoveHandle
extends MoveHandle {
    final Insets myFrameInsets;
    private static Insets ourInsets = new Insets();
    private static final int BUFFER_GAP = 5;

    public U2TMoveHandle(IGraphicalEditPart owner) {
        this(owner, new Insets(0, 0, 0, 0));
    }

    public U2TMoveHandle(IGraphicalEditPart owner, Insets frameInsets) {
        super((GraphicalEditPart)owner);
        this.myFrameInsets = new Insets(frameInsets);
        this.setForegroundColor(U2THandleKit.SELECTION_COLOR);
        this.setCursor(null);
    }

    protected void initialize() {
        super.initialize();
        this.setBorder(null);
    }

    public void paintFigure(Graphics g) {
        Rectangle b = new Rectangle(this.getClientArea()).expand(this.myFrameInsets);
        g.setLineStyle(3);
        g.drawRectangle(b.x, b.y, b.width - 1, b.height - 1);
    }

    public Insets getInsets() {
        U2TMoveHandle.ourInsets.left = this.myFrameInsets.left;
        U2TMoveHandle.ourInsets.top = this.myFrameInsets.top;
        U2TMoveHandle.ourInsets.right = Math.max(this.myFrameInsets.right, 5);
        U2TMoveHandle.ourInsets.bottom = this.myFrameInsets.bottom;
        return ourInsets;
    }

    public boolean containsPoint(int x, int y) {
        if (!this.getBounds().contains(x, y)) {
            return false;
        }
        Rectangle.SINGLETON.setBounds(this.getBounds());
        Rectangle.SINGLETON.width -= 5;
        return !Rectangle.SINGLETON.contains(x, y);
    }

    protected DragTracker createDragTracker() {
        DragEditPartsTrackerEx tracker = new DragEditPartsTrackerEx((EditPart)this.getOwner());
        return tracker;
    }

    public Point getAccessibleLocation() {
        Point p = this.getBounds().getTopRight().translate(-2, this.getBounds().height / 4);
        this.translateToAbsolute((Translatable)p);
        return p;
    }
}

