/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.types.impl;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ocl.expressions.CollectionKind;
import org.eclipse.emf.ocl.types.AnyType;
import org.eclipse.emf.ocl.types.BagType;
import org.eclipse.emf.ocl.types.CollectionType;
import org.eclipse.emf.ocl.types.ElementType;
import org.eclipse.emf.ocl.types.InvalidType;
import org.eclipse.emf.ocl.types.MessageType;
import org.eclipse.emf.ocl.types.OrderedSetType;
import org.eclipse.emf.ocl.types.PrimitiveBoolean;
import org.eclipse.emf.ocl.types.PrimitiveInteger;
import org.eclipse.emf.ocl.types.PrimitiveReal;
import org.eclipse.emf.ocl.types.PrimitiveString;
import org.eclipse.emf.ocl.types.SequenceType;
import org.eclipse.emf.ocl.types.SetType;
import org.eclipse.emf.ocl.types.TupleType;
import org.eclipse.emf.ocl.types.TypeType;
import org.eclipse.emf.ocl.types.TypesFactory;
import org.eclipse.emf.ocl.types.TypesPackage;
import org.eclipse.emf.ocl.types.VoidType;
import org.eclipse.emf.ocl.types.impl.AnyTypeImpl;
import org.eclipse.emf.ocl.types.impl.BagTypeImpl;
import org.eclipse.emf.ocl.types.impl.CollectionTypeImpl;
import org.eclipse.emf.ocl.types.impl.ElementTypeImpl;
import org.eclipse.emf.ocl.types.impl.InvalidTypeImpl;
import org.eclipse.emf.ocl.types.impl.MessageTypeImpl;
import org.eclipse.emf.ocl.types.impl.OrderedSetTypeImpl;
import org.eclipse.emf.ocl.types.impl.PrimitiveBooleanImpl;
import org.eclipse.emf.ocl.types.impl.PrimitiveIntegerImpl;
import org.eclipse.emf.ocl.types.impl.PrimitiveRealImpl;
import org.eclipse.emf.ocl.types.impl.PrimitiveStringImpl;
import org.eclipse.emf.ocl.types.impl.SequenceTypeImpl;
import org.eclipse.emf.ocl.types.impl.SetTypeImpl;
import org.eclipse.emf.ocl.types.impl.TupleTypeImpl;
import org.eclipse.emf.ocl.types.impl.TypeTypeImpl;
import org.eclipse.emf.ocl.types.impl.VoidTypeImpl;

public class TypesFactoryImpl
extends EFactoryImpl
implements TypesFactory {
    public static final String copyright = "";

    public static TypesFactory init() {
        try {
            TypesFactory theTypesFactory = (TypesFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/OCL2/1.0.0/ocl/types");
            if (theTypesFactory != null) {
                return theTypesFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new TypesFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createAnyType();
            }
            case 1: {
                return this.createBagType();
            }
            case 2: {
                return this.createCollectionType();
            }
            case 3: {
                return this.createElementType();
            }
            case 4: {
                return this.createInvalidType();
            }
            case 5: {
                return this.createMessageType();
            }
            case 6: {
                return this.createOrderedSetType();
            }
            case 7: {
                return this.createPrimitiveBoolean();
            }
            case 8: {
                return this.createPrimitiveInteger();
            }
            case 9: {
                return this.createPrimitiveReal();
            }
            case 10: {
                return this.createPrimitiveString();
            }
            case 12: {
                return this.createSequenceType();
            }
            case 13: {
                return this.createSetType();
            }
            case 14: {
                return this.createTupleType();
            }
            case 15: {
                return this.createTypeType();
            }
            case 16: {
                return this.createVoidType();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public BagType createBagType() {
        return new BagTypeImpl();
    }

    public CollectionType createCollectionType() {
        return new CollectionTypeImpl();
    }

    public BagType createBagType(EClassifier elementType) {
        return new BagTypeImpl(elementType);
    }

    public CollectionType createCollectionType(EClassifier elementType) {
        return new CollectionTypeImpl(elementType);
    }

    public CollectionType createCollectionType(CollectionKind kind, EClassifier elementType) {
        switch (kind.getValue()) {
            case 3: {
                return this.createBagType(elementType);
            }
            case 2: {
                return this.createSetType(elementType);
            }
            case 4: {
                return this.createSequenceType(elementType);
            }
            case 5: {
                return this.createOrderedSetType(elementType);
            }
        }
        return this.createCollectionType(elementType);
    }

    public TupleType createTupleType(List parts) {
        return new TupleTypeImpl(parts);
    }

    public OrderedSetType createOrderedSetType() {
        return new OrderedSetTypeImpl();
    }

    public OrderedSetType createOrderedSetType(EClassifier elementType) {
        return new OrderedSetTypeImpl(elementType);
    }

    public SequenceType createSequenceType() {
        return new SequenceTypeImpl();
    }

    public SequenceType createSequenceType(EClassifier elementType) {
        return new SequenceTypeImpl(elementType);
    }

    public SetType createSetType() {
        return new SetTypeImpl();
    }

    public SetType createSetType(EClassifier elementType) {
        return new SetTypeImpl(elementType);
    }

    public TupleType createTupleType() {
        TupleTypeImpl tupleType = new TupleTypeImpl();
        return tupleType;
    }

    public VoidType createVoidType() {
        VoidTypeImpl voidType = new VoidTypeImpl();
        return voidType;
    }

    public MessageType createMessageType() {
        MessageTypeImpl messageType = new MessageTypeImpl();
        return messageType;
    }

    public MessageType createMessageType(ENamedElement behavioralFeature) {
        return MessageTypeImpl.createMessageType(behavioralFeature);
    }

    public ElementType createElementType() {
        ElementTypeImpl elementType = new ElementTypeImpl();
        return elementType;
    }

    public InvalidType createInvalidType() {
        InvalidTypeImpl invalidType = new InvalidTypeImpl();
        return invalidType;
    }

    public TypeType createTypeType() {
        TypeTypeImpl typeType = new TypeTypeImpl();
        return typeType;
    }

    public TypeType createTypeType(EClassifier type) {
        return TypeTypeImpl.createType(type);
    }

    public PrimitiveBoolean createPrimitiveBoolean() {
        PrimitiveBooleanImpl primitiveBoolean = new PrimitiveBooleanImpl();
        return primitiveBoolean;
    }

    public PrimitiveInteger createPrimitiveInteger() {
        PrimitiveIntegerImpl primitiveInteger = new PrimitiveIntegerImpl();
        return primitiveInteger;
    }

    public PrimitiveReal createPrimitiveReal() {
        PrimitiveRealImpl primitiveReal = new PrimitiveRealImpl();
        return primitiveReal;
    }

    public PrimitiveString createPrimitiveString() {
        PrimitiveStringImpl primitiveString = new PrimitiveStringImpl();
        return primitiveString;
    }

    public AnyType createAnyType() {
        AnyTypeImpl anyType = new AnyTypeImpl();
        return anyType;
    }

    public TypesPackage getTypesPackage() {
        return (TypesPackage)this.getEPackage();
    }

    @Deprecated
    public static TypesPackage getPackage() {
        return TypesPackage.eINSTANCE;
    }
}

