/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: OWLParserException.java,v 1.2 2006/06/22 05:08:16 gxie Exp $
 */

package org.eclipse.eodm.owl.resource.parser.exception;

/**
 * OWLParserException - OWL Parser Exception
 * <p>
 * Nested exception can be another type of exception.
 */
public class OWLParserException extends RuntimeException {

	private static final long serialVersionUID = -5483848924785807040L;

	/**
     * Constructs a new OWLParserException with <code>null</code> as its
     * detail message.
     */
    public OWLParserException() {
        super();
    }

    /**
     * Constructs a new OWLParserException with the specified detail message.
     * 
     * @param message
     *            the detail message
     */
    public OWLParserException(String message) {
        super(message);
    }

    /**
     * Constructs a new OWLParserException with the specified cause.
     * 
     * @param cause
     *            the cause
     */
    public OWLParserException(Throwable cause) {
        super(cause);
    }

    /**
     * Constructs a new OWLParserException with the specified detail message and
     * cause.
     * 
     * @param message
     *            the detail message
     * @param cause
     *            the cause
     */
    public OWLParserException(String message, Throwable cause) {
        super(message, cause);
    }

}