/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: RDFWebFactoryImpl.java,v 1.1 2007/03/18 08:10:12 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfweb.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.eodm.rdf.rdfweb.*;
import org.eclipse.eodm.rdf.rdfweb.util.RDFWebFactory;
import org.eclipse.eodm.rdf.rdfweb.util.RDFWebPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class RDFWebFactoryImpl extends EFactoryImpl implements RDFWebFactory {
	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFWebFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case RDFWebPackage.DOCUMENT: return createDocument();
			case RDFWebPackage.LOCAL_NAME: return createLocalName();
			case RDFWebPackage.NAMESPACE: return createNamespace();
			case RDFWebPackage.NAMESPACE_DEFINITION: return createNamespaceDefinition();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Document createDocument() {
		DocumentImpl document = new DocumentImpl();
		return document;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LocalName createLocalName() {
		LocalNameImpl localName = new LocalNameImpl();
		return localName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Namespace createNamespace() {
		NamespaceImpl namespace = new NamespaceImpl();
		return namespace;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NamespaceDefinition createNamespaceDefinition() {
		NamespaceDefinitionImpl namespaceDefinition = new NamespaceDefinitionImpl();
		return namespaceDefinition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFWebPackage getrdfwebPackage() {
		return (RDFWebPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	public static RDFWebPackage getPackage() {
		return RDFWebPackage.eINSTANCE;
	}

} //RDFWebFactoryImpl
