/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.internal.evaluation;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.EvaluationVisitor;
import org.eclipse.ocl.Query;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.internal.OCLPlugin;
import org.eclipse.ocl.internal.helper.HelperUtil;
import org.eclipse.ocl.internal.l10n.OCLMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryImpl<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>
implements Query<C, CLS, E> {
    private Map<CLS, ? extends Set<? extends E>> extentMap = null;
    private final OCLExpression<C> expression;
    private final Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> environment;
    private EvaluationEnvironment<C, O, P, CLS, E> evalEnv;

    public QueryImpl(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> environment, OCLExpression<C> expr, Map<CLS, ? extends Set<? extends E>> extentMap) {
        this.environment = environment;
        this.expression = expr;
        this.extentMap = extentMap;
    }

    @Override
    public Map<CLS, ? extends Set<? extends E>> getExtentMap() {
        if (this.extentMap == null) {
            EvaluationEnvironment<C, O, P, CLS, E> myEnv = this.getEvaluationEnvironment();
            Object context = myEnv.getValueOf("self");
            this.extentMap = myEnv.createExtentMap(context);
        }
        return this.extentMap;
    }

    @Override
    public OCLExpression<C> getExpression() {
        return this.expression;
    }

    @Override
    public Object evaluate(Object obj) {
        Object result;
        if (obj == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.NullArgExpectEObj_ERROR_);
            OCLPlugin.throwing(this.getClass(), "evaluate", error);
            throw error;
        }
        obj = HelperUtil.getConstraintContext(this.environment, obj, this.expression);
        EvaluationEnvironment<C, O, P, CLS, E> myEnv = this.getEvaluationEnvironment();
        myEnv.add("self", obj);
        EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> ev = this.environment.getFactory().createEvaluationVisitor(this.environment, myEnv, this.getExtentMap());
        try {
            result = ev.visitExpression(this.expression);
        }
        finally {
            myEnv.remove("self");
        }
        return result;
    }

    @Override
    public Object evaluate() {
        EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> ev = this.environment.getFactory().createEvaluationVisitor(this.environment, this.getEvaluationEnvironment(), this.getExtentMap());
        return ev.visitExpression(this.expression);
    }

    @Override
    public boolean check(Object obj) {
        if (this.resultType() != this.environment.getOCLStandardLibrary().getBoolean()) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.BooleanQuery_ERROR_);
            OCLPlugin.throwing(this.getClass(), "check", error);
            throw error;
        }
        Object result = obj == null ? this.evaluate() : this.evaluate(obj);
        return Boolean.TRUE.equals(result);
    }

    @Override
    public List<?> evaluate(List<?> objList) {
        if (objList == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.NullArgExpectlist_ERROR_);
            OCLPlugin.throwing(this.getClass(), "evaluate", error);
            throw error;
        }
        BasicEList result = new BasicEList();
        Iterator<?> iter = objList.iterator();
        while (iter.hasNext()) {
            result.add(this.evaluate(iter.next()));
        }
        return result;
    }

    @Override
    public boolean check(List<?> objList) {
        if (objList == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.NullArgExpectlist_ERROR_);
            OCLPlugin.throwing(this.getClass(), "check", error);
            throw error;
        }
        if (this.resultType() != this.environment.getOCLStandardLibrary().getBoolean()) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.BooleanQuery_ERROR_);
            OCLPlugin.throwing(this.getClass(), "check", error);
            throw error;
        }
        Iterator<?> iter = objList.iterator();
        while (iter.hasNext()) {
            if (this.check(iter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T> List<T> select(List<T> objList) {
        if (objList == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.NullArgExpectlist_ERROR_);
            OCLPlugin.throwing(this.getClass(), "select", error);
            throw error;
        }
        BasicEList result = new BasicEList();
        for (T obj : objList) {
            if (!this.check(obj)) continue;
            result.add(obj);
        }
        return result;
    }

    @Override
    public <T> List<T> reject(List<T> objList) {
        if (objList == null) {
            IllegalArgumentException error = new IllegalArgumentException(OCLMessages.NullArgExpectlist_ERROR_);
            OCLPlugin.throwing(this.getClass(), "reject", error);
            throw error;
        }
        BasicEList result = new BasicEList();
        for (T obj : objList) {
            if (this.check(obj)) continue;
            result.add(obj);
        }
        return result;
    }

    @Override
    public C resultType() {
        return this.expression.getType();
    }

    @Override
    public String queryText() {
        return this.expression.toString();
    }

    @Override
    public EvaluationEnvironment<C, O, P, CLS, E> getEvaluationEnvironment() {
        if (this.evalEnv == null) {
            this.evalEnv = this.environment.getFactory().createEvaluationEnvironment();
        }
        return this.evalEnv;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Query[");
        result.append(this.queryText());
        result.append(']');
        return result.toString();
    }
}

