/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.deploy.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.common.genapi.IVisualIDRegistry;
import org.eclipse.uml2.diagram.deploy.expressions.UMLAbstractExpression;
import org.eclipse.uml2.diagram.deploy.expressions.UMLOCLFactory;
import org.eclipse.uml2.diagram.deploy.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.diagram.deploy.part.UMLNodeDescriptor;
import org.eclipse.uml2.uml.Artifact;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Node;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.uml2.diagram.deploy/debug/visualID";
    private static UMLAbstractExpression Node_2004_Constraint;
    private static UMLAbstractExpression Artifact_2006_Constraint;
    private static UMLAbstractExpression Artifact_3002_Constraint;
    private static UMLAbstractExpression Artifact_3008_Constraint;
    private static UMLAbstractExpression Node_3007_Constraint;
    private static UMLAbstractExpression Dependency_4005_Constraint;
    public static final IVisualIDRegistry TYPED_ADAPTER;

    static {
        TYPED_ADAPTER = new IVisualIDRegistry(){

            public String getModelID(View view) {
                return UMLVisualIDRegistry.getModelID(view);
            }

            public int getVisualID(View view) {
                return UMLVisualIDRegistry.getVisualID(view);
            }

            public int getNodeVisualID(View containerView, EObject domainElement) {
                return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
            }

            public boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
                return UMLVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
            }

            public boolean isCompartmentVisualID(int visualID) {
                return UMLVisualIDRegistry.isCompartmentVisualID(visualID);
            }

            public boolean isSemanticLeafVisualID(int visualID) {
                return UMLVisualIDRegistry.isSemanticLeafVisualID(visualID);
            }

            public boolean isShortcutDescendant(View view) {
                return UMLVisualIDRegistry.isShortcutDescendant(view);
            }
        };
    }

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("UMLDeployment".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                UMLDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return String.valueOf(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDiagram((Package)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"UMLDeployment".equals(containerModelID) && !"uml".equals(containerModelID)) {
            return -1;
        }
        if ("UMLDeployment".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 7001: {
                if (!UMLPackage.eINSTANCE.getElementImport().isSuperTypeOf(domainElement.eClass())) break;
                return 3001;
            }
            case 7004: {
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isArtifact_3002((Artifact)domainElement)) {
                    return 3002;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (!UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isNode_3007((Node)domainElement)) break;
                return 3007;
            }
            case 7005: {
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isArtifact_3002((Artifact)domainElement)) {
                    return 3002;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (!UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isNode_3007((Node)domainElement)) break;
                return 3007;
            }
            case 7007: {
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isArtifact_3008((Artifact)domainElement)) {
                    return 3008;
                }
                if (!UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) break;
                return 3009;
            }
            case 7008: {
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isArtifact_3008((Artifact)domainElement)) {
                    return 3008;
                }
                if (!UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) break;
                return 3009;
            }
            case 7010: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3003;
            }
            case 7006: {
                if (!UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) break;
                return 3006;
            }
            case 7002: {
                if (!UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) break;
                return 3006;
            }
            case 7009: {
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isArtifact_3008((Artifact)domainElement)) {
                    return 3008;
                }
                if (!UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) break;
                return 3009;
            }
            case 7003: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3003;
            }
            case 1000: {
                if (containerView instanceof Diagram && domainElement != null && domainElement.equals(containerView.getElement())) {
                    return 2001;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 2003;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isNode_2004((Node)domainElement)) {
                    return 2004;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 2005;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isArtifact_2006((Artifact)domainElement)) {
                    return 2006;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 2007;
                }
                if (!UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) break;
                return 2008;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"UMLDeployment".equals(containerModelID) && !"uml".equals(containerModelID)) {
            return false;
        }
        if ("UMLDeployment".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 2001: {
                if (5001 == nodeVisualID) {
                    return true;
                }
                if (5025 == nodeVisualID) {
                    return true;
                }
                if (7001 != nodeVisualID) break;
                return true;
            }
            case 2003: {
                if (5002 == nodeVisualID) {
                    return true;
                }
                if (5019 == nodeVisualID) {
                    return true;
                }
                if (7004 != nodeVisualID) break;
                return true;
            }
            case 2004: {
                if (5003 == nodeVisualID) {
                    return true;
                }
                if (5020 != nodeVisualID) break;
                return true;
            }
            case 2005: {
                if (5004 == nodeVisualID) {
                    return true;
                }
                if (5021 == nodeVisualID) {
                    return true;
                }
                if (7002 != nodeVisualID) break;
                return true;
            }
            case 2006: {
                if (5005 == nodeVisualID) {
                    return true;
                }
                if (5022 == nodeVisualID) {
                    return true;
                }
                if (7009 != nodeVisualID) break;
                return true;
            }
            case 2007: {
                if (5006 == nodeVisualID) {
                    return true;
                }
                if (5023 == nodeVisualID) {
                    return true;
                }
                if (7003 != nodeVisualID) break;
                return true;
            }
            case 2008: {
                if (5024 != nodeVisualID) break;
                return true;
            }
            case 3004: {
                if (5010 == nodeVisualID) {
                    return true;
                }
                if (5018 == nodeVisualID) {
                    return true;
                }
                if (7005 != nodeVisualID) break;
                return true;
            }
            case 3002: {
                if (5007 == nodeVisualID) {
                    return true;
                }
                if (5015 == nodeVisualID) {
                    return true;
                }
                if (7007 != nodeVisualID) break;
                return true;
            }
            case 3008: {
                if (5011 == nodeVisualID) {
                    return true;
                }
                if (5014 == nodeVisualID) {
                    return true;
                }
                if (7008 != nodeVisualID) break;
                return true;
            }
            case 3009: {
                if (5012 == nodeVisualID) {
                    return true;
                }
                if (5013 == nodeVisualID) {
                    return true;
                }
                if (7010 != nodeVisualID) break;
                return true;
            }
            case 3005: {
                if (5008 == nodeVisualID) {
                    return true;
                }
                if (5016 == nodeVisualID) {
                    return true;
                }
                if (7006 != nodeVisualID) break;
                return true;
            }
            case 3007: {
                if (5009 == nodeVisualID) {
                    return true;
                }
                if (5017 != nodeVisualID) break;
                return true;
            }
            case 7001: {
                if (3001 != nodeVisualID) break;
                return true;
            }
            case 7004: {
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3002 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3007 != nodeVisualID) break;
                return true;
            }
            case 7005: {
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3002 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3007 != nodeVisualID) break;
                return true;
            }
            case 7007: {
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3009 != nodeVisualID) break;
                return true;
            }
            case 7008: {
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3009 != nodeVisualID) break;
                return true;
            }
            case 7010: {
                if (3003 != nodeVisualID) break;
                return true;
            }
            case 7006: {
                if (3006 != nodeVisualID) break;
                return true;
            }
            case 7002: {
                if (3006 != nodeVisualID) break;
                return true;
            }
            case 7009: {
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3009 != nodeVisualID) break;
                return true;
            }
            case 7003: {
                if (3003 != nodeVisualID) break;
                return true;
            }
            case 1000: {
                if (2001 == nodeVisualID) {
                    return true;
                }
                if (2003 == nodeVisualID) {
                    return true;
                }
                if (2004 == nodeVisualID) {
                    return true;
                }
                if (2005 == nodeVisualID) {
                    return true;
                }
                if (2006 == nodeVisualID) {
                    return true;
                }
                if (2007 == nodeVisualID) {
                    return true;
                }
                if (2008 != nodeVisualID) break;
                return true;
            }
            case 4001: {
                if (6001 != nodeVisualID) break;
                return true;
            }
            case 4002: {
                if (6002 != nodeVisualID) break;
                return true;
            }
            case 4004: {
                if (6003 != nodeVisualID) break;
                return true;
            }
            case 4005: {
                if (6004 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getDeployment().isSuperTypeOf(domainElement.eClass())) {
            return 4001;
        }
        if (UMLPackage.eINSTANCE.getManifestation().isSuperTypeOf(domainElement.eClass())) {
            return 4002;
        }
        if (UMLPackage.eINSTANCE.getCommunicationPath().isSuperTypeOf(domainElement.eClass())) {
            return 4004;
        }
        if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDependency_4005((Dependency)domainElement)) {
            return 4005;
        }
        return -1;
    }

    private static boolean isDiagram(Package element) {
        return true;
    }

    private static boolean isNode_2004(Node domainElement) {
        Object result;
        if (Node_2004_Constraint == null) {
            Node_2004_Constraint = UMLOCLFactory.getExpression("not oclIsKindOf(uml::Device) and not oclIsKindOf(uml::ExecutionEnvironment)", (EClassifier)UMLPackage.eINSTANCE.getNode());
        }
        return (result = Node_2004_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isArtifact_2006(Artifact domainElement) {
        Object result;
        if (Artifact_2006_Constraint == null) {
            Artifact_2006_Constraint = UMLOCLFactory.getExpression("not oclIsKindOf(uml::DeploymentSpecification)", (EClassifier)UMLPackage.eINSTANCE.getArtifact());
        }
        return (result = Artifact_2006_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isArtifact_3002(Artifact domainElement) {
        Object result;
        if (Artifact_3002_Constraint == null) {
            Artifact_3002_Constraint = UMLOCLFactory.getExpression("not oclIsKindOf(uml::DeploymentSpecification)", (EClassifier)UMLPackage.eINSTANCE.getArtifact());
        }
        return (result = Artifact_3002_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isArtifact_3008(Artifact domainElement) {
        Object result;
        if (Artifact_3008_Constraint == null) {
            Artifact_3008_Constraint = UMLOCLFactory.getExpression("not oclIsKindOf(uml::DeploymentSpecification)", (EClassifier)UMLPackage.eINSTANCE.getArtifact());
        }
        return (result = Artifact_3008_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isNode_3007(Node domainElement) {
        Object result;
        if (Node_3007_Constraint == null) {
            Node_3007_Constraint = UMLOCLFactory.getExpression("not oclIsKindOf(uml::Device) and not oclIsKindOf(uml::ExecutionEnvironment)", (EClassifier)UMLPackage.eINSTANCE.getNode());
        }
        return (result = Node_3007_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isDependency_4005(Dependency domainElement) {
        Object result;
        if (Dependency_4005_Constraint == null) {
            Dependency_4005_Constraint = UMLOCLFactory.getExpression("(self.oclIsTypeOf(uml::Dependency) or self.oclIsTypeOf(uml::Abstraction) or self.oclIsTypeOf(uml::Substitution) or self.oclIsTypeOf(uml::Usage)) and self.supplier->size() = 1 and self.client->size() = 1 and self.supplier->forAll(e|not e.oclIsKindOf(uml::Interface))", (EClassifier)UMLPackage.eINSTANCE.getDependency());
        }
        return (result = Dependency_4005_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    protected static boolean hasViewChild(View containerView, EObject domainElement, int visualId) {
        if (containerView == null) {
            return false;
        }
        if (domainElement == null) {
            return false;
        }
        for (Object next : containerView.getChildren()) {
            View nextView = (View)next;
            if (!domainElement.equals(nextView.getElement()) || !UMLVisualIDRegistry.getType(visualId).equals(nextView.getType())) continue;
            return true;
        }
        return false;
    }

    public static int getChildDescriptorVisualID(UMLNodeDescriptor container, EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        switch (container.getVisualID()) {
            case 2001: {
                if (!UMLPackage.eINSTANCE.getElementImport().isSuperTypeOf(domainElement.eClass())) break;
                return 3001;
            }
            case 2003: {
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isArtifact_3002((Artifact)domainElement)) {
                    return 3002;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (!UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isNode_3007((Node)domainElement)) break;
                return 3007;
            }
            case 2005: {
                if (!UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) break;
                return 3006;
            }
            case 2006: {
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isArtifact_3008((Artifact)domainElement)) {
                    return 3008;
                }
                if (!UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) break;
                return 3009;
            }
            case 2007: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3003;
            }
            case 3004: {
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isArtifact_3002((Artifact)domainElement)) {
                    return 3002;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (!UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isNode_3007((Node)domainElement)) break;
                return 3007;
            }
            case 3002: {
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isArtifact_3008((Artifact)domainElement)) {
                    return 3008;
                }
                if (!UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) break;
                return 3009;
            }
            case 3008: {
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isArtifact_3008((Artifact)domainElement)) {
                    return 3008;
                }
                if (!UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) break;
                return 3009;
            }
            case 3009: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3003;
            }
            case 3005: {
                if (!UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) break;
                return 3006;
            }
            case 1000: {
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 2003;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isNode_2004((Node)domainElement)) {
                    return 2004;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 2005;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isArtifact_2006((Artifact)domainElement)) {
                    return 2006;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 2007;
                }
                if (!UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) break;
                return 2008;
            }
        }
        return -1;
    }

    protected static boolean canSubstitute(int visualId, int substituteCandidate) {
        return visualId == substituteCandidate;
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
        if (candidate == -1) {
            return false;
        }
        int basic = UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return basic == candidate || UMLVisualIDRegistry.canSubstitute(basic, candidate);
    }

    public static boolean isCompartmentVisualID(int visualID) {
        switch (visualID) {
            case 7001: 
            case 7002: 
            case 7003: 
            case 7004: 
            case 7005: 
            case 7006: 
            case 7007: 
            case 7008: 
            case 7009: 
            case 7010: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSemanticLeafVisualID(int visualID) {
        switch (visualID) {
            case 2004: 
            case 2008: 
            case 3001: 
            case 3003: 
            case 3006: 
            case 3007: {
                return true;
            }
        }
        return false;
    }

    public static boolean isShortcutDescendant(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram && view != null) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return true;
            }
            view = (View)view.eContainer();
        }
        return false;
    }
}

