/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.execution.ui.launching.configuration;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.qvt.declarative.editor.qvtrelation.ui.QVTrNature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclarativeQVTFileFetcher {
    protected Set<IFile> qvtFiles = new HashSet<IFile>();
    public static final String QVT_RELATIONS_FILE_EXTENSION = "qvtr";
    public static final String QVT_CORE_FILE_EXTENSION = "qvtc";

    public DeclarativeQVTFileFetcher(IContainer scope) {
        ArrayList<IJavaProject> javaProjects = new ArrayList<IJavaProject>();
        if (scope instanceof IWorkspaceRoot) {
            IWorkspaceRoot workspaceRoot = (IWorkspaceRoot)scope;
            IProject[] iProjectArray = workspaceRoot.getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                try {
                    if (project.isOpen() && project.hasNature(QVTrNature.class.getName())) {
                        javaProjects.add(JavaCore.create((IProject)project));
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        } else if (scope instanceof IProject) {
            IProject project = (IProject)scope;
            javaProjects.add(JavaCore.create((IProject)project));
        }
        this.collect(javaProjects);
    }

    private void collect(List<IJavaProject> javaProjects) {
        for (IJavaProject javaProject : javaProjects) {
            try {
                IClasspathEntry[] classpathEntries;
                IClasspathEntry[] iClasspathEntryArray = classpathEntries = javaProject.getRawClasspath();
                int n = classpathEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                    if (classpathEntry.getEntryKind() == 3) {
                        this.visit(classpathEntry.getPath());
                    }
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    private void visit(IPath path) {
        IFile file;
        String fileExtension;
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (resource instanceof IFile && ((fileExtension = (file = (IFile)resource).getFileExtension()).equals(QVT_CORE_FILE_EXTENSION) || fileExtension.equals(QVT_RELATIONS_FILE_EXTENSION))) {
            this.qvtFiles.add(file);
        }
        if (resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            try {
                IResource[] resources;
                IResource[] iResourceArray = resources = container.members();
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    this.visit(member.getFullPath());
                    ++n2;
                }
            }
            catch (CoreException e) {
                System.out.println((Object)e);
            }
        }
    }

    public Set<IFile> getQVTfiles() {
        System.out.println("qvtfiles = " + this.qvtFiles);
        return this.qvtFiles;
    }
}

