/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.execution.ui.launching.configuration;

import java.util.Comparator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.qvt.declarative.execution.ui.Activator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationSelectionDialog
extends FilteredItemsSelectionDialog {
    private Set<IFile> files = null;
    private static final String SETTINGS_ID = "org.eclipse.qvt.declarative.execution.ui";

    public TransformationSelectionDialog(Shell shell, Set<IFile> files) {
        super(shell, false);
        this.setTitle("Select transformation");
        this.files = files;
        this.setMessage(((Object)((Object)this)).getClass().getName());
        this.setInitialPattern("**");
    }

    protected Control createExtendedContentArea(Composite parent) {
        System.out.println("createExtendedContentArea");
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new FileItemsFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        if (this.files != null) {
            for (IFile file : this.files) {
                if (!itemsFilter.isConsistentItem((Object)file)) continue;
                contentProvider.add((Object)file, itemsFilter);
            }
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings dialogSettings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(SETTINGS_ID);
        if (section == null) {
            section = dialogSettings.addNewSection(SETTINGS_ID);
        }
        return section;
    }

    public String getElementName(Object item) {
        if (item instanceof IFile) {
            IFile file = (IFile)item;
            return file.getName();
        }
        return null;
    }

    protected Comparator<?> getItemsComparator() {
        Comparator<Object> comparator = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof IFile && o2 instanceof IFile) {
                    return ((IFile)o1).getName().compareTo(((IFile)o2).getName());
                }
                return -1;
            }
        };
        return comparator;
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    private class FileItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private FileItemsFilter() {
            super((FilteredItemsSelectionDialog)TransformationSelectionDialog.this);
        }

        public boolean isConsistentItem(Object item) {
            if (item instanceof IFile) {
                IFile file = (IFile)item;
                String extension = file.getFileExtension();
                return extension.equals("qvtc") || extension.equals("qvtr");
            }
            return false;
        }

        public boolean matchItem(Object item) {
            if (item instanceof IFile) {
                IFile file = (IFile)item;
                return TransformationSelectionDialog.this.files.contains(file) && this.matches(((IFile)item).getName());
            }
            return false;
        }
    }
}

