/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hover;

import org.eclipse.nebula.widgets.nattable.hover.command.ClearHoverStylingCommandHandler;
import org.eclipse.nebula.widgets.nattable.hover.command.HoverStylingCommandHandler;
import org.eclipse.nebula.widgets.nattable.hover.config.BodyHoverStylingBindings;
import org.eclipse.nebula.widgets.nattable.layer.AbstractIndexLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.CellVisualUpdateEvent;
import org.eclipse.swt.graphics.Point;

public class HoverLayer
extends AbstractIndexLayerTransform {
    private Point currentHoveredCellPosition;

    public HoverLayer(IUniqueIndexLayer underlyingLayer) {
        this(underlyingLayer, true);
    }

    public HoverLayer(IUniqueIndexLayer underlyingLayer, boolean useDefaultConfiguration) {
        super(underlyingLayer);
        if (useDefaultConfiguration) {
            this.addConfiguration(new BodyHoverStylingBindings(this));
        }
        this.registerCommandHandler(new HoverStylingCommandHandler(this));
        this.registerCommandHandler(new ClearHoverStylingCommandHandler(this));
    }

    @Override
    public String getDisplayModeByPosition(int columnPosition, int rowPosition) {
        if (this.isCellPositionHovered(columnPosition, rowPosition)) {
            return "HOVER";
        }
        return super.getDisplayModeByPosition(columnPosition, rowPosition);
    }

    public boolean isCellPositionHovered(Point cellPosition) {
        return this.isCellPositionHovered(cellPosition.x, cellPosition.y);
    }

    public boolean isCellPositionHovered(int columnPosition, int rowPosition) {
        ILayerCell cell;
        if (this.currentHoveredCellPosition != null && (cell = this.getCellByPosition(columnPosition, rowPosition)) != null) {
            return this.currentHoveredCellPosition.x == cell.getOriginColumnPosition() && this.currentHoveredCellPosition.y == cell.getOriginRowPosition();
        }
        return false;
    }

    public Point getCurrentHoveredCellPosition() {
        return this.currentHoveredCellPosition;
    }

    public void setCurrentHoveredCellPosition(int columnPosition, int rowPosition) {
        this.setCurrentHoveredCellPosition(new Point(columnPosition, rowPosition));
    }

    public void setCurrentHoveredCellPosition(Point cellPosition) {
        if (!this.isCellPositionHovered(cellPosition)) {
            Point oldHover = this.currentHoveredCellPosition;
            ILayerCell cell = this.getCellByPosition(cellPosition.x, cellPosition.y);
            if (cell != null) {
                this.currentHoveredCellPosition = new Point(cell.getOriginColumnPosition(), cell.getOriginRowPosition());
            }
            if (oldHover != null) {
                this.fireLayerEvent(new CellVisualUpdateEvent(this, oldHover.x, oldHover.y));
            }
            this.fireLayerEvent(new CellVisualUpdateEvent(this, this.currentHoveredCellPosition.x, this.currentHoveredCellPosition.y));
        }
    }

    public void clearCurrentHoveredCellPosition() {
        if (this.currentHoveredCellPosition != null) {
            Point oldHover = this.currentHoveredCellPosition;
            this.currentHoveredCellPosition = null;
            this.fireLayerEvent(new CellVisualUpdateEvent(this, oldHover.x, oldHover.y));
        }
    }
}

