/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.cell;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.CellPainterWrapper;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class BackgroundImagePainter
extends CellPainterWrapper {
    public final Color separatorColor;
    private Image bgImage;

    public BackgroundImagePainter(Image bgImage) {
        this(null, bgImage, null);
    }

    public BackgroundImagePainter(ICellPainter interiorPainter, Image bgImage) {
        this(interiorPainter, bgImage, null);
    }

    public BackgroundImagePainter(Image bgImage, Color separatorColor) {
        this(null, bgImage, separatorColor);
    }

    public BackgroundImagePainter(ICellPainter interiorPainter, Image bgImage, Color separatorColor) {
        super(interiorPainter);
        this.bgImage = bgImage;
        this.separatorColor = separatorColor;
    }

    @Override
    public int getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return super.getPreferredWidth(cell, gc, configRegistry) + 4;
    }

    @Override
    public int getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return super.getPreferredHeight(cell, gc, configRegistry) + 4;
    }

    @Override
    public void paintCell(ILayerCell cell, GC gc, Rectangle rectangle, IConfigRegistry configRegistry) {
        if (this.bgImage != null) {
            Color originalBackground = gc.getBackground();
            Color originalForeground = gc.getForeground();
            Pattern pattern = new Pattern((Device)Display.getCurrent(), this.bgImage);
            gc.setBackgroundPattern(pattern);
            gc.fillRectangle(rectangle);
            gc.setBackgroundPattern(null);
            pattern.dispose();
            if (ObjectUtils.isNotNull(this.separatorColor)) {
                gc.setForeground(this.separatorColor);
                gc.drawLine(rectangle.x - 1, rectangle.y, rectangle.x - 1, rectangle.y + rectangle.height);
                gc.drawLine(rectangle.x - 1 + rectangle.width, rectangle.y, rectangle.x - 1 + rectangle.width, rectangle.y + rectangle.height);
            }
            gc.setBackground(originalBackground);
            gc.setForeground(originalForeground);
        }
        Rectangle interiorBounds = new Rectangle(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
        super.paintCell(cell, gc, interiorBounds, configRegistry);
    }

    public Image getBackgroundImage() {
        return this.bgImage;
    }

    public void setBackgroundImage(Image bgImage) {
        this.bgImage = bgImage;
    }
}

