/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.beans.IBeanMapProperty;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.property.map.DelegatingMapProperty;
import org.eclipse.core.databinding.property.map.IMapProperty;
import org.eclipse.core.internal.databinding.beans.BeanPropertyHelper;

public class AnonymousPojoMapProperty
extends DelegatingMapProperty {
    private final String propertyName;
    private Map delegates;

    public AnonymousPojoMapProperty(String propertyName, Class keyType, Class valueType) {
        super((Object)keyType, (Object)valueType);
        this.propertyName = propertyName;
        this.delegates = new HashMap();
    }

    protected IMapProperty doGetDelegate(Object source) {
        IBeanMapProperty delegate;
        Class<?> beanClass = source.getClass();
        if (this.delegates.containsKey(beanClass)) {
            return (IMapProperty)this.delegates.get(beanClass);
        }
        try {
            delegate = PojoProperties.map(beanClass, this.propertyName, (Class)this.getKeyType(), (Class)this.getValueType());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            delegate = null;
        }
        this.delegates.put(beanClass, delegate);
        return delegate;
    }

    public String toString() {
        String s = "?." + this.propertyName + "{:}";
        Class keyType = (Class)this.getKeyType();
        Class valueType = (Class)this.getValueType();
        if (keyType != null || valueType != null) {
            s = String.valueOf(s) + "<" + BeanPropertyHelper.shortClassName(keyType) + ", " + BeanPropertyHelper.shortClassName(valueType) + ">";
        }
        return s;
    }
}

