/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.di.internal.extensions.util;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public final class EventUtils {
    public static final String DATA = "org.eclipse.e4.data";

    private EventUtils() {
    }

    public static boolean send(EventAdmin eventAdmin, String topic, Object data) {
        Event event = EventUtils.constructEvent(topic, data);
        eventAdmin.sendEvent(event);
        return true;
    }

    public static boolean post(EventAdmin eventAdmin, String topic, Object data) {
        Event event = EventUtils.constructEvent(topic, data);
        eventAdmin.postEvent(event);
        return true;
    }

    public static Event constructEvent(String topic, Object data) {
        Event event;
        if (data instanceof Dictionary) {
            event = new Event(topic, (Dictionary)data);
        } else if (data instanceof Map) {
            event = new Event(topic, (Map)data);
        } else {
            Hashtable<String, Object> d = new Hashtable<String, Object>(2);
            ((Dictionary)d).put("event.topics", topic);
            if (data != null) {
                ((Dictionary)d).put(DATA, data);
            }
            event = new Event(topic, d);
        }
        return event;
    }
}

