/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hideshow.indicator;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.hideshow.indicator.HideIndicatorConfigAttributes;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter2;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class HideIndicatorOverlayPainter
implements IOverlayPainter2 {
    protected ILayer columnHeaderLayer;
    protected ILayer rowHeaderLayer;
    private Color indicatorColor = GUIHelper.COLOR_DARK_GRAY;
    private int lineWidth = 3;
    protected IConfigRegistry configRegistry;

    public HideIndicatorOverlayPainter(ILayer columnHeaderLayer, ILayer rowHeaderLayer) {
        this.columnHeaderLayer = columnHeaderLayer;
        this.rowHeaderLayer = rowHeaderLayer;
    }

    @Override
    public void paintOverlay(GC gc, ILayer layer) {
        this.paintOverlay(layer, gc, 0, 0, new Rectangle(0, 0, layer.getWidth(), layer.getHeight()));
    }

    @Override
    public void paintOverlay(ILayer layer, GC gc, int xOffset, int yOffset, Rectangle rectangle) {
        Color originalForeground = gc.getForeground();
        int originalLineWidth = gc.getLineWidth();
        gc.setForeground(this.getIndicatorColor());
        gc.setLineWidth(GUIHelper.convertHorizontalPixelToDpi(this.getIndicatorLineWidth()));
        this.paintHiddenColumnIndicator(layer, gc, xOffset, yOffset, rectangle);
        this.paintHiddenRowIndicator(layer, gc, xOffset, yOffset, rectangle);
        gc.setForeground(originalForeground);
        gc.setLineWidth(originalLineWidth);
    }

    protected void paintHiddenColumnIndicator(ILayer layer, GC gc, int xOffset, int yOffset, Rectangle rectangle) {
        if (this.columnHeaderLayer != null) {
            int lineAdjustment = gc.getLineWidth() % 2;
            int height = this.columnHeaderLayer.getHeight();
            int col = 0;
            while (col < layer.getColumnCount()) {
                ILayerCell cell;
                int i;
                int start;
                int x;
                LabelStack configLabels = layer.getConfigLabelsByPosition(col, this.columnHeaderLayer.getRowCount());
                if (configLabels.hasLabel("COLUMN_LEFT_HIDDEN")) {
                    x = layer.getStartXOfColumnPosition(col);
                    if (this.rowHeaderLayer == null || x >= this.rowHeaderLayer.getWidth()) {
                        start = rectangle.y;
                        i = 0;
                        while (i < this.columnHeaderLayer.getRowCount()) {
                            cell = layer.getCellByPosition(col, i);
                            int cellStart = layer.getStartXOfColumnPosition(cell.getOriginColumnPosition());
                            if (cellStart < x && (this.rowHeaderLayer != null && x > this.rowHeaderLayer.getWidth() || this.rowHeaderLayer == null && x > 0)) {
                                start += layer.getRowHeightByPosition(i);
                            }
                            ++i;
                        }
                        gc.drawLine(x - lineAdjustment, start, x - lineAdjustment, height);
                    }
                }
                if (configLabels.hasLabel("COLUMN_RIGHT_HIDDEN")) {
                    x = layer.getStartXOfColumnPosition(col) + layer.getColumnWidthByPosition(col);
                    if (col == layer.getColumnCount() - 1) {
                        lineAdjustment = gc.getLineWidth() / 2 + lineAdjustment;
                    }
                    if (this.rowHeaderLayer == null || x >= this.rowHeaderLayer.getWidth()) {
                        start = rectangle.y;
                        i = 0;
                        while (i < this.columnHeaderLayer.getRowCount()) {
                            cell = layer.getCellByPosition(col + 1, i);
                            if (cell != null && cell.getOriginColumnPosition() < cell.getColumnPosition() && x < cell.getBounds().x + cell.getBounds().width) {
                                start += layer.getRowHeightByPosition(i);
                            }
                            ++i;
                        }
                        gc.drawLine(x - lineAdjustment, start, x - lineAdjustment, height - 1);
                    }
                }
                ++col;
            }
        }
    }

    protected void paintHiddenRowIndicator(ILayer layer, GC gc, int xOffset, int yOffset, Rectangle rectangle) {
        if (this.rowHeaderLayer != null) {
            int lineAdjustment = gc.getLineWidth() % 2;
            int width = this.rowHeaderLayer.getWidth();
            int row = 0;
            while (row < layer.getRowCount()) {
                ILayerCell cell;
                int i;
                int start;
                int y;
                LabelStack configLabels = layer.getConfigLabelsByPosition(this.rowHeaderLayer.getColumnCount(), row);
                if (configLabels.hasLabel("ROW_TOP_HIDDEN")) {
                    y = layer.getStartYOfRowPosition(row);
                    if (this.columnHeaderLayer == null || y >= this.columnHeaderLayer.getHeight()) {
                        start = rectangle.x;
                        i = 0;
                        while (i < this.rowHeaderLayer.getColumnCount()) {
                            cell = layer.getCellByPosition(i, row);
                            int cellStart = layer.getStartYOfRowPosition(cell.getOriginRowPosition());
                            if (cellStart < y && (this.columnHeaderLayer != null && y > this.columnHeaderLayer.getHeight() || this.columnHeaderLayer == null && y > 0)) {
                                start += layer.getColumnWidthByPosition(i);
                            }
                            ++i;
                        }
                        gc.drawLine(start, y - lineAdjustment, width, y - lineAdjustment);
                    }
                }
                if (configLabels.hasLabel("ROW_BOTTOM_HIDDEN")) {
                    y = layer.getStartYOfRowPosition(row) + layer.getRowHeightByPosition(row);
                    if (row == layer.getRowCount() - 1) {
                        lineAdjustment = gc.getLineWidth() / 2 + lineAdjustment;
                    }
                    if (this.columnHeaderLayer == null || y >= this.columnHeaderLayer.getHeight()) {
                        start = rectangle.x;
                        i = 0;
                        while (i < this.rowHeaderLayer.getColumnCount()) {
                            cell = layer.getCellByPosition(i, row + 1);
                            if (cell != null && cell.getOriginRowPosition() < cell.getRowPosition()) {
                                start += layer.getColumnWidthByPosition(i);
                            }
                            ++i;
                        }
                        gc.drawLine(start, y - lineAdjustment, width, y - lineAdjustment);
                    }
                }
                ++row;
            }
        }
    }

    public Color getIndicatorColor() {
        Color color;
        if (this.configRegistry != null && (color = this.configRegistry.getConfigAttribute(HideIndicatorConfigAttributes.HIDE_INDICATOR_COLOR, "NORMAL", new String[0])) != null) {
            return color;
        }
        return this.indicatorColor;
    }

    public void setIndicatorColor(Color indicatorColor) {
        if (indicatorColor != null) {
            this.indicatorColor = indicatorColor;
        }
    }

    public int getIndicatorLineWidth() {
        Integer width;
        if (this.configRegistry != null && (width = this.configRegistry.getConfigAttribute(HideIndicatorConfigAttributes.HIDE_INDICATOR_LINE_WIDTH, "NORMAL", new String[0])) != null) {
            return width;
        }
        return this.lineWidth;
    }

    public void setIndicatorLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setConfigRegistry(IConfigRegistry configRegistry) {
        this.configRegistry = configRegistry;
    }
}

