/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.internal.expressions.OrExpression;
import org.eclipse.e4.core.commands.ExpressionContext;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.ui.MCoreExpression;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MExpression;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.impl.UiFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRenderer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.MenuManager;

public class ContributionRecord {
    public static final String FACTORY = "ContributionFactory";
    static final String STATIC_CONTEXT = "ContributionFactoryContext";
    MMenu menuModel;
    private MMenuContribution menuContribution;
    private ArrayList<MMenuElement> generatedElements = new ArrayList();
    private HashSet<MMenuElement> sharedElements = new HashSet();
    private MenuManagerRenderer renderer;
    boolean isVisible = true;
    private IEclipseContext infoContext;
    private Runnable factoryDispose;

    public ContributionRecord(MMenu menuModel, MMenuContribution contribution, MenuManagerRenderer renderer) {
        this.menuModel = menuModel;
        this.menuContribution = contribution;
        this.renderer = renderer;
    }

    public MenuManager getManagerForModel() {
        return this.renderer.getManager(this.menuModel);
    }

    public MMenuContribution getMenuContribution() {
        return this.menuContribution;
    }

    public Collection<MMenuElement> getSharedElements() {
        return this.sharedElements;
    }

    public Collection<MMenuElement> getGeneratedElements() {
        return this.generatedElements;
    }

    public void updateVisibility(IEclipseContext context) {
        MenuManager manager;
        boolean currentVisibility;
        ExpressionContext exprContext = new ExpressionContext(context);
        this.updateIsVisible(exprContext);
        HashSet<ContributionRecord> recentlyUpdated = new HashSet<ContributionRecord>();
        recentlyUpdated.add(this);
        boolean changed = false;
        for (MMenuElement item : this.generatedElements) {
            currentVisibility = this.computeVisibility(recentlyUpdated, item, exprContext);
            if (item.isVisible() == currentVisibility) continue;
            changed = true;
            item.setVisible(currentVisibility);
        }
        for (MMenuElement item : this.sharedElements) {
            currentVisibility = this.computeVisibility(recentlyUpdated, item, exprContext);
            if (item.isVisible() == currentVisibility) continue;
            changed = true;
            item.setVisible(currentVisibility);
        }
        if (changed && (manager = this.getManagerForModel()) != null) {
            manager.markDirty();
        }
    }

    public void collectInfo(ExpressionInfo info) {
        ContributionsAnalyzer.collectInfo((ExpressionInfo)info, (MExpression)this.menuContribution.getVisibleWhen());
        for (MMenuElement item : this.generatedElements) {
            ContributionsAnalyzer.collectInfo((ExpressionInfo)info, (MExpression)item.getVisibleWhen());
        }
        for (MMenuElement item : this.sharedElements) {
            ContributionsAnalyzer.collectInfo((ExpressionInfo)info, (MExpression)item.getVisibleWhen());
        }
    }

    public void updateIsVisible(ExpressionContext exprContext) {
        this.isVisible = ContributionsAnalyzer.isVisible((MMenuContribution)this.menuContribution, (ExpressionContext)exprContext);
    }

    public boolean computeVisibility(HashSet<ContributionRecord> recentlyUpdated, MMenuElement item, ExpressionContext exprContext) {
        String identifier;
        Object rc;
        ArrayList<ContributionRecord> list;
        boolean currentVisibility = this.isVisible;
        if ((item instanceof MMenu || item instanceof MMenuSeparator) && (list = this.renderer.getList(item)) != null) {
            Iterator<ContributionRecord> cr = list.iterator();
            while (!currentVisibility && cr.hasNext()) {
                ContributionRecord rec = cr.next();
                if (!recentlyUpdated.contains(rec)) {
                    rec.updateIsVisible(exprContext);
                    recentlyUpdated.add(rec);
                }
                currentVisibility |= rec.isVisible;
            }
        }
        if (currentVisibility && item.getPersistedState().get("IIdentifier") != null && (rc = exprContext.eclipseContext.get(identifier = (String)item.getPersistedState().get("IIdentifier"))) instanceof Boolean) {
            currentVisibility = (Boolean)rc;
        }
        if (currentVisibility && item.getVisibleWhen() != null) {
            boolean val;
            currentVisibility = val = ContributionsAnalyzer.isVisible((MExpression)item.getVisibleWhen(), (ExpressionContext)exprContext);
        }
        return currentVisibility;
    }

    private Expression getExpression(MExpression expression) {
        if (expression instanceof MCoreExpression) {
            Object coreExpression = ((MCoreExpression)expression).getCoreExpression();
            return coreExpression instanceof Expression ? (Expression)coreExpression : null;
        }
        return null;
    }

    private MExpression merge(MExpression expressionA, MExpression expressionB) {
        Expression coreExpressionA = this.getExpression(expressionA);
        Expression coreExpressionB = this.getExpression(expressionB);
        if (coreExpressionA == null || coreExpressionB == null) {
            return null;
        }
        if (coreExpressionA.equals(coreExpressionB)) {
            return expressionA;
        }
        OrExpression expression = new OrExpression();
        expression.add(coreExpressionA);
        expression.add(coreExpressionB);
        MCoreExpression exp = UiFactoryImpl.eINSTANCE.createCoreExpression();
        exp.setCoreExpressionId("programmatic.value");
        exp.setCoreExpression((Object)expression);
        return exp;
    }

    public boolean mergeIntoModel() {
        List<MMenuElement> copyElements;
        int idx = ContributionRecord.getIndex(this.menuModel, this.menuContribution.getPositionInParent());
        if (idx == -1) {
            return false;
        }
        if (this.menuContribution.getTransientData().get(FACTORY) != null) {
            copyElements = this.mergeFactoryIntoModel();
        } else {
            copyElements = new ArrayList<MMenuElement>();
            for (MMenuElement item : this.menuContribution.getChildren()) {
                MMenuElement copy = (MMenuElement)EcoreUtil.copy((EObject)((EObject)item));
                copyElements.add(copy);
            }
        }
        for (MMenuElement copy : copyElements) {
            MMenu shared;
            if (copy instanceof MMenu) {
                shared = this.findExistingMenu(copy.getElementId());
                if (shared == null) {
                    shared = (MMenu)copy;
                    this.renderer.linkElementToContributionRecord(copy, this);
                    this.menuModel.getChildren().add(idx++, copy);
                } else {
                    shared.setVisibleWhen(this.merge(copy.getVisibleWhen(), shared.getVisibleWhen()));
                    copy = shared;
                }
                this.sharedElements.add((MMenuElement)shared);
            } else if (copy instanceof MMenuSeparator) {
                shared = this.findExistingSeparator(copy.getElementId());
                if (shared == null) {
                    shared = (MMenuSeparator)copy;
                    this.renderer.linkElementToContributionRecord(copy, this);
                    this.menuModel.getChildren().add(idx++, copy);
                } else {
                    copy = shared;
                }
                this.sharedElements.add((MMenuElement)shared);
            } else {
                this.generatedElements.add(copy);
                this.renderer.linkElementToContributionRecord(copy, this);
                this.menuModel.getChildren().add(idx++, copy);
            }
            if (!(copy instanceof MMenu) && !(copy instanceof MMenuSeparator)) continue;
            this.renderer.addRecord(copy, this);
        }
        return true;
    }

    private List<MMenuElement> mergeFactoryIntoModel() {
        Object obj = this.menuContribution.getTransientData().get(FACTORY);
        if (!(obj instanceof IContextFunction)) {
            return Collections.EMPTY_LIST;
        }
        IEclipseContext staticContext = this.getStaticContext();
        staticContext.remove(List.class);
        this.factoryDispose = (Runnable)((IContextFunction)obj).compute(staticContext, null);
        return (List)staticContext.get(List.class);
    }

    private IEclipseContext getStaticContext() {
        if (this.infoContext == null) {
            IEclipseContext parentContext = this.renderer.getContext((MUIElement)this.menuModel);
            this.infoContext = parentContext != null ? parentContext.createChild(STATIC_CONTEXT) : EclipseContextFactory.create((String)STATIC_CONTEXT);
            ContributionsAnalyzer.populateModelInterfaces((Object)this.menuModel, (IEclipseContext)this.infoContext, (Class[])this.menuModel.getClass().getInterfaces());
            this.infoContext.set(MenuManagerRenderer.class, (Object)this.renderer);
        }
        return this.infoContext;
    }

    MMenu findExistingMenu(String id) {
        if (id == null) {
            return null;
        }
        for (MMenuElement item : this.menuModel.getChildren()) {
            if (!(item instanceof MMenu) || !id.equals(item.getElementId())) continue;
            return (MMenu)item;
        }
        return null;
    }

    MMenuSeparator findExistingSeparator(String id) {
        if (id == null) {
            return null;
        }
        for (MMenuElement item : this.menuModel.getChildren()) {
            if (!(item instanceof MMenuSeparator) || !id.equals(item.getElementId())) continue;
            return (MMenuSeparator)item;
        }
        return null;
    }

    public void dispose() {
        for (MMenuElement copy : this.generatedElements) {
            this.menuModel.getChildren().remove(copy);
        }
        for (MMenuElement shared : this.sharedElements) {
            this.renderer.removeRecord(shared, this);
            ArrayList<ContributionRecord> array = this.renderer.getList(shared);
            if (!array.isEmpty()) continue;
            this.menuModel.getChildren().remove(shared);
        }
        if (this.factoryDispose != null) {
            this.factoryDispose.run();
            this.factoryDispose = null;
        }
    }

    private static int getIndex(MElementContainer<?> menuModel, String positionInParent) {
        String id = null;
        String modifier = null;
        if (positionInParent != null && positionInParent.length() > 0) {
            String[] array = positionInParent.split("=");
            modifier = array[0];
            if (array.length > 1) {
                id = array[1];
            }
        }
        if (id == null) {
            return menuModel.getChildren().size();
        }
        int idx = 0;
        int size = menuModel.getChildren().size();
        while (idx < size) {
            if (id.equals(((MUIElement)menuModel.getChildren().get(idx)).getElementId())) {
                if ("after".equals(modifier)) {
                    ++idx;
                } else if ("endof".equals(modifier)) {
                    ++idx;
                    while (!(idx >= size || menuModel.getChildren().get(idx) instanceof MMenuSeparator && ((MUIElement)menuModel.getChildren().get(idx)).getElementId() != null)) {
                        ++idx;
                    }
                }
                return idx;
            }
            ++idx;
        }
        return id.equals("additions") ? menuModel.getChildren().size() : -1;
    }
}

