/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.nebula.widgets.nattable.command.DisposeResourcesCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.command.StructuralRefreshCommand;
import org.eclipse.nebula.widgets.nattable.command.VisualRefreshCommand;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.NatTableConfigAttributes;
import org.eclipse.nebula.widgets.nattable.conflation.EventConflaterChain;
import org.eclipse.nebula.widgets.nattable.conflation.IEventConflater;
import org.eclipse.nebula.widgets.nattable.conflation.VisualChangeEventConflater;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.copy.InternalCellClipboard;
import org.eclipse.nebula.widgets.nattable.edit.CellEditorCreatedEvent;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.grid.command.ClientAreaResizeCommand;
import org.eclipse.nebula.widgets.nattable.grid.command.InitializeGridCommand;
import org.eclipse.nebula.widgets.nattable.layer.DefaultHorizontalDpiConverter;
import org.eclipse.nebula.widgets.nattable.layer.DefaultVerticalDpiConverter;
import org.eclipse.nebula.widgets.nattable.layer.IDpiConverter;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.command.ConfigureScalingCommand;
import org.eclipse.nebula.widgets.nattable.layer.event.CellVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.CellVisualUpdateEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnVisualUpdateEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowVisualUpdateEvent;
import org.eclipse.nebula.widgets.nattable.layer.stack.DummyGridLayerStack;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.NatLayerPainter;
import org.eclipse.nebula.widgets.nattable.persistence.IPersistable;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.event.CellSelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.ISelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.RowSelectionEvent;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.theme.ThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.style.theme.ThemeManager;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.mode.ConfigurableModeEventHandler;
import org.eclipse.nebula.widgets.nattable.ui.mode.Mode;
import org.eclipse.nebula.widgets.nattable.ui.mode.ModeSupport;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.util.IClientAreaProvider;
import org.eclipse.nebula.widgets.nattable.viewport.command.RecalculateScrollBarsCommand;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NatTable
extends Canvas
implements ILayer,
PaintListener,
IClientAreaProvider,
ILayerListener,
IPersistable {
    private static final Logger LOG = LoggerFactory.getLogger(NatTable.class);
    public static final int DEFAULT_STYLE_OPTIONS = 538182400;
    public static final String INITIAL_PAINT_COMPLETE_FLAG = "NatTable.initialPaintComplete";
    private UiBindingRegistry uiBindingRegistry;
    private ModeSupport modeSupport;
    private final EventConflaterChain conflaterChain;
    private final List<IOverlayPainter> overlayPainters = new ArrayList<IOverlayPainter>();
    private final List<IPersistable> persistables = new LinkedList<IPersistable>();
    private ILayer underlyingLayer;
    private IConfigRegistry configRegistry;
    protected final Collection<IConfiguration> configurations = new LinkedList<IConfiguration>();
    protected String id = GUIHelper.getSequenceNumber();
    private ILayerPainter layerPainter = new NatLayerPainter(this);
    private final boolean autoconfigure;
    private Listener closeEditorOnParentResize = event -> {
        if (!this.commitAndCloseActiveCellEditor()) {
            this.getActiveCellEditor().close();
        }
    };
    private boolean initialPaintComplete = false;
    private ThemeManager themeManager;
    private InternalCellClipboard clipboard = new InternalCellClipboard();
    private ICellEditor activeCellEditor;
    private List<ILayerListener> listeners = new ArrayList<ILayerListener>();
    protected ReadWriteLock eventListenerLock = new ReentrantReadWriteLock();

    public NatTable(Composite parent) {
        this(parent, 538182400);
    }

    public NatTable(Composite parent, boolean autoconfigure) {
        this(parent, 538182400, autoconfigure);
    }

    public NatTable(Composite parent, ILayer layer) {
        this(parent, 538182400, layer);
    }

    public NatTable(Composite parent, ILayer layer, boolean autoconfigure) {
        this(parent, 538182400, layer, autoconfigure);
    }

    public NatTable(Composite parent, int style) {
        this(parent, style, new DummyGridLayerStack());
    }

    public NatTable(Composite parent, int style, boolean autoconfigure) {
        this(parent, style, new DummyGridLayerStack(), autoconfigure);
    }

    public NatTable(Composite parent, int style, ILayer layer) {
        this(parent, style, layer, true);
    }

    public NatTable(Composite parent, int style, ILayer layer, boolean autoconfigure) {
        this(parent, style, layer, new EventConflaterChain(), autoconfigure);
    }

    public NatTable(Composite parent, int style, ILayer layer, EventConflaterChain chain, boolean autoconfigure) {
        super(parent, style);
        this.disableScrollBar(this.getHorizontalBar());
        this.disableScrollBar(this.getVerticalBar());
        this.initInternalListener();
        this.internalSetLayer(layer);
        this.autoconfigure = autoconfigure;
        if (autoconfigure) {
            this.configurations.add(new DefaultNatTableStyleConfiguration());
            this.configure();
        }
        this.conflaterChain = chain;
        this.conflaterChain.add(this.getVisualChangeEventConflater());
        this.conflaterChain.start();
        parent.addListener(11, this.closeEditorOnParentResize);
        this.addDisposeListener(e -> {
            this.doCommand(new DisposeResourcesCommand());
            this.conflaterChain.stop();
            layer.dispose();
            parent.removeListener(11, this.closeEditorOnParentResize);
        });
    }

    protected IEventConflater getVisualChangeEventConflater() {
        return new VisualChangeEventConflater(this);
    }

    private void disableScrollBar(ScrollBar scrollBar) {
        if (scrollBar != null) {
            scrollBar.setMinimum(0);
            scrollBar.setMaximum(1);
            scrollBar.setThumb(1);
            scrollBar.setEnabled(false);
        }
    }

    public ILayer getLayer() {
        return this.underlyingLayer;
    }

    public void setLayer(ILayer layer) {
        if (this.autoconfigure) {
            throw new IllegalStateException("May only set layer post construction if autoconfigure is turned off");
        }
        this.internalSetLayer(layer);
    }

    private void internalSetLayer(ILayer layer) {
        if (layer != null) {
            this.underlyingLayer = layer;
            this.underlyingLayer.setClientAreaProvider(() -> {
                Rectangle clientArea = new Rectangle(0, 0, 0, 0);
                if (!this.isDisposed()) {
                    this.getDisplay().syncExec(() -> {
                        Rectangle natClientArea = this.getClientArea();
                        rectangle.x = natClientArea.x;
                        rectangle.y = natClientArea.y;
                        rectangle.width = natClientArea.width;
                        rectangle.height = natClientArea.height;
                    });
                }
                return clientArea;
            });
            this.underlyingLayer.addLayerListener(this);
            this.underlyingLayer.doCommand(new ConfigureScalingCommand(new DefaultHorizontalDpiConverter(), new DefaultVerticalDpiConverter()));
        }
    }

    public void addConfiguration(IConfiguration configuration) {
        if (this.autoconfigure) {
            throw new IllegalStateException("May only add configurations post construction if autoconfigure is turned off");
        }
        this.configurations.add(configuration);
    }

    public IConfigRegistry getConfigRegistry() {
        if (this.configRegistry == null) {
            this.configRegistry = new ConfigRegistry();
            this.themeManager = new ThemeManager(this.configRegistry);
            this.configureScaling(new DefaultHorizontalDpiConverter(), new DefaultVerticalDpiConverter());
        }
        return this.configRegistry;
    }

    public void setConfigRegistry(IConfigRegistry configRegistry) {
        if (this.autoconfigure) {
            throw new IllegalStateException("May only set config registry post construction if autoconfigure is turned off");
        }
        this.configRegistry = configRegistry;
        this.themeManager = new ThemeManager(configRegistry);
        this.configureScaling(new DefaultHorizontalDpiConverter(), new DefaultVerticalDpiConverter());
    }

    protected void configureScaling(IDpiConverter horizontalConverter, IDpiConverter verticalConverter) {
        if (!this.commitAndCloseActiveCellEditor()) {
            this.getActiveCellEditor().close();
        }
        this.getConfigRegistry().registerConfigAttribute(NatTableConfigAttributes.HORIZONTAL_DPI_CONVERTER, horizontalConverter);
        this.getConfigRegistry().registerConfigAttribute(NatTableConfigAttributes.VERTICAL_DPI_CONVERTER, verticalConverter);
        GUIHelper.setDpi(horizontalConverter.getDpi(), verticalConverter.getDpi());
        float dpiFactor = GUIHelper.getDpiFactor(GUIHelper.getDpiX());
        float displayDpiFactor = GUIHelper.getDpiFactor(Display.getDefault().getDPI().x);
        float fontScalingFactor = dpiFactor / displayDpiFactor;
        this.getConfigRegistry().registerConfigAttribute(NatTableConfigAttributes.FONT_SCALING_FACTOR, Float.valueOf(fontScalingFactor));
        this.themeManager.refreshCurrentTheme();
    }

    public UiBindingRegistry getUiBindingRegistry() {
        if (this.uiBindingRegistry == null) {
            this.uiBindingRegistry = new UiBindingRegistry(this);
        }
        return this.uiBindingRegistry;
    }

    public void setUiBindingRegistry(UiBindingRegistry uiBindingRegistry) {
        if (this.autoconfigure) {
            throw new IllegalStateException("May only set UI binding registry post construction if autoconfigure is turned off");
        }
        this.uiBindingRegistry = uiBindingRegistry;
    }

    public String getID() {
        return this.id;
    }

    protected void checkSubclass() {
    }

    protected void initInternalListener() {
        this.modeSupport = new ModeSupport(this);
        this.modeSupport.registerModeEventHandler(Mode.NORMAL_MODE, new ConfigurableModeEventHandler(this.modeSupport, this));
        this.modeSupport.switchMode(Mode.NORMAL_MODE);
        this.addPaintListener(this);
        this.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                NatTable.this.redraw();
            }

            public void focusGained(FocusEvent arg0) {
                NatTable.this.redraw();
            }
        });
        this.addListener(11, e -> {
            this.doCommand(new ClientAreaResizeCommand((Scrollable)this));
            this.redraw();
        });
    }

    public List<IOverlayPainter> getOverlayPainters() {
        return this.overlayPainters;
    }

    public void addOverlayPainter(IOverlayPainter overlayPainter) {
        this.overlayPainters.add(overlayPainter);
    }

    public void removeOverlayPainter(IOverlayPainter overlayPainter) {
        this.overlayPainters.remove(overlayPainter);
    }

    public void paintControl(PaintEvent event) {
        this.paintNatTable(event);
        this.initialPaintComplete = true;
    }

    private void paintNatTable(PaintEvent event) {
        this.getLayerPainter().paintLayer(this, event.gc, 0, 0, new Rectangle(event.x, event.y, event.width, event.height), this.getConfigRegistry());
    }

    @Override
    public ILayerPainter getLayerPainter() {
        return this.layerPainter;
    }

    public void setLayerPainter(ILayerPainter layerPainter) {
        this.layerPainter = layerPainter;
    }

    public void repaintColumn(int columnPosition) {
        int xOffset = this.getStartXOfColumnPosition(columnPosition);
        if (xOffset < 0) {
            return;
        }
        this.redraw(xOffset, 0, this.getColumnWidthByPosition(columnPosition), this.getHeight(), true);
    }

    public void repaintRow(int rowPosition) {
        int yOffset = this.getStartYOfRowPosition(rowPosition);
        if (yOffset < 0) {
            return;
        }
        this.redraw(0, yOffset, this.getWidth(), this.getRowHeightByPosition(rowPosition), true);
    }

    public void repaintCell(int columnPosition, int rowPosition) {
        ILayerCell cell = this.getCellByPosition(columnPosition, rowPosition);
        if (cell != null) {
            Rectangle bounds = cell.getBounds();
            this.redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
        } else {
            this.redraw(this.getStartXOfColumnPosition(columnPosition), this.getStartYOfRowPosition(rowPosition), this.getColumnWidthByPosition(columnPosition), this.getRowHeightByPosition(rowPosition), true);
        }
    }

    public void repaintHorizontalLeftOver() {
        int leftOverSpace = this.getClientArea().width - this.getWidth();
        if (leftOverSpace > 0) {
            this.redraw(this.getWidth(), 0, leftOverSpace, this.getHeight(), true);
        }
    }

    public void repaintVerticalLeftOver() {
        int leftOverSpace = this.getClientArea().height - this.getHeight();
        if (leftOverSpace > 0) {
            this.redraw(0, this.getHeight(), this.getClientArea().width, leftOverSpace, true);
        }
    }

    public void updateResize() {
        this.updateResize(true);
    }

    private void updateResize(boolean redraw) {
        if (this.isDisposed()) {
            return;
        }
        this.doCommand(new RecalculateScrollBarsCommand());
        if (redraw) {
            this.redraw();
        }
    }

    public void refresh() {
        this.doCommand(new StructuralRefreshCommand());
    }

    public void refresh(boolean structuralChange) {
        if (structuralChange) {
            this.refresh();
        } else {
            this.doCommand(new VisualRefreshCommand());
        }
    }

    @Override
    public void configure(IConfigRegistry configRegistry, UiBindingRegistry uiBindingRegistry) {
        throw new UnsupportedOperationException("Cannot use this method to configure NatTable. Use no-argument configure() instead.");
    }

    public void configure() {
        if (this.underlyingLayer == null) {
            throw new IllegalStateException("Layer must be set before configure is called");
        }
        this.underlyingLayer.configure(this.getConfigRegistry(), this.getUiBindingRegistry());
        for (IConfiguration configuration : this.configurations) {
            configuration.configureLayer(this);
            configuration.configureRegistry(this.getConfigRegistry());
            configuration.configureUiBindings(this.getUiBindingRegistry());
        }
        this.doCommand(new InitializeGridCommand((Composite)this));
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        Range range;
        Collection<Range> ranges;
        IVisualChangeEvent update;
        List<ILayerListener> currentListeners;
        this.eventListenerLock.readLock().lock();
        try {
            currentListeners = this.listeners;
        }
        finally {
            this.eventListenerLock.readLock().unlock();
        }
        for (ILayerListener layerListener : currentListeners) {
            layerListener.handleLayerEvent(event);
        }
        if (event instanceof CellVisualUpdateEvent) {
            update = (CellVisualUpdateEvent)event;
            this.repaintCell(((CellVisualChangeEvent)update).getColumnPosition(), ((CellVisualChangeEvent)update).getRowPosition());
            return;
        }
        if (event instanceof ColumnVisualUpdateEvent && (ranges = ((ColumnVisualChangeEvent)(update = (ColumnVisualUpdateEvent)event)).getColumnPositionRanges()).size() == 1) {
            range = ranges.iterator().next();
            if (range.end - range.start == 1) {
                this.repaintColumn(range.start);
                return;
            }
        }
        if (event instanceof RowVisualUpdateEvent && (ranges = ((RowVisualChangeEvent)(update = (RowVisualUpdateEvent)event)).getRowPositionRanges()).size() == 1) {
            range = ranges.iterator().next();
            if (range.end - range.start == 1) {
                this.repaintRow(range.start);
                return;
            }
        }
        if (event instanceof ISelectionEvent) {
            if (event instanceof CellSelectionEvent || event instanceof RowSelectionEvent) {
                Event e2 = new Event();
                e2.widget = this;
                try {
                    this.notifyListeners(13, e2);
                }
                catch (RuntimeException re) {
                    LOG.error("Error on SWT selection processing", (Throwable)re);
                }
            }
            this.redraw();
        } else if (event instanceof IVisualChangeEvent) {
            this.conflaterChain.addEvent(event);
        }
        if (event instanceof CellEditorCreatedEvent) {
            CellEditorCreatedEvent editorEvent = (CellEditorCreatedEvent)event;
            this.activeCellEditor = editorEvent.getEditor();
            Control editorControl = this.activeCellEditor.getEditorControl();
            if (editorControl != null && !editorControl.isDisposed()) {
                editorControl.addDisposeListener(e -> {
                    ICellEditor iCellEditor = this.activeCellEditor = null;
                });
            } else {
                this.activeCellEditor = null;
            }
        }
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        BusyIndicator.showWhile(null, () -> this.underlyingLayer.saveState(prefix, properties));
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        BusyIndicator.showWhile(null, () -> {
            if (!this.initialPaintComplete) {
                properties.setProperty(INITIAL_PAINT_COMPLETE_FLAG, "true");
            }
            this.underlyingLayer.loadState(prefix, properties);
        });
    }

    @Override
    public void registerPersistable(IPersistable persistable) {
        this.persistables.add(persistable);
    }

    @Override
    public void unregisterPersistable(IPersistable persistable) {
        this.persistables.remove(persistable);
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof ConfigureScalingCommand) {
            ConfigureScalingCommand cmd = (ConfigureScalingCommand)command;
            this.configureScaling(cmd.getHorizontalDpiConverter(), cmd.getVerticalDpiConverter());
        }
        return this.underlyingLayer.doCommand(command);
    }

    @Override
    public void registerCommandHandler(ILayerCommandHandler<?> commandHandler) {
        this.underlyingLayer.registerCommandHandler(commandHandler);
    }

    @Override
    public void unregisterCommandHandler(Class<? extends ILayerCommand> commandClass) {
        this.underlyingLayer.unregisterCommandHandler(commandClass);
    }

    @Override
    public void fireLayerEvent(ILayerEvent event) {
        this.underlyingLayer.fireLayerEvent(event);
    }

    @Override
    public void addLayerListener(ILayerListener listener) {
        this.eventListenerLock.writeLock().lock();
        try {
            this.listeners = new ArrayList<ILayerListener>(this.listeners);
            this.listeners.add(listener);
        }
        finally {
            this.eventListenerLock.writeLock().unlock();
        }
    }

    @Override
    public void removeLayerListener(ILayerListener listener) {
        this.eventListenerLock.writeLock().lock();
        try {
            this.listeners = new ArrayList<ILayerListener>(this.listeners);
            this.listeners.remove(listener);
        }
        finally {
            this.eventListenerLock.writeLock().unlock();
        }
    }

    @Override
    public boolean hasLayerListener(Class<? extends ILayerListener> layerListenerClass) {
        for (ILayerListener listener : this.listeners) {
            if (!listener.getClass().equals(layerListenerClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getColumnCount() {
        return this.underlyingLayer.getColumnCount();
    }

    @Override
    public int getPreferredColumnCount() {
        return this.underlyingLayer.getPreferredColumnCount();
    }

    @Override
    public int getColumnIndexByPosition(int columnPosition) {
        return this.underlyingLayer.getColumnIndexByPosition(columnPosition);
    }

    @Override
    public int localToUnderlyingColumnPosition(int localColumnPosition) {
        return localColumnPosition;
    }

    @Override
    public int underlyingToLocalColumnPosition(ILayer sourceUnderlyingLayer, int underlyingColumnPosition) {
        if (sourceUnderlyingLayer != this.underlyingLayer) {
            return -1;
        }
        return underlyingColumnPosition;
    }

    @Override
    public Collection<Range> underlyingToLocalColumnPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingColumnPositionRanges) {
        if (sourceUnderlyingLayer != this.underlyingLayer) {
            return null;
        }
        return underlyingColumnPositionRanges;
    }

    @Override
    public int getWidth() {
        return this.underlyingLayer.getWidth();
    }

    @Override
    public int getPreferredWidth() {
        return this.underlyingLayer.getPreferredWidth();
    }

    @Override
    public int getColumnWidthByPosition(int columnPosition) {
        return this.underlyingLayer.getColumnWidthByPosition(columnPosition);
    }

    @Override
    public boolean isColumnPositionResizable(int columnPosition) {
        return this.underlyingLayer.isColumnPositionResizable(columnPosition);
    }

    @Override
    public int getColumnPositionByX(int x) {
        return this.underlyingLayer.getColumnPositionByX(x);
    }

    @Override
    public int getStartXOfColumnPosition(int columnPosition) {
        return this.underlyingLayer.getStartXOfColumnPosition(columnPosition);
    }

    @Override
    public Collection<ILayer> getUnderlyingLayersByColumnPosition(int columnPosition) {
        HashSet<ILayer> underlyingLayers = new HashSet<ILayer>();
        underlyingLayers.add(this.underlyingLayer);
        return underlyingLayers;
    }

    @Override
    public int getRowCount() {
        return this.underlyingLayer.getRowCount();
    }

    @Override
    public int getPreferredRowCount() {
        return this.underlyingLayer.getPreferredRowCount();
    }

    @Override
    public int getRowIndexByPosition(int rowPosition) {
        return this.underlyingLayer.getRowIndexByPosition(rowPosition);
    }

    @Override
    public int localToUnderlyingRowPosition(int localRowPosition) {
        return localRowPosition;
    }

    @Override
    public int underlyingToLocalRowPosition(ILayer sourceUnderlyingLayer, int underlyingRowPosition) {
        if (sourceUnderlyingLayer != this.underlyingLayer) {
            return -1;
        }
        return underlyingRowPosition;
    }

    @Override
    public Collection<Range> underlyingToLocalRowPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingRowPositionRanges) {
        if (sourceUnderlyingLayer != this.underlyingLayer) {
            return null;
        }
        return underlyingRowPositionRanges;
    }

    @Override
    public int getHeight() {
        return this.underlyingLayer.getHeight();
    }

    @Override
    public int getPreferredHeight() {
        return this.underlyingLayer.getPreferredHeight();
    }

    @Override
    public int getRowHeightByPosition(int rowPosition) {
        return this.underlyingLayer.getRowHeightByPosition(rowPosition);
    }

    @Override
    public boolean isRowPositionResizable(int rowPosition) {
        return this.underlyingLayer.isRowPositionResizable(rowPosition);
    }

    @Override
    public int getRowPositionByY(int y) {
        return this.underlyingLayer.getRowPositionByY(y);
    }

    @Override
    public int getStartYOfRowPosition(int rowPosition) {
        return this.underlyingLayer.getStartYOfRowPosition(rowPosition);
    }

    @Override
    public Collection<ILayer> getUnderlyingLayersByRowPosition(int rowPosition) {
        HashSet<ILayer> underlyingLayers = new HashSet<ILayer>();
        underlyingLayers.add(this.underlyingLayer);
        return underlyingLayers;
    }

    @Override
    public ILayerCell getCellByPosition(int columnPosition, int rowPosition) {
        return this.underlyingLayer.getCellByPosition(columnPosition, rowPosition);
    }

    @Override
    public Rectangle getBoundsByPosition(int columnPosition, int rowPosition) {
        return this.underlyingLayer.getBoundsByPosition(columnPosition, rowPosition);
    }

    @Override
    public DisplayMode getDisplayModeByPosition(int columnPosition, int rowPosition) {
        return this.underlyingLayer.getDisplayModeByPosition(columnPosition, rowPosition);
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        return this.underlyingLayer.getConfigLabelsByPosition(columnPosition, rowPosition);
    }

    @Override
    public Object getDataValueByPosition(int columnPosition, int rowPosition) {
        return this.underlyingLayer.getDataValueByPosition(columnPosition, rowPosition);
    }

    @Override
    public ICellPainter getCellPainter(int columnPosition, int rowPosition, ILayerCell cell, IConfigRegistry configRegistry) {
        return this.underlyingLayer.getCellPainter(columnPosition, rowPosition, cell, configRegistry);
    }

    @Override
    public LabelStack getRegionLabelsByXY(int x, int y) {
        return this.underlyingLayer.getRegionLabelsByXY(x, y);
    }

    @Override
    public ILayer getUnderlyingLayerByPosition(int columnPosition, int rowPosition) {
        return this.underlyingLayer;
    }

    @Override
    public IClientAreaProvider getClientAreaProvider() {
        return this;
    }

    @Override
    public void setClientAreaProvider(IClientAreaProvider clientAreaProvider) {
        this.underlyingLayer.setClientAreaProvider(clientAreaProvider);
    }

    public void addDragSupport(int operations, Transfer[] transferTypes, final DragSourceListener listener) {
        DragSource dragSource = new DragSource((Control)this, operations);
        dragSource.setTransfer(transferTypes);
        DragSourceListener wrapper = new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                listener.dragStart(event);
            }

            public void dragSetData(DragSourceEvent event) {
                listener.dragSetData(event);
            }

            public void dragFinished(DragSourceEvent event) {
                listener.dragFinished(event);
                NatTable.this.modeSupport.switchMode(Mode.NORMAL_MODE);
            }
        };
        dragSource.addDragListener(wrapper);
    }

    public void addDropSupport(int operations, Transfer[] transferTypes, DropTargetListener listener) {
        DropTarget dropTarget = new DropTarget((Control)this, operations);
        dropTarget.setTransfer(transferTypes);
        dropTarget.addDropListener(listener);
    }

    public void setTheme(ThemeConfiguration themeConfiguration) {
        this.themeManager.applyTheme(themeConfiguration);
        this.doCommand(new VisualRefreshCommand());
    }

    public InternalCellClipboard getInternalCellClipboard() {
        return this.clipboard;
    }

    public ICellEditor getActiveCellEditor() {
        return this.activeCellEditor;
    }

    public boolean commitAndCloseActiveCellEditor() {
        if (this.activeCellEditor != null) {
            return this.activeCellEditor.commit(SelectionLayer.MoveDirectionEnum.NONE, true);
        }
        return true;
    }

    @Override
    public Collection<String> getProvidedLabels() {
        return this.underlyingLayer.getProvidedLabels();
    }
}

