/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group;

import java.util.Collection;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.IColumnGroupModelListener;
import org.eclipse.nebula.widgets.nattable.group.command.ColumnGroupExpandCollapseCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.AbstractColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;

public class ColumnGroupExpandCollapseLayer
extends AbstractColumnHideShowLayer
implements IColumnGroupModelListener {
    private final ColumnGroupModel[] models;

    public ColumnGroupExpandCollapseLayer(IUniqueIndexLayer underlyingLayer, ColumnGroupModel model) {
        this(underlyingLayer, new ColumnGroupModel[]{model});
    }

    public ColumnGroupExpandCollapseLayer(IUniqueIndexLayer underlyingLayer, ColumnGroupModel ... models) {
        super(underlyingLayer);
        this.models = models;
        ColumnGroupModel[] columnGroupModelArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnGroupModel model = columnGroupModelArray[n2];
            model.registerColumnGroupModelListener(this);
            ++n2;
        }
        this.registerCommandHandler(new ColumnGroupExpandCollapseCommandHandler(this));
    }

    public ColumnGroupModel getModel(int row) {
        if (row >= this.models.length) {
            row = this.models.length - 1;
        }
        return this.models[row];
    }

    @Override
    public boolean isColumnIndexHidden(int columnIndex) {
        IUniqueIndexLayer underlyingLayer = this.getUnderlyingLayer();
        boolean isHiddeninUnderlyingLayer = ColumnGroupUtils.isColumnIndexHiddenInUnderLyingLayer(columnIndex, underlyingLayer);
        if (isHiddeninUnderlyingLayer) {
            return true;
        }
        ColumnGroupModel[] columnGroupModelArray = this.models;
        int n = this.models.length;
        int n2 = 0;
        while (n2 < n) {
            boolean isCollapsedAndStaticColumn;
            ColumnGroupModel model = columnGroupModelArray[n2];
            ColumnGroupModel.ColumnGroup columnGroup = model.getColumnGroupByIndex(columnIndex);
            boolean bl = isCollapsedAndStaticColumn = columnGroup != null && columnGroup.isCollapsed() && !ColumnGroupUtils.isStaticOrFirstVisibleColumn(columnIndex, underlyingLayer, model);
            if (isCollapsedAndStaticColumn) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Collection<Integer> getHiddenColumnIndexes() {
        return ArrayUtil.asIntegerList(this.getHiddenColumnIndexesArray());
    }

    @Override
    public int[] getHiddenColumnIndexesArray() {
        MutableIntSet hiddenColumnIndexes = IntSets.mutable.empty();
        IUniqueIndexLayer underlyingLayer = this.getUnderlyingLayer();
        int underlyingColumnCount = underlyingLayer.getColumnCount();
        int i = 0;
        while (i < underlyingColumnCount) {
            int columnIndex = underlyingLayer.getColumnIndexByPosition(i);
            ColumnGroupModel[] columnGroupModelArray = this.models;
            int n = this.models.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnGroupModel model = columnGroupModelArray[n2];
                ColumnGroupModel.ColumnGroup columnGroup = model.getColumnGroupByIndex(columnIndex);
                if (columnGroup != null && columnGroup.isCollapsed() && !ColumnGroupUtils.isStaticOrFirstVisibleColumn(columnIndex, underlyingLayer, model)) {
                    hiddenColumnIndexes.add(columnIndex);
                }
                ++n2;
            }
            ++i;
        }
        return hiddenColumnIndexes.toSortedArray();
    }

    @Override
    public boolean hasHiddenColumns() {
        ColumnGroupModel[] columnGroupModelArray = this.models;
        int n = this.models.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnGroupModel model = columnGroupModelArray[n2];
            if (model.getCollapsedColumnCount() > 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void columnGroupModelChanged() {
        this.invalidateCache();
    }
}

