/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.menu;

import org.eclipse.jface.action.MenuManager;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class PopupMenuAction
implements IMouseAction {
    private Menu menu;
    private MenuManager menuManager;

    public PopupMenuAction(Menu menu) {
        if (menu == null) {
            throw new IllegalArgumentException("menu can not be null");
        }
        this.menu = menu;
    }

    public PopupMenuAction(MenuManager menuManager) {
        this.menuManager = menuManager;
    }

    @Override
    public void run(NatTable natTable, MouseEvent event) {
        if (this.menuManager != null) {
            if (this.menu != null) {
                this.menu.dispose();
            } else {
                natTable.addDisposeListener(e -> {
                    if (this.menu != null && !this.menu.isDisposed()) {
                        this.menu.dispose();
                    }
                });
            }
            this.menu = this.menuManager.createContextMenu((Control)natTable);
        }
        this.menu.setData("natEventData", event.data);
        this.menu.setVisible(true);
    }
}

