/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.calculation;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.calculation.Calculation;
import ca.odell.glazedlists.calculation.ConditionalCount;
import ca.odell.glazedlists.calculation.Count;
import ca.odell.glazedlists.calculation.Division;
import ca.odell.glazedlists.calculation.ElementAt;
import ca.odell.glazedlists.calculation.SizeInRange;
import ca.odell.glazedlists.calculation.Subtraction;
import ca.odell.glazedlists.calculation.Sum;
import ca.odell.glazedlists.matchers.Matcher;

public final class Calculations {
    private Calculations() {
    }

    public static Calculation<Integer> count(EventList elements) {
        return new Count(elements);
    }

    public static <E> Calculation<Integer> count(EventList<E> elements, Matcher<E> matcher) {
        return new ConditionalCount<E>(elements, matcher);
    }

    public static Calculation<Boolean> zeroElements(EventList elements) {
        return new SizeInRange(elements, 0, 0);
    }

    public static Calculation<Boolean> oneElement(EventList elements) {
        return new SizeInRange(elements, 1, 1);
    }

    public static Calculation<Boolean> oneOrMoreElements(EventList elements) {
        return new SizeInRange(elements, 1, Integer.MAX_VALUE);
    }

    public static Calculation<Boolean> manyElements(EventList elements) {
        return new SizeInRange(elements, 2, Integer.MAX_VALUE);
    }

    public static Calculation<Float> sumFloats(EventList<? extends Number> numbers) {
        return new Sum.SumFloat<Number>(numbers);
    }

    public static Calculation<Double> sumDoubles(EventList<? extends Number> numbers) {
        return new Sum.SumDouble<Number>(numbers);
    }

    public static Calculation<Integer> sumIntegers(EventList<? extends Number> numbers) {
        return new Sum.SumInteger<Number>(numbers);
    }

    public static Calculation<Long> sumLongs(EventList<? extends Number> numbers) {
        return new Sum.SumLong<Number>(numbers);
    }

    public static Calculation<Float> divideFloats(Calculation<? extends Number> numerator, Calculation<? extends Number> denominator) {
        return new Division.DivisionFloat(numerator, denominator);
    }

    public static Calculation<Double> divideDoubles(Calculation<? extends Number> numerator, Calculation<? extends Number> denominator) {
        return new Division.DivisionDouble(numerator, denominator);
    }

    public static Calculation<Float> subtractFloats(Calculation<? extends Number> a, Calculation<? extends Number> b) {
        return new Subtraction.SubtractionFloat(a, b);
    }

    public static Calculation<Double> subtractDoubles(Calculation<? extends Number> a, Calculation<? extends Number> b) {
        return new Subtraction.SubtractionDouble(a, b);
    }

    public static Calculation<Integer> subtractIntegers(Calculation<? extends Number> a, Calculation<? extends Number> b) {
        return new Subtraction.SubtractionInteger(a, b);
    }

    public static Calculation<Long> subtractLongs(Calculation<? extends Number> a, Calculation<? extends Number> b) {
        return new Subtraction.SubtractionLong(a, b);
    }

    public static Calculation<Float> meanFloats(EventList<? extends Number> numbers) {
        return Calculations.divideFloats(Calculations.sumFloats(numbers), Calculations.count(numbers));
    }

    public static Calculation<Double> meanDoubles(EventList<? extends Number> numbers) {
        return Calculations.divideDoubles(Calculations.sumDoubles(numbers), Calculations.count(numbers));
    }

    public static <E> Calculation<E> elementAt(EventList<E> elements, int index, E defaultValue) {
        return new ElementAt<E>(elements, index, defaultValue);
    }
}

