/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.pmap;

import ca.odell.glazedlists.impl.pmap.Chunk;
import ca.odell.glazedlists.impl.pmap.PersistentMap;
import java.io.IOException;
import java.util.logging.Logger;

class AddChunk
implements Runnable {
    private static Logger logger = Logger.getLogger(AddChunk.class.toString());
    private final PersistentMap persistentMap;
    private final Chunk newValue;
    private final Chunk oldValue;

    public AddChunk(PersistentMap persistentMap, Chunk newValue, Chunk oldValue) {
        this.persistentMap = persistentMap;
        this.newValue = newValue;
        this.oldValue = oldValue;
    }

    @Override
    public void run() {
        try {
            this.persistentMap.allocate(this.newValue);
            this.newValue.setSequenceId(this.persistentMap.nextSequenceId());
            this.newValue.writeData();
            if (this.oldValue != null) {
                this.oldValue.delete();
            }
            logger.info("Successfully wrote value for key \"" + this.newValue.getKey() + "\"");
        }
        catch (IOException e) {
            this.persistentMap.fail(e, "Failed to write to file " + this.persistentMap.getFile().getPath());
        }
    }
}

