/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.cairo.cairo_font_extents_t;
import org.eclipse.swt.internal.cairo.cairo_text_extents_t;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.Visual;
import org.eclipse.swt.internal.motif.XCharStruct;
import org.eclipse.swt.internal.motif.XColor;
import org.eclipse.swt.internal.motif.XFontStruct;
import org.eclipse.swt.internal.motif.XGCValues;
import org.eclipse.swt.internal.motif.XImage;
import org.eclipse.swt.internal.motif.XRectangle;
import org.eclipse.swt.internal.motif.XRenderPictureAttributes;

public final class GC
extends Resource {
    public int handle;
    Drawable drawable;
    GCData data;
    static final int FOREGROUND = 1;
    static final int BACKGROUND = 2;
    static final int FONT = 4;
    static final int LINE_STYLE = 8;
    static final int LINE_CAP = 16;
    static final int LINE_JOIN = 32;
    static final int LINE_WIDTH = 64;
    static final int LINE_MITERLIMIT = 128;
    static final int BACKGROUND_BG = 256;
    static final int FOREGROUND_RGB = 512;
    static final int BACKGROUND_RGB = 1024;
    static final int DRAW_OFFSET = 2048;
    static final int DRAW = 2297;
    static final int FILL = 2;
    static final float[] LINE_DOT = new float[]{1.0f, 1.0f};
    static final float[] LINE_DASH = new float[]{3.0f, 1.0f};
    static final float[] LINE_DASHDOT = new float[]{3.0f, 1.0f, 1.0f, 1.0f};
    static final float[] LINE_DASHDOTDOT = new float[]{3.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    static final float[] LINE_DOT_ZERO = new float[]{3.0f, 3.0f};
    static final float[] LINE_DASH_ZERO = new float[]{18.0f, 6.0f};
    static final float[] LINE_DASHDOT_ZERO = new float[]{9.0f, 6.0f, 3.0f, 6.0f};
    static final float[] LINE_DASHDOTDOT_ZERO = new float[]{9.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f};

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int n) {
        if (drawable == null) {
            SWT.error(4);
        }
        GCData gCData = new GCData();
        gCData.style = GC.checkStyle(n);
        int n2 = drawable.internal_new_GC(gCData);
        Device device = gCData.device;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = gCData.device = device;
        this.init(drawable, gCData, n2);
        this.init();
    }

    static void addCairoString(int n, String string, float f, float f2, Font font) {
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        GC.setCairoFont(n, font);
        cairo_font_extents_t cairo_font_extents_t2 = new cairo_font_extents_t();
        Cairo.cairo_font_extents(n, cairo_font_extents_t2);
        double d = (double)f2 + cairo_font_extents_t2.ascent;
        Cairo.cairo_move_to(n, f, d);
        Cairo.cairo_text_path(n, byArray);
    }

    static int checkStyle(int n) {
        if ((n & 0x2000000) != 0) {
            n &= 0xFBFFFFFF;
        }
        return n & 0x6000000;
    }

    void checkGC(int n) {
        XColor xColor;
        int n2 = this.data.state;
        if ((n2 & n) == n) {
            return;
        }
        n2 = (n2 ^ n) & n;
        this.data.state |= n;
        int n3 = this.data.cairo;
        if (n3 != 0) {
            Object object;
            if ((n2 & 3) != 0) {
                XColor xColor2;
                if ((n2 & 1) != 0) {
                    xColor2 = this.data.foreground;
                    if ((this.data.state & 0x200) == 0) {
                        OS.XQueryColor(this.data.display, this.data.colormap, xColor2);
                        this.data.state |= 0x200;
                    }
                    object = this.data.foregroundPattern;
                    this.data.state &= 0xFFFFFFFD;
                } else {
                    xColor2 = this.data.background;
                    if ((this.data.state & 0x400) == 0) {
                        OS.XQueryColor(this.data.display, this.data.colormap, xColor2);
                        this.data.state |= 0x400;
                    }
                    object = this.data.backgroundPattern;
                    this.data.state &= 0xFFFFFFFE;
                }
                if (object != null) {
                    Cairo.cairo_set_source(n3, ((Pattern)object).handle);
                } else {
                    Cairo.cairo_set_source_rgba(n3, (float)(xColor2.red & 0xFFFF) / 65535.0f, (float)(xColor2.green & 0xFFFF) / 65535.0f, (float)(xColor2.blue & 0xFFFF) / 65535.0f, (float)this.data.alpha / 255.0f);
                }
            }
            if ((n2 & 4) != 0) {
                GC.setCairoFont(n3, this.data.font);
            }
            if ((n2 & 0x10) != 0) {
                int n4 = 0;
                switch (this.data.lineCap) {
                    case 2: {
                        n4 = 1;
                        break;
                    }
                    case 1: {
                        n4 = 0;
                        break;
                    }
                    case 3: {
                        n4 = 2;
                    }
                }
                Cairo.cairo_set_line_cap(n3, n4);
            }
            if ((n2 & 0x20) != 0) {
                int n5 = 0;
                switch (this.data.lineJoin) {
                    case 1: {
                        n5 = 0;
                        break;
                    }
                    case 2: {
                        n5 = 1;
                        break;
                    }
                    case 3: {
                        n5 = 2;
                    }
                }
                Cairo.cairo_set_line_join(n3, n5);
            }
            if ((n2 & 0x40) != 0) {
                Cairo.cairo_set_line_width(n3, this.data.lineWidth == 0.0f ? 1.0f : this.data.lineWidth);
                switch (this.data.lineStyle) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        n2 |= 8;
                    }
                }
            }
            if ((n2 & 8) != 0) {
                float f = 0.0f;
                object = null;
                float f2 = this.data.lineWidth;
                switch (this.data.lineStyle) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        object = f2 != 0.0f ? LINE_DASH : LINE_DASH_ZERO;
                        break;
                    }
                    case 3: {
                        object = f2 != 0.0f ? LINE_DOT : LINE_DOT_ZERO;
                        break;
                    }
                    case 4: {
                        object = f2 != 0.0f ? LINE_DASHDOT : LINE_DASHDOT_ZERO;
                        break;
                    }
                    case 5: {
                        object = f2 != 0.0f ? LINE_DASHDOTDOT : LINE_DASHDOTDOT_ZERO;
                        break;
                    }
                    case 6: {
                        object = this.data.lineDashes;
                    }
                }
                if (object != null) {
                    f = this.data.lineDashesOffset;
                    double[] dArray = new double[((Object)object).length];
                    int n6 = 0;
                    while (n6 < dArray.length) {
                        dArray[n6] = (double)(f2 == 0.0f || this.data.lineStyle == 6 ? object[n6] : object[n6] * f2);
                        ++n6;
                    }
                    Cairo.cairo_set_dash(n3, dArray, dArray.length, f);
                } else {
                    Cairo.cairo_set_dash(n3, null, 0, 0.0);
                }
            }
            if ((n2 & 0x80) != 0) {
                Cairo.cairo_set_miter_limit(n3, this.data.lineMiterLimit);
            }
            if ((n2 & 0x800) != 0) {
                double d;
                this.data.cairoYoffset = 0.0;
                this.data.cairoXoffset = 0.0;
                double[] dArray = new double[6];
                Cairo.cairo_get_matrix(n3, dArray);
                object = new double[]{1.0};
                double[] dArray2 = new double[]{1.0};
                Cairo.cairo_user_to_device_distance(n3, (double[])object, dArray2);
                Object object2 = object[0];
                if (object2 < 0.0) {
                    object2 = -object2;
                }
                if ((d = (double)this.data.lineWidth * object2) == 0.0 || (int)d % 2 == 1) {
                    this.data.cairoXoffset = 0.5 / object2;
                }
                if ((object2 = (Object)dArray2[0]) < 0.0) {
                    object2 = -object2;
                }
                if ((d = (double)this.data.lineWidth * object2) == 0.0 || (int)d % 2 == 1) {
                    this.data.cairoYoffset = 0.5 / object2;
                }
            }
            return;
        }
        int n7 = this.data.display;
        if ((n2 & 3) != 0) {
            if ((n2 & 1) != 0) {
                xColor = this.data.foreground;
                this.data.state &= 0xFFFFFFFD;
            } else {
                xColor = this.data.background;
                this.data.state &= 0xFFFFFFFE;
            }
            OS.XSetForeground(n7, this.handle, xColor.pixel);
        }
        if ((n2 & 0x100) != 0) {
            xColor = this.data.background;
            OS.XSetBackground(n7, this.handle, xColor.pixel);
        }
        if ((n2 & 0x78) != 0) {
            int n8 = 0;
            int n9 = 0;
            int n10 = (int)this.data.lineWidth;
            int n11 = 0;
            float[] fArray = null;
            switch (this.data.lineCap) {
                case 2: {
                    n8 = 2;
                    break;
                }
                case 1: {
                    n8 = 1;
                    break;
                }
                case 3: {
                    n8 = 3;
                }
            }
            switch (this.data.lineJoin) {
                case 2: {
                    n9 = 1;
                    break;
                }
                case 1: {
                    n9 = 0;
                    break;
                }
                case 3: {
                    n9 = 2;
                }
            }
            switch (this.data.lineStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    fArray = n10 != 0 ? LINE_DASH : LINE_DASH_ZERO;
                    break;
                }
                case 3: {
                    fArray = n10 != 0 ? LINE_DOT : LINE_DOT_ZERO;
                    break;
                }
                case 4: {
                    fArray = n10 != 0 ? LINE_DASHDOT : LINE_DASHDOT_ZERO;
                    break;
                }
                case 5: {
                    fArray = n10 != 0 ? LINE_DASHDOTDOT : LINE_DASHDOTDOT_ZERO;
                    break;
                }
                case 6: {
                    fArray = this.data.lineDashes;
                }
            }
            if (fArray != null) {
                if ((n2 & 8) != 0) {
                    byte[] byArray = new byte[fArray.length];
                    int n12 = 0;
                    while (n12 < byArray.length) {
                        byArray[n12] = (byte)(n10 == 0 || this.data.lineStyle == 6 ? fArray[n12] : fArray[n12] * (float)n10);
                        ++n12;
                    }
                    OS.XSetDashes(n7, this.handle, 0, byArray, byArray.length);
                }
                n11 = 1;
            } else {
                n11 = 0;
            }
            OS.XSetLineAttributes(n7, this.handle, n10, n11, n8, n9);
        }
    }

    int convertRgn(int n, double[] dArray) {
        int n2 = OS.XCreateRegion();
        XRectangle xRectangle = new XRectangle();
        OS.XClipBox(n, xRectangle);
        short[] sArray = new short[8];
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        dArray2[0] = xRectangle.x;
        dArray3[0] = xRectangle.y;
        Cairo.cairo_matrix_transform_point(dArray, dArray2, dArray3);
        sArray[0] = (short)dArray2[0];
        sArray[1] = (short)dArray3[0];
        dArray2[0] = xRectangle.x + xRectangle.width;
        dArray3[0] = xRectangle.y;
        Cairo.cairo_matrix_transform_point(dArray, dArray2, dArray3);
        sArray[2] = (short)Math.round(dArray2[0]);
        sArray[3] = (short)dArray3[0];
        dArray2[0] = xRectangle.x + xRectangle.width;
        dArray3[0] = xRectangle.y + xRectangle.height;
        Cairo.cairo_matrix_transform_point(dArray, dArray2, dArray3);
        sArray[4] = (short)Math.round(dArray2[0]);
        sArray[5] = (short)Math.round(dArray3[0]);
        dArray2[0] = xRectangle.x;
        dArray3[0] = xRectangle.y + xRectangle.height;
        Cairo.cairo_matrix_transform_point(dArray, dArray2, dArray3);
        sArray[6] = (short)dArray2[0];
        sArray[7] = (short)Math.round(dArray3[0]);
        int n3 = OS.XPolygonRegion(sArray, sArray.length / 2, 0);
        OS.XUnionRegion(n2, n3, n2);
        OS.XDestroyRegion(n3);
        return n2;
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.copyArea(n, n2, n3, n4, n5, n6, true);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        int n7 = n5 - n;
        int n8 = n6 - n2;
        if (n7 == 0 && n8 == 0) {
            return;
        }
        int n9 = this.data.display;
        int n10 = this.data.drawable;
        if (this.data.backgroundImage != null && bl) {
            OS.XClearArea(n9, n10, n, n2, n3, n4, true);
            OS.XClearArea(n9, n10, n5, n6, n3, n4, true);
            return;
        }
        if (this.data.image == null && bl) {
            OS.XSetGraphicsExposures(n9, this.handle, true);
        }
        OS.XCopyArea(n9, n10, n10, this.handle, n, n2, n3, n4, n5, n6);
        if (this.data.image == null && bl) {
            boolean bl2;
            OS.XSetGraphicsExposures(n9, this.handle, false);
            boolean bl3 = bl2 = n5 + n3 < n || n + n3 < n5 || n6 + n4 < n2 || n2 + n4 < n6;
            if (bl2) {
                OS.XClearArea(n9, n10, n, n2, n3, n4, true);
            } else {
                int n11;
                if (n7 != 0) {
                    n11 = n5 - n7;
                    if (n7 < 0) {
                        n11 = n5 + n3;
                    }
                    OS.XClearArea(n9, n10, n11, n2, Math.abs(n7), n4, true);
                }
                if (n8 != 0) {
                    n11 = n6 - n8;
                    if (n8 < 0) {
                        n11 = n6 + n4;
                    }
                    OS.XClearArea(n9, n10, n, n11, n3, Math.abs(n8), true);
                }
            }
        }
    }

    public void copyArea(Image image, int n, int n2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        Rectangle rectangle = image.getBounds();
        int n3 = this.data.display;
        int n4 = OS.XCreateGC(n3, image.pixmap, 0, null);
        if (n4 == 0) {
            SWT.error(2);
        }
        OS.XSetSubwindowMode(n3, n4, 1);
        OS.XCopyArea(n3, this.data.drawable, image.pixmap, n4, n, n2, rectangle.width, rectangle.height, 0, 0);
        OS.XFreeGC(n3, n4);
    }

    void destroy() {
        int n;
        int n2;
        int n3;
        int n4;
        Image image;
        int n5 = this.data.cairo;
        if (n5 != 0) {
            Cairo.cairo_destroy(n5);
        }
        this.data.cairo = 0;
        int n6 = this.data.clipRgn;
        if (n6 != 0) {
            OS.XDestroyRegion(n6);
        }
        if ((image = this.data.image) != null) {
            image.memGC = null;
            if (image.transparentPixel != -1) {
                image.createMask();
            }
        }
        if ((n4 = this.data.renderTable) != 0) {
            OS.XmRenderTableFree(n4);
        }
        if ((n3 = this.data.xmString) != 0) {
            OS.XmStringFree(n3);
        }
        if ((n2 = this.data.xmText) != 0) {
            OS.XmStringFree(n2);
        }
        if ((n = this.data.xmMnemonic) != 0) {
            OS.XmStringFree(n);
        }
        if (this.drawable != null) {
            this.drawable.internal_dispose_GC(this.handle, this.data);
        }
        this.data.xmMnemonic = 0;
        this.data.xmText = 0;
        this.data.xmString = 0;
        this.data.renderTable = 0;
        this.data.clipRgn = 0;
        this.data.colormap = 0;
        this.data.drawable = 0;
        this.data.display = 0;
        this.data.font = null;
        this.drawable = null;
        this.handle = 0;
        this.data.image = null;
        this.data = null;
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2297);
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n3 == 0 || n4 == 0 || n6 == 0) {
            return;
        }
        int n7 = this.data.cairo;
        if (n7 != 0) {
            double d = this.data.cairoXoffset;
            double d2 = this.data.cairoYoffset;
            if (n3 == n4) {
                if (n6 >= 0) {
                    Cairo.cairo_arc_negative(n7, (double)n + d + (double)((float)n3 / 2.0f), (double)n2 + d2 + (double)((float)n4 / 2.0f), (float)n3 / 2.0f, (float)(-n5) * (float)Compatibility.PI / 180.0f, (float)(-(n5 + n6)) * (float)Compatibility.PI / 180.0f);
                } else {
                    Cairo.cairo_arc(n7, (double)n + d + (double)((float)n3 / 2.0f), (double)n2 + d2 + (double)((float)n4 / 2.0f), (float)n3 / 2.0f, (float)(-n5) * (float)Compatibility.PI / 180.0f, (float)(-(n5 + n6)) * (float)Compatibility.PI / 180.0f);
                }
            } else {
                Cairo.cairo_save(n7);
                Cairo.cairo_translate(n7, (double)n + d + (double)((float)n3 / 2.0f), (double)n2 + d2 + (double)((float)n4 / 2.0f));
                Cairo.cairo_scale(n7, (float)n3 / 2.0f, (float)n4 / 2.0f);
                if (n6 >= 0) {
                    Cairo.cairo_arc_negative(n7, 0.0, 0.0, 1.0, (float)(-n5) * (float)Compatibility.PI / 180.0f, (float)(-(n5 + n6)) * (float)Compatibility.PI / 180.0f);
                } else {
                    Cairo.cairo_arc(n7, 0.0, 0.0, 1.0, (float)(-n5) * (float)Compatibility.PI / 180.0f, (float)(-(n5 + n6)) * (float)Compatibility.PI / 180.0f);
                }
                Cairo.cairo_restore(n7);
            }
            Cairo.cairo_stroke(n7);
            return;
        }
        OS.XDrawArc(this.data.display, this.data.drawable, this.handle, n, n2, n3, n4, n5 * 64, n6 * 64);
    }

    public void drawFocus(int n, int n2, int n3, int n4) {
        int n5;
        if (this.handle == 0) {
            SWT.error(44);
        }
        int n6 = this.data.display;
        int n7 = this.data.drawable;
        int n8 = 0;
        int n9 = OS.XtWindowToWidget(n6, n7);
        if (n9 != 0) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNhighlightColor;
            int[] nArray2 = nArray;
            OS.XtGetValues(n9, nArray2, nArray2.length / 2);
            n8 = nArray2[1];
        }
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if ((n5 = this.data.cairo) != 0) {
            boolean bl = true;
            Cairo.cairo_save(n5);
            Cairo.cairo_set_line_width(n5, (double)bl);
            XColor xColor = new XColor();
            xColor.pixel = n8;
            OS.XQueryColor(this.data.display, this.data.colormap, xColor);
            Cairo.cairo_set_source_rgba(n5, (float)(xColor.red & 0xFFFF) / 65535.0f, (float)(xColor.green & 0xFFFF) / 65535.0f, (float)(xColor.blue & 0xFFFF) / 65535.0f, 1.0);
            Cairo.cairo_rectangle(n5, (float)n + (float)bl / 2.0f, (float)n2 + (float)bl / 2.0f, n3, n4);
            Cairo.cairo_stroke(n5);
            Cairo.cairo_restore(n5);
            return;
        }
        OS.XSetForeground(n6, this.handle, n8);
        OS.XDrawRectangle(n6, n7, this.handle, n, n2, n3 - 1, n4 - 1);
        this.data.state &= 0xFFFFFFFC;
    }

    public void drawImage(Image image, int n, int n2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, 0, 0, -1, -1, n, n2, -1, -1, true);
    }

    public void drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n3 == 0 || n4 == 0 || n7 == 0 || n8 == 0) {
            return;
        }
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0 || n7 < 0 || n8 < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, false);
    }

    void drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        OS.XGetGeometry(this.data.display, image.pixmap, nArray4, nArray4, nArray4, nArray, nArray2, nArray4, nArray3);
        int n9 = nArray[0];
        int n10 = nArray2[0];
        if (bl) {
            n3 = n7 = n9;
            n4 = n8 = n10;
        } else {
            boolean bl2 = bl = n == 0 && n2 == 0 && n3 == n7 && n7 == n9 && n4 == n8 && n8 == n10;
            if (n + n3 > n9 || n2 + n4 > n10) {
                SWT.error(5);
            }
        }
        int n11 = this.data.cairo;
        if (n11 != 0) {
            if (this.data.alpha != 0) {
                image.createSurface();
                Cairo.cairo_save(n11);
                Cairo.cairo_rectangle(n11, n5, n6, n7, n8);
                Cairo.cairo_clip(n11);
                Cairo.cairo_translate(n11, n5 - n, n6 - n2);
                if (n3 != n7 || n4 != n8) {
                    Cairo.cairo_scale(n11, (float)n7 / (float)n3, (float)n8 / (float)n4);
                }
                int n12 = 1;
                switch (this.data.interpolation) {
                    case -1: {
                        n12 = 1;
                        break;
                    }
                    case 0: {
                        n12 = 3;
                        break;
                    }
                    case 1: {
                        n12 = 0;
                        break;
                    }
                    case 2: {
                        n12 = 2;
                    }
                }
                int n13 = Cairo.cairo_pattern_create_for_surface(image.surface);
                if (n13 == 0) {
                    SWT.error(2);
                }
                if ((n3 != n7 || n4 != n8) && Cairo.cairo_version() >= Cairo.CAIRO_VERSION_ENCODE(1, 4, 2)) {
                    int n14 = Cairo.cairo_image_surface_create(0, n9 * 3, n10 * 3);
                    int n15 = Cairo.cairo_create(n14);
                    Cairo.cairo_set_source_surface(n15, image.surface, n9, n10);
                    Cairo.cairo_paint(n15);
                    Cairo.cairo_scale(n15, -1.0, -1.0);
                    Cairo.cairo_set_source_surface(n15, image.surface, -n9, -n10);
                    Cairo.cairo_paint(n15);
                    Cairo.cairo_set_source_surface(n15, image.surface, -n9 * 3, -n10);
                    Cairo.cairo_paint(n15);
                    Cairo.cairo_set_source_surface(n15, image.surface, -n9, -n10 * 3);
                    Cairo.cairo_paint(n15);
                    Cairo.cairo_set_source_surface(n15, image.surface, -n9 * 3, -n10 * 3);
                    Cairo.cairo_paint(n15);
                    Cairo.cairo_scale(n15, 1.0, -1.0);
                    Cairo.cairo_set_source_surface(n15, image.surface, -n9, n10);
                    Cairo.cairo_paint(n15);
                    Cairo.cairo_set_source_surface(n15, image.surface, -n9 * 3, n10);
                    Cairo.cairo_paint(n15);
                    Cairo.cairo_scale(n15, -1.0, -1.0);
                    Cairo.cairo_set_source_surface(n15, image.surface, n9, -n10);
                    Cairo.cairo_paint(n15);
                    Cairo.cairo_set_source_surface(n15, image.surface, n9, -n10 * 3);
                    Cairo.cairo_paint(n15);
                    Cairo.cairo_destroy(n15);
                    int n16 = Cairo.cairo_pattern_create_for_surface(n14);
                    Cairo.cairo_surface_destroy(n14);
                    if (n16 == 0) {
                        SWT.error(2);
                    }
                    Cairo.cairo_pattern_destroy(n13);
                    n13 = n16;
                    Cairo.cairo_pattern_set_extend(n13, 3);
                    double[] dArray = new double[6];
                    Cairo.cairo_matrix_init_translate(dArray, n9, n10);
                    Cairo.cairo_pattern_set_matrix(n13, dArray);
                }
                Cairo.cairo_pattern_set_filter(n13, n12);
                Cairo.cairo_set_source(n11, n13);
                if (this.data.alpha != 255) {
                    Cairo.cairo_paint_with_alpha(n11, (float)this.data.alpha / 255.0f);
                } else {
                    Cairo.cairo_paint(n11);
                }
                Cairo.cairo_restore(n11);
                Cairo.cairo_pattern_destroy(n13);
            }
            return;
        }
        if (image.alpha != -1 || image.alphaData != null) {
            this.drawImageAlpha(image, n, n2, n3, n4, n5, n6, n7, n8, bl, n9, n10, nArray3[0]);
        } else if (image.transparentPixel != -1 || image.mask != 0) {
            this.drawImageMask(image, n, n2, n3, n4, n5, n6, n7, n8, bl, n9, n10, nArray3[0]);
        } else {
            this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, bl, n9, n10, nArray3[0]);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void drawImageAlpha(Image var1_1, int var2_2, int var3_3, int var4_4, int var5_5, int var6_6, int var7_7, int var8_8, int var9_9, boolean var10_10, int var11_11, int var12_12, int var13_13) {
        block21: {
            block18: {
                block19: {
                    if (var1_1.alpha == 0) {
                        return;
                    }
                    if (var1_1.alpha == 255) {
                        this.drawImage(var1_1, var2_2, var3_3, var4_4, var5_5, var6_6, var7_7, var8_8, var9_9, var10_10, var11_11, var12_12, var13_13);
                        return;
                    }
                    if (this.device.useXRender) {
                        this.drawImageXRender(var1_1, var2_2, var3_3, var4_4, var5_5, var6_6, var7_7, var8_8, var9_9, var10_10, var11_11, var12_12, var1_1.mask, 2);
                        return;
                    }
                    var14_14 = this.getClipping();
                    if ((var14_14 = var14_14.intersection(new Rectangle(var6_6, var7_7, var8_8, var9_9))).isEmpty()) {
                        return;
                    }
                    var15_15 = var2_2 + (var14_14.x - var6_6) * var4_4 / var8_8;
                    var16_16 = var2_2 + (var14_14.x + var14_14.width - var6_6) * var4_4 / var8_8;
                    var17_17 = var3_3 + (var14_14.y - var7_7) * var5_5 / var9_9;
                    var18_18 = var3_3 + (var14_14.y + var14_14.height - var7_7) * var5_5 / var9_9;
                    var6_6 = var14_14.x;
                    var7_7 = var14_14.y;
                    var8_8 = var14_14.width;
                    var9_9 = var14_14.height;
                    var2_2 = var15_15;
                    var3_3 = var17_17;
                    var4_4 = Math.max(1, var16_16 - var15_15);
                    var5_5 = Math.max(1, var18_18 - var17_17);
                    var19_19 = this.data.display;
                    var20_20 = this.data.drawable;
                    var21_21 = 0;
                    var22_22 = 0;
                    try {
                        block20: {
                            var21_21 = OS.XGetImage(var19_19, var20_20, var6_6, var7_7, var8_8, var9_9, -1, 2);
                            if (var21_21 == 0) {
                                while (true) {
                                    var35_23 = null;
                                    if (var22_22 == 0) break block18;
                                    break block19;
                                    break;
                                }
                            }
                            var23_26 = new XImage();
                            OS.memmove(var23_26, var21_21, 88);
                            var24_27 = new byte[var23_26.bytes_per_line * var23_26.height];
                            OS.memmove(var24_27, var23_26.data, var24_27.length);
                            var22_22 = OS.XGetImage(var19_19, var1_1.pixmap, var2_2, var3_3, var4_4, var5_5, -1, 2);
                            if (var22_22 == 0) ** continue;
                            var25_28 = new XImage();
                            OS.memmove(var25_28, var22_22, 88);
                            var26_29 = new byte[var25_28.bytes_per_line * var25_28.height];
                            OS.memmove(var26_29, var25_28.data, var26_29.length);
                            if (var25_28.depth <= 8) {
                                var27_30 = this.data.device.xcolors;
                                if (var27_30 == null) {
                                    SWT.error(38);
                                }
                                var28_32 = new byte[var27_30.length];
                                var29_34 = new byte[var27_30.length];
                                var30_36 = new byte[var27_30.length];
                                var31_38 = 0;
                                while (true) {
                                    if (var31_38 >= var27_30.length) {
                                        ImageData.blit(2, var26_29, var25_28.bits_per_pixel, var25_28.bytes_per_line, var25_28.byte_order, 0, 0, var4_4, var5_5, var28_32, var29_34, var30_36, var1_1.alpha, var1_1.alphaData, var11_11, var2_2, var3_3, var24_27, var23_26.bits_per_pixel, var23_26.bytes_per_line, var23_26.byte_order, 0, 0, var8_8, var9_9, var28_32, var29_34, var30_36, false, false);
                                        break block20;
                                    }
                                    var32_40 = var27_30[var31_38];
                                    if (var32_40 != null) {
                                        var28_32[var31_38] = (byte)(var32_40.red >> 8 & 255);
                                        var29_34[var31_38] = (byte)(var32_40.green >> 8 & 255);
                                        var30_36[var31_38] = (byte)(var32_40.blue >> 8 & 255);
                                    }
                                    ++var31_38;
                                }
                            }
                            var27_31 = var25_28.red_mask;
                            var28_33 = var25_28.green_mask;
                            var29_35 = var25_28.blue_mask;
                            var30_37 = var23_26.red_mask;
                            var31_39 = var23_26.green_mask;
                            var32_41 = var23_26.blue_mask;
                            var33_42 = OS.XDefaultVisual(var19_19, OS.XDefaultScreen(var19_19));
                            var34_43 = new Visual();
                            OS.memmove(var34_43, var33_42, 32);
                            if (var27_31 == 0 && var28_33 == 0 && var29_35 == 0) {
                                var27_31 = var34_43.red_mask;
                                var28_33 = var34_43.green_mask;
                                var29_35 = var34_43.blue_mask;
                            }
                            if (var30_37 == 0 && var31_39 == 0 && var32_41 == 0) {
                                var30_37 = var34_43.red_mask;
                                var31_39 = var34_43.green_mask;
                                var32_41 = var34_43.blue_mask;
                            }
                            ImageData.blit(2, var26_29, var25_28.bits_per_pixel, var25_28.bytes_per_line, var25_28.byte_order, 0, 0, var4_4, var5_5, var27_31, var28_33, var29_35, var1_1.alpha, var1_1.alphaData, var11_11, var2_2, var3_3, var24_27, var23_26.bits_per_pixel, var23_26.bytes_per_line, var23_26.byte_order, 0, 0, var8_8, var9_9, var30_37, var31_39, var32_41, false, false);
                        }
                        OS.memmove(var23_26.data, var24_27, var24_27.length);
                        OS.XPutImage(var19_19, var20_20, this.handle, var21_21, 0, 0, var6_6, var7_7, var8_8, var9_9);
                        break block21;
                    }
                    catch (Throwable var36_44) {
                        var35_24 = null;
                        if (var22_22 != 0) {
                            OS.XDestroyImage(var22_22);
                        }
                        if (var21_21 == 0) throw var36_44;
                        OS.XDestroyImage(var21_21);
                        throw var36_44;
                    }
                }
                OS.XDestroyImage(var22_22);
            }
            if (var21_21 == 0) return;
            OS.XDestroyImage(var21_21);
            return;
        }
        var35_25 = null;
        if (var22_22 != 0) {
            OS.XDestroyImage(var22_22);
        }
        if (var21_21 == 0) return;
        OS.XDestroyImage(var21_21);
    }

    void drawImageMask(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, int n9, int n10, int n11) {
        int n12 = this.data.display;
        int n13 = this.data.drawable;
        if (image.transparentPixel != -1) {
            image.createMask();
        }
        if (this.device.useXRender) {
            this.drawImageXRender(image, n, n2, n3, n4, n5, n6, n7, n8, bl, n9, n10, image.mask, 4);
        } else {
            int n14 = 0;
            int n15 = 0;
            int n16 = 0;
            if (bl || n3 == n7 && n4 == n8) {
                n14 = image.pixmap;
                n15 = image.mask;
            } else {
                int n17 = GC.scalePixmap(n12, image.pixmap, n, n2, n3, n4, n5, n6, n7, n8, false, false);
                if (n17 != 0) {
                    int n18 = GC.scalePixmap(n12, image.mask, n, n2, n3, n4, n5, n6, n7, n8, false, false);
                    if (n18 != 0) {
                        n14 = OS.XCreatePixmap(n12, n13, n7, n8, n11);
                        int n19 = OS.XCreateGC(n12, n14, 0, null);
                        OS.XPutImage(n12, n14, n19, n17, 0, 0, 0, 0, n7, n8);
                        OS.XFreeGC(n12, n19);
                        n15 = OS.XCreatePixmap(n12, n13, n7, n8, 1);
                        n19 = OS.XCreateGC(n12, n15, 0, null);
                        OS.XPutImage(n12, n15, n19, n18, 0, 0, 0, 0, n7, n8);
                        OS.XFreeGC(n12, n19);
                        OS.XDestroyImage(n18);
                    }
                    OS.XDestroyImage(n17);
                }
                n2 = 0;
                n = 0;
                n3 = n7;
                n4 = n8;
                n16 ^= 0xFFFFFFFF;
            }
            if (n14 != 0 && n15 != 0) {
                XGCValues xGCValues = new XGCValues();
                OS.XGetGCValues(n12, this.handle, 13, xGCValues);
                OS.XSetFunction(n12, this.handle, 6);
                OS.XCopyArea(n12, n14, n13, this.handle, n, n2, n3, n4, n5, n6);
                OS.XSetForeground(n12, this.handle, n16);
                OS.XSetBackground(n12, this.handle, ~n16);
                OS.XSetFunction(n12, this.handle, 1);
                OS.XCopyPlane(n12, n15, n13, this.handle, n, n2, n3, n4, n5, n6, 1);
                OS.XSetFunction(n12, this.handle, 6);
                OS.XCopyArea(n12, n14, n13, this.handle, n, n2, n3, n4, n5, n6);
                OS.XSetForeground(n12, this.handle, xGCValues.foreground);
                OS.XSetBackground(n12, this.handle, xGCValues.background);
                OS.XSetFunction(n12, this.handle, xGCValues.function);
            }
            if (n14 != 0 && image.pixmap != n14) {
                OS.XFreePixmap(n12, n14);
            }
            if (n15 != 0 && image.mask != n15) {
                OS.XFreePixmap(n12, n15);
            }
        }
        if (image.transparentPixel != -1 && image.memGC != null) {
            image.destroyMask();
        }
    }

    void drawImageXRender(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, int n9, int n10, int n11, int n12) {
        int n13;
        int n14;
        int n15;
        int n16 = this.data.drawable;
        int n17 = this.data.display;
        int n18 = 0;
        if (n11 != 0) {
            n15 = 0;
            XRenderPictureAttributes xRenderPictureAttributes = null;
            if (image.alpha != -1) {
                n15 = 1;
                xRenderPictureAttributes = new XRenderPictureAttributes();
                xRenderPictureAttributes.repeat = true;
            }
            if ((n18 = OS.XRenderCreatePicture(n17, n11, OS.XRenderFindStandardFormat(n17, n12), n15, xRenderPictureAttributes)) == 0) {
                SWT.error(2);
            }
        }
        if ((n14 = OS.XRenderCreatePicture(n17, n16, n15 = OS.XRenderFindVisualFormat(n17, OS.XDefaultVisual(n17, OS.XDefaultScreen(n17))), 0, null)) == 0) {
            SWT.error(2);
        }
        if ((n13 = OS.XRenderCreatePicture(n17, image.pixmap, n15, 0, null)) == 0) {
            SWT.error(2);
        }
        if (n3 != n7 || n4 != n8) {
            int[] nArray = new int[9];
            nArray[0] = (int)((float)n3 / (float)n7 * 65536.0f);
            nArray[4] = (int)((float)n4 / (float)n8 * 65536.0f);
            nArray[8] = 65536;
            int[] nArray2 = nArray;
            OS.XRenderSetPictureTransform(n17, n13, nArray2);
            if (n18 != 0) {
                OS.XRenderSetPictureTransform(n17, n18, nArray2);
            }
            n = (int)((float)n * ((float)n7 / (float)n3));
            n2 = (int)((float)n2 * ((float)n8 / (float)n4));
        }
        int n19 = this.data.clipRgn;
        if (this.data.damageRgn != 0) {
            if (n19 == 0) {
                n19 = this.data.damageRgn;
            } else {
                n19 = OS.XCreateRegion();
                OS.XUnionRegion(n19, this.data.clipRgn, n19);
                OS.XIntersectRegion(n19, this.data.damageRgn, n19);
            }
        }
        if (n19 != 0) {
            OS.XRenderSetPictureClipRegion(n17, n14, n19);
            if (n19 != this.data.clipRgn && n19 != this.data.damageRgn) {
                OS.XDestroyRegion(n19);
            }
        }
        OS.XRenderComposite(n17, n18 != 0 ? 3 : 1, n13, n18, n14, n, n2, n, n2, n5, n6, n7, n8);
        OS.XRenderFreePicture(n17, n14);
        OS.XRenderFreePicture(n17, n13);
        if (n18 != 0) {
            OS.XRenderFreePicture(n17, n18);
        }
    }

    void drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, int n9, int n10, int n11) {
        int n12 = this.data.display;
        int n13 = this.data.drawable;
        if (n3 == n7 && n4 == n8) {
            OS.XCopyArea(n12, image.pixmap, n13, this.handle, n, n2, n3, n4, n5, n6);
            return;
        }
        if (this.device.useXRender) {
            this.drawImageXRender(image, n, n2, n3, n4, n5, n6, n7, n8, bl, n9, n10, 0, -1);
            return;
        }
        int n14 = GC.scalePixmap(n12, image.pixmap, n, n2, n3, n4, n5, n6, n7, n8, false, false);
        if (n14 != 0) {
            OS.XPutImage(n12, n13, this.handle, n14, 0, 0, n5, n6, n7, n8);
            OS.XDestroyImage(n14);
        }
    }

    static int scalePixmap(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl, boolean bl2) {
        int n11 = OS.XGetImage(n, n2, n3, n4, n5, n6, -1, 2);
        if (n11 == 0) {
            return 0;
        }
        XImage xImage = new XImage();
        OS.memmove(xImage, n11, 88);
        byte[] byArray = new byte[xImage.bytes_per_line * xImage.height];
        OS.memmove(byArray, xImage.data, byArray.length);
        OS.XDestroyImage(n11);
        int n12 = 0;
        int n13 = OS.XDefaultVisual(n, OS.XDefaultScreen(n));
        switch (xImage.bits_per_pixel) {
            case 1: 
            case 4: 
            case 8: {
                int n14;
                int n15 = xImage.bits_per_pixel == 1 ? 0 : 2;
                n12 = OS.XCreateImage(n, n13, xImage.depth, n15, 0, 0, n9, n10, xImage.bitmap_pad, 0);
                if (n12 == 0) {
                    return 0;
                }
                XImage xImage2 = new XImage();
                OS.memmove(xImage2, n12, 88);
                int n16 = xImage2.bytes_per_line * xImage2.height;
                if (n16 < 0) {
                    OS.XDestroyImage(n12);
                    return 0;
                }
                xImage2.data = n14 = OS.XtMalloc(n16);
                OS.memmove(n12, xImage2, 88);
                byte[] byArray2 = new byte[n16];
                int n17 = xImage.bits_per_pixel == 1 ? xImage.bitmap_bit_order : xImage.byte_order;
                int n18 = xImage2.bits_per_pixel == 1 ? xImage2.bitmap_bit_order : xImage2.byte_order;
                ImageData.blit(1, byArray, xImage.bits_per_pixel, xImage.bytes_per_line, n17, 0, 0, n5, n6, null, null, null, 255, null, 0, 0, 0, byArray2, xImage2.bits_per_pixel, xImage2.bytes_per_line, n18, 0, 0, n9, n10, null, null, null, bl, bl2);
                OS.memmove(n14, byArray2, n16);
                break;
            }
            case 16: 
            case 24: 
            case 32: {
                int n19;
                n12 = OS.XCreateImage(n, n13, xImage.depth, 2, 0, 0, n9, n10, xImage.bitmap_pad, 0);
                if (n12 == 0) {
                    return 0;
                }
                XImage xImage3 = new XImage();
                OS.memmove(xImage3, n12, 88);
                int n20 = xImage3.bytes_per_line * xImage3.height;
                if (n20 < 0) {
                    OS.XDestroyImage(n12);
                    return 0;
                }
                xImage3.data = n19 = OS.XtMalloc(n20);
                OS.memmove(n12, xImage3, 88);
                byte[] byArray3 = new byte[n20];
                ImageData.blit(1, byArray, xImage.bits_per_pixel, xImage.bytes_per_line, xImage.byte_order, 0, 0, n5, n6, 0, 0, 0, 255, null, 0, 0, 0, byArray3, xImage3.bits_per_pixel, xImage3.bytes_per_line, xImage3.byte_order, 0, 0, n9, n10, 0, 0, 0, bl, bl2);
                OS.memmove(n19, byArray3, n20);
            }
        }
        return n12;
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2297);
        int n5 = this.data.cairo;
        if (n5 != 0) {
            double d = this.data.cairoXoffset;
            double d2 = this.data.cairoYoffset;
            Cairo.cairo_move_to(n5, (double)n + d, (double)n2 + d2);
            Cairo.cairo_line_to(n5, (double)n3 + d, (double)n4 + d2);
            Cairo.cairo_stroke(n5);
            return;
        }
        OS.XDrawLine(this.data.display, this.data.drawable, this.handle, n, n2, n3, n4);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        int n5;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2297);
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if ((n5 = this.data.cairo) != 0) {
            double d = this.data.cairoXoffset;
            double d2 = this.data.cairoYoffset;
            if (n3 == n4) {
                Cairo.cairo_arc_negative(n5, (double)n + d + (double)((float)n3 / 2.0f), (double)n2 + d2 + (double)((float)n4 / 2.0f), (float)n3 / 2.0f, 0.0, -2.0f * (float)Compatibility.PI);
            } else {
                Cairo.cairo_save(n5);
                Cairo.cairo_translate(n5, (double)n + d + (double)((float)n3 / 2.0f), (double)n2 + d2 + (double)((float)n4 / 2.0f));
                Cairo.cairo_scale(n5, (float)n3 / 2.0f, (float)n4 / 2.0f);
                Cairo.cairo_arc_negative(n5, 0.0, 0.0, 1.0, 0.0, -2.0f * (float)Compatibility.PI);
                Cairo.cairo_restore(n5);
            }
            Cairo.cairo_stroke(n5);
            return;
        }
        OS.XDrawArc(this.data.display, this.data.drawable, this.handle, n, n2, n3, n4, 0, 23040);
    }

    public void drawPath(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0) {
            SWT.error(5);
        }
        this.initCairo();
        this.checkGC(2297);
        int n = this.data.cairo;
        Cairo.cairo_save(n);
        double d = this.data.cairoXoffset;
        double d2 = this.data.cairoYoffset;
        Cairo.cairo_translate(n, d, d2);
        int n2 = Cairo.cairo_copy_path(path.handle);
        if (n2 == 0) {
            SWT.error(2);
        }
        Cairo.cairo_append_path(n, n2);
        Cairo.cairo_path_destroy(n2);
        Cairo.cairo_stroke(n);
        Cairo.cairo_restore(n);
    }

    public void drawPoint(int n, int n2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2297);
        int n3 = this.data.cairo;
        if (n3 != 0) {
            Cairo.cairo_rectangle(n3, n, n2, 1.0, 1.0);
            Cairo.cairo_fill(n3);
            return;
        }
        OS.XDrawPoint(this.data.display, this.data.drawable, this.handle, n, n2);
    }

    public void drawPolygon(int[] nArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        this.checkGC(2297);
        int n = this.data.cairo;
        if (n != 0) {
            this.drawPolyline(n, nArray, true);
            Cairo.cairo_stroke(n);
            return;
        }
        int n2 = nArray.length;
        if (n2 < 4) {
            this.drawPolyline(nArray);
            return;
        }
        if (nArray[0] == nArray[n2 - 2] && nArray[1] == nArray[n2 - 1]) {
            this.drawPolyline(nArray);
            return;
        }
        int[] nArray2 = new int[n2 + 2];
        int n3 = 0;
        while (n3 < n2) {
            nArray2[n3] = nArray[n3];
            ++n3;
        }
        nArray2[n2] = nArray[0];
        nArray2[n2 + 1] = nArray[1];
        this.drawPolyline(nArray2);
    }

    public void drawPolyline(int[] nArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        this.checkGC(2297);
        int n = this.data.cairo;
        if (n != 0) {
            this.drawPolyline(n, nArray, false);
            Cairo.cairo_stroke(n);
            return;
        }
        short[] sArray = new short[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            sArray[n2] = (short)nArray[n2];
            ++n2;
        }
        OS.XDrawLines(this.data.display, this.data.drawable, this.handle, sArray, sArray.length / 2, 0);
    }

    void drawPolyline(int n, int[] nArray, boolean bl) {
        int n2 = nArray.length / 2;
        if (n2 == 0) {
            return;
        }
        double d = this.data.cairoXoffset;
        double d2 = this.data.cairoYoffset;
        Cairo.cairo_move_to(n, (double)nArray[0] + d, (double)nArray[1] + d2);
        int n3 = 1;
        int n4 = 2;
        while (n3 < n2) {
            Cairo.cairo_line_to(n, (double)nArray[n4] + d, (double)nArray[n4 + 1] + d2);
            ++n3;
            n4 += 2;
        }
        if (bl) {
            Cairo.cairo_close_path(n);
        }
    }

    public void drawRectangle(int n, int n2, int n3, int n4) {
        int n5;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2297);
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if ((n5 = this.data.cairo) != 0) {
            double d = this.data.cairoXoffset;
            double d2 = this.data.cairoYoffset;
            Cairo.cairo_rectangle(n5, (double)n + d, (double)n2 + d2, n3, n4);
            Cairo.cairo_stroke(n5);
            return;
        }
        OS.XDrawRectangle(this.data.display, this.data.drawable, this.handle, n, n2, n3, n4);
    }

    public void drawRectangle(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error(4);
        }
        this.drawRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawRoundRectangle(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2297);
        int n8 = n;
        int n9 = n2;
        int n10 = n3;
        int n11 = n4;
        int n12 = n5;
        int n13 = n6;
        if (n10 < 0) {
            n10 = 0 - n10;
            n8 -= n10;
        }
        if (n11 < 0) {
            n11 = 0 - n11;
            n9 -= n11;
        }
        if (n12 < 0) {
            n12 = 0 - n12;
        }
        if (n13 < 0) {
            n13 = 0 - n13;
        }
        if ((n7 = this.data.cairo) != 0) {
            double d = this.data.cairoXoffset;
            double d2 = this.data.cairoYoffset;
            if (n12 == 0 || n13 == 0) {
                Cairo.cairo_rectangle(n7, (double)n + d, (double)n2 + d2, n3, n4);
            } else {
                float f = (float)n12 / 2.0f;
                float f2 = (float)n13 / 2.0f;
                float f3 = (float)n10 / f;
                float f4 = (float)n11 / f2;
                Cairo.cairo_save(n7);
                Cairo.cairo_translate(n7, (double)n8 + d, (double)n9 + d2);
                Cairo.cairo_scale(n7, f, f2);
                Cairo.cairo_move_to(n7, f3 - 1.0f, 0.0);
                Cairo.cairo_arc(n7, f3 - 1.0f, 1.0, 1.0, Compatibility.PI + Compatibility.PI / 2.0, Compatibility.PI * 2.0);
                Cairo.cairo_arc(n7, f3 - 1.0f, f4 - 1.0f, 1.0, 0.0, Compatibility.PI / 2.0);
                Cairo.cairo_arc(n7, 1.0, f4 - 1.0f, 1.0, Compatibility.PI / 2.0, Compatibility.PI);
                Cairo.cairo_arc(n7, 1.0, 1.0, 1.0, Compatibility.PI, 270.0 * Compatibility.PI / 180.0);
                Cairo.cairo_close_path(n7);
                Cairo.cairo_restore(n7);
            }
            Cairo.cairo_stroke(n7);
            return;
        }
        int n14 = n12 / 2;
        int n15 = n13 / 2;
        int n16 = this.data.display;
        int n17 = this.data.drawable;
        if (n10 > n12) {
            if (n11 > n13) {
                OS.XDrawArc(n16, n17, this.handle, n8, n9, n12, n13, 5760, 5760);
                OS.XDrawLine(n16, n17, this.handle, n8 + n14, n9, n8 + n10 - n14, n9);
                OS.XDrawArc(n16, n17, this.handle, n8 + n10 - n12, n9, n12, n13, 0, 5760);
                OS.XDrawLine(n16, n17, this.handle, n8 + n10, n9 + n15, n8 + n10, n9 + n11 - n15);
                OS.XDrawArc(n16, n17, this.handle, n8 + n10 - n12, n9 + n11 - n13, n12, n13, 17280, 5760);
                OS.XDrawLine(n16, n17, this.handle, n8 + n14, n9 + n11, n8 + n10 - n14, n9 + n11);
                OS.XDrawArc(n16, n17, this.handle, n8, n9 + n11 - n13, n12, n13, 11520, 5760);
                OS.XDrawLine(n16, n17, this.handle, n8, n9 + n15, n8, n9 + n11 - n15);
            } else {
                OS.XDrawArc(n16, n17, this.handle, n8, n9, n12, n11, 5760, 11520);
                OS.XDrawLine(n16, n17, this.handle, n8 + n14, n9, n8 + n10 - n14, n9);
                OS.XDrawArc(n16, n17, this.handle, n8 + n10 - n12, n9, n12, n11, 17280, 11520);
                OS.XDrawLine(n16, n17, this.handle, n8 + n14, n9 + n11, n8 + n10 - n14, n9 + n11);
            }
        } else if (n11 > n13) {
            OS.XDrawArc(n16, n17, this.handle, n8, n9, n10, n13, 0, 11520);
            OS.XDrawLine(n16, n17, this.handle, n8 + n10, n9 + n15, n8 + n10, n9 + n11 - n15);
            OS.XDrawArc(n16, n17, this.handle, n8, n9 + n11 - n13, n10, n13, 11520, 11520);
            OS.XDrawLine(n16, n17, this.handle, n8, n9 + n15, n8, n9 + n11 - n15);
        } else {
            OS.XDrawArc(n16, n17, this.handle, n8, n9, n10, n11, 0, 23040);
        }
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, n, n2, false);
    }

    public void drawString(String string, int n, int n2, boolean bl) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return;
        }
        int n3 = this.data.cairo;
        if (n3 != 0) {
            this.checkGC(5);
            cairo_font_extents_t cairo_font_extents_t2 = new cairo_font_extents_t();
            Cairo.cairo_font_extents(n3, cairo_font_extents_t2);
            double d = (double)n2 + cairo_font_extents_t2.ascent;
            Cairo.cairo_move_to(n3, n, d);
            byte[] byArray = Converter.wcsToMbcs(null, string, true);
            Cairo.cairo_show_text(n3, byArray);
            Cairo.cairo_new_path(n3);
            return;
        }
        this.setString(string);
        this.checkGC(261);
        if (bl) {
            OS.XmStringDraw(this.data.display, this.data.drawable, this.data.font.handle, this.data.xmString, this.handle, n, n2, Integer.MAX_VALUE, 0, 0, null);
        } else {
            OS.XmStringDrawImage(this.data.display, this.data.drawable, this.data.font.handle, this.data.xmString, this.handle, n, n2, Integer.MAX_VALUE, 0, 0, null);
        }
    }

    void createRenderTable() {
        int n;
        int n2 = this.data.font.handle;
        byte[] byArray = new byte[2];
        byArray[0] = 32;
        byte[] byArray2 = byArray;
        int n3 = OS.XmStringCreate(byArray2, OS.XmFONTLIST_DEFAULT_TAG);
        int n4 = OS.XmStringWidth(n2, n3) * 8;
        OS.XmStringFree(n3);
        int[] nArray = new int[16];
        int n5 = OS.XmTabCreate(n4, (byte)0, (byte)1, (byte)0, null);
        int n6 = 0;
        while (n6 < nArray.length) {
            nArray[n6] = n5;
            ++n6;
        }
        n6 = OS.XmTabListInsertTabs(0, nArray, nArray.length, 0);
        int[] nArray2 = new int[1];
        if (!OS.XmFontListInitFontContext(nArray2, n2)) {
            SWT.error(2);
        }
        int n7 = nArray2[0];
        int n8 = 0;
        int[] nArray3 = new int[4];
        int n9 = 0;
        while ((n8 = OS.XmFontListNextEntry(n7)) != 0) {
            int n10;
            n = OS.XmFontListEntryGetFont(n8, nArray2);
            int n11 = n10 = nArray2[0] == 0 ? 0 : 1;
            if (n == 0) {
                SWT.error(2);
            }
            int[] nArray4 = new int[]{OS.XmNtabList, n6, OS.XmNfont, n, OS.XmNfontType, n10};
            int n12 = OS.XmRenditionCreate(this.data.device.shellHandle, OS.XmFONTLIST_DEFAULT_TAG, nArray4, nArray4.length / 2);
            nArray3[n9++] = n12;
            if (n9 != nArray3.length) continue;
            int[] nArray5 = new int[nArray3.length + 4];
            System.arraycopy(nArray5, 0, nArray3, 0, n9);
            nArray3 = nArray5;
        }
        OS.XmFontListFreeFontContext(n7);
        OS.XmTabFree(n5);
        OS.XmTabListFree(n6);
        this.data.renderTable = OS.XmRenderTableAddRenditions(0, nArray3, n9, 1);
        n = 0;
        while (n < n9) {
            OS.XmRenditionFree(nArray3[n]);
            ++n;
        }
    }

    public void drawText(String string, int n, int n2) {
        this.drawText(string, n, n2, 6);
    }

    public void drawText(String string, int n, int n2, boolean bl) {
        int n3 = 6;
        if (bl) {
            n3 |= 1;
        }
        this.drawText(string, n, n2, n3);
    }

    public void drawText(String string, int n, int n2, int n3) {
        int n4;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return;
        }
        int n5 = this.data.cairo;
        if (n5 != 0) {
            this.checkGC(5);
            cairo_font_extents_t cairo_font_extents_t2 = new cairo_font_extents_t();
            Cairo.cairo_font_extents(n5, cairo_font_extents_t2);
            double d = (double)n2 + cairo_font_extents_t2.ascent;
            Cairo.cairo_move_to(n5, n, d);
            byte[] byArray = Converter.wcsToMbcs(null, string, true);
            Cairo.cairo_show_text(n5, byArray);
            Cairo.cairo_new_path(n5);
            return;
        }
        this.setText(string, n3);
        this.checkGC(261);
        int n6 = this.data.display;
        int n7 = this.data.drawable;
        if (this.data.image != null) {
            OS.XtRegisterDrawable(n6, n7, this.data.device.shellHandle);
        }
        if ((n4 = this.data.xmMnemonic) != 0) {
            OS.XmStringDrawUnderline(n6, n7, this.data.renderTable, this.data.xmText, this.handle, n, n2, Integer.MAX_VALUE, 0, 0, null, n4);
        } else if ((n3 & 1) != 0) {
            OS.XmStringDraw(n6, n7, this.data.renderTable, this.data.xmText, this.handle, n, n2, Integer.MAX_VALUE, 0, 0, null);
        } else {
            OS.XmStringDrawImage(n6, n7, this.data.renderTable, this.data.xmText, this.handle, n, n2, Integer.MAX_VALUE, 0, 0, null);
        }
        if (this.data.image != null) {
            OS.XtUnregisterDrawable(n6, n7);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GC)) {
            return false;
        }
        return this.handle == ((GC)object).handle;
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2);
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n3 == 0 || n4 == 0 || n6 == 0) {
            return;
        }
        int n7 = this.data.cairo;
        if (n7 != 0) {
            if (n3 == n4) {
                if (n6 >= 0) {
                    Cairo.cairo_arc_negative(n7, (float)n + (float)n3 / 2.0f, (float)n2 + (float)n4 / 2.0f, (float)n3 / 2.0f, (float)(-n5) * (float)Compatibility.PI / 180.0f, (float)(-(n5 + n6)) * (float)Compatibility.PI / 180.0f);
                } else {
                    Cairo.cairo_arc(n7, (float)n + (float)n3 / 2.0f, (float)n2 + (float)n4 / 2.0f, (float)n3 / 2.0f, (float)(-n5) * (float)Compatibility.PI / 180.0f, (float)(-(n5 + n6)) * (float)Compatibility.PI / 180.0f);
                }
                Cairo.cairo_line_to(n7, (float)n + (float)n3 / 2.0f, (float)n2 + (float)n4 / 2.0f);
            } else {
                Cairo.cairo_save(n7);
                Cairo.cairo_translate(n7, (float)n + (float)n3 / 2.0f, (float)n2 + (float)n4 / 2.0f);
                Cairo.cairo_scale(n7, (float)n3 / 2.0f, (float)n4 / 2.0f);
                if (n6 >= 0) {
                    Cairo.cairo_arc_negative(n7, 0.0, 0.0, 1.0, (float)(-n5) * (float)Compatibility.PI / 180.0f, (float)(-(n5 + n6)) * (float)Compatibility.PI / 180.0f);
                } else {
                    Cairo.cairo_arc(n7, 0.0, 0.0, 1.0, (float)(-n5) * (float)Compatibility.PI / 180.0f, (float)(-(n5 + n6)) * (float)Compatibility.PI / 180.0f);
                }
                Cairo.cairo_line_to(n7, 0.0, 0.0);
                Cairo.cairo_restore(n7);
            }
            Cairo.cairo_fill(n7);
            return;
        }
        OS.XFillArc(this.data.display, this.data.drawable, this.handle, n, n2, n3, n4, n5 * 64, n6 * 64);
    }

    public void fillGradientRectangle(int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        int n6;
        int n7;
        RGB rGB;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n3 == 0 || n4 == 0) {
            return;
        }
        RGB rGB2 = this.getBackground().getRGB();
        RGB rGB3 = rGB = this.getForeground().getRGB();
        RGB rGB4 = rGB2;
        boolean bl2 = false;
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
            if (!bl) {
                bl2 = true;
            }
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
            if (bl) {
                bl2 = true;
            }
        }
        if (bl2) {
            rGB3 = rGB2;
            rGB4 = rGB;
        }
        if (rGB3.equals(rGB4)) {
            this.fillRectangle(n, n2, n3, n4);
            return;
        }
        int n8 = this.data.display;
        int n9 = OS.XDefaultScreen(n8);
        int n10 = OS.XDefaultScreenOfDisplay(n8);
        int n11 = OS.XDefaultVisual(n8, n9);
        Visual visual = new Visual();
        OS.memmove(visual, n11, 32);
        int n12 = OS.XDefaultDepthOfScreen(n10);
        boolean bl3 = n12 > 8;
        int n13 = this.data.cairo;
        if (n13 != 0) {
            int n14 = bl ? Cairo.cairo_pattern_create_linear(0.0, 0.0, 0.0, 1.0) : Cairo.cairo_pattern_create_linear(0.0, 0.0, 1.0, 0.0);
            Cairo.cairo_pattern_add_color_stop_rgba(n14, 0.0, (float)rGB3.red / 255.0f, (float)rGB3.green / 255.0f, (float)rGB3.blue / 255.0f, (float)this.data.alpha / 255.0f);
            Cairo.cairo_pattern_add_color_stop_rgba(n14, 1.0, (float)rGB4.red / 255.0f, (float)rGB4.green / 255.0f, (float)rGB4.blue / 255.0f, (float)this.data.alpha / 255.0f);
            Cairo.cairo_save(n13);
            Cairo.cairo_translate(n13, n, n2);
            Cairo.cairo_scale(n13, n3, n4);
            Cairo.cairo_rectangle(n13, 0.0, 0.0, 1.0, 1.0);
            Cairo.cairo_set_source(n13, n14);
            Cairo.cairo_fill(n13);
            Cairo.cairo_restore(n13);
            Cairo.cairo_pattern_destroy(n14);
            return;
        }
        if (bl3) {
            n7 = GC.getChannelWidth(visual.red_mask);
            n6 = GC.getChannelWidth(visual.green_mask);
            n5 = GC.getChannelWidth(visual.blue_mask);
        } else {
            n5 = 0;
            n6 = 0;
            n7 = 0;
        }
        ImageData.fillGradientRectangle(this, this.data.device, n, n2, n3, n4, bl, rGB3, rGB4, n7, n6, n5);
    }

    static int getChannelWidth(int n) {
        int n2 = 0;
        while (n != 0) {
            n2 += n & 1;
            n >>>= 1;
        }
        return n2;
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        int n5;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2);
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if ((n5 = this.data.cairo) != 0) {
            if (n3 == n4) {
                Cairo.cairo_arc_negative(n5, (float)n + (float)n3 / 2.0f, (float)n2 + (float)n4 / 2.0f, (float)n3 / 2.0f, 0.0, 2.0f * (float)Compatibility.PI);
            } else {
                Cairo.cairo_save(n5);
                Cairo.cairo_translate(n5, (float)n + (float)n3 / 2.0f, (float)n2 + (float)n4 / 2.0f);
                Cairo.cairo_scale(n5, (float)n3 / 2.0f, (float)n4 / 2.0f);
                Cairo.cairo_arc_negative(n5, 0.0, 0.0, 1.0, 0.0, 2.0f * (float)Compatibility.PI);
                Cairo.cairo_restore(n5);
            }
            Cairo.cairo_fill(n5);
            return;
        }
        OS.XFillArc(this.data.display, this.data.drawable, this.handle, n, n2, n3, n4, 0, 23040);
    }

    public void fillPath(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0) {
            SWT.error(5);
        }
        this.initCairo();
        this.checkGC(2);
        int n = this.data.cairo;
        int n2 = Cairo.cairo_copy_path(path.handle);
        if (n2 == 0) {
            SWT.error(2);
        }
        Cairo.cairo_append_path(n, n2);
        Cairo.cairo_path_destroy(n2);
        Cairo.cairo_fill(n);
    }

    public void fillPolygon(int[] nArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        this.checkGC(2);
        int n = this.data.cairo;
        if (n != 0) {
            this.drawPolyline(n, nArray, true);
            Cairo.cairo_fill(n);
            return;
        }
        short[] sArray = new short[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            sArray[n2] = (short)nArray[n2];
            ++n2;
        }
        OS.XFillPolygon(this.data.display, this.data.drawable, this.handle, sArray, sArray.length / 2, 0, 0);
    }

    public void fillRectangle(int n, int n2, int n3, int n4) {
        int n5;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2);
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if ((n5 = this.data.cairo) != 0) {
            Cairo.cairo_rectangle(n5, n, n2, n3, n4);
            Cairo.cairo_fill(n5);
            return;
        }
        OS.XFillRectangle(this.data.display, this.data.drawable, this.handle, n, n2, n3, n4);
    }

    public void fillRectangle(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error(4);
        }
        this.fillRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void fillRoundRectangle(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2);
        int n8 = n;
        int n9 = n2;
        int n10 = n3;
        int n11 = n4;
        int n12 = n5;
        int n13 = n6;
        if (n10 < 0) {
            n10 = 0 - n10;
            n8 -= n10;
        }
        if (n11 < 0) {
            n11 = 0 - n11;
            n9 -= n11;
        }
        if (n12 < 0) {
            n12 = 0 - n12;
        }
        if (n13 < 0) {
            n13 = 0 - n13;
        }
        if ((n7 = this.data.cairo) != 0) {
            if (n12 == 0 || n13 == 0) {
                Cairo.cairo_rectangle(n7, n, n2, n3, n4);
            } else {
                float f = (float)n12 / 2.0f;
                float f2 = (float)n13 / 2.0f;
                float f3 = (float)n10 / f;
                float f4 = (float)n11 / f2;
                Cairo.cairo_save(n7);
                Cairo.cairo_translate(n7, n8, n9);
                Cairo.cairo_scale(n7, f, f2);
                Cairo.cairo_move_to(n7, f3 - 1.0f, 0.0);
                Cairo.cairo_arc(n7, f3 - 1.0f, 1.0, 1.0, Compatibility.PI + Compatibility.PI / 2.0, Compatibility.PI * 2.0);
                Cairo.cairo_arc(n7, f3 - 1.0f, f4 - 1.0f, 1.0, 0.0, Compatibility.PI / 2.0);
                Cairo.cairo_arc(n7, 1.0, f4 - 1.0f, 1.0, Compatibility.PI / 2.0, Compatibility.PI);
                Cairo.cairo_arc(n7, 1.0, 1.0, 1.0, Compatibility.PI, 270.0 * Compatibility.PI / 180.0);
                Cairo.cairo_close_path(n7);
                Cairo.cairo_restore(n7);
            }
            Cairo.cairo_fill(n7);
            return;
        }
        int n14 = n12 / 2;
        int n15 = n13 / 2;
        int n16 = this.data.display;
        int n17 = this.data.drawable;
        if (n10 > n12) {
            if (n11 > n13) {
                OS.XFillArc(n16, n17, this.handle, n8, n9, n12, n13, 5760, 5760);
                OS.XFillRectangle(n16, n17, this.handle, n8 + n14, n9, n10 - n14 * 2, n15);
                OS.XFillArc(n16, n17, this.handle, n8 + n10 - n12, n9, n12, n13, 0, 5760);
                OS.XFillRectangle(n16, n17, this.handle, n8, n9 + n15, n10, n11 - n15 * 2);
                OS.XFillArc(n16, n17, this.handle, n8 + n10 - n12, n9 + n11 - n13, n12, n13, 17280, 5760);
                OS.XFillRectangle(n16, n17, this.handle, n8 + n14, n9 + n11 - n15, n10 - n14 * 2, n15);
                OS.XFillArc(n16, n17, this.handle, n8, n9 + n11 - n13, n12, n13, 11520, 5760);
            } else {
                OS.XFillArc(n16, n17, this.handle, n8, n9, n12, n11, 5760, 11520);
                OS.XFillRectangle(n16, n17, this.handle, n8 + n14, n9, n10 - n14 * 2, n11);
                OS.XFillArc(n16, n17, this.handle, n8 + n10 - n12, n9, n12, n11, 17280, 11520);
            }
        } else if (n11 > n13) {
            OS.XFillArc(n16, n17, this.handle, n8, n9, n10, n13, 0, 11520);
            OS.XFillRectangle(n16, n17, this.handle, n8, n9 + n15, n10, n11 - n15 * 2);
            OS.XFillArc(n16, n17, this.handle, n8, n9 + n11 - n13, n10, n13, 11520, 11520);
        } else {
            OS.XFillArc(n16, n17, this.handle, n8, n9, n10, n11, 0, 23040);
        }
    }

    char fixMnemonic(char[] cArray) {
        char c = '\u0000';
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            if ((cArray[n2++] = cArray[n++]) != '&' || n == cArray.length) continue;
            if (cArray[n] == '&') {
                ++n;
                continue;
            }
            if (c == '\u0000') {
                c = cArray[n];
            }
            --n2;
        }
        while (n2 < cArray.length) {
            cArray[n2++] = '\u0000';
        }
        return c;
    }

    public int getAdvanceWidth(char c) {
        int n;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(4);
        int n2 = this.data.font.handle;
        byte[] byArray = Converter.wcsToMbcs(this.getCodePage(), new char[]{c}, false);
        int n3 = byArray[0] & 0xFF;
        int[] nArray = new int[1];
        if (!OS.XmFontListInitFontContext(nArray, n2)) {
            SWT.error(2);
        }
        int n4 = nArray[0];
        XFontStruct xFontStruct = new XFontStruct();
        XCharStruct xCharStruct = new XCharStruct();
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        while ((n = OS.XmFontListNextEntry(n4)) != 0) {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10 = OS.XmFontListEntryGetFont(n, nArray);
            if (nArray[0] == 0) {
                OS.memmove(xFontStruct, n10, 80);
                if (xFontStruct.min_byte1 == 0 && xFontStruct.max_byte1 == 0) {
                    if (xFontStruct.min_char_or_byte2 > n3 || n3 > xFontStruct.max_char_or_byte2) continue;
                    n9 = 0;
                    int n11 = xFontStruct.per_char;
                    if (n11 == 0) {
                        n9 = xFontStruct.max_bounds_width;
                    } else {
                        OS.memmove(xCharStruct, n11 + (n3 - xFontStruct.min_char_or_byte2) * 12, 12);
                        n9 = xCharStruct.width;
                    }
                    if (n9 == 0) continue;
                    OS.XmFontListFreeFontContext(n4);
                    return n9;
                }
                n9 = xFontStruct.max_char_or_byte2 - xFontStruct.min_char_or_byte2 + 1;
                int n12 = 0;
                if (byArray.length > 1) {
                    n12 = byArray[1] - xFontStruct.min_byte1;
                }
                n8 = byArray[0] - xFontStruct.min_char_or_byte2;
                if (n12 > xFontStruct.max_byte1 || n8 > xFontStruct.max_char_or_byte2) continue;
                n7 = 0;
                n6 = xFontStruct.per_char;
                if (n6 == 0) {
                    n7 = xFontStruct.max_bounds_width;
                } else {
                    n5 = n12 * n9 + n8;
                    OS.memmove(xCharStruct, n6 + n5 * 12, 12);
                    n7 = xCharStruct.width;
                }
                if (n7 == 0) continue;
                OS.XmFontListFreeFontContext(n4);
                return n7;
            }
            n9 = OS.XFontsOfFontSet(n10, nArray2, nArray3);
            int[] nArray4 = new int[n9];
            OS.memmove(nArray4, nArray2[0], n9 * 4);
            n8 = 0;
            while (n8 < n9) {
                OS.memmove(xFontStruct, nArray4[n8], 80);
                if (xFontStruct.min_byte1 == 0 && xFontStruct.max_byte1 == 0) {
                    if (xFontStruct.min_char_or_byte2 <= n3 && n3 <= xFontStruct.max_char_or_byte2) {
                        n7 = 0;
                        n6 = xFontStruct.per_char;
                        if (n6 == 0) {
                            n7 = xFontStruct.max_bounds_width;
                        } else {
                            OS.memmove(xCharStruct, n6 + (n3 - xFontStruct.min_char_or_byte2) * 12, 12);
                            n7 = xCharStruct.width;
                        }
                        if (n7 != 0) {
                            OS.XmFontListFreeFontContext(n4);
                            return n7;
                        }
                    }
                } else {
                    n7 = xFontStruct.max_char_or_byte2 - xFontStruct.min_char_or_byte2 + 1;
                    n6 = 0;
                    if (byArray.length > 1) {
                        n6 = byArray[1] - xFontStruct.min_byte1;
                    }
                    n5 = byArray[0] - xFontStruct.min_char_or_byte2;
                    if (n6 <= xFontStruct.max_byte1 && n5 <= xFontStruct.max_char_or_byte2) {
                        short s = 0;
                        int n13 = xFontStruct.per_char;
                        if (n13 == 0) {
                            s = xFontStruct.max_bounds_width;
                        } else {
                            int n14 = n6 * n7 + n5;
                            OS.memmove(xCharStruct, n13 + n14 * 12, 12);
                            s = xCharStruct.width;
                        }
                        if (s != 0) {
                            OS.XmFontListFreeFontContext(n4);
                            return s;
                        }
                    }
                }
                ++n8;
            }
        }
        OS.XmFontListFreeFontContext(n4);
        return this.stringExtent((String)new String((char[])new char[]{c})).x;
    }

    public boolean getAdvanced() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.cairo != 0;
    }

    public int getAlpha() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.alpha;
    }

    public int getAntialias() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.cairo == 0) {
            return -1;
        }
        int n = Cairo.cairo_get_antialias(this.data.cairo);
        switch (n) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: 
            case 3: {
                return 1;
            }
        }
        return -1;
    }

    public Color getBackground() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        XColor xColor = this.data.background;
        if ((this.data.state & 0x400) == 0) {
            OS.XQueryColor(this.data.display, this.data.colormap, xColor);
            this.data.state |= 0x400;
        }
        return Color.motif_new(this.data.device, xColor);
    }

    public Pattern getBackgroundPattern() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.backgroundPattern;
    }

    public int getCharWidth(char c) {
        int n;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(4);
        int n2 = this.data.font.handle;
        byte[] byArray = Converter.wcsToMbcs(this.getCodePage(), new char[]{c}, false);
        int n3 = byArray[0] & 0xFF;
        int[] nArray = new int[1];
        if (!OS.XmFontListInitFontContext(nArray, n2)) {
            SWT.error(2);
        }
        int n4 = nArray[0];
        XFontStruct xFontStruct = new XFontStruct();
        XCharStruct xCharStruct = new XCharStruct();
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        while ((n = OS.XmFontListNextEntry(n4)) != 0) {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12 = OS.XmFontListEntryGetFont(n, nArray);
            if (nArray[0] == 0) {
                OS.memmove(xFontStruct, n12, 80);
                if (xFontStruct.min_byte1 == 0 && xFontStruct.max_byte1 == 0) {
                    if (xFontStruct.min_char_or_byte2 > n3 || n3 > xFontStruct.max_char_or_byte2) continue;
                    n11 = 0;
                    short s = 0;
                    n10 = 0;
                    n9 = xFontStruct.per_char;
                    if (n9 == 0) {
                        n11 = xFontStruct.max_bounds_width;
                        s = xFontStruct.min_bounds_lbearing;
                        n10 = xFontStruct.max_bounds_rbearing;
                    } else {
                        OS.memmove(xCharStruct, n9 + (n3 - xFontStruct.min_char_or_byte2) * 12, 12);
                        n11 = xCharStruct.width;
                        s = xCharStruct.lbearing;
                        n10 = xCharStruct.rbearing;
                    }
                    if (n11 == 0) continue;
                    OS.XmFontListFreeFontContext(n4);
                    return n10 - s;
                }
                n11 = xFontStruct.max_char_or_byte2 - xFontStruct.min_char_or_byte2 + 1;
                int n13 = 0;
                if (byArray.length > 1) {
                    n13 = byArray[1] - xFontStruct.min_byte1;
                }
                n10 = byArray[0] - xFontStruct.min_char_or_byte2;
                if (n13 > xFontStruct.max_byte1 || n10 > xFontStruct.max_char_or_byte2) continue;
                n9 = 0;
                n8 = 0;
                n7 = 0;
                n6 = xFontStruct.per_char;
                if (n6 == 0) {
                    n9 = xFontStruct.max_bounds_width;
                    n8 = xFontStruct.min_bounds_lbearing;
                    n7 = xFontStruct.max_bounds_rbearing;
                } else {
                    n5 = n13 * n11 + n10;
                    OS.memmove(xCharStruct, n6 + n5 * 12, 12);
                    n9 = xCharStruct.width;
                    n8 = xCharStruct.lbearing;
                    n7 = xCharStruct.rbearing;
                }
                if (n9 == 0) continue;
                OS.XmFontListFreeFontContext(n4);
                return n7 - n8;
            }
            n11 = OS.XFontsOfFontSet(n12, nArray2, nArray3);
            int[] nArray4 = new int[n11];
            OS.memmove(nArray4, nArray2[0], n11 * 4);
            n10 = 0;
            while (n10 < n11) {
                OS.memmove(xFontStruct, nArray4[n10], 80);
                if (xFontStruct.min_byte1 == 0 && xFontStruct.max_byte1 == 0) {
                    if (xFontStruct.min_char_or_byte2 <= n3 && n3 <= xFontStruct.max_char_or_byte2) {
                        n9 = 0;
                        n8 = 0;
                        n7 = 0;
                        n6 = xFontStruct.per_char;
                        if (n6 == 0) {
                            n9 = xFontStruct.max_bounds_width;
                            n8 = xFontStruct.min_bounds_lbearing;
                            n7 = xFontStruct.max_bounds_rbearing;
                        } else {
                            OS.memmove(xCharStruct, n6 + (n3 - xFontStruct.min_char_or_byte2) * 12, 12);
                            n9 = xCharStruct.width;
                            n8 = xCharStruct.lbearing;
                            n7 = xCharStruct.rbearing;
                        }
                        if (n9 != 0) {
                            OS.XmFontListFreeFontContext(n4);
                            return n7 - n8;
                        }
                    }
                } else {
                    n9 = xFontStruct.max_char_or_byte2 - xFontStruct.min_char_or_byte2 + 1;
                    n8 = 0;
                    if (byArray.length > 1) {
                        n8 = byArray[1] - xFontStruct.min_byte1;
                    }
                    n7 = byArray[0] - xFontStruct.min_char_or_byte2;
                    if (n8 <= xFontStruct.max_byte1 && n7 <= xFontStruct.max_char_or_byte2) {
                        n6 = 0;
                        n5 = 0;
                        short s = 0;
                        int n14 = xFontStruct.per_char;
                        if (n14 == 0) {
                            n6 = xFontStruct.max_bounds_width;
                            n5 = xFontStruct.min_bounds_lbearing;
                            s = xFontStruct.max_bounds_rbearing;
                        } else {
                            int n15 = n8 * n9 + n7;
                            OS.memmove(xCharStruct, n14 + n15 * 12, 12);
                            n6 = xCharStruct.width;
                            n5 = xCharStruct.lbearing;
                            s = xCharStruct.rbearing;
                        }
                        if (n6 != 0) {
                            OS.XmFontListFreeFontContext(n4);
                            return s - n5;
                        }
                    }
                }
                ++n10;
            }
        }
        OS.XmFontListFreeFontContext(n4);
        return this.stringExtent((String)new String((char[])new char[]{c})).x;
    }

    public Rectangle getClipping() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.XGetGeometry(this.data.display, this.data.drawable, nArray3, nArray3, nArray3, nArray, nArray2, nArray3, nArray3);
        n3 = nArray[0];
        n4 = nArray2[0];
        int n5 = this.data.cairo;
        int n6 = this.data.clipRgn;
        int n7 = this.data.damageRgn;
        if (n6 != 0 || n7 != 0 || n5 != 0) {
            int n8 = OS.XCreateRegion();
            XRectangle xRectangle = new XRectangle();
            xRectangle.width = (short)n3;
            xRectangle.height = (short)n4;
            OS.XUnionRectWithRegion(xRectangle, n8, n8);
            if (n7 != 0) {
                OS.XIntersectRegion(n7, n8, n8);
            }
            if (n6 != 0) {
                if (this.data.clippingTransform != null) {
                    n6 = this.convertRgn(n6, this.data.clippingTransform);
                    OS.XIntersectRegion(n8, n6, n8);
                    OS.XDestroyRegion(n6);
                } else {
                    OS.XIntersectRegion(n8, n6, n8);
                }
            }
            if (n5 != 0) {
                double[] dArray = new double[6];
                Cairo.cairo_get_matrix(n5, dArray);
                Cairo.cairo_matrix_invert(dArray);
                n6 = this.convertRgn(n8, dArray);
                OS.XDestroyRegion(n8);
                n8 = n6;
            }
            OS.XClipBox(n8, xRectangle);
            OS.XDestroyRegion(n8);
            n = xRectangle.x;
            n2 = xRectangle.y;
            n3 = xRectangle.width;
            n4 = xRectangle.height;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    public void getClipping(Region region) {
        Object[] objectArray;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        int n = region.handle;
        OS.XSubtractRegion(n, n, n);
        int n2 = this.data.cairo;
        int n3 = this.data.clipRgn;
        if (n3 == 0) {
            objectArray = new int[1];
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.XGetGeometry(this.data.display, this.data.drawable, nArray2, nArray2, nArray2, objectArray, nArray, nArray2, nArray2);
            XRectangle xRectangle = new XRectangle();
            xRectangle.x = 0;
            xRectangle.y = 0;
            xRectangle.width = (short)objectArray[0];
            xRectangle.height = (short)nArray[0];
            OS.XUnionRectWithRegion(xRectangle, n, n);
        } else if (this.data.clippingTransform != null) {
            int n4 = this.convertRgn(n3, this.data.clippingTransform);
            OS.XUnionRegion(n, n4, n);
            OS.XDestroyRegion(n4);
        } else {
            OS.XUnionRegion(n, n3, n);
        }
        if (this.data.damageRgn != 0) {
            OS.XIntersectRegion(n, this.data.damageRgn, n);
        }
        if (n2 != 0) {
            objectArray = new double[6];
            Cairo.cairo_get_matrix(n2, objectArray);
            Cairo.cairo_matrix_invert(objectArray);
            int n5 = this.convertRgn(n, (double[])objectArray);
            OS.XSubtractRegion(n, n, n);
            OS.XUnionRegion(n, n5, n);
            OS.XDestroyRegion(n5);
        }
    }

    String getCodePage() {
        return this.data.font.codePage;
    }

    public int getFillRule() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        XGCValues xGCValues = new XGCValues();
        OS.XGetGCValues(this.data.display, this.handle, 512, xGCValues);
        return xGCValues.fill_rule == 1 ? 2 : 1;
    }

    public Font getFont() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return Font.motif_new(this.data.device, this.data.font.handle);
    }

    int getFontHeight() {
        int n;
        int[] nArray = new int[1];
        int n2 = this.data.font.handle;
        if (!OS.XmFontListInitFontContext(nArray, n2)) {
            SWT.error(2);
        }
        int n3 = nArray[0];
        int n4 = 0;
        XFontStruct xFontStruct = new XFontStruct();
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        while ((n = OS.XmFontListNextEntry(n3)) != 0) {
            int n5;
            int n6 = OS.XmFontListEntryGetFont(n, nArray);
            if (nArray[0] == 0) {
                OS.memmove(xFontStruct, n6, 80);
                n5 = xFontStruct.ascent + xFontStruct.descent;
                n4 = Math.max(n4, n5);
                continue;
            }
            n5 = OS.XFontsOfFontSet(n6, nArray2, nArray3);
            int[] nArray4 = new int[n5];
            OS.memmove(nArray4, nArray2[0], n5 * 4);
            int n7 = 0;
            while (n7 < n5) {
                OS.memmove(xFontStruct, nArray4[n7], 80);
                int n8 = xFontStruct.ascent + xFontStruct.descent;
                n4 = Math.max(n4, n8);
                ++n7;
            }
        }
        OS.XmFontListFreeFontContext(n3);
        return n4;
    }

    public FontMetrics getFontMetrics() {
        int n;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(4);
        int n2 = this.data.display;
        Font font = this.data.font;
        int n3 = font.handle;
        int[] nArray = new int[1];
        if (!OS.XmFontListInitFontContext(nArray, n3)) {
            SWT.error(2);
        }
        int n4 = nArray[0];
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        XFontStruct xFontStruct = new XFontStruct();
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        block6: while ((n = OS.XmFontListNextEntry(n4)) != 0) {
            int n11;
            int n12;
            int n13;
            int n14;
            Object[] objectArray;
            int n15;
            int n16;
            int n17;
            int n18;
            int n19 = OS.XmFontListEntryGetFont(n, nArray);
            if (nArray[0] == 0) {
                OS.memmove(xFontStruct, n19, 80);
                n5 = Math.max(n5, xFontStruct.ascent);
                n6 = Math.max(n6, xFontStruct.descent);
                n18 = xFontStruct.ascent + xFontStruct.descent;
                n10 = Math.max(n10, n18);
                int n20 = xFontStruct.properties;
                n17 = 0;
                while (n17 < xFontStruct.n_properties) {
                    int[] nArray4 = new int[2];
                    OS.memmove(nArray4, n20, 8);
                    if (nArray4[0] == 18) {
                        n16 = OS.XmGetAtomName(n2, nArray4[1]);
                        n15 = OS.strlen(n16);
                        objectArray = new byte[n15];
                        OS.memmove(objectArray, n16, n15);
                        OS.XFree(n16);
                        String string = new String(Converter.mbcsToWcs(null, objectArray)).toLowerCase();
                        n14 = 0;
                        try {
                            n14 = FontData.motif_new((String)string).averageWidth / 10;
                        }
                        catch (Exception exception) {}
                        if (n14 == 0) {
                            int n21 = xFontStruct.per_char;
                            if (n21 == 0) {
                                n7 = xFontStruct.max_bounds_width;
                            } else {
                                int n22 = 0;
                                n13 = 0;
                                int n23 = xFontStruct.max_char_or_byte2 - xFontStruct.min_char_or_byte2 + 1;
                                XCharStruct xCharStruct = new XCharStruct();
                                n12 = 0;
                                while (n12 < n23) {
                                    OS.memmove(xCharStruct, n21 + n12 * 12, 12);
                                    n11 = xCharStruct.width;
                                    if (n11 != 0) {
                                        n22 += n11;
                                        ++n13;
                                    }
                                    ++n12;
                                }
                                n7 += n22 / n13;
                            }
                        } else {
                            n7 += n14;
                        }
                        ++n8;
                        continue block6;
                    }
                    n20 += 8;
                    ++n17;
                }
                continue;
            }
            n18 = OS.XFontsOfFontSet(n19, nArray2, nArray3);
            int[] nArray5 = new int[n18];
            OS.memmove(nArray5, nArray2[0], n18 * 4);
            n17 = 0;
            while (n17 < n18) {
                OS.memmove(xFontStruct, nArray5[n17], 80);
                n5 = Math.max(n5, xFontStruct.ascent);
                n6 = Math.max(n6, xFontStruct.descent);
                int n24 = xFontStruct.ascent + xFontStruct.descent;
                n10 = Math.max(n10, n24);
                n16 = xFontStruct.properties;
                n15 = 0;
                while (n15 < xFontStruct.n_properties) {
                    objectArray = new int[2];
                    OS.memmove((int[])objectArray, n16, 8);
                    if (objectArray[0] == 18) {
                        block27: {
                            int n25 = OS.XmGetAtomName(n2, objectArray[1]);
                            n14 = OS.strlen(n25);
                            byte[] byArray = new byte[n14];
                            OS.memmove(byArray, n25, n14);
                            OS.XFree(n25);
                            String string = new String(Converter.mbcsToWcs(null, byArray)).toLowerCase();
                            n13 = 0;
                            try {
                                n13 = FontData.motif_new((String)string).averageWidth / 10;
                            }
                            catch (Exception exception) {
                                int[] nArray6 = new int[1];
                                OS.memmove(nArray6, nArray3[0] + n17 * 4, 4);
                                n25 = nArray6[0];
                                if (n25 == 0) break block27;
                                n14 = OS.strlen(n25);
                                byArray = new byte[n14];
                                OS.memmove(byArray, n25, n14);
                                string = new String(Converter.mbcsToWcs(null, byArray)).toLowerCase();
                                try {
                                    n13 = FontData.motif_new((String)string).averageWidth / 10;
                                }
                                catch (Exception exception2) {}
                            }
                        }
                        if (n13 == 0) {
                            int n26 = xFontStruct.per_char;
                            if (n26 == 0) {
                                n7 = xFontStruct.max_bounds_width;
                            } else {
                                int n27 = 0;
                                n12 = 0;
                                n11 = xFontStruct.max_char_or_byte2 - xFontStruct.min_char_or_byte2 + 1;
                                XCharStruct xCharStruct = new XCharStruct();
                                int n28 = 0;
                                while (n28 < n11) {
                                    OS.memmove(xCharStruct, n26 + n28 * 12, 12);
                                    short s = xCharStruct.width;
                                    if (s != 0) {
                                        n27 += s;
                                        ++n12;
                                    }
                                    ++n28;
                                }
                                n7 += n27 / n12;
                            }
                        } else {
                            n7 += n13;
                        }
                        ++n8;
                        break;
                    }
                    n16 += 8;
                    ++n15;
                }
                ++n17;
            }
        }
        OS.XmFontListFreeFontContext(n4);
        return FontMetrics.motif_new(n5, n6, n7 / n8, n9, n10);
    }

    public Color getForeground() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        XColor xColor = this.data.foreground;
        if ((this.data.state & 0x200) == 0) {
            OS.XQueryColor(this.data.display, this.data.colormap, xColor);
            this.data.state |= 0x200;
        }
        return Color.motif_new(this.data.device, xColor);
    }

    public Pattern getForegroundPattern() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.foregroundPattern;
    }

    public GCData getGCData() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data;
    }

    public int getInterpolation() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.interpolation;
    }

    public LineAttributes getLineAttributes() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        float[] fArray = null;
        if (this.data.lineDashes != null) {
            fArray = new float[this.data.lineDashes.length];
            System.arraycopy(this.data.lineDashes, 0, fArray, 0, fArray.length);
        }
        return new LineAttributes(this.data.lineWidth, this.data.lineCap, this.data.lineJoin, this.data.lineStyle, fArray, this.data.lineDashesOffset, this.data.lineMiterLimit);
    }

    public int getLineCap() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineCap;
    }

    public int[] getLineDash() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineDashes == null) {
            return null;
        }
        int[] nArray = new int[this.data.lineDashes.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = (int)this.data.lineDashes[n];
            ++n;
        }
        return nArray;
    }

    public int getLineJoin() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineJoin;
    }

    public int getLineStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineStyle;
    }

    public int getLineWidth() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return (int)this.data.lineWidth;
    }

    public int getStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.style;
    }

    public int getTextAntialias() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.cairo == 0) {
            return -1;
        }
        int n = Cairo.cairo_font_options_create();
        Cairo.cairo_get_font_options(this.data.cairo, n);
        int n2 = Cairo.cairo_font_options_get_antialias(n);
        Cairo.cairo_font_options_destroy(n);
        switch (n2) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: 
            case 3: {
                return 1;
            }
        }
        return -1;
    }

    public void getTransform(Transform transform) {
        int n;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
        if ((n = this.data.cairo) != 0) {
            Cairo.cairo_get_matrix(n, transform.handle);
        } else {
            transform.setElements(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
    }

    public boolean getXORMode() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        XGCValues xGCValues = new XGCValues();
        OS.XGetGCValues(this.data.display, this.handle, 1, xGCValues);
        return xGCValues.function == 6;
    }

    public int hashCode() {
        return this.handle;
    }

    void init(Drawable drawable, GCData gCData, int n) {
        Image image;
        if (gCData.foreground != null) {
            gCData.state &= 0xFFFFFDFE;
        }
        if (gCData.background != null) {
            gCData.state &= 0xFFFFFAFD;
        }
        if (gCData.font != null) {
            gCData.state &= 0xFFFFFFFB;
        }
        if ((image = gCData.image) != null) {
            image.memGC = this;
            if (image.transparentPixel != -1) {
                image.destroyMask();
            }
        }
        this.drawable = drawable;
        this.data = gCData;
        this.handle = n;
    }

    void initCairo() {
        this.data.device.checkCairo();
        int n = this.data.cairo;
        if (n != 0) {
            return;
        }
        int n2 = this.data.display;
        int n3 = this.data.drawable;
        int n4 = OS.XDefaultVisual(n2, OS.XDefaultScreen(n2));
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.XGetGeometry(n2, n3, nArray3, nArray3, nArray3, nArray, nArray2, nArray3, nArray3);
        int n5 = Cairo.cairo_xlib_surface_create(n2, n3, n4, nArray[0], nArray2[0]);
        if (n5 == 0) {
            SWT.error(2);
        }
        this.data.cairo = n = Cairo.cairo_create(n5);
        Cairo.cairo_surface_destroy(n5);
        if (n == 0) {
            SWT.error(2);
        }
        Cairo.cairo_set_fill_rule(n, 1);
        this.data.state &= 0xFFFFF780;
        this.setCairoClip(this.data.damageRgn, this.data.clipRgn);
    }

    public boolean isClipped() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.clipRgn != 0;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    boolean isIdentity(double[] dArray) {
        if (dArray == null) {
            return true;
        }
        return dArray[0] == 1.0 && dArray[1] == 0.0 && dArray[2] == 0.0 && dArray[3] == 1.0 && dArray[4] == 0.0 && dArray[5] == 0.0;
    }

    public void setAdvanced(boolean bl) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (bl && this.data.cairo != 0) {
            return;
        }
        if (bl) {
            try {
                this.initCairo();
            }
            catch (SWTException sWTException) {}
        } else {
            int n = this.data.cairo;
            if (n != 0) {
                Cairo.cairo_destroy(n);
            }
            this.data.cairo = 0;
            this.data.interpolation = -1;
            this.data.foregroundPattern = null;
            this.data.backgroundPattern = null;
            this.data.state = 0;
            this.setClipping(0);
        }
    }

    public void setAlpha(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.cairo == 0 && (n & 0xFF) == 255) {
            return;
        }
        this.initCairo();
        this.data.alpha = n & 0xFF;
        this.data.state &= 0xFFFFFEFC;
    }

    public void setAntialias(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.cairo == 0 && n == -1) {
            return;
        }
        int n2 = 0;
        switch (n) {
            case -1: {
                n2 = 0;
                break;
            }
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        int n3 = this.data.cairo;
        Cairo.cairo_set_antialias(n3, n2);
    }

    public static GC motif_new(Drawable drawable, GCData gCData) {
        GC gC = new GC();
        int n = drawable.internal_new_GC(gCData);
        gC.device = gCData.device;
        gC.init(drawable, gCData, n);
        return gC;
    }

    public static GC motif_new(int n, GCData gCData) {
        GC gC = new GC();
        gC.device = gCData.device;
        gC.init(null, gCData, n);
        return gC;
    }

    public void setBackground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.background = color.handle;
        this.data.backgroundPattern = null;
        this.data.state &= 0xFFFFFEFD;
        this.data.state |= 0x400;
    }

    public void setBackgroundPattern(Pattern pattern) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.cairo == 0 && pattern == null) {
            return;
        }
        this.initCairo();
        if (this.data.backgroundPattern == pattern) {
            return;
        }
        this.data.backgroundPattern = pattern;
        this.data.state &= 0xFFFFFFFD;
    }

    static void setCairoFont(int n, Font font) {
        String string;
        int n2;
        FontData[] fontDataArray = font.getFontData();
        FontData fontData = fontDataArray[0];
        int n3 = fontData.getStyle();
        int n4 = 0;
        if ((n3 & 2) != 0) {
            n4 = 1;
        }
        int n5 = 0;
        if ((n3 & 1) != 0) {
            n5 = 1;
        }
        if ((n2 = (string = fontData.getName()).indexOf(45)) != -1) {
            string = string.substring(n2 + 1);
        }
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        Cairo.cairo_select_font_face(n, byArray, n4, n5);
        Cairo.cairo_set_font_size(n, fontData.getHeight());
    }

    static void setCairoRegion(int n, int n2) {
        XRectangle xRectangle = new XRectangle();
        OS.XClipBox(n2, xRectangle);
        Cairo.cairo_rectangle(n, xRectangle.x, xRectangle.y, xRectangle.width, xRectangle.height);
    }

    static void setCairoPatternColor(int n, int n2, Color color, int n3) {
        XColor xColor = color.handle;
        double d = (double)(n3 & 0xFF) / 255.0;
        double d2 = (double)(xColor.red & 0xFFFF) / 65535.0;
        double d3 = (double)(xColor.green & 0xFFFF) / 65535.0;
        double d4 = (double)(xColor.blue & 0xFFFF) / 65535.0;
        Cairo.cairo_pattern_add_color_stop_rgba(n, n2, d2, d3, d4, d);
    }

    void setCairoClip(int n, int n2) {
        int n3 = this.data.cairo;
        Cairo.cairo_reset_clip(n3);
        if (n != 0) {
            double[] dArray = new double[6];
            Cairo.cairo_get_matrix(n3, dArray);
            Cairo.cairo_identity_matrix(n3);
            GC.setCairoRegion(n3, n);
            Cairo.cairo_clip(n3);
            Cairo.cairo_set_matrix(n3, dArray);
        }
        if (n2 != 0) {
            GC.setCairoRegion(n3, n2);
            Cairo.cairo_clip(n3);
        }
    }

    void setClipping(int n) {
        int n2 = this.data.cairo;
        if (n == 0) {
            if (this.data.clipRgn != 0) {
                OS.XDestroyRegion(this.data.clipRgn);
                this.data.clipRgn = 0;
            }
            if (n2 != 0) {
                this.data.clippingTransform = null;
                this.setCairoClip(this.data.damageRgn, 0);
            } else if (this.data.damageRgn == 0) {
                OS.XSetClipMask(this.data.display, this.handle, 0);
            } else {
                OS.XSetRegion(this.data.display, this.handle, this.data.damageRgn);
            }
        } else {
            if (this.data.clipRgn == 0) {
                this.data.clipRgn = OS.XCreateRegion();
            }
            OS.XSubtractRegion(this.data.clipRgn, this.data.clipRgn, this.data.clipRgn);
            OS.XUnionRegion(n, this.data.clipRgn, this.data.clipRgn);
            if (n2 != 0) {
                if (this.data.clippingTransform == null) {
                    this.data.clippingTransform = new double[6];
                }
                Cairo.cairo_get_matrix(n2, this.data.clippingTransform);
                this.setCairoClip(this.data.damageRgn, n);
            } else {
                int n3 = n;
                if (this.data.damageRgn != 0) {
                    n3 = OS.XCreateRegion();
                    OS.XUnionRegion(n3, n, n3);
                    OS.XIntersectRegion(n3, this.data.damageRgn, n3);
                }
                OS.XSetRegion(this.data.display, this.handle, n3);
                if (n3 != n) {
                    OS.XDestroyRegion(n3);
                }
            }
        }
    }

    public void setClipping(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        XRectangle xRectangle = new XRectangle();
        xRectangle.x = (short)n;
        xRectangle.y = (short)n2;
        xRectangle.width = (short)Math.max(0, n3);
        xRectangle.height = (short)Math.max(0, n4);
        int n5 = OS.XCreateRegion();
        OS.XUnionRectWithRegion(xRectangle, n5, n5);
        this.setClipping(n5);
        OS.XDestroyRegion(n5);
    }

    public void setClipping(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path != null && path.isDisposed()) {
            SWT.error(44);
        }
        this.setClipping(0);
        if (path != null) {
            this.initCairo();
            int n = this.data.cairo;
            int n2 = Cairo.cairo_copy_path(path.handle);
            if (n2 == 0) {
                SWT.error(2);
            }
            Cairo.cairo_append_path(n, n2);
            Cairo.cairo_path_destroy(n2);
            Cairo.cairo_clip(n);
            Cairo.cairo_new_path(n);
        }
    }

    public void setClipping(Rectangle rectangle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rectangle == null) {
            this.setClipping(0);
        } else {
            this.setClipping(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void setClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region != null && region.isDisposed()) {
            SWT.error(5);
        }
        this.setClipping(region != null ? region.handle : 0);
    }

    public void setFillRule(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int n2 = 0;
        int n3 = 1;
        switch (n) {
            case 2: {
                n2 = 1;
                n3 = 0;
                break;
            }
            case 1: {
                n2 = 0;
                n3 = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        OS.XSetFillRule(this.data.display, this.handle, n2);
        int n4 = this.data.cairo;
        if (n4 != 0) {
            Cairo.cairo_set_fill_rule(n4, n3);
        }
    }

    public void setFont(Font font) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.data.font = font != null ? font : this.data.device.systemFont;
        this.data.state &= 0xFFFFFFFB;
        if (this.data.renderTable != 0) {
            OS.XmRenderTableFree(this.data.renderTable);
        }
        this.data.renderTable = 0;
        this.data.textHeight = -1;
        this.data.textWidth = -1;
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
    }

    public void setForeground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.foreground = color.handle;
        this.data.foregroundPattern = null;
        this.data.state &= 0xFFFFFFFE;
        this.data.state |= 0x200;
    }

    public void setForegroundPattern(Pattern pattern) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.cairo == 0 && pattern == null) {
            return;
        }
        this.initCairo();
        if (this.data.foregroundPattern == pattern) {
            return;
        }
        this.data.foregroundPattern = pattern;
        this.data.state &= 0xFFFFFFFE;
    }

    public void setInterpolation(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.cairo == 0 && n == -1) {
            return;
        }
        switch (n) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        this.data.interpolation = n;
    }

    public void setLineAttributes(LineAttributes lineAttributes) {
        float f;
        int n;
        int n2;
        int n3;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (lineAttributes == null) {
            SWT.error(4);
        }
        int n4 = 0;
        float f2 = lineAttributes.width;
        if (f2 != this.data.lineWidth) {
            n4 |= 0x840;
        }
        if ((n3 = lineAttributes.style) != this.data.lineStyle) {
            n4 |= 8;
            switch (n3) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    if (lineAttributes.dash != null) break;
                    n3 = 1;
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((n2 = lineAttributes.join) != this.data.lineJoin) {
            n4 |= 0x20;
            switch (n2) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((n = lineAttributes.cap) != this.data.lineCap) {
            n4 |= 0x10;
            switch (n) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        float[] fArray = lineAttributes.dash;
        float[] fArray2 = this.data.lineDashes;
        if (fArray != null && fArray.length > 0) {
            boolean bl = fArray2 == null || fArray2.length != fArray.length;
            int n5 = 0;
            while (n5 < fArray.length) {
                float f3 = fArray[n5];
                if (f3 <= 0.0f) {
                    SWT.error(5);
                }
                if (!bl && fArray2[n5] != f3) {
                    bl = true;
                }
                ++n5;
            }
            if (bl) {
                float[] fArray3 = new float[fArray.length];
                System.arraycopy(fArray, 0, fArray3, 0, fArray.length);
                fArray = fArray3;
                n4 |= 8;
            } else {
                fArray = fArray2;
            }
        } else if (fArray2 != null && fArray2.length > 0) {
            n4 |= 8;
        } else {
            fArray = fArray2;
        }
        float f4 = lineAttributes.dashOffset;
        if (f4 != this.data.lineDashesOffset) {
            n4 |= 8;
        }
        if ((f = lineAttributes.miterLimit) != this.data.lineMiterLimit) {
            n4 |= 0x80;
        }
        this.initCairo();
        if (n4 == 0) {
            return;
        }
        this.data.lineWidth = f2;
        this.data.lineStyle = n3;
        this.data.lineCap = n;
        this.data.lineJoin = n2;
        this.data.lineDashes = fArray;
        this.data.lineDashesOffset = f4;
        this.data.lineMiterLimit = f;
        this.data.state &= ~n4;
    }

    public void setLineCap(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineCap == n) {
            return;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineCap = n;
        this.data.state &= 0xFFFFFFEF;
    }

    public void setLineDash(int[] nArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        float[] fArray = this.data.lineDashes;
        if (nArray != null && nArray.length > 0) {
            boolean bl = this.data.lineStyle != 6 || fArray == null || fArray.length != nArray.length;
            int n = 0;
            while (n < nArray.length) {
                int n2 = nArray[n];
                if (n2 <= 0) {
                    SWT.error(5);
                }
                if (!bl && fArray[n] != (float)n2) {
                    bl = true;
                }
                ++n;
            }
            if (!bl) {
                return;
            }
            this.data.lineDashes = new float[nArray.length];
            n = 0;
            while (n < nArray.length) {
                this.data.lineDashes[n] = nArray[n];
                ++n;
            }
            this.data.lineStyle = 6;
        } else {
            if (this.data.lineStyle == 1 && (fArray == null || fArray.length == 0)) {
                return;
            }
            this.data.lineDashes = null;
            this.data.lineStyle = 1;
        }
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineJoin(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineJoin == n) {
            return;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineJoin = n;
        this.data.state &= 0xFFFFFFDF;
    }

    public void setLineStyle(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineStyle == n) {
            return;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                if (this.data.lineDashes != null) break;
                n = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineStyle = n;
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineWidth(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineWidth == (float)n) {
            return;
        }
        this.data.lineWidth = n;
        this.data.state &= 0xFFFFF7BF;
    }

    void setString(String string) {
        if (string == this.data.string) {
            return;
        }
        if (this.data.xmString != 0) {
            OS.XmStringFree(this.data.xmString);
        }
        byte[] byArray = Converter.wcsToMbcs(this.getCodePage(), string, true);
        this.data.xmString = OS.XmStringCreate(byArray, OS.XmFONTLIST_DEFAULT_TAG);
        this.data.string = string;
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
    }

    void setText(String string, int n) {
        if (this.data.renderTable == 0) {
            this.createRenderTable();
        }
        if (string == this.data.text && (n & 0xFFFFFFFE) == (this.data.drawFlags & 0xFFFFFFFE)) {
            return;
        }
        if (this.data.xmText != 0) {
            OS.XmStringFree(this.data.xmText);
        }
        if (this.data.xmMnemonic != 0) {
            OS.XmStringFree(this.data.xmMnemonic);
        }
        char c = '\u0000';
        int n2 = 0;
        Device device = this.data.device;
        int[] nArray = new int[2];
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        if ((n & 2) != 0) {
            nArray[n2++] = device.crMapping;
        }
        if ((n & 4) != 0) {
            nArray[n2++] = device.tabMapping;
        }
        if ((n & 8) != 0) {
            c = this.fixMnemonic(cArray);
        }
        String string2 = this.getCodePage();
        byte[] byArray = Converter.wcsToMbcs(string2, cArray, true);
        this.data.xmText = OS.XmStringParseText(byArray, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, nArray, n2, 0);
        if (c != '\u0000') {
            byte[] byArray2 = Converter.wcsToMbcs(string2, new char[]{c}, true);
            this.data.xmMnemonic = OS.XmStringCreate(byArray2, OS.XmFONTLIST_DEFAULT_TAG);
        } else {
            this.data.xmMnemonic = 0;
        }
        this.data.text = string;
        this.data.textHeight = -1;
        this.data.textWidth = -1;
        this.data.drawFlags = n;
    }

    public void setTextAntialias(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.cairo == 0 && n == -1) {
            return;
        }
        int n2 = 0;
        switch (n) {
            case -1: {
                n2 = 0;
                break;
            }
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        int n3 = Cairo.cairo_font_options_create();
        Cairo.cairo_font_options_set_antialias(n3, n2);
        Cairo.cairo_set_font_options(this.data.cairo, n3);
        Cairo.cairo_font_options_destroy(n3);
    }

    public void setTransform(Transform transform) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (transform != null && transform.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.cairo == 0 && transform == null) {
            return;
        }
        this.initCairo();
        int n = this.data.cairo;
        if (transform != null) {
            Cairo.cairo_set_matrix(n, transform.handle);
        } else {
            Cairo.cairo_identity_matrix(n);
        }
        this.data.state &= 0xFFFFF7FF;
    }

    public void setXORMode(boolean bl) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        OS.XSetFunction(this.data.display, this.handle, bl ? 6 : 3);
    }

    public Point stringExtent(String string) {
        int n;
        int n2;
        int n3;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if ((n3 = this.data.cairo) != 0) {
            this.checkGC(4);
            byte[] byArray = Converter.wcsToMbcs(null, string, true);
            cairo_font_extents_t cairo_font_extents_t2 = new cairo_font_extents_t();
            Cairo.cairo_font_extents(n3, cairo_font_extents_t2);
            cairo_text_extents_t cairo_text_extents_t2 = new cairo_text_extents_t();
            Cairo.cairo_text_extents(n3, byArray, cairo_text_extents_t2);
            return new Point((int)cairo_text_extents_t2.width, (int)cairo_font_extents_t2.height);
        }
        this.setString(string);
        this.checkGC(4);
        if (this.data.stringWidth != -1) {
            return new Point(this.data.stringWidth, this.data.stringHeight);
        }
        if (string.length() == 0) {
            n2 = 0;
            n = this.getFontHeight();
        } else {
            int n4 = this.data.font.handle;
            int n5 = this.data.xmString;
            n2 = OS.XmStringWidth(n4, n5);
            n = OS.XmStringHeight(n4, n5);
        }
        this.data.stringWidth = n2;
        this.data.stringHeight = n;
        return new Point(this.data.stringWidth, this.data.stringHeight);
    }

    public Point textExtent(String string) {
        return this.textExtent(string, 6);
    }

    public Point textExtent(String string, int n) {
        int n2;
        int n3;
        int n4;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if ((n4 = this.data.cairo) != 0) {
            this.checkGC(4);
            byte[] byArray = Converter.wcsToMbcs(null, string, true);
            cairo_font_extents_t cairo_font_extents_t2 = new cairo_font_extents_t();
            Cairo.cairo_font_extents(n4, cairo_font_extents_t2);
            cairo_text_extents_t cairo_text_extents_t2 = new cairo_text_extents_t();
            Cairo.cairo_text_extents(n4, byArray, cairo_text_extents_t2);
            return new Point((int)cairo_text_extents_t2.width, (int)cairo_font_extents_t2.height);
        }
        this.setText(string, n);
        this.checkGC(4);
        if (this.data.textWidth != -1) {
            return new Point(this.data.textWidth, this.data.textHeight);
        }
        if (string.length() == 0) {
            n3 = 0;
            n2 = this.getFontHeight();
        } else {
            int n5 = this.data.font.handle;
            int n6 = this.data.xmText;
            n3 = OS.XmStringWidth(n5, n6);
            n2 = OS.XmStringHeight(n5, n6);
        }
        this.data.textWidth = n3;
        this.data.textHeight = n2;
        return new Point(this.data.textWidth, this.data.textHeight);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }
}

