/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleTableAdapter;
import org.eclipse.swt.accessibility.AccessibleTableEvent;
import org.eclipse.swt.accessibility.AccessibleTableListener;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSValue;

class AccessibleTableColumn
extends Accessible {
    public AccessibleTableColumn(Accessible accessible, int n) {
        super(accessible);
        this.index = n;
        this.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                int n;
                Accessible[] accessibleArray = AccessibleTableColumn.this.getColumnCells();
                AccessibleControlEvent accessibleControlEvent2 = new AccessibleControlEvent(this);
                accessibleControlEvent2.childID = -1;
                accessibleControlEvent2.width = -1;
                Accessible accessible = accessibleArray[0];
                for (n = 0; n < accessible.accessibleControlListeners.size(); ++n) {
                    AccessibleControlListener accessibleControlListener = (AccessibleControlListener)accessible.accessibleControlListeners.elementAt(n);
                    accessibleControlListener.getLocation(accessibleControlEvent2);
                }
                n = 0;
                int n2 = 0;
                for (int i = 0; i < accessibleArray.length; ++i) {
                    NSValue nSValue = (NSValue)accessibleArray[i].getSizeAttribute(-1);
                    NSSize nSSize = nSValue.sizeValue();
                    if (nSSize.width > (double)n2) {
                        n2 = (int)nSSize.width;
                    }
                    n = (int)((double)n + nSSize.height);
                }
                accessibleControlEvent.x = accessibleControlEvent2.x;
                accessibleControlEvent.y = accessibleControlEvent2.y;
                accessibleControlEvent.width = n2;
                accessibleControlEvent.height = n;
            }

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 27;
            }
        });
        this.addAccessibleTableListener(new AccessibleTableAdapter(){

            public void getRowCount(AccessibleTableEvent accessibleTableEvent) {
                accessibleTableEvent.count = AccessibleTableColumn.this.getColumnCells().length;
            }

            public void getRow(AccessibleTableEvent accessibleTableEvent) {
                int n = accessibleTableEvent.row;
                Accessible[] accessibleArray = AccessibleTableColumn.this.getColumnCells();
                int n2 = accessibleArray.length;
                if (0 <= n && n < n2) {
                    accessibleTableEvent.accessible = accessibleArray[n];
                }
            }

            public void getRows(AccessibleTableEvent accessibleTableEvent) {
                accessibleTableEvent.accessibles = AccessibleTableColumn.this.getColumnCells();
            }
        });
    }

    private Accessible[] getColumnCells() {
        int n = Math.max(1, this.parent.getRowCount());
        Accessible[] accessibleArray = new Accessible[n];
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        for (int i = 0; i < n; ++i) {
            accessibleTableEvent.column = this.index;
            accessibleTableEvent.row = i;
            for (int j = 0; j < this.parent.accessibleTableListeners.size(); ++j) {
                AccessibleTableListener accessibleTableListener = (AccessibleTableListener)this.parent.accessibleTableListeners.elementAt(j);
                accessibleTableListener.getCell(accessibleTableEvent);
            }
            accessibleArray[i] = accessibleTableEvent.accessible;
        }
        return accessibleArray;
    }
}

