/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSData;
import org.eclipse.swt.internal.cocoa.NSKeyedArchiver;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPrintInfo;
import org.eclipse.swt.internal.cocoa.NSPrintPanel;
import org.eclipse.swt.internal.cocoa.NSPrinter;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTPrintPanelDelegate;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PrintDialog
extends Dialog {
    PrinterData printerData = new PrinterData();
    int returnCode;
    static Callback dialogCallback5;
    static final byte[] SWT_OBJECT;
    static final String SET_MODAL_DIALOG = "org.eclipse.swt.internal.modalDialog";
    static /* synthetic */ Class class$org$eclipse$swt$printing$PrintDialog;

    public PrintDialog(Shell shell) {
        this(shell, 32768);
    }

    public PrintDialog(Shell shell, int n) {
        super(shell, PrintDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    static int checkStyle(Shell shell, int n) {
        int n2 = 229376;
        if ((n & 0x10000000) != 0) {
            if (PrintDialog.getSheetEnabled()) {
                if (shell == null) {
                    n &= 0xEFFFFFFF;
                }
            } else {
                n &= 0xEFFFFFFF;
            }
            if ((n & n2) == 0) {
                n |= shell == null ? 65536 : 32768;
            }
        }
        return n;
    }

    public void setPrinterData(PrinterData printerData) {
        if (printerData == null) {
            printerData = new PrinterData();
        }
        this.printerData = printerData;
    }

    public PrinterData getPrinterData() {
        return this.printerData;
    }

    public PrinterData open() {
        int n;
        NSObject nSObject;
        Display display;
        NSPrinter nSPrinter;
        PrinterData printerData = null;
        NSPrintPanel nSPrintPanel = NSPrintPanel.printPanel();
        NSPrintInfo nSPrintInfo = new NSPrintInfo(NSPrintInfo.sharedPrintInfo().copy());
        if (this.printerData.duplex != -1) {
            long l = nSPrintInfo.PMPrintSettings();
            int n2 = this.printerData.duplex == 2 ? 3 : (this.printerData.duplex == 1 ? 2 : 1);
            OS.PMSetDuplex(l, n2);
        }
        nSPrintInfo.updateFromPMPrintSettings();
        if (this.printerData.name != null && (nSPrinter = NSPrinter.printerWithName(NSString.stringWith(this.printerData.name))) != null) {
            nSPrintInfo.setPrinter(nSPrinter);
        }
        NSMutableDictionary nSMutableDictionary = nSPrintInfo.dictionary();
        nSMutableDictionary.setValue(NSNumber.numberWithBool(this.printerData.collate), OS.NSPrintMustCollate);
        nSMutableDictionary.setValue(NSNumber.numberWithInt(this.printerData.copyCount), OS.NSPrintCopies);
        nSMutableDictionary.setValue(NSNumber.numberWithInt(this.printerData.orientation == 2 ? 1 : 0), OS.NSPrintOrientation);
        if (this.printerData.printToFile) {
            nSMutableDictionary.setValue(OS.NSPrintSaveJob, OS.NSPrintJobDisposition);
        }
        if (this.printerData.fileName != null && this.printerData.fileName.length() > 0) {
            nSMutableDictionary.setValue(NSString.stringWith(this.printerData.fileName), OS.NSPrintSavePath);
        }
        nSMutableDictionary.setValue(NSNumber.numberWithBool(this.printerData.scope == 0), OS.NSPrintAllPages);
        if (this.printerData.scope == 1) {
            nSMutableDictionary.setValue(NSNumber.numberWithInt(this.printerData.startPage), OS.NSPrintFirstPage);
            nSMutableDictionary.setValue(NSNumber.numberWithInt(this.printerData.endPage), OS.NSPrintLastPage);
        }
        nSPrintPanel.setOptions(0x100L | nSPrintPanel.options());
        Shell shell = this.getParent();
        Display display2 = display = shell != null ? shell.getDisplay() : Display.getCurrent();
        if ((this.getStyle() & 0x10000000) != 0) {
            this.initClasses();
            nSObject = (SWTPrintPanelDelegate)new SWTPrintPanelDelegate().alloc().init();
            long l = OS.NewGlobalRef(this);
            if (l == 0L) {
                SWT.error(2);
            }
            OS.object_setInstanceVariable(((SWTPrintPanelDelegate)nSObject).id, SWT_OBJECT, l);
            this.returnCode = -1;
            nSPrintPanel.beginSheetWithPrintInfo(nSPrintInfo, shell.view.window(), nSObject, OS.sel_panelDidEnd_returnCode_contextInfo_, 0L);
            while (this.returnCode == -1) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            if (nSObject != null) {
                nSObject.release();
            }
            if (l != 0L) {
                OS.DeleteGlobalRef(l);
            }
            n = this.returnCode;
        } else {
            display.setData(SET_MODAL_DIALOG, this);
            n = (int)nSPrintPanel.runModalWithPrintInfo(nSPrintInfo);
        }
        display.setData(SET_MODAL_DIALOG, null);
        if (n != 0) {
            nSObject = nSPrintInfo.printer();
            NSString nSString = ((NSPrinter)nSObject).name();
            printerData = new PrinterData("Mac", nSString.getString());
            printerData.printToFile = nSPrintInfo.jobDisposition().isEqual(OS.NSPrintSaveJob);
            if (printerData.printToFile) {
                NSString nSString2 = new NSString(nSMutableDictionary.objectForKey(OS.NSPrintSavePath));
                printerData.fileName = nSString2.getString();
            }
            int n3 = printerData.scope = new NSNumber(nSMutableDictionary.objectForKey(OS.NSPrintAllPages)).intValue() != 0 ? 0 : 1;
            if (printerData.scope == 1) {
                printerData.startPage = new NSNumber(nSMutableDictionary.objectForKey(OS.NSPrintFirstPage)).intValue();
                printerData.endPage = new NSNumber(nSMutableDictionary.objectForKey(OS.NSPrintLastPage)).intValue();
            }
            printerData.collate = new NSNumber(nSMutableDictionary.objectForKey(OS.NSPrintMustCollate)).intValue() != 0;
            printerData.collate = false;
            printerData.copyCount = new NSNumber(nSMutableDictionary.objectForKey(OS.NSPrintCopies)).intValue();
            printerData.copyCount = 1;
            printerData.orientation = new NSNumber(nSMutableDictionary.objectForKey(OS.NSPrintOrientation)).intValue() == 1 ? 2 : 1;
            long l = nSPrintInfo.PMPrintSettings();
            int[] nArray = new int[1];
            OS.PMGetDuplex(l, nArray);
            printerData.duplex = nArray[0] == 3 ? 2 : (nArray[0] == 2 ? 1 : 0);
            NSData nSData = NSKeyedArchiver.archivedDataWithRootObject(nSPrintInfo);
            printerData.otherData = new byte[(int)nSData.length()];
            OS.memmove(printerData.otherData, nSData.bytes(), (long)printerData.otherData.length);
            this.printerData = printerData;
        }
        nSPrintInfo.release();
        return printerData;
    }

    public int getScope() {
        return this.printerData.scope;
    }

    static boolean getSheetEnabled() {
        return !"false".equals(System.getProperty("org.eclipse.swt.sheet"));
    }

    static long dialogProc(long l, long l2, long l3, long l4, long l5) {
        long[] lArray = new long[1];
        OS.object_getInstanceVariable(l, SWT_OBJECT, lArray);
        if (lArray[0] == 0L) {
            return 0L;
        }
        if (l2 == OS.sel_panelDidEnd_returnCode_contextInfo_) {
            PrintDialog printDialog = (PrintDialog)OS.JNIGetObject(lArray[0]);
            if (printDialog == null) {
                return 0L;
            }
            printDialog.panelDidEnd_returnCode_contextInfo(l, l2, l3, l4, l5);
        }
        return 0L;
    }

    void initClasses() {
        String string = "SWTPrintPanelDelegate";
        if (OS.objc_lookUpClass(string) != 0L) {
            return;
        }
        dialogCallback5 = new Callback(this.getClass(), "dialogProc", 5);
        long l = dialogCallback5.getAddress();
        if (l == 0L) {
            SWT.error(3);
        }
        byte[] byArray = new byte[]{42, 0};
        int n = C.PTR_SIZEOF;
        int n2 = C.PTR_SIZEOF == 4 ? 2 : 3;
        long l2 = OS.objc_allocateClassPair(OS.class_NSObject, string, 0L);
        OS.class_addIvar(l2, SWT_OBJECT, n, (byte)n2, byArray);
        OS.class_addMethod(l2, OS.sel_panelDidEnd_returnCode_contextInfo_, l, "@:@i@");
        OS.objc_registerClassPair(l2);
    }

    void panelDidEnd_returnCode_contextInfo(long l, long l2, long l3, long l4, long l5) {
        this.returnCode = (int)l4;
    }

    public void setScope(int n) {
        this.printerData.scope = n;
    }

    public int getStartPage() {
        return this.printerData.startPage;
    }

    public void setStartPage(int n) {
        this.printerData.startPage = n;
    }

    public int getEndPage() {
        return this.printerData.endPage;
    }

    public void setEndPage(int n) {
        this.printerData.endPage = n;
    }

    public boolean getPrintToFile() {
        return this.printerData.printToFile;
    }

    public void setPrintToFile(boolean bl) {
        this.printerData.printToFile = bl;
    }

    protected void checkSubclass() {
        String string = this.getClass().getName();
        String string2 = (class$org$eclipse$swt$printing$PrintDialog == null ? (class$org$eclipse$swt$printing$PrintDialog = PrintDialog.class$("org.eclipse.swt.printing.PrintDialog")) : class$org$eclipse$swt$printing$PrintDialog).getName();
        if (!string2.equals(string)) {
            SWT.error(43);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        SWT_OBJECT = new byte[]{83, 87, 84, 95, 79, 66, 74, 69, 67, 84, 0};
    }
}

