/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XSetWindowAttributes;
import org.eclipse.swt.internal.motif.XtWidgetGeometry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Label
extends Control {
    int formHandle;
    String text = "";
    Image image;
    Image bitmap;
    Image disabled;

    public Label(Composite composite, int n) {
        super(composite, Label.checkStyle(n));
    }

    static int checkStyle(int n) {
        if (((n |= 0x80000) & 2) != 0) {
            n = Label.checkBits(n, 512, 256, 0, 0, 0, 0);
            return Label.checkBits(n, 8, 4, 32, 0, 0, 0);
        }
        return Label.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    void _setText(String string) {
        if (string.length() == 0) {
            string = " ";
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        int n = Label.fixMnemonic(cArray);
        byte[] byArray = null;
        if ((this.style & 0x40) != 0) {
            int[] nArray = new int[4];
            nArray[0] = OS.XmNwidth;
            nArray[2] = OS.XmNmarginWidth;
            int[] nArray2 = nArray;
            OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
            int n2 = nArray2[1] - nArray2[3] * 2;
            if (n != 0) {
                string = new String(cArray);
            }
            string = this.display.wrapText(string, this.font, n2);
            byArray = Converter.wcsToMbcs(this.getCodePage(), string, true);
        } else {
            byArray = Converter.wcsToMbcs(this.getCodePage(), cArray, true);
        }
        int n3 = OS.XmStringGenerate(byArray, null, 0, null);
        if (n3 == 0) {
            this.error(13);
        }
        if (n == 0 || string.indexOf(10) != -1) {
            n = 0xFFFFFF;
        }
        int[] nArray = new int[]{OS.XmNlabelType, 2, OS.XmNlabelString, n3, OS.XmNmnemonic, n};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
        if (n3 != 0) {
            OS.XmStringFree(n3);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Object object;
        this.checkWidget();
        int n3 = this.getBorderWidth();
        int n4 = n3 * 2;
        int n5 = n3 * 2;
        if ((this.style & 2) != 0) {
            if ((this.style & 0x100) != 0) {
                n4 += 64;
                n5 += 3;
            } else {
                n4 += 3;
                n5 += 64;
            }
            if (n != -1) {
                n4 = n + n3 * 2;
            }
            if (n2 != -1) {
                n5 = n2 + n3 * 2;
            }
            return new Point(n4, n5);
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNlabelType;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n6 = nArray2[1];
        if (n6 == 2 && (this.style & 0x40) != 0) {
            int[] nArray3 = new int[12];
            nArray3[0] = OS.XmNmarginTop;
            nArray3[2] = OS.XmNmarginBottom;
            nArray3[4] = OS.XmNmarginHeight;
            nArray3[6] = OS.XmNmarginWidth;
            nArray3[8] = OS.XmNmarginLeft;
            nArray3[10] = OS.XmNmarginRight;
            object = nArray3;
            OS.XtGetValues(this.handle, (int[])object, ((Object)object).length / 2);
            String string = this.text;
            if (n != -1) {
                string = this.display.wrapText(string, this.font, n - object[7] * 2 - object[9] - object[11]);
            }
            GC gC = new GC(this);
            Point point = gC.textExtent(string);
            gC.dispose();
            n5 = point.y + object[1] + object[3] + object[5] * 2 + n3 * 2;
            if (n == -1) {
                n4 += point.x + object[7] * 2 + object[9] + object[11];
            }
        } else {
            object = new XtWidgetGeometry();
            ((XtWidgetGeometry)object).request_mode = 12;
            OS.XtQueryGeometry(this.handle, null, (XtWidgetGeometry)object);
            n4 += ((XtWidgetGeometry)object).width;
            n5 += ((XtWidgetGeometry)object).height;
        }
        if (n6 == 2 && this.text.length() == 0) {
            n4 = 0;
        }
        if (n != -1) {
            int[] nArray4 = new int[6];
            nArray4[0] = OS.XmNmarginWidth;
            nArray4[2] = OS.XmNmarginLeft;
            nArray4[4] = OS.XmNmarginRight;
            object = nArray4;
            OS.XtGetValues(this.handle, (int[])object, ((Object)object).length / 2);
            n4 = n + n3 * 2 + object[1] * 2 + object[3] + object[5];
        }
        if (n2 != -1) {
            int[] nArray5 = new int[6];
            nArray5[0] = OS.XmNmarginHeight;
            nArray5[2] = OS.XmNmarginTop;
            nArray5[4] = OS.XmNmarginBottom;
            object = nArray5;
            OS.XtGetValues(this.handle, (int[])object, ((Object)object).length / 2);
            n5 = n2 + n3 * 2 + object[1] * 2 + object[3] + object[5];
        }
        return new Point(n4, n5);
    }

    void createHandle(int n) {
        int n2;
        this.state |= 0x80;
        int n3 = this.parent.handle;
        int n4 = n2 = (this.style & 0x800) != 0 ? 1 : 0;
        if ((this.style & 2) != 0) {
            int n5 = this.separatorType();
            int n6 = (this.style & 0x100) != 0 ? 2 : 1;
            int[] nArray = new int[]{OS.XmNancestorSensitive, 1, OS.XmNborderWidth, n2, OS.XmNorientation, n6, OS.XmNseparatorType, n5};
            this.handle = OS.XmCreateSeparator(n3, null, nArray, nArray.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
            return;
        }
        int[] nArray = new int[10];
        nArray[0] = OS.XmNancestorSensitive;
        nArray[1] = 1;
        nArray[2] = OS.XmNmarginWidth;
        nArray[4] = OS.XmNmarginHeight;
        nArray[6] = OS.XmNresizePolicy;
        nArray[8] = OS.XmNborderWidth;
        nArray[9] = n2;
        int[] nArray2 = nArray;
        this.formHandle = OS.XmCreateForm(n3, null, nArray2, nArray2.length / 2);
        if (this.formHandle == 0) {
            this.error(2);
        }
        int n7 = 0;
        if ((this.style & 0x1000000) != 0) {
            n7 = 1;
        }
        if ((this.style & 0x20000) != 0) {
            n7 = 2;
        }
        int[] nArray3 = new int[]{OS.XmNalignment, n7, OS.XmNtopAttachment, 1, OS.XmNleftAttachment, 1, OS.XmNrightAttachment, 1};
        byte[] byArray = new byte[2];
        byArray[0] = 32;
        byte[] byArray2 = byArray;
        this.handle = OS.XmCreateLabel(this.formHandle, byArray2, nArray3, nArray3.length / 2);
        if (this.handle == 0) {
            this.error(2);
        }
        int[] nArray4 = new int[2];
        nArray4[0] = OS.XmNbackground;
        int[] nArray5 = nArray4;
        OS.XtGetValues(this.handle, nArray5, nArray5.length / 2);
        OS.XtSetValues(this.formHandle, nArray5, nArray5.length / 2);
    }

    int defaultBackground() {
        return this.display.labelBackground;
    }

    Font defaultFont() {
        return this.display.labelFont;
    }

    int defaultForeground() {
        return this.display.labelForeground;
    }

    void deregister() {
        super.deregister();
        if (this.formHandle != 0) {
            this.display.removeWidget(this.formHandle);
        }
    }

    void enableWidget(boolean bl) {
        super.enableWidget(bl);
        if (this.formHandle != 0) {
            this.enableHandle(bl, this.formHandle);
        }
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return 16384;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNalignment;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n = nArray2[1];
        if (n == 0) {
            return 16384;
        }
        if (n == 1) {
            return 0x1000000;
        }
        if (n == 2) {
            return 131072;
        }
        return 16384;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return "";
        }
        return this.text;
    }

    void hookEvents() {
        super.hookEvents();
        if (this.formHandle != 0) {
            int n = this.display.windowProc;
            OS.XtAddEventHandler(this.formHandle, 4, false, n, 1);
            OS.XtAddEventHandler(this.formHandle, 8, false, n, 2);
            OS.XtAddEventHandler(this.formHandle, 64, false, n, 26);
            OS.XtAddEventHandler(this.formHandle, 16, false, n, 4);
            OS.XtAddEventHandler(this.formHandle, 32, false, n, 8);
            OS.XtInsertEventHandler(this.formHandle, 32768, false, n, 3, 1);
        }
    }

    void manageChildren() {
        if (this.formHandle != 0) {
            OS.XtSetMappedWhenManaged(this.formHandle, false);
            OS.XtManageChild(this.formHandle);
        }
        super.manageChildren();
        if (this.formHandle != 0) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNborderWidth;
            int[] nArray2 = nArray;
            OS.XtGetValues(this.formHandle, nArray2, nArray2.length / 2);
            OS.XtResizeWidget(this.formHandle, 1, 1, nArray2[1]);
            OS.XtSetMappedWhenManaged(this.formHandle, true);
        }
    }

    boolean mnemonicHit(char c) {
        Composite composite = this.parent;
        while (composite != null) {
            Control[] controlArray = composite._getChildren();
            int n = 0;
            while (n < controlArray.length) {
                if (controlArray[n] == this) break;
                ++n;
            }
            if (++n < controlArray.length && controlArray[n].setFocus()) {
                return true;
            }
            composite = composite.parent;
        }
        return false;
    }

    boolean mnemonicMatch(char c) {
        char c2 = this.findMnemonic(this.getText());
        if (c2 == '\u0000') {
            return false;
        }
        return Character.toUpperCase(c) == Character.toUpperCase(c2);
    }

    void propagateWidget(boolean bl) {
        super.propagateWidget(bl);
        if (this.formHandle != 0) {
            this.propagateHandle(bl, this.formHandle, 0);
        }
    }

    void realizeChildren() {
        super.realizeChildren();
        this.setBitGravity();
    }

    void redrawWidget(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        super.redrawWidget(n, n2, n3, n4, bl, bl2, bl3);
        if (this.formHandle != 0) {
            short[] sArray = new short[1];
            short[] sArray2 = new short[1];
            OS.XtTranslateCoords(this.handle, (short)n, (short)n2, sArray, sArray2);
            short[] sArray3 = new short[1];
            short[] sArray4 = new short[1];
            OS.XtTranslateCoords(this.formHandle, (short)0, (short)0, sArray3, sArray4);
            this.redrawHandle(sArray[0] - sArray3[0], sArray2[0] - sArray4[0], n3, n4, bl, this.formHandle);
        }
    }

    void register() {
        super.register();
        if (this.formHandle != 0) {
            this.display.addWidget(this.formHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.formHandle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        int[] nArray = new int[]{OS.XmNlabelPixmap, 2, OS.XmNlabelInsensitivePixmap, 2};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
        if (this.bitmap != null) {
            this.bitmap.dispose();
        }
        if (this.disabled != null) {
            this.disabled.dispose();
        }
        this.disabled = null;
        this.bitmap = null;
        this.image = null;
    }

    int separatorType() {
        if ((this.style & 4) != 0) {
            return 5;
        }
        if ((this.style & 8) != 0) {
            return 6;
        }
        return 1;
    }

    public void setAlignment(int n) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNalignment;
        int[] nArray2 = nArray;
        if ((n & 0x1000000) != 0) {
            nArray2[1] = 1;
        }
        if ((n & 0x20000) != 0) {
            nArray2[1] = 2;
        }
        OS.XtSetValues(this.handle, nArray2, nArray2.length / 2);
        this.setBitGravity();
    }

    void setBackgroundPixel(int n) {
        int[] nArray;
        super.setBackgroundPixel(n);
        if (this.formHandle != 0) {
            int[] nArray2 = new int[4];
            nArray2[0] = OS.XmNforeground;
            nArray2[2] = OS.XmNhighlightColor;
            nArray = nArray2;
            OS.XtGetValues(this.formHandle, nArray, nArray.length / 2);
            OS.XmChangeColor(this.formHandle, n);
            OS.XtSetValues(this.formHandle, nArray, nArray.length / 2);
        }
        int[] nArray3 = new int[2];
        nArray3[0] = OS.XmNlabelType;
        nArray = nArray3;
        OS.XtGetValues(this.handle, nArray, nArray.length / 2);
        if (nArray[1] == 1) {
            this.setBitmap(this.image);
        }
    }

    void setBitGravity() {
        int n = OS.XtDisplay(this.handle);
        if (n == 0) {
            return;
        }
        int n2 = OS.XtWindow(this.handle);
        if (n2 == 0) {
            return;
        }
        int n3 = 16;
        XSetWindowAttributes xSetWindowAttributes = new XSetWindowAttributes();
        xSetWindowAttributes.bit_gravity = (this.style & 0x4000) != 0 ? 1 : 0;
        OS.XChangeWindowAttributes(n, n2, n3, xSetWindowAttributes);
    }

    void setBitmap(Image image) {
        Object object;
        int n = 2;
        int n2 = 2;
        if (this.bitmap != null) {
            this.bitmap.dispose();
        }
        if (this.disabled != null) {
            this.disabled.dispose();
        }
        this.disabled = null;
        this.bitmap = null;
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            switch (image.type) {
                case 0: {
                    if (image.mask == 0) {
                        object = image.getImageData();
                        if (((ImageData)object).alpha == -1 && ((ImageData)object).alphaData == null && ((ImageData)object).transparentPixel == -1) {
                            n = image.pixmap;
                            this.disabled = new Image((Device)this.display, image, 1);
                            n2 = this.disabled.pixmap;
                            break;
                        }
                    }
                }
                case 1: {
                    Rectangle rectangle = image.getBounds();
                    this.bitmap = new Image((Device)this.display, rectangle.width, rectangle.height);
                    GC gC = new GC(this.bitmap);
                    gC.setBackground(this.getBackground());
                    gC.fillRectangle(rectangle);
                    gC.drawImage(image, 0, 0);
                    gC.dispose();
                    n = this.bitmap.pixmap;
                    this.disabled = new Image((Device)this.display, this.bitmap, 1);
                    n2 = this.disabled.pixmap;
                    break;
                }
                default: {
                    this.error(20);
                }
            }
        }
        object = new int[]{OS.XmNlabelType, image == null ? 2 : 1, OS.XmNlabelPixmap, n, OS.XmNlabelInsensitivePixmap, n2};
        OS.XtSetValues(this.handle, (int[])object, ((Object)object).length / 2);
    }

    boolean setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        boolean bl3 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if (bl3 && bl2 && (this.style & 0x40) != 0) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNlabelType;
            int[] nArray2 = nArray;
            OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
            if (nArray2[1] == 2) {
                this._setText(this.text);
            }
        }
        return bl3;
    }

    public void setFont(Font font) {
        Object[] objectArray;
        boolean bl;
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNlabelString;
        nArray[2] = OS.XmNlabelType;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        boolean bl2 = bl = OS.IsDBLocale && OS.XmStringEmpty(nArray2[1]);
        if (bl) {
            objectArray = Converter.wcsToMbcs(this.getCodePage(), "string", true);
            int n = OS.XmStringCreateLocalized(objectArray);
            int[] nArray3 = new int[]{OS.XmNlabelType, 2, OS.XmNlabelString, n};
            OS.XtSetValues(this.handle, nArray3, nArray3.length / 2);
            OS.XmStringFree(n);
        }
        super.setFont(font);
        if (bl) {
            OS.XtSetValues(this.handle, nArray2, nArray2.length / 2);
        }
        if ((this.style & 0x40) != 0) {
            int[] nArray4 = new int[2];
            nArray4[0] = OS.XmNlabelType;
            objectArray = nArray4;
            OS.XtGetValues(this.handle, objectArray, objectArray.length / 2);
            if (objectArray[1] == 2) {
                this._setText(this.text);
            }
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        this.image = image;
        this.setBitmap(this.image);
    }

    void setParentBackground() {
        super.setParentBackground();
        if (this.formHandle != 0) {
            this.setParentBackground(this.formHandle);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.text.equals(string)) {
            return;
        }
        this.text = string;
        this._setText(this.text);
    }

    int topHandle() {
        if (this.formHandle != 0) {
            return this.formHandle;
        }
        return this.handle;
    }
}

