/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.DROPFILES;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;

public class FileTransfer
extends ByteArrayTransfer {
    private static FileTransfer _instance = new FileTransfer();
    private static final String CF_HDROP = "CF_HDROP ";
    private static final int CF_HDROPID = 15;
    private static final String CF_HDROP_SEPARATOR = "\u0000";

    private FileTransfer() {
    }

    public static FileTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkFile(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String[] stringArray = (String[])object;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(CF_HDROP_SEPARATOR);
        }
        TCHAR tCHAR = new TCHAR(0, stringBuffer.toString(), true);
        DROPFILES dROPFILES = new DROPFILES();
        dROPFILES.pFiles = DROPFILES.sizeof;
        dROPFILES.pt_y = 0;
        dROPFILES.pt_x = 0;
        dROPFILES.fNC = 0;
        dROPFILES.fWide = OS.IsUnicode ? 1 : 0;
        int n = tCHAR.length() * TCHAR.sizeof;
        long l = OS.GlobalAlloc(64, DROPFILES.sizeof + n);
        OS.MoveMemory(l, dROPFILES, DROPFILES.sizeof);
        OS.MoveMemory(l + (long)DROPFILES.sizeof, tCHAR, n);
        transferData.stgmedium = new STGMEDIUM();
        transferData.stgmedium.tymed = 1;
        transferData.stgmedium.unionField = l;
        transferData.stgmedium.pUnkForRelease = 0L;
        transferData.result = 0;
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pIDataObject == 0L) {
            return null;
        }
        IDataObject iDataObject = new IDataObject(transferData.pIDataObject);
        iDataObject.AddRef();
        FORMATETC fORMATETC = new FORMATETC();
        fORMATETC.cfFormat = 15;
        fORMATETC.ptd = 0L;
        fORMATETC.dwAspect = 1;
        fORMATETC.lindex = -1;
        fORMATETC.tymed = 1;
        STGMEDIUM sTGMEDIUM = new STGMEDIUM();
        sTGMEDIUM.tymed = 1;
        transferData.result = this.getData(iDataObject, fORMATETC, sTGMEDIUM);
        iDataObject.Release();
        if (transferData.result != 0) {
            return null;
        }
        int n = OS.DragQueryFile(sTGMEDIUM.unionField, -1, null, 0);
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            int n2 = OS.DragQueryFile(sTGMEDIUM.unionField, i, null, 0) + 1;
            TCHAR tCHAR = new TCHAR(0, n2);
            OS.DragQueryFile(sTGMEDIUM.unionField, i, tCHAR, n2);
            stringArray[i] = tCHAR.toString(0, tCHAR.strlen());
        }
        OS.DragFinish(sTGMEDIUM.unionField);
        return stringArray;
    }

    protected int[] getTypeIds() {
        return new int[]{15};
    }

    protected String[] getTypeNames() {
        return new String[]{CF_HDROP};
    }

    boolean checkFile(Object object) {
        if (object == null || !(object instanceof String[]) || ((String[])object).length == 0) {
            return false;
        }
        String[] stringArray = (String[])object;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null && stringArray[i].length() != 0) continue;
            return false;
        }
        return true;
    }

    protected boolean validate(Object object) {
        return this.checkFile(object);
    }
}

